/***************************************************************************
                          configfile.cpp  - QZLog
                             -------------------
    begin                : Oct 12 13:46:56 CET 2003
    copyright            : (C) 2001 by Johan Maes - ON4QZ(ex-ON1MH)
    email                : on4qz@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configfile.h"
#include "config.h"
#include <stdlib.h>
#include <qtextstream.h>
#include "localtypes.h"

configurationFile::configurationFile()
{
	optionList.setAutoDelete( TRUE );     // delete items when they are removed
	changed=FALSE;
}


int  configurationFile::processLine( QString &s,QString &OptN, QString &OptV)
{
  int pos,result;
  QString temp;
  temp=s.copy();  // uses deep copy while we will change s
  s=s.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
  if ((pos=s.find('#'))!=-1)
    {
		  s.truncate(pos);
			temp=temp.right(temp.length()-pos);  // temp contains comment
    }
  else
    {
      temp="";
    }
  if ((pos=s.find('='))!=-1)
    {
      OptN=s.left(pos);
      OptN=OptN.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      OptV=s.right(s.length()-pos-1);
      OptV=OptV.stripWhiteSpace(); // eliminate whitespaces at the beginning and the end
      result=1;
      //	  cout <<" detected " << OptN << "..  "<< OptV <<endl;   // for debug
    }
  else
    {
      OptN="";
      OptV="";
      result=0;
    }
  s=temp;  // on return s contains comment
  return result;
}
/**
		
*/
configOption *configurationFile::optionCheck(QString OptN, QString OptV, bool toUpdate)
{
  configOption *co;
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
			if (OptN==co->name())
				{
					if (toUpdate==TRUE)
	   				{
	     				co->setvalstr(OptV);
	   				}
	 				co->setstored(TRUE);
	 				return co;
       }
    }
  return NULL;
} 

bool configurationFile::readFile (const char * name, const char *path,bool create)
{

  QFileInfo t;
  QDir ConfigDir;
  QString home;
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
  configFileName.setFile(name);

  if(path==NULL)
    {
      // try to find it in the local directory
      ConfigDir.setPath(getenv("PWD"));
      configFileName.setFile(ConfigDir,name);
      if (!configFileName.exists())
				{
	 			 //try to find it in the HOME directory
				  ConfigDir.setPath(getenv("HOME"));
	 				configFileName.setFile(ConfigDir,name);
				}
    }
  else
    {
      ConfigDir.setPath(path);
      configFileName.setFile(ConfigDir,name); 
    }
  if (!configFileName.exists())
    {
      //      debug("fn=%s",(const char *)configFileName.filePath());
      changed=TRUE;
      QFile inf(configFileName.filePath());
      if(inf.open(IO_WriteOnly))
      	{
      		inf.close(); //make one
        	return TRUE;
        }
       else
       	{
      		return FALSE;
       	}
    }
  QFile inf(configFileName.filePath());
  if(!inf.open(IO_ReadOnly))
		{
    	return FALSE;
		} 
  QTextStream stream( &inf);
	while (!stream.eof())
		{
			s=stream.readLine(); //line excluding \n
			if(processLine(s,OptN,OptV)==1) // 1 if valid option layout
				{
				  if(optionCheck (OptN,OptV,TRUE)==NULL)
						{
							if(create)
								{
									registerOption(OptN, OptV);   //register the option
								}
						}
				}      	
    }
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
      if (co->IsStored()==FALSE)
				{
	  			changed=TRUE; // we have registered options that are not in the configfile
				}
    }
  inf.close();
  return TRUE;  
}


bool configurationFile::readOption(const char * s,int &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvali();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}


bool configurationFile::readOption(const char * s,short int &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=(short int)co->getvali();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

bool configurationFile::readOption(const char * s,float &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}


bool configurationFile::readOption(const char * s,double &i)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      i=co->getvald();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

bool configurationFile::readOption(const char * s,bool &b)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      b=(bool)co->getvalf();
      return TRUE;
    }
  debug("%s - illegal read option",s);
  return FALSE;
}

const char * configurationFile::readOption(const char * s)
{
  QString OptV;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))!=NULL)
    {
      return (co->getvalstr());      
    }
  debug("%s - illegal read option",s);
  return NULL;
}

bool configurationFile::readOption(const char * s,int *i,int &size)
{
  QString OptV;
  unsigned int j;
  int t;
  bool ok;
  configOption *co;
  if ((co=optionCheck (s,OptV,FALSE))==NULL)
    {
      debug("%s - illegal read option",s);
      return FALSE;
    }
  QStringList sList=QStringList::split(';',co->getvalstr());
  for(j=0;(j<(unsigned int)size)&&(j<sList.count());j++)
    {
      t=sList[j].toInt(&ok);
      if(!ok)
        {
         debug("%s - illegal value in array",s); 
         return FALSE;
        }
      i[j]=t;
    }
    return TRUE;
}

void configurationFile::registerOption(const char *name, const char *def)
{
  optionList.append(new configOption(name,def));
}




void configurationFile::setOption(const char *s,const char *t)
{
 QString OptN;
 QString OptV;
 OptN=s;
 OptV=t;
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
else
  {
  debug("%s - illegal set option",s);
  }     	 
}



void configurationFile::setOption(const char *s,int t)
{
 QString OptN;
 QString OptV;
 OptN=s; 
 OptV.setNum(t);
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	       	 
}



void configurationFile::setOption(const char *s,short int t)
{
 QString OptN;
 QString OptV;
 OptN=s;
 OptV.setNum(t);
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }
}

void configurationFile::setOption(const char *s,bool b)
{
	if(b)
		{
			setOption(s,1);
		}
	else
		{
			setOption(s,0);
		}
}



void configurationFile::setOption(const char *s,float t)
{
  QString OptN;
  QString OptV;
  OptN=s; 
  OptV.setNum(t);
  if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }     	 
}

void configurationFile::setOption(const char *s,double t)
{
 QString OptN;
 QString OptV;
 OptN=s;
 OptV=OptV.setNum(t,'g',PRECISION);
if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }
}

void configurationFile::setOption(const char * s,int *i,int &size)
{
 QString OptN;
 QString OptV("");
 OptN=s;
 int j;
 
 for (j=0;j<size;j++)
  {
    OptV+=QString::number(i[j])+';';
  }
 
 if(optionCheck (OptN,OptV,TRUE))
   {
     changed=TRUE;
   }
 else
   {
     debug("%s - illegal set option",s);
   }
}

void configurationFile::initOptions(sConfigEntry *table,const char *name,const char *path)
{
  int i=0;
  while (table[i].name!=0)
    {
      registerOption(table[i].name,table[i].initialValue);
      i++;
    }
	if(name!=0)
		{
			readFile(name,path);
		}
   // readback config
  i=0;
  while (table[i].name!=0)
    {
      switch(table[i].type)
				{
				case DOUBLE:
				   readOption(table[i].name,*(double *)table[i].variable);
				break;
				case FLOAT:
				   readOption(table[i].name,*(float *)table[i].variable);
				break;
				case BOOL:
				  readOption(table[i].name,*(bool *)table[i].variable);
				break;
				case INT:
				  readOption(table[i].name,*(int *)table[i].variable);
				  break;
				case SINT:
				  readOption(table[i].name,*(short int *)table[i].variable);
        break;
 				case INTA:
				  readOption(table[i].name,(int *)table[i].variable,table[i].size);
				break;
				
				default:
				break;
		 		}
   		i++;
    }
}

void configurationFile::saveActiveOptions(sConfigEntry *table)
{
	int i=0;
  while (table[i].name!=0)
    {
      switch(table[i].type)
				{
				case DOUBLE:
				   setOption(table[i].name,*(double *)table[i].variable);
				break;
				case FLOAT:
				   setOption(table[i].name,*(float *)table[i].variable);
				break;
				case BOOL:
				   setOption(table[i].name,*(bool *)table[i].variable);
				  break;
				case INT:
				   setOption(table[i].name,*(int *)table[i].variable);
				  break;
				case SINT:
				   setOption(table[i].name,*(short int *)table[i].variable);
				  break;
        case INTA:
           setOption(table[i].name,(int *)table[i].variable,table[i].size);
        break;
				default:
				break;
		 		}
   		i++;
    }
}


bool  configurationFile::saveFile(sConfigEntry *table)
{

	int fd;
  char tn[]=PACKAGE "XXXXXX";

  QFileInfo tempname;
  QString OptN;
  QString OptV;
  QString s;
  configOption *co;
	saveActiveOptions(table);
  
  fd=mkstemp(tn);
	for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
    	co->setstored(FALSE);
    }
	QFile of(tn);
	QFile inf(configFileName.filePath());

	if (!of.open(IO_WriteOnly))
		{
			return FALSE;
		}
	if (!inf.open(IO_ReadOnly))
		{
			of.close();
			return FALSE;
		}
	QTextStream stream_out(&of);
	QTextStream stream_in(&inf);

	while (!stream_in.eof())
		{
			s=stream_in.readLine();
   		if (processLine(s,OptN,OptV)==0)
				{
					stream_out<<s<<"\n"; // simply store the comment
				}
   		else
				{
					if((co=optionCheck(OptN,OptV,FALSE))!=NULL)
	   					{
	      					stream_out<< OptN << "=" << co->getvalstr() << " " << s <<"\n";   // store valid option and comment
	   				 	}
	  			else
	    				{
	      				// invalid option
	      				stream_out<< "#  *** invalid option *** " << OptN << "=" << OptV <<" "<<  s <<"\n";
	    				}
				}
     }
 		inf.close();

	 // we will add option not stored yet
  for ( co=optionList.first(); co!= 0; co=optionList.next() )
    {
     if (!co->IsStored())
       {
				 stream_out << co->name() <<"="<<co->getvalstr()<<"\n";
       }
    }
  of.close();

// copy tempfile to configfile


  inf.setName(tn);
  of.setName(configFileName.filePath());
  if(!inf.open(IO_ReadOnly))
  	{
   	 inf.remove();
  	 return FALSE;
    }
  if(!of.open(IO_WriteOnly))
  	{
   		inf.remove();
     	return FALSE;
   	}
	QTextStream stream_dst(&of);
	QTextStream stream_src(&inf);
	while(!stream_src.eof())
		{
			s=stream_src.readLine();
			stream_dst <<s << "\n";
		}
	inf.remove();
	of.close();
	return TRUE;

}

void getVal(QLineEdit *l,unsigned int &v)
{
	bool ok;
	QString s;
	s=l->text();
	unsigned int	temp=s.toUInt(&ok);
	if(ok)
		{
			v=temp;
		}
}

void getVal(QLineEdit *l,double &v)
{
	bool ok;
	QString s;
	s=l->text();
	double temp=s.toDouble(&ok);
	if(ok)
		{
			v=temp;
		}
}
