/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

//#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qlabel.h>

#include "MQChk.h"

drive_info*	mqchk_drive;

mqchk_dialog::mqchk_dialog(QWidget* parent, const char* name, bool modal, WFlags fl)
	: mqchk_dialog_UI(parent,name,modal,fl)
{
	printf(tr("Media Quality Check...\n"));
	ck_mode = AS_MEDIACK_QUICK;
	text_result->clear();
	if (mqchk_drive->dev_ID == PLEXTOR_716)
		group_mchk_type->setEnabled(false);
	else
		group_mchk_type->setEnabled(true);
	detect_wr_spd();
	this->show();
}

mqchk_dialog::~mqchk_dialog()
{
	printf(tr("MQChk destroyed\n"));
}

void mqchk_dialog::show_write_speed()
{
	get_write_speed(mqchk_drive);
	text_chk_spd->setText(QString().sprintf("%d kB/s",mqchk_drive->parms.write_speed_kb));
}

void mqchk_dialog::change_chk_spd(const QString&)
{
	int idx = combo_chk_spd->currentItem();
	mqchk_drive->parms.write_speed_kb = mqchk_drive->parms.wr_speed_tbl_kb[idx];
	printf(tr("** Set write speed %d kB/s [idx %d]\n"), mqchk_drive->parms.write_speed_kb,idx);
	set_streaming(mqchk_drive);
	show_write_speed();
}

void mqchk_dialog::detect_wr_spd()
{
	int i=0;
	combo_chk_spd->clear();
	printf(tr("** Detecting write speeds...\n"));
	show_write_speed();
	get_write_speed_tbl(mqchk_drive);
	while ((mqchk_drive->parms.wr_speed_tbl_kb[i]) && (i<speed_tbl_size)) {
		printf(tr("Write speed #%d: %d kB/s\n"),i,mqchk_drive->parms.wr_speed_tbl_kb[i]);
		combo_chk_spd->insertItem(QString().sprintf("%3.1fX (%d kB/s)",
			mqchk_drive->parms.wr_speed_tbl_kb[i]/1385.0,mqchk_drive->parms.wr_speed_tbl_kb[i]));
		i++;
	}
}

void mqchk_dialog::quick_toggled(bool state)
{
	if ((!state) || (ck_mode == AS_MEDIACK_QUICK)) return;
	ck_mode = AS_MEDIACK_QUICK;
	printf("\tQuick Media Check\n");
}

void mqchk_dialog::adv_toggled(bool state)
{
	if ((!state) || (ck_mode == AS_MEDIACK_ADV)) return;
	ck_mode = AS_MEDIACK_ADV;
	printf("\tAdvanced Media Check\n");
}

void mqchk_dialog::mchk_start()
{
	printf("\tStarting Check...\n");
	text_result->setText("Checking media...");
	if (plextor_media_check(mqchk_drive, ck_mode)) {
		if ((mqchk_drive->err & 0x023A00) == 0x023A00)
			text_result->setText("<font color=\"red\">No media found</font>");
		else
			text_result->setText("<font color=\"red\">Media check ERROR</font>");
		return;
	}
	if (!mqchk_drive->rd_buf[0x11]) {
		if ((mqchk_drive->rd_buf[0x10] & 0xFF) == 0xFF)
			text_result->setText("<font color=\"red\">AUTOSTRATEGY is OFF</font>");
		else
			text_result->setText("<font color=\"dark green\">Media is GOOD for writing at selected speed</font>");
	} else {
		switch (mqchk_drive->rd_buf[0x10] & 0xFF) {
			case 0x01:
				text_result->setText("<font color=\"red\">Write error may occur</font>");
				break;
			case 0x03:
				text_result->setText("<font color=\"red\">Drive may not write correctly at selected speed</font>");
				break;
			default:
				text_result->setText(QString().sprintf("<font color=\"red\">Unknown error 0x%02X</font>", mqchk_drive->rd_buf[0x10] & 0xFF));
		}
	}
}
