/*
 * QCameraKeyPathDrag.cpp
 * $Id: 
 *
 * Copyright (C) 2001 Thomas Woerner, Michael Meissner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

/* 
  [tw] 2001/05/12 initial version
*/

// Qt
///////
#include <qtextstream.h>

// Own
////////
#include "QCameraKeyPathDrag.h"
#include "QGLViewerXML.h"



// Function  : QCameraKeyPathDrag
// Parameters: CList<CCameraPathPoint> &list,
//             QWidget *parent,
//             const char *name
// Purpose   : default constructor.
// Comments  : 
QCameraKeyPathDrag::QCameraKeyPathDrag(CList<CCameraKeyPathPoint> &list,
				       QWidget *parent,
				       const char *name)
                   : QStoredDrag("glviewer/camerakeypath", parent, name)
/*************************************************************/
{
   QDomDocument doc("glviewer/camerakeypath");
   QDomElement elem = doc.createElement("CameraKeyPath");
   doc.appendChild(elem);

   QByteArray data;

   if (QGLViewerXML::writeXML(elem, list, "CameraKeyPath")) {
      QTextStream ts(data, IO_WriteOnly);
      doc.firstChild().save(ts, 0);
   }

   setEncodedData(data);
}



// Function  : canDecode
// Parameters: QDragMoveEvent *event
// Purpose   : return provide test for event
// Comments  : 
bool QCameraKeyPathDrag::canDecode(QDragMoveEvent *event)
/*************************************************************/
{
   return event->provides("glviewer/camerakeypath");
}



// Function  : decode
// Parameters: QDropEvent *event,
//             CList<CCameraKeyPathPoint> &list
// Purpose   : decode and return status
// Comments  : 
bool QCameraKeyPathDrag::decode(QDropEvent *event, CList<CCameraKeyPathPoint> &list)
/*************************************************************/
{
   QByteArray data = event->data("glviewer/camerakeypath");
    
   if (data.size()) {
      QDomDocument doc("glviewer/camerakeypath");

      doc.setContent(QCString(data));

      if (QGLViewerXML::readXML(doc.documentElement(), list, "CameraKeyPath")) {
	 event->accept();
         return true;
      }
   }

   return false;
}
