/****************************************************************************

   FILE: audioenv.h

   DESCRIPTION: header for audio environment class

****************************************************************************/
#if !defined (AUDIOENV)
#define AUDIOENV

/**
  *@author Krippel Harald
  */


#include <qglobal.h>
#include <QObject>

#include <AL/al.h>
#include <AL/alut.h>

#ifdef    Q_OS_LINUX
  #define LINUX
#endif

#ifdef    Q_OS_MACX
  #define MACOS
#endif

#ifdef    Q_OS_WIN32
  #define WINDOWS
#endif

class AudioEnv : public QObject
{
//	Q_OBJECT
public:

  static AudioEnv *theInstance(QObject *parent=0);

   AudioEnv (QObject *parent=0);
   ~AudioEnv ();
   void Init ();
   void ListenerPosition (float c[4][4] );
   void UpdateObstruction (int);
   int LoadFile (const char *, bool);
   int PlayFile (char *, bool);
   void SetSourcePosition (int, float *);
   void SetSourceVelocity (int, float *);
   void SetSourceGain (int handle, float gain);
   void Play (int);
   void Stop (int);
   void Loop(int , int);
   void Relative(int , int);
   int  IsPlaying(int);
   int IncrementEnv();

private:
   ALuint buffer[512];
   ALuint source[512];
   ALuint nextBuffer, nextSource;
   unsigned int EAXlevel;
   
   static AudioEnv *theInstancePtr;
};
#endif // AUDIOENV

