//
// C++ Implementation: CCameraEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CCameraEdit.hpp"

CCameraEditDlg::CCameraEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CCameraEditDlg::~CCameraEditDlg() {
}

void CCameraEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CCameraEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
    
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.locx->setValue(i->GetValue("x",i).toDouble());
    ui.locy->setValue(i->GetValue("y",i).toDouble());
    ui.locz->setValue(i->GetValue("z",i).toDouble());

    ui.rotx->setValue(i->GetValue("rotx",i).toDouble());
    ui.roty->setValue(i->GetValue("roty",i).toDouble());
    ui.rotz->setValue(i->GetValue("rotz",i).toDouble());
    
    ui.fovw->setValue(i->GetValue("fovw",i).toDouble());
    ui.fovh->setValue(i->GetValue("fovh",i).toDouble());

    ui.camnear->setValue(i->GetValue("near",i).toDouble());
    ui.camfar->setValue(i->GetValue("far",i).toDouble());
    ui.bind->setValue(i->GetValue("bind",i).toInt());

    ui.camrotw->setText(i->GetValue("camrotw",i));
    ui.camhight->setText(i->GetValue("camhight",i));
    ui.camradius->setText(i->GetValue("camradius",i));

    ui.camego->setChecked(i->GetValue("camego",i).toInt());
    ui.cam2d->setChecked(i->GetValue("cam2d",i).toInt());
    ui.camfix->setChecked(i->GetValue("camfix",i).toInt());

    qWarning( "CCameraEditDlg::slotGetData(): Geht !" );
}

void CCameraEditDlg::slotEditData()
{
    if(point != NULL){
        point->setText(0,ui.text->text());

        point->SetValue("on", ui.on->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("rotx",ui.rotx->text());
        point->SetValue("roty",ui.roty->text());
        point->SetValue("rotz",ui.rotz->text());

        point->SetValue("fovw",ui.fovw->text());
        point->SetValue("fovh",ui.fovh->text());

        point->SetValue("near",ui.camnear->text());
        point->SetValue("far",ui.camfar->text());

        point->SetValue("bind",ui.bind->text());
    
        point->SetValue("camrotw",ui.camrotw->text());
        point->SetValue("camhight",ui.camhight->text());
        point->SetValue("camradius",ui.camradius->text());

        point->SetValue("camego", ui.camego->isChecked() ? "1" : "0");
        point->SetValue("cam2d", ui.cam2d->isChecked() ? "1" : "0");
        point->SetValue("camfix", ui.camfix->isChecked() ? "1" : "0");

	point->updategl();
    }

qWarning( "CCameraEditDlg::slotEditData(): Geht !" );
}
