/***************************************************************************
  hops.cpp
  -------------------
  A hops class
  -------------------
  Copyright 1999-2004, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <cmath>

#include <qregexp.h>
#include <qstringlist.h>

#include "hops.h"

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// Hops()
// ------
// constructor

Hops::Hops()
    : name_("Generic"), weight_(), form_( QString::null), alpha_(0.0), time_(0)
{ ; }

Hops::Hops(const QString &name, const Weight &weight, const QString &form,
           const double &alpha, const unsigned &time)
    : name_(name), weight_(weight), form_(form), alpha_(alpha), time_(time)
      
{
    hbu_ = 0.75 * alpha * weight_.amount(Weight::ounce);
}

Hops::~Hops() { ; }

//////////////////////////////////////////////////////////////////////////////
// Hops(const Hops &)
// ------------------
// Copy constructor

Hops::Hops(const Hops &h)
    : name_(h.name_), weight_(h.weight_), form_(h.form_), alpha_(h.alpha_),
      time_(h.time_), hbu_(h.hbu_)
{ ; }

//////////////////////////////////////////////////////////////////////////////
// Operators                                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// operator=()
// -----------
// Assignment operator

Hops Hops::operator=(const Hops &h)
{
    if (this != &h) {
        name_ = h.name_;
        weight_ = h.weight_;
        form_ = h.form_;
        alpha_ = h.alpha_;
        time_ = h.time_;
        hbu_ = h.hbu_;
    }
    return *this;
}

//////////////////////////////////////////////////////////////////////////////
// operator==()
// ------------
// Equivalence operator

bool Hops::operator==(const Hops &h)
{
    return (name_ == h.name_)
        && (weight_ == h.weight_)
        && (form_ == h.form_)
        && (alpha_ == h.alpha_)
        && (time_ == h.time_);
}

//////////////////////////////////////////////////////////////////////////////
// HopsListItem Class                                                       //
//////////////////////////////////////////////////////////////////////////////

HopsListItem::HopsListItem(QListView * parent, QString a, QString b, QString c,
                           QString d, QString e, QString f, QString g, QString h)
    : QListViewItem(parent, a, b, c, d, e, f, g, h), hit_(0) { ; }

void HopsListItem::setToIterator()
{
    setText(0, (*hit_).name());
    setText(1, QString::number((*hit_).weight().amount(), 'f', 2));
    setText(2, (*hit_).form());
    setText(3, QString::number((*hit_).alpha(), 'f', 1) + '%');
    setText(4, QString::number((*hit_).time()));
}

// reimplemented for numerical sorting
int HopsListItem::compare(QListViewItem* item, int column, bool asc) const
{
    switch (column) {
      case 1:
      case 3: { // remove suffixes and decimals in these fields
          QRegExp regex("[0-9.]+");
          regex.search(text(column));
          int first = (int) regex.cap(0).toDouble() * 1000;
          regex.search(item->text(column));
          int second = (int) regex.cap(0).toDouble() * 1000;
          return (first - second);
      }

      case 4: // plain int with no suffix
          return (text(column).toInt() - item->text(column).toInt());

      default:
          return QListViewItem::compare(item, column, asc);
    }
}
