# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Resource(_serialization.Model):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class GenericResource(Resource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.managed_by = managed_by
        self.sku = sku
        self.identity = identity


class Application(GenericResource):  # pylint: disable=too-many-instance-attributes
    """Information about managed application.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
    :ivar plan: The plan information.
    :vartype plan: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Plan
    :ivar kind: The kind of the managed application. Allowed values are MarketPlace and
     ServiceCatalog. Required.
    :vartype kind: str
    :ivar managed_resource_group_id: The managed resource group Id. Required.
    :vartype managed_resource_group_id: str
    :ivar application_definition_id: The fully qualified path of managed application definition Id.
    :vartype application_definition_id: str
    :ivar parameters: Name and value pairs that define the managed application parameters. It can
     be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar outputs: Name and value pairs that define the managed application outputs.
    :vartype outputs: JSON
    :ivar provisioning_state: The managed application provisioning state. Known values are:
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True, "pattern": r"^[-\w\._,\(\)]+$"},
        "managed_resource_group_id": {"required": True},
        "outputs": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "plan": {"key": "plan", "type": "Plan"},
        "kind": {"key": "kind", "type": "str"},
        "managed_resource_group_id": {"key": "properties.managedResourceGroupId", "type": "str"},
        "application_definition_id": {"key": "properties.applicationDefinitionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: str,
        managed_resource_group_id: str,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        plan: Optional["_models.Plan"] = None,
        application_definition_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
        :keyword plan: The plan information.
        :paramtype plan: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Plan
        :keyword kind: The kind of the managed application. Allowed values are MarketPlace and
         ServiceCatalog. Required.
        :paramtype kind: str
        :keyword managed_resource_group_id: The managed resource group Id. Required.
        :paramtype managed_resource_group_id: str
        :keyword application_definition_id: The fully qualified path of managed application definition
         Id.
        :paramtype application_definition_id: str
        :keyword parameters: Name and value pairs that define the managed application parameters. It
         can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, identity=identity, **kwargs)
        self.plan = plan
        self.kind = kind
        self.managed_resource_group_id = managed_resource_group_id
        self.application_definition_id = application_definition_id
        self.parameters = parameters
        self.outputs = None
        self.provisioning_state = None


class ApplicationArtifact(_serialization.Model):
    """Managed application artifact.

    :ivar name: The managed application artifact name.
    :vartype name: str
    :ivar uri: The managed application artifact blob uri.
    :vartype uri: str
    :ivar type: The managed application artifact type. Known values are: "Template" and "Custom".
    :vartype type: str or
     ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationArtifactType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        uri: Optional[str] = None,
        type: Optional[Union[str, "_models.ApplicationArtifactType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The managed application artifact name.
        :paramtype name: str
        :keyword uri: The managed application artifact blob uri.
        :paramtype uri: str
        :keyword type: The managed application artifact type. Known values are: "Template" and
         "Custom".
        :paramtype type: str or
         ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationArtifactType
        """
        super().__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.type = type


class ApplicationDefinition(GenericResource):  # pylint: disable=too-many-instance-attributes
    """Information about managed application definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
    :ivar lock_level: The managed application lock level. Required. Known values are:
     "CanNotDelete", "ReadOnly", and "None".
    :vartype lock_level: str or
     ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationLockLevel
    :ivar display_name: The managed application definition display name.
    :vartype display_name: str
    :ivar is_enabled: A value indicating whether the package is enabled or not.
    :vartype is_enabled: str
    :ivar authorizations: The managed application provider authorizations. Required.
    :vartype authorizations:
     list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationProviderAuthorization]
    :ivar artifacts: The collection of managed application artifacts. The portal will use the files
     specified as artifacts to construct the user experience of creating a managed application from
     a managed application definition.
    :vartype artifacts:
     list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationArtifact]
    :ivar description: The managed application definition description.
    :vartype description: str
    :ivar package_file_uri: The managed application definition package file Uri. Use this element.
    :vartype package_file_uri: str
    :ivar main_template: The inline main template json which has resources to be provisioned. It
     can be a JObject or well-formed JSON string.
    :vartype main_template: JSON
    :ivar create_ui_definition: The createUiDefinition json for the backing template with
     Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
    :vartype create_ui_definition: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "lock_level": {"required": True},
        "authorizations": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "lock_level": {"key": "properties.lockLevel", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ApplicationProviderAuthorization]"},
        "artifacts": {"key": "properties.artifacts", "type": "[ApplicationArtifact]"},
        "description": {"key": "properties.description", "type": "str"},
        "package_file_uri": {"key": "properties.packageFileUri", "type": "str"},
        "main_template": {"key": "properties.mainTemplate", "type": "object"},
        "create_ui_definition": {"key": "properties.createUiDefinition", "type": "object"},
    }

    def __init__(
        self,
        *,
        lock_level: Union[str, "_models.ApplicationLockLevel"],
        authorizations: List["_models.ApplicationProviderAuthorization"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        display_name: Optional[str] = None,
        is_enabled: Optional[str] = None,
        artifacts: Optional[List["_models.ApplicationArtifact"]] = None,
        description: Optional[str] = None,
        package_file_uri: Optional[str] = None,
        main_template: Optional[JSON] = None,
        create_ui_definition: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
        :keyword lock_level: The managed application lock level. Required. Known values are:
         "CanNotDelete", "ReadOnly", and "None".
        :paramtype lock_level: str or
         ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationLockLevel
        :keyword display_name: The managed application definition display name.
        :paramtype display_name: str
        :keyword is_enabled: A value indicating whether the package is enabled or not.
        :paramtype is_enabled: str
        :keyword authorizations: The managed application provider authorizations. Required.
        :paramtype authorizations:
         list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationProviderAuthorization]
        :keyword artifacts: The collection of managed application artifacts. The portal will use the
         files specified as artifacts to construct the user experience of creating a managed application
         from a managed application definition.
        :paramtype artifacts:
         list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationArtifact]
        :keyword description: The managed application definition description.
        :paramtype description: str
        :keyword package_file_uri: The managed application definition package file Uri. Use this
         element.
        :paramtype package_file_uri: str
        :keyword main_template: The inline main template json which has resources to be provisioned. It
         can be a JObject or well-formed JSON string.
        :paramtype main_template: JSON
        :keyword create_ui_definition: The createUiDefinition json for the backing template with
         Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
        :paramtype create_ui_definition: JSON
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, identity=identity, **kwargs)
        self.lock_level = lock_level
        self.display_name = display_name
        self.is_enabled = is_enabled
        self.authorizations = authorizations
        self.artifacts = artifacts
        self.description = description
        self.package_file_uri = package_file_uri
        self.main_template = main_template
        self.create_ui_definition = create_ui_definition


class ApplicationDefinitionListResult(_serialization.Model):
    """List of managed application definitions.

    :ivar value: The array of managed application definitions.
    :vartype value:
     list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The array of managed application definitions.
        :paramtype value:
         list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.ApplicationDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationListResult(_serialization.Model):
    """List of managed applications.

    :ivar value: The array of managed applications.
    :vartype value: list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.Application]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Application]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Application"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The array of managed applications.
        :paramtype value: list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.Application]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationPatchable(GenericResource):  # pylint: disable=too-many-instance-attributes
    """Information about managed application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
    :ivar plan: The plan information.
    :vartype plan: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.PlanPatchable
    :ivar kind: The kind of the managed application. Allowed values are MarketPlace and
     ServiceCatalog.
    :vartype kind: str
    :ivar managed_resource_group_id: The managed resource group Id.
    :vartype managed_resource_group_id: str
    :ivar application_definition_id: The fully qualified path of managed application definition Id.
    :vartype application_definition_id: str
    :ivar parameters: Name and value pairs that define the managed application parameters. It can
     be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar outputs: Name and value pairs that define the managed application outputs.
    :vartype outputs: JSON
    :ivar provisioning_state: The managed application provisioning state. Known values are:
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.v2018_06_01.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"pattern": r"^[-\w\._,\(\)]+$"},
        "outputs": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "plan": {"key": "plan", "type": "PlanPatchable"},
        "kind": {"key": "kind", "type": "str"},
        "managed_resource_group_id": {"key": "properties.managedResourceGroupId", "type": "str"},
        "application_definition_id": {"key": "properties.applicationDefinitionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        plan: Optional["_models.PlanPatchable"] = None,
        kind: Optional[str] = None,
        managed_resource_group_id: Optional[str] = None,
        application_definition_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.Identity
        :keyword plan: The plan information.
        :paramtype plan: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.PlanPatchable
        :keyword kind: The kind of the managed application. Allowed values are MarketPlace and
         ServiceCatalog.
        :paramtype kind: str
        :keyword managed_resource_group_id: The managed resource group Id.
        :paramtype managed_resource_group_id: str
        :keyword application_definition_id: The fully qualified path of managed application definition
         Id.
        :paramtype application_definition_id: str
        :keyword parameters: Name and value pairs that define the managed application parameters. It
         can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, identity=identity, **kwargs)
        self.plan = plan
        self.kind = kind
        self.managed_resource_group_id = managed_resource_group_id
        self.application_definition_id = application_definition_id
        self.parameters = parameters
        self.outputs = None
        self.provisioning_state = None


class ApplicationProviderAuthorization(_serialization.Model):
    """The managed application provider authorization.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The provider's principal identifier. This is the identity that the provider
     will use to call ARM to manage the managed application resources. Required.
    :vartype principal_id: str
    :ivar role_definition_id: The provider's role definition identifier. This role will define all
     the permissions that the provider must have on the managed application's container resource
     group. This role definition cannot have permission to delete the resource group. Required.
    :vartype role_definition_id: str
    """

    _validation = {
        "principal_id": {"required": True},
        "role_definition_id": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
    }

    def __init__(self, *, principal_id: str, role_definition_id: str, **kwargs):
        """
        :keyword principal_id: The provider's principal identifier. This is the identity that the
         provider will use to call ARM to manage the managed application resources. Required.
        :paramtype principal_id: str
        :keyword role_definition_id: The provider's role definition identifier. This role will define
         all the permissions that the provider must have on the managed application's container resource
         group. This role definition cannot have permission to delete the resource group. Required.
        :paramtype role_definition_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id


class ErrorResponse(_serialization.Model):
    """Error response indicates managed application is not able to process the incoming request. The reason is provided in the error message.

    :ivar http_status: Http status code.
    :vartype http_status: str
    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar error_message: Error message indicating why the operation failed.
    :vartype error_message: str
    """

    _attribute_map = {
        "http_status": {"key": "httpStatus", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        http_status: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword http_status: Http status code.
        :paramtype http_status: str
        :keyword error_code: Error code.
        :paramtype error_code: str
        :keyword error_message: Error message indicating why the operation failed.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.http_status = http_status
        self.error_code = error_code
        self.error_message = error_message


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[str] = None, **kwargs):
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class Operation(_serialization.Model):
    """Microsoft.Solutions operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.managedapplications.v2018_06_01.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display:
         ~azure.mgmt.resource.managedapplications.v2018_06_01.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Solutions.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Application, JitRequest, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Service provider: Microsoft.Solutions.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Application, JitRequest, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Solutions operations. It contains a list of operations and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Solutions operations.
    :vartype value: list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: List of Microsoft.Solutions operations.
        :paramtype value: list[~azure.mgmt.resource.managedapplications.v2018_06_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Plan(_serialization.Model):
    """Plan for the managed application.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The plan name. Required.
    :vartype name: str
    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar product: The product code. Required.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version. Required.
    :vartype version: str
    """

    _validation = {
        "name": {"required": True},
        "publisher": {"required": True},
        "product": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self, *, name: str, publisher: str, product: str, version: str, promotion_code: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: The plan name. Required.
        :paramtype name: str
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword product: The product code. Required.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PlanPatchable(_serialization.Model):
    """Plan for the managed application.

    :ivar name: The plan name.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product code.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The plan name.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product code.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class Sku(_serialization.Model):
    """SKU for the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name. Required.
    :vartype name: str
    :ivar tier: The SKU tier.
    :vartype tier: str
    :ivar size: The SKU size.
    :vartype size: str
    :ivar family: The SKU family.
    :vartype family: str
    :ivar model: The SKU model.
    :vartype model: str
    :ivar capacity: The SKU capacity.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        model: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The SKU name. Required.
        :paramtype name: str
        :keyword tier: The SKU tier.
        :paramtype tier: str
        :keyword size: The SKU size.
        :paramtype size: str
        :keyword family: The SKU family.
        :paramtype family: str
        :keyword model: The SKU model.
        :paramtype model: str
        :keyword capacity: The SKU capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.model = model
        self.capacity = capacity
