# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._email_registrations_operations import build_activate_email_request, build_register_email_request

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class EmailRegistrationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.datashare.aio.DataShareManagementClient`'s
        :attr:`email_registrations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def activate_email(
        self,
        location: str,
        email_registration: _models.EmailRegistration,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EmailRegistration:
        """Activates the tenant and email combination using email code received.

        Activate the email registration for the current tenant.

        :param location: Location of the activation. Required.
        :type location: str
        :param email_registration: The payload for tenant domain activation. Required.
        :type email_registration: ~azure.mgmt.datashare.models.EmailRegistration
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EmailRegistration or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.EmailRegistration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def activate_email(
        self, location: str, email_registration: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.EmailRegistration:
        """Activates the tenant and email combination using email code received.

        Activate the email registration for the current tenant.

        :param location: Location of the activation. Required.
        :type location: str
        :param email_registration: The payload for tenant domain activation. Required.
        :type email_registration: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EmailRegistration or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.EmailRegistration
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def activate_email(
        self, location: str, email_registration: Union[_models.EmailRegistration, IO], **kwargs: Any
    ) -> _models.EmailRegistration:
        """Activates the tenant and email combination using email code received.

        Activate the email registration for the current tenant.

        :param location: Location of the activation. Required.
        :type location: str
        :param email_registration: The payload for tenant domain activation. Is either a model type or
         a IO type. Required.
        :type email_registration: ~azure.mgmt.datashare.models.EmailRegistration or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EmailRegistration or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.EmailRegistration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.EmailRegistration]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(email_registration, (IO, bytes)):
            _content = email_registration
        else:
            _json = self._serialize.body(email_registration, "EmailRegistration")

        request = build_activate_email_request(
            location=location,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.activate_email.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EmailRegistration", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    activate_email.metadata = {"url": "/providers/Microsoft.DataShare/locations/{location}/activateEmail"}  # type: ignore

    @distributed_trace_async
    async def register_email(self, location: str, **kwargs: Any) -> _models.EmailRegistration:
        """Registers the tenant and email combination for verification.

        Register an email for the current tenant.

        :param location: Location of the registration. Required.
        :type location: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EmailRegistration or the result of cls(response)
        :rtype: ~azure.mgmt.datashare.models.EmailRegistration
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2020-09-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.EmailRegistration]

        request = build_register_email_request(
            location=location,
            api_version=api_version,
            template_url=self.register_email.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DataShareError, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("EmailRegistration", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    register_email.metadata = {"url": "/providers/Microsoft.DataShare/locations/{location}/registerEmail"}  # type: ignore
