# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .restore_request import RestoreRequest


class AzureWorkloadSAPHanaRestoreRequest(RestoreRequest):
    """AzureWorkload SAP Hana-specific restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureWorkloadSAPHanaPointInTimeRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param target_info: Details of target database
    :type target_info:
     ~azure.mgmt.recoveryservicesbackup.models.TargetRestoreInfo
    :param recovery_type: OLR/ALR, RestoreDisks is invalid option. Possible
     values include: 'Invalid', 'OriginalLocation', 'AlternateLocation',
     'RestoreDisks'
    :type recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RecoveryType
    :param source_resource_id: Fully qualified ARM ID of the VM on which
     workload that was running is being recovered.
    :type source_resource_id: str
    :param property_bag: Workload specific property bag.
    :type property_bag: dict[str, str]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'target_info': {'key': 'targetInfo', 'type': 'TargetRestoreInfo'},
        'recovery_type': {'key': 'recoveryType', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '{str}'},
    }

    _subtype_map = {
        'object_type': {'AzureWorkloadSAPHanaPointInTimeRestoreRequest': 'AzureWorkloadSAPHanaPointInTimeRestoreRequest'}
    }

    def __init__(self, **kwargs):
        super(AzureWorkloadSAPHanaRestoreRequest, self).__init__(**kwargs)
        self.target_info = kwargs.get('target_info', None)
        self.recovery_type = kwargs.get('recovery_type', None)
        self.source_resource_id = kwargs.get('source_resource_id', None)
        self.property_bag = kwargs.get('property_bag', None)
        self.object_type = 'AzureWorkloadSAPHanaRestoreRequest'
