/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Data;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class EarthLocationLite
extends RealTuple
implements EarthLocation {
    Real lat;
    Real lon;
    Real alt;
    RealTuple latlon;
    Data[] components;

    public EarthLocationLite(double lat, double lon, double alt) throws VisADException {
        this(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt));
    }

    public EarthLocationLite(Real lat, Real lon, Real alt) {
        super(RealTupleType.LatitudeLongitudeAltitude);
        this.lat = lat;
        this.lon = lon;
        this.alt = alt;
    }

    public boolean isMissing() {
        return this.lat.isMissing() || this.lon.isMissing() || this.alt.isMissing();
    }

    public Real getLatitude() {
        return this.lat;
    }

    public Real getLongitude() {
        return this.lon;
    }

    public Real getAltitude() {
        return this.alt;
    }

    public LatLonPoint getLatLonPoint() {
        if (this.latlon == null) {
            try {
                this.latlon = new LatLonTuple(this.lat, this.lon);
            }
            catch (Exception e) {
                this.latlon = this;
                throw new RuntimeException(e);
            }
        }
        return (LatLonPoint)((Object)this.latlon);
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        if (i == 0) {
            return this.lat;
        }
        if (i == 1) {
            return this.lon;
        }
        if (i == 2) {
            return this.alt;
        }
        throw new IllegalArgumentException("Wrong component number:" + i);
    }

    public Data[] getComponents(boolean copy) {
        if (this.components == null) {
            Data[] tmp = new Data[this.getDimension()];
            tmp[0] = this.lat;
            tmp[1] = this.lon;
            tmp[2] = this.alt;
            this.components = tmp;
        }
        return this.components;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EarthLocationLite)) {
            return false;
        }
        EarthLocationLite that = (EarthLocationLite)obj;
        return this.lat.equals(that.lat) && this.lon.equals(that.lon) && this.alt.equals(that.alt);
    }

    public int hashCode() {
        return this.lat.hashCode() ^ this.lon.hashCode() & this.alt.hashCode();
    }

    public String toString() {
        return this.getLatitude() + " " + this.getLongitude() + " " + this.getAltitude();
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        Real lat = new Real(RealType.Latitude);
        Real lon = new Real(RealType.Longitude);
        Real alt = new Real(RealType.Altitude);
        for (int j = 0; j < 10; ++j) {
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                EarthLocationTuple elt = new EarthLocationTuple(lat, lon, alt);
            }
            long t2 = System.currentTimeMillis();
            long t3 = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                EarthLocationLite elt = new EarthLocationLite(lat, lon, alt);
            }
            long t4 = System.currentTimeMillis();
            System.err.println("time EathLocationTuple:" + (t2 - t1) + " EarthLocationLite:" + (t4 - t3));
        }
    }
}

