/*
 * Decompiled with CFR 0.152.
 */
package visad.benjamin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import visad.CellImpl;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.ContourControl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Field;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.SampledSet;
import visad.ScalarMap;
import visad.Set;
import visad.UnionSet;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.util.LabeledColorWidget;
import visad.util.VisADSlider;

public class Galaxy
implements ActionListener {
    RemoteServerImpl server_server;
    RemoteServer client_server;
    static int NxpxMAX;
    static int NypxMAX;
    static int NRMAX;
    static int NZMAX;
    static int NXP;
    static int NYP;
    static int NZP;
    static int NX;
    static int NY;
    static int NZ;
    static double llast;
    static double elast;
    Linear3DSet grid_set;
    Linear2DSet image_set;
    Linear2DSet lonlat_set;
    Linear1DSet distSol_set;
    Set distDomain;
    Set velDomain;
    Gridded3DSet line_to_sol;
    Gridded3DSet x_to_sol;
    Gridded3DSet y_to_sol;
    Gridded3DSet z_to_sol;
    SampledSet[] set_s = new SampledSet[3];
    UnionSet sol_sight;
    RealTuple sol;
    float sol_x = 0.0f;
    float sol_y = 8.5f;
    float sol_z = 0.0f;
    int npts = 2;
    float[][] samples = new float[3][this.npts];
    int n_profpts = 50;
    float[] xprof = new float[this.n_profpts];
    float[] yprof = new float[this.n_profpts];
    float[][] yprof_a = new float[1][this.n_profpts];
    float[][] xprof_a = new float[1][this.n_profpts];
    int i_type = 1;
    float last_x;
    float last_y;
    float last_z;
    float l;
    float b;
    float d;
    float[] lbd = new float[3];
    float[][] lonlat_b;
    float[][] image_b;
    int length_0;
    int length_1;
    RealType gridx;
    RealType gridy;
    RealType gridz;
    RealTupleType grid_domain;
    RealType density;
    RealType emission;
    RealType Intensity;
    RealType distance;
    RealType v_LSR;
    FunctionType grid_type;
    FunctionType dist_density;
    FunctionType vel_intensity;
    FlatField field_D;
    FlatField field_E;
    RealType line;
    RealType element;
    RealTupleType image_domain;
    RealType radiance;
    FunctionType image_type;
    RealType lon;
    RealType lat;
    RealTupleType lonlat_range;
    FunctionType lonlat_type;
    DataReference grid_ref;
    DataReference image_ref;
    DataReference lonlat_ref;
    DataReference sphrSkyMap_ref;
    DataReference ireg_set_ref;
    DataReference line_to_sol_ref;
    DataReference sol_ref;
    DataReference sol_sightRef;
    DataReference red_cursor_ref;
    DataReference dist_densityRef;
    DataReference vel_intensityRef;
    DataReference n1_ref;
    DataReference h1_ref;
    DataReference A1_ref;
    DataReference n2_ref;
    DataReference h2_ref;
    DataReference A2_ref;
    DataReference na_ref;
    DataReference ha_ref;
    DataReference wa_ref;
    DataReference Aa_ref;
    static final double F1 = 0.36;
    static final double F2 = 40.0;
    static final double Fa = 6.0;
    DataReference density_ref;
    DataReference contour_button_ref;
    DataReference compute_button_ref;
    DataReference reset_button_ref;
    DataReference density_button_ref;
    DataReference flat_sphere_button_ref;
    DisplayImpl display1;
    DisplayImpl display2;
    DisplayImpl display3;
    DisplayImpl display4;
    DisplayImpl display5;
    JTextField[] coord_fields = new JTextField[3];
    JPanel center;
    JButton flat_sphere_button;
    JPanel panel2;
    JPanel panel5;
    JPanel widget_panel;
    LabeledColorWidget lw2;
    LabeledColorWidget lw5;
    ConstantMap[] cmaps;
    ConstantMap[] cmaps_sol;
    ConstantMap[] cmaps_line;
    ConstantMap[] yellow;
    ScalarMap linemap;

    public static void main(String[] args) throws VisADException, RemoteException {
        Galaxy galaxy = new Galaxy(args);
        if (galaxy.client_server != null) {
            galaxy.setupClient();
        } else if (galaxy.server_server != null) {
            System.loadLibrary("Galaxy");
            galaxy.setupServer();
        } else {
            System.loadLibrary("Galaxy");
            galaxy.setupServer();
        }
    }

    public Galaxy(String[] args) throws VisADException, RemoteException {
        if (args.length > 0) {
            String domain = "//" + args[0] + "/Galaxy";
            try {
                this.client_server = (RemoteServer)Naming.lookup(domain);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (NotBoundException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (AccessException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
            catch (RemoteException e) {
                System.out.println("Cannot connect to server");
                System.exit(0);
            }
        } else {
            this.server_server = new RemoteServerImpl();
            try {
                Naming.rebind("///Galaxy", this.server_server);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (AccessException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
            catch (RemoteException e) {
                System.out.println("Cannot set up server - running as stand-alone");
                this.server_server = null;
            }
        }
    }

    void setupServer() throws VisADException, RemoteException {
        int[] constants = new int[4];
        this.getcon_c(constants);
        NxpxMAX = constants[0];
        NypxMAX = constants[1];
        NRMAX = constants[2];
        NZMAX = constants[3];
        NYP = NXP = NRMAX - 1;
        NZP = NZMAX - 1;
        NX = 2 * NXP + 1;
        NY = 2 * NYP + 1;
        NZ = 2 * NZP + 1;
        this.gridx = RealType.getRealType("gridx");
        this.gridy = RealType.getRealType("gridy");
        this.gridz = RealType.getRealType("gridz");
        this.grid_domain = new RealTupleType(this.gridx, this.gridy, this.gridz);
        this.density = RealType.getRealType("density");
        this.Intensity = RealType.getRealType("Intensity");
        this.distance = RealType.getRealType("distance");
        this.v_LSR = RealType.getRealType("v_LSR");
        this.grid_type = new FunctionType(this.grid_domain, this.density);
        this.dist_density = new FunctionType(this.distance, this.density);
        this.vel_intensity = new FunctionType(this.v_LSR, this.Intensity);
        this.line = RealType.getRealType("line");
        this.element = RealType.getRealType("element");
        this.image_domain = new RealTupleType(this.element, this.line);
        this.radiance = RealType.getRealType("H-alpha");
        this.image_type = new FunctionType(this.image_domain, this.radiance);
        this.lon = RealType.getRealType("lon", CommonUnit.degree);
        this.lat = RealType.getRealType("lat", CommonUnit.degree);
        this.lonlat_range = new RealTupleType(this.lon, this.lat);
        this.lonlat_type = new FunctionType(this.image_domain, this.lonlat_range);
        this.grid_ref = new DataReferenceImpl("grid_ref");
        final float[][] grid_a = new float[1][NX * NY * NZ];
        this.image_ref = new DataReferenceImpl("image_ref");
        final float[][] image_a = new float[1][NxpxMAX * NypxMAX];
        this.lonlat_ref = new DataReferenceImpl("lonlat_ref");
        final float[][] lonlat_a = new float[2][NxpxMAX * NypxMAX];
        this.sphrSkyMap_ref = new DataReferenceImpl("sphrSkyMap_ref");
        this.ireg_set_ref = new DataReferenceImpl("ireg_set_ref");
        this.n1_ref = new DataReferenceImpl("n1_ref");
        this.h1_ref = new DataReferenceImpl("h1_ref");
        this.A1_ref = new DataReferenceImpl("A1_ref");
        this.n2_ref = new DataReferenceImpl("n2_ref");
        this.h2_ref = new DataReferenceImpl("h2_ref");
        this.A2_ref = new DataReferenceImpl("A2_ref");
        this.na_ref = new DataReferenceImpl("na_ref");
        this.ha_ref = new DataReferenceImpl("ha_ref");
        this.wa_ref = new DataReferenceImpl("wa_ref");
        this.Aa_ref = new DataReferenceImpl("Aa_ref");
        this.compute_button_ref = new DataReferenceImpl("compute_button");
        this.contour_button_ref = new DataReferenceImpl("contour_button");
        this.reset_button_ref = new DataReferenceImpl("reset_button");
        this.density_button_ref = new DataReferenceImpl("density_button");
        this.density_ref = new DataReferenceImpl("density");
        this.red_cursor_ref = new DataReferenceImpl("red_cursor_ref");
        this.sol_ref = new DataReferenceImpl("sol_ref");
        this.dist_densityRef = new DataReferenceImpl("dist_densityRef");
        this.vel_intensityRef = new DataReferenceImpl("vel_intensityRef");
        this.flat_sphere_button_ref = new DataReferenceImpl("flat_sphere_button");
        this.flat_sphere_button_ref.setData(new Real(0.0));
        final RealTuple init_red_cursor = new RealTuple(new Real[]{new Real(this.gridx, 0.0), new Real(this.gridy, 0.0), new Real(this.gridz, 20.0)});
        this.sol_sightRef = new DataReferenceImpl("sol_sight");
        this.samples[0][0] = this.sol_x;
        this.samples[1][0] = this.sol_y;
        this.samples[2][0] = this.sol_z;
        this.samples[0][1] = 20.0f;
        this.samples[1][1] = this.sol_y;
        this.samples[2][1] = this.sol_z;
        this.x_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.samples[0][1] = this.sol_x;
        this.samples[1][1] = 20.0f;
        this.samples[2][1] = this.sol_z;
        this.y_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.samples[0][1] = this.sol_x;
        this.samples[1][1] = this.sol_y;
        this.samples[2][1] = 80.0f;
        this.z_to_sol = new Gridded3DSet((MathType)this.grid_domain, this.samples, this.npts, null, null, null);
        this.set_s[0] = this.x_to_sol;
        this.set_s[1] = this.y_to_sol;
        this.set_s[2] = this.z_to_sol;
        this.sol_sight = new UnionSet((MathType)this.grid_domain, this.set_s);
        this.sol_sightRef.setData(this.sol_sight);
        RealTuple sol = new RealTuple(new Real[]{new Real(this.gridx, 0.0), new Real(this.gridy, 8.5), new Real(this.gridz, 0.0)});
        this.sol_ref.setData(sol);
        this.line_to_sol_ref = new DataReferenceImpl("line_to_sol_ref");
        DisplayImpl[] displays = new DisplayImpl[5];
        VisADSlider[] sliders = new VisADSlider[1];
        this.setupDisplays(false, displays, sliders);
        this.setupUI(displays, sliders);
        final int[] sizes = new int[5];
        final float[] params = new float[13];
        CellImpl cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                File file = new File("./switch.out");
                file.delete();
                params[0] = (float)((Real)Galaxy.this.n1_ref.getData()).getValue();
                params[1] = (float)((Real)Galaxy.this.h1_ref.getData()).getValue();
                params[2] = (float)((Real)Galaxy.this.A1_ref.getData()).getValue();
                params[3] = 0.36f;
                params[4] = (float)((Real)Galaxy.this.n2_ref.getData()).getValue();
                params[5] = (float)((Real)Galaxy.this.h2_ref.getData()).getValue();
                params[6] = (float)((Real)Galaxy.this.A2_ref.getData()).getValue();
                params[7] = 40.0f;
                params[8] = (float)((Real)Galaxy.this.na_ref.getData()).getValue();
                params[9] = (float)((Real)Galaxy.this.ha_ref.getData()).getValue();
                params[10] = (float)((Real)Galaxy.this.wa_ref.getData()).getValue();
                params[11] = (float)((Real)Galaxy.this.Aa_ref.getData()).getValue();
                params[12] = 6.0f;
                Galaxy.this.ismgsc_c(params, sizes, grid_a[0], image_a[0], lonlat_a[0], lonlat_a[1]);
                elast = (double)sizes[0] - 1.0;
                llast = (double)sizes[1] - 1.0;
                Galaxy.this.length_0 = sizes[0];
                Galaxy.this.length_1 = sizes[1];
                Galaxy.this.image_set = Galaxy.this.lonlat_set = new Linear2DSet(0.0, elast, sizes[0], 0.0, llast, sizes[1]);
                Galaxy.this.linemap.setRange(-0.5 * llast, 1.5 * llast + 1.0);
                FlatField image = new FlatField(Galaxy.this.image_type, Galaxy.this.image_set);
                Galaxy.this.image_b = new float[1][sizes[0] * sizes[1]];
                System.arraycopy(image_a[0], 0, Galaxy.this.image_b[0], 0, Galaxy.this.image_b[0].length);
                image.setSamples(Galaxy.this.image_b);
                Galaxy.this.image_ref.setData(image);
                FlatField lonlat = new FlatField(Galaxy.this.lonlat_type, Galaxy.this.lonlat_set);
                Galaxy.this.lonlat_b = new float[2][sizes[0] * sizes[1]];
                System.arraycopy(lonlat_a[0], 0, Galaxy.this.lonlat_b[0], 0, Galaxy.this.lonlat_b[0].length);
                System.arraycopy(lonlat_a[1], 0, Galaxy.this.lonlat_b[1], 0, Galaxy.this.lonlat_b[1].length);
                FlatField f_field = Galaxy.this.makeSphericalSkyMap();
                Galaxy.this.sphrSkyMap_ref.setData(f_field);
                for (int i = 0; i < sizes[0] * sizes[1]; ++i) {
                    if (Galaxy.this.lonlat_b[0][i] < -400.0f) {
                        Galaxy.this.lonlat_b[0][i] = Float.NaN;
                    }
                    if (!(Galaxy.this.lonlat_b[1][i] < -400.0f)) continue;
                    Galaxy.this.lonlat_b[1][i] = Float.NaN;
                }
                lonlat.setSamples(Galaxy.this.lonlat_b);
                Galaxy.this.lonlat_ref.setData(lonlat);
                double halfx = 0.5 * ((double)sizes[2] - 1.0);
                double halfy = 0.5 * ((double)sizes[3] - 1.0);
                double halfz = 0.5 * ((double)sizes[4] - 1.0);
                Galaxy.this.grid_set = new Linear3DSet(-halfx, halfx, sizes[2], -halfy, halfy, sizes[3], -halfz, halfz, sizes[4]);
                FlatField grid = new FlatField(Galaxy.this.grid_type, Galaxy.this.grid_set);
                float[][] grid_b = new float[1][sizes[2] * sizes[3] * sizes[4]];
                System.arraycopy(grid_a[0], 0, grid_b[0], 0, grid_b[0].length);
                grid.setSamples(grid_b);
                Galaxy.this.grid_ref.setData(grid);
                Galaxy.this.red_cursor_ref.setData(init_red_cursor);
            }
        };
        Real compute_button = new Real(0.0);
        this.compute_button_ref.setData(compute_button);
        cell.addReference(this.compute_button_ref);
        CellImpl reset_cell = new CellImpl(){
            boolean first = true;

            public void doAction() throws VisADException, RemoteException {
                if (!this.first) {
                    System.out.println("reset:doAction");
                    Galaxy.this.n1_ref.setData(new Real(0.025));
                    Galaxy.this.h1_ref.setData(new Real(0.906));
                    Galaxy.this.A1_ref.setData(new Real(19.957));
                    Galaxy.this.n2_ref.setData(new Real(0.099));
                    Galaxy.this.h2_ref.setData(new Real(0.15));
                    Galaxy.this.A2_ref.setData(new Real(3.693));
                    Galaxy.this.na_ref.setData(new Real(0.074));
                    Galaxy.this.ha_ref.setData(new Real(0.297));
                    Galaxy.this.wa_ref.setData(new Real(0.298));
                    Galaxy.this.Aa_ref.setData(new Real(8.278));
                } else {
                    this.first = false;
                }
            }
        };
        reset_cell.addReference(this.reset_button_ref);
        CellImpl red_cursor_cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                RealTuple red_cursor = (RealTuple)Galaxy.this.red_cursor_ref.getData();
                if (red_cursor == null) {
                    return;
                }
                Galaxy.this.last_x = (float)((Real)red_cursor.getComponent(0)).getValue();
                Galaxy.this.last_y = (float)((Real)red_cursor.getComponent(1)).getValue();
                Galaxy.this.last_z = (float)((Real)red_cursor.getComponent(2)).getValue();
                double step_x = (((Real)red_cursor.getComponent(0)).getValue() - (double)Galaxy.this.sol_x) / ((double)Galaxy.this.npts - 1.0);
                double step_y = (((Real)red_cursor.getComponent(1)).getValue() - (double)Galaxy.this.sol_y) / ((double)Galaxy.this.npts - 1.0);
                double step_z = (((Real)red_cursor.getComponent(2)).getValue() - (double)Galaxy.this.sol_z) / ((double)Galaxy.this.npts - 1.0);
                for (int ii = 0; ii < Galaxy.this.npts; ++ii) {
                    Galaxy.this.samples[0][ii] = (float)((double)Galaxy.this.sol_x + (double)ii * step_x);
                    Galaxy.this.samples[1][ii] = (float)((double)Galaxy.this.sol_y + (double)ii * step_y);
                    Galaxy.this.samples[2][ii] = (float)((double)Galaxy.this.sol_z + (double)ii * step_z);
                }
                Galaxy.this.line_to_sol = new Gridded3DSet(red_cursor.getType(), Galaxy.this.samples, Galaxy.this.npts, null, null, null);
                Galaxy.this.line_to_sol_ref.setData(Galaxy.this.line_to_sol);
                Galaxy.this.galtosol(Galaxy.this.last_x, Galaxy.this.last_y, Galaxy.this.last_z, Galaxy.this.lbd);
                Galaxy.this.coord_fields[0].setText(PlotText.shortString(Galaxy.this.lbd[0]));
                Galaxy.this.coord_fields[1].setText(PlotText.shortString(Galaxy.this.lbd[1]));
                Galaxy.this.coord_fields[2].setText(PlotText.shortString(Galaxy.this.lbd[2]));
                Galaxy.this.density_button_ref.setData(new Real(0.0));
            }
        };
        this.red_cursor_ref.setData(init_red_cursor);
        red_cursor_cell.addReference(this.red_cursor_ref);
        CellImpl computeDensityEmission_cell = new CellImpl(){

            public void doAction() throws VisADException, RemoteException {
                Galaxy.this.i_type = 1;
                Galaxy.this.profile_c(Galaxy.this.i_type, Galaxy.this.n_profpts, Galaxy.this.last_x, Galaxy.this.last_y, Galaxy.this.last_z, Galaxy.this.xprof, Galaxy.this.yprof);
                Galaxy.this.distDomain = new Linear1DSet((MathType)Galaxy.this.distance, Galaxy.this.xprof[0], Galaxy.this.xprof[Galaxy.this.n_profpts - 1], Galaxy.this.n_profpts);
                Galaxy.this.field_D = new FlatField(Galaxy.this.dist_density, Galaxy.this.distDomain);
                Galaxy.this.yprof_a[0] = Galaxy.this.yprof;
                Galaxy.this.field_D.setSamples(Galaxy.this.yprof_a);
                Galaxy.this.dist_densityRef.setData(Galaxy.this.field_D);
                Galaxy.this.i_type = 2;
                Galaxy.this.profile_c(Galaxy.this.i_type, Galaxy.this.n_profpts, Galaxy.this.last_x, Galaxy.this.last_y, Galaxy.this.last_z, Galaxy.this.xprof, Galaxy.this.yprof);
                Galaxy.this.velDomain = new Linear1DSet((MathType)Galaxy.this.v_LSR, Galaxy.this.xprof[0], Galaxy.this.xprof[Galaxy.this.n_profpts - 1], Galaxy.this.n_profpts);
                Galaxy.this.field_E = new FlatField(Galaxy.this.vel_intensity, Galaxy.this.velDomain);
                Galaxy.this.yprof_a[0] = Galaxy.this.yprof;
                Galaxy.this.field_E.setSamples(Galaxy.this.yprof_a);
                Galaxy.this.vel_intensityRef.setData(Galaxy.this.field_E);
            }
        };
        computeDensityEmission_cell.addReference(this.density_button_ref);
        if (this.server_server != null) {
            RemoteDataReferenceImpl[] refs = new RemoteDataReferenceImpl[]{new RemoteDataReferenceImpl((DataReferenceImpl)this.grid_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.image_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.lonlat_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.n1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.h1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.A1_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.n2_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.h2_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.A2_ref), null, new RemoteDataReferenceImpl((DataReferenceImpl)this.na_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.ha_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.wa_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.Aa_ref), null, new RemoteDataReferenceImpl((DataReferenceImpl)this.compute_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.contour_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.density_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.reset_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.red_cursor_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.sol_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.line_to_sol_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.dist_densityRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.vel_intensityRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.sol_sightRef), new RemoteDataReferenceImpl((DataReferenceImpl)this.density_button_ref), new RemoteDataReferenceImpl((DataReferenceImpl)this.sphrSkyMap_ref)};
            this.server_server.setDataReferences(refs);
        }
    }

    void setupClient() throws VisADException, RemoteException {
        RemoteDataReference[] refs = this.client_server.getDataReferences();
        if (refs == null) {
            System.out.println("Cannot connect to server");
            System.exit(0);
        }
        this.grid_ref = refs[0];
        this.image_ref = refs[1];
        this.lonlat_ref = refs[2];
        this.n1_ref = refs[3];
        this.h1_ref = refs[4];
        this.A1_ref = refs[5];
        this.n2_ref = refs[6];
        this.h2_ref = refs[7];
        this.A2_ref = refs[8];
        this.na_ref = refs[10];
        this.ha_ref = refs[11];
        this.wa_ref = refs[12];
        this.Aa_ref = refs[13];
        this.compute_button_ref = refs[15];
        this.contour_button_ref = refs[16];
        this.density_ref = refs[17];
        this.reset_button_ref = refs[18];
        this.red_cursor_ref = refs[19];
        this.sol_ref = refs[20];
        this.line_to_sol_ref = refs[21];
        this.dist_densityRef = refs[22];
        this.vel_intensityRef = refs[23];
        this.sol_sightRef = refs[24];
        this.density_button_ref = refs[25];
        this.sphrSkyMap_ref = refs[26];
        this.flat_sphere_button_ref = new DataReferenceImpl("flat_sphere_button");
        this.flat_sphere_button_ref.setData(new Real(0.0));
        this.grid_type = (FunctionType)this.grid_ref.getType();
        this.grid_domain = this.grid_type.getDomain();
        this.density = (RealType)this.grid_type.getRange();
        this.gridx = (RealType)this.grid_domain.getComponent(0);
        this.gridy = (RealType)this.grid_domain.getComponent(1);
        this.gridz = (RealType)this.grid_domain.getComponent(2);
        this.distance = (RealType)((FunctionType)this.dist_densityRef.getType()).getDomain().getComponent(0);
        this.v_LSR = (RealType)((FunctionType)this.vel_intensityRef.getType()).getDomain().getComponent(0);
        this.Intensity = (RealType)((FunctionType)this.vel_intensityRef.getType()).getRange();
        Field grid = (Field)this.grid_ref.getData();
        this.grid_set = (Linear3DSet)grid.getDomainSet();
        int[] lens = this.grid_set.getLengths();
        NX = lens[0];
        NY = lens[1];
        NZ = lens[2];
        this.image_type = (FunctionType)this.image_ref.getType();
        this.image_domain = this.image_type.getDomain();
        this.radiance = (RealType)this.image_type.getRange();
        this.element = (RealType)this.image_domain.getComponent(0);
        this.line = (RealType)this.image_domain.getComponent(1);
        this.lonlat_type = (FunctionType)this.lonlat_ref.getType();
        this.lonlat_range = (RealTupleType)this.lonlat_type.getRange();
        this.lon = (RealType)this.lonlat_range.getComponent(0);
        this.lat = (RealType)this.lonlat_range.getComponent(1);
        Field lonlat = (Field)this.lonlat_ref.getData();
        this.lonlat_set = (Linear2DSet)lonlat.getDomainSet();
        lens = this.lonlat_set.getLengths();
        elast = lens[0];
        llast = lens[1];
        DisplayImpl[] displays = new DisplayImpl[5];
        VisADSlider[] sliders = new VisADSlider[1];
        this.setupDisplays(true, displays, sliders);
        this.setupUI(displays, sliders);
    }

    void setupDisplays(boolean client, DisplayImpl[] displays, VisADSlider[] sliders) throws VisADException, RemoteException {
        this.display1 = new DisplayImplJ3D("display1");
        this.display1.addMap(new ScalarMap(this.gridx, Display.XAxis));
        this.display1.addMap(new ScalarMap(this.gridy, Display.YAxis));
        ScalarMap mapz = new ScalarMap(this.gridz, Display.ZAxis);
        mapz.setRange(-NZ, 2 * NZ - 1);
        this.display1.addMap(mapz);
        GraphicsModeControl mode1 = this.display1.getGraphicsModeControl();
        mode1.setScaleEnable(true);
        ScalarMap mapdcontour = new ScalarMap(this.density, Display.IsoContour);
        this.display1.addMap(mapdcontour);
        ContourControl controldcontour = (ContourControl)mapdcontour.getControl();
        controldcontour.setSurfaceValue(0.06f);
        controldcontour.enableContours(true);
        this.cmaps = new ConstantMap[4];
        this.cmaps[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps[1] = new ConstantMap(1.0, Display.Red);
        this.cmaps[2] = new ConstantMap(0.0, Display.Green);
        this.cmaps[3] = new ConstantMap(4.0, Display.PointSize);
        this.cmaps_sol = new ConstantMap[4];
        this.cmaps_sol[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps_sol[1] = new ConstantMap(1.0, Display.Red);
        this.cmaps_sol[2] = new ConstantMap(1.0, Display.Green);
        this.cmaps_sol[3] = new ConstantMap(6.0, Display.PointSize);
        this.cmaps_line = new ConstantMap[3];
        this.cmaps_line[0] = new ConstantMap(0.0, Display.Blue);
        this.cmaps_line[1] = new ConstantMap(1.0, Display.Green);
        this.cmaps_line[2] = new ConstantMap(0.0, Display.Red);
        this.yellow = new ConstantMap[3];
        this.yellow[0] = new ConstantMap(0.0, Display.Blue);
        this.yellow[1] = new ConstantMap(1.0, Display.Green);
        this.yellow[2] = new ConstantMap(1.0, Display.Red);
        if (client) {
            RemoteDisplayImpl remote_display1 = new RemoteDisplayImpl(this.display1);
            remote_display1.addReference(this.grid_ref);
            remote_display1.addReference(this.sol_ref, this.cmaps_sol);
            remote_display1.addReference(this.line_to_sol_ref, this.cmaps_line);
            remote_display1.addReference(this.sol_sightRef, this.yellow);
            remote_display1.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.red_cursor_ref, this.cmaps);
        } else {
            this.display1.addReference(this.grid_ref);
            this.display1.addReference(this.sol_ref, this.cmaps_sol);
            this.display1.addReference(this.line_to_sol_ref, this.cmaps_line);
            this.display1.addReference(this.sol_sightRef, this.yellow);
            this.display1.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), this.red_cursor_ref, this.cmaps);
        }
        VisADSlider density_slider = new VisADSlider("density", 0, 400, 60, 0.001, this.density_ref, RealType.Generic);
        Dimension slide_dim = density_slider.getMinimumSize();
        slide_dim.width = 70;
        density_slider.setMinimumSize(slide_dim);
        this.display2 = new DisplayImplJ2D("display2");
        this.display2.setAlwaysAutoScale(true);
        GraphicsModeControl mode2 = this.display2.getGraphicsModeControl();
        mode2.setScaleEnable(false);
        DisplayRenderer displayRenderer = this.display2.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        this.display2.addMap(new ScalarMap(this.element, Display.XAxis));
        this.linemap = new ScalarMap(this.line, Display.YAxis);
        this.display2.addMap(this.linemap);
        ScalarMap rgbmap2 = new ScalarMap(this.radiance, Display.RGB);
        this.display2.addMap(rgbmap2);
        ScalarMap lonmap = new ScalarMap(this.lon, Display.IsoContour);
        this.display2.addMap(lonmap);
        ScalarMap latmap = new ScalarMap(this.lat, Display.IsoContour);
        this.display2.addMap(latmap);
        this.lw2 = new LabeledColorWidget(rgbmap2);
        ContourControl loncontrol = (ContourControl)lonmap.getControl();
        loncontrol.enableContours(true);
        loncontrol.setContourInterval(30.0f, -180.0f, 180.0f, -180.0f);
        ContourControl latcontrol = (ContourControl)latmap.getControl();
        latcontrol.enableContours(true);
        latcontrol.setContourInterval(30.0f, -90.0f, 89.0f, -90.0f);
        if (client) {
            this.linemap.setRange(-0.5 * llast, 1.5 * llast + 1.0);
            RemoteDisplayImpl remote_display2 = new RemoteDisplayImpl(this.display2);
            remote_display2.addReference(this.image_ref);
            remote_display2.addReference(this.lonlat_ref);
        } else {
            this.display2.addReference(this.image_ref);
            this.display2.addReference(this.lonlat_ref);
        }
        ContourCell cell_density = new ContourCell(controldcontour, this.density_ref);
        Real contour_button = new Real(0.0);
        this.contour_button_ref.setData(contour_button);
        if (client) {
            RemoteCellImpl remote_cell_density = new RemoteCellImpl(cell_density);
            remote_cell_density.addReference(this.contour_button_ref);
        } else {
            cell_density.addReference(this.contour_button_ref);
        }
        this.display3 = new DisplayImplJ2D("display3");
        this.display4 = new DisplayImplJ2D("display4");
        this.display3.setAlwaysAutoScale(true);
        this.display4.setAlwaysAutoScale(true);
        GraphicsModeControl mode3 = this.display3.getGraphicsModeControl();
        mode3.setScaleEnable(true);
        GraphicsModeControl mode4 = this.display4.getGraphicsModeControl();
        mode4.setScaleEnable(true);
        this.display3.addMap(new ScalarMap(this.distance, Display.XAxis));
        this.display3.addMap(new ScalarMap(this.density, Display.YAxis));
        this.display3.addMap(new ScalarMap(this.density, Display.Green));
        this.display4.addMap(new ScalarMap(this.v_LSR, Display.XAxis));
        this.display4.addMap(new ScalarMap(this.Intensity, Display.YAxis));
        this.display4.addMap(new ScalarMap(this.Intensity, Display.Green));
        if (client) {
            RemoteDisplayImpl remote_display3 = new RemoteDisplayImpl(this.display3);
            remote_display3.addReference(this.dist_densityRef);
            RemoteDisplayImpl remote_display4 = new RemoteDisplayImpl(this.display4);
            remote_display4.addReference(this.vel_intensityRef);
        } else {
            this.display3.addReference(this.dist_densityRef);
            this.display4.addReference(this.vel_intensityRef);
        }
        this.display5 = new DisplayImplJ3D("display5");
        this.display5.addMap(new ScalarMap(this.lon, Display.Longitude));
        this.display5.addMap(new ScalarMap(this.lat, Display.Latitude));
        ScalarMap rgbmap5 = new ScalarMap(this.radiance, Display.RGB);
        this.display5.addMap(rgbmap5);
        this.lw5 = new LabeledColorWidget(rgbmap5);
        if (client) {
            RemoteDisplayImpl remote_display5 = new RemoteDisplayImpl(this.display5);
            remote_display5.addReference(this.sphrSkyMap_ref);
        } else {
            this.display5.addReference(this.sphrSkyMap_ref);
        }
        sliders[0] = density_slider;
        displays[0] = this.display1;
        displays[1] = this.display2;
        displays[2] = this.display3;
        displays[3] = this.display4;
        displays[4] = this.display5;
    }

    void setupUI(DisplayImpl[] displays, VisADSlider[] sliders) throws VisADException, RemoteException {
        JFrame frame = new JFrame("VisAD Collaborative Galaxy Designer");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        int WIDTH = 1200;
        int HEIGHT = 950;
        frame.setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        JPanel big_panel = new JPanel();
        big_panel.setLayout(new BoxLayout(big_panel, 0));
        big_panel.setAlignmentY(0.0f);
        big_panel.setAlignmentX(0.0f);
        frame.setContentPane(big_panel);
        JPanel left = new JPanel();
        left.setLayout(new BoxLayout(left, 1));
        left.setAlignmentY(0.0f);
        left.setAlignmentX(0.0f);
        big_panel.add(left);
        left.add(new JLabel("Interactive Milky Way galaxy design"));
        left.add(new JLabel("using VisAD  -  see:"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        left.add(new JLabel("  "));
        left.add(new JLabel("for more information about VisAD."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Bill Hibbard and Bob Benjamin"));
        left.add(new JLabel("University of Wisconsin - Madison"));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        left.add(new JLabel("Adjust Milky Way galaxy parameters using"));
        left.add(new JLabel("sliders."));
        left.add(new JLabel("  "));
        left.add(new JLabel("Then press 'Compute' button to compute"));
        left.add(new JLabel("new galaxy."));
        left.add(new JLabel("  "));
        left.add(new JLabel("  "));
        JPanel slider_panel = new JPanel();
        slider_panel.setName("Galaxy Sliders");
        slider_panel.setFont(new Font("Dialog", 0, 12));
        slider_panel.setLayout(new BoxLayout(slider_panel, 1));
        slider_panel.setAlignmentY(0.0f);
        slider_panel.setAlignmentX(0.0f);
        left.add(slider_panel);
        slider_panel.add(new VisADSlider("n1", 0, 500, 250, 1.0E-4, this.n1_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("h1", 0, 300, 91, 0.01, this.h1_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("A1", 50, 400, 200, 0.1, this.A1_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("n2", 0, 500, 100, 0.001, this.n2_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("h2", 0, 300, 150, 0.001, this.h2_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("A2", 10, 600, 370, 0.01, this.A2_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("na", 0, 200, 80, 0.001, this.na_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("ha", 0, 100, 30, 0.01, this.ha_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("wa", 0, 500, 300, 0.001, this.wa_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new VisADSlider("Aa", 50, 200, 85, 0.1, this.Aa_ref, RealType.Generic));
        slider_panel.add(new JLabel("  "));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setAlignmentY(0.0f);
        buttonPanel.setAlignmentX(0.0f);
        JButton compute = new JButton("Compute");
        compute.addActionListener(this);
        compute.setActionCommand("compute");
        buttonPanel.add(compute);
        JButton reset = new JButton("Reset");
        reset.addActionListener(this);
        reset.setActionCommand("reset");
        buttonPanel.add(reset);
        slider_panel.add(buttonPanel);
        slider_panel.add(new JLabel("  "));
        slider_panel.add(new JLabel("  "));
        this.widget_panel = new JPanel();
        this.widget_panel.setName("Color Widget");
        this.widget_panel.setFont(new Font("Dialog", 0, 12));
        this.widget_panel.setLayout(new BoxLayout(this.widget_panel, 1));
        this.widget_panel.setAlignmentY(0.0f);
        this.widget_panel.setAlignmentX(0.0f);
        Dimension d = new Dimension(400, 950);
        left.setMaximumSize(d);
        left.add(this.widget_panel);
        d = new Dimension(300, 170);
        this.lw2.setMaximumSize(d);
        this.lw5.setMaximumSize(d);
        this.widget_panel.add(this.lw2);
        this.center = new JPanel();
        this.center.setLayout(new BoxLayout(this.center, 1));
        this.center.setAlignmentY(0.0f);
        this.center.setAlignmentX(0.0f);
        d = new Dimension(400, 950);
        this.center.setMaximumSize(d);
        this.center.setPreferredSize(new Dimension(400, 950));
        big_panel.add(this.center);
        JPanel contour_panel = new JPanel();
        contour_panel.setLayout(new BoxLayout(contour_panel, 0));
        contour_panel.setAlignmentY(0.0f);
        contour_panel.setAlignmentX(0.0f);
        contour_panel.add(sliders[0]);
        JButton contour = new JButton("Contour");
        contour.setAlignmentY(0.0f);
        contour.setAlignmentX(0.0f);
        contour.addActionListener(this);
        contour.setActionCommand("contour");
        contour_panel.add(contour);
        JPanel panel1 = (JPanel)displays[0].getComponent();
        this.panel2 = (JPanel)displays[1].getComponent();
        JPanel panel3 = (JPanel)displays[2].getComponent();
        JPanel panel4 = (JPanel)displays[3].getComponent();
        this.panel5 = (JPanel)displays[4].getComponent();
        CompoundBorder etchedBorder5 = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
        panel1.setBorder(etchedBorder5);
        this.panel2.setBorder(etchedBorder5);
        panel3.setBorder(etchedBorder5);
        panel4.setBorder(etchedBorder5);
        this.panel5.setBorder(etchedBorder5);
        JPanel coord_panel = new JPanel();
        coord_panel.setLayout(new BoxLayout(coord_panel, 0));
        coord_panel.setAlignmentY(0.0f);
        coord_panel.setAlignmentX(0.0f);
        this.coord_fields[0] = new JTextField("---");
        this.coord_fields[0].setBackground(Color.black);
        this.coord_fields[0].setForeground(Color.white);
        this.coord_fields[1] = new JTextField("---");
        this.coord_fields[1].setBackground(Color.black);
        this.coord_fields[1].setForeground(Color.white);
        this.coord_fields[2] = new JTextField("---");
        this.coord_fields[2].setBackground(Color.black);
        this.coord_fields[2].setForeground(Color.white);
        for (int i = 0; i < 3; ++i) {
            Dimension msize = this.coord_fields[i].getMaximumSize();
            Dimension psize = this.coord_fields[i].getPreferredSize();
            msize.height = psize.height;
            this.coord_fields[i].setMaximumSize(msize);
        }
        JLabel coord_label = new JLabel("L:");
        coord_panel.add(coord_label);
        coord_panel.add(this.coord_fields[0]);
        coord_label = new JLabel("B:");
        coord_panel.add(coord_label);
        coord_panel.add(this.coord_fields[1]);
        coord_label = new JLabel("D:");
        coord_panel.add(coord_label);
        coord_panel.add(this.coord_fields[2]);
        JLabel display1_label = new JLabel("3D isodensity surface of Galaxy");
        JLabel display1a_label = new JLabel("set density slider and press Contour button");
        JLabel display2_label = new JLabel("H-alpha emission sky map");
        JLabel display2a_label = new JLabel("as seen from Earth");
        this.flat_sphere_button = new JButton("flat > sphere");
        this.flat_sphere_button.addActionListener(this);
        this.flat_sphere_button.setActionCommand("flat/sphere");
        this.center.add(contour_panel);
        this.center.add(panel1);
        this.center.add(display1_label);
        this.center.add(display1a_label);
        this.center.add(coord_panel);
        this.center.add(this.panel2);
        this.center.add(this.flat_sphere_button);
        this.center.add(display2_label);
        this.center.add(display2a_label);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        right.setAlignmentY(0.0f);
        right.setAlignmentX(0.0f);
        right.setPreferredSize(new Dimension(400, 950));
        big_panel.add(right);
        right.add(panel3);
        right.add(panel4);
        frame.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("contour")) {
            try {
                this.contour_button_ref.setData(new Real(0.0));
            }
            catch (VisADException ex) {
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (cmd.equals("compute")) {
            try {
                this.compute_button_ref.setData(new Real(0.0));
                this.density_button_ref.setData(new Real(0.0));
            }
            catch (VisADException ex) {
                System.out.println(ex.getMessage());
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (cmd.equals("reset")) {
            try {
                this.reset_button_ref.setData(new Real(0.0));
            }
            catch (VisADException ex) {
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (cmd.equals("density/emission")) {
            try {
                this.density_button_ref.setData(new Real(0.0));
            }
            catch (VisADException ex) {
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        if (cmd.equals("flat/sphere")) {
            try {
                double val = ((Real)this.flat_sphere_button_ref.getData()).getValue();
                if (val < 0.5) {
                    val = 1.0;
                    this.center.remove(this.panel2);
                    this.center.add((Component)this.panel5, 5);
                    this.widget_panel.remove(this.lw2);
                    this.widget_panel.add((Component)this.lw5, 0);
                    this.flat_sphere_button.setText("sphere > flat");
                } else {
                    val = 0.0;
                    this.center.remove(this.panel5);
                    this.center.add((Component)this.panel2, 5);
                    this.widget_panel.remove(this.lw5);
                    this.widget_panel.add((Component)this.lw2, 0);
                    this.flat_sphere_button.setText("flat > sphere");
                }
                this.flat_sphere_button_ref.setData(new Real(val));
            }
            catch (VisADException ex) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private float[][] getLonLat(float[][] lonlat, int length_0, int length_1) {
        float[][] n_lonlat = new float[2][lonlat[0].length];
        for (int jj = 0; jj < length_1; ++jj) {
            for (int ii = 0; ii < length_0; ++ii) {
                int ii_a = (int)((float)ii * 25.0f) / 10;
                int jj_a = (int)((float)jj * 25.0f) / 10;
                int kk = jj * length_0 + ii;
                if (lonlat[1][kk] < -400.0f) {
                    float gl;
                    float gb;
                    float x = ((float)(2 * ii_a) - 1.0f - 181.0f) / 180.0f;
                    float y = ((float)(2 * jj_a) - 1.0f - 91.0f) / 180.0f;
                    float rad = (float)Math.sqrt(x * x + 4.0f * y * y);
                    float sinalp = (float)Math.sqrt((4.0f * y * y - 1.0f) * (4.0f * y * y - 1.0f) + x * y * 2.0f * (x * y * 2.0f));
                    if (Math.abs(sinalp) > 1.0f) {
                        gb = 0.0f;
                    } else {
                        float alpha = (float)(Math.asin(sinalp) * 57.2957795);
                        gb = 90.0f - alpha;
                    }
                    if (y < 0.0f) {
                        gb = -gb;
                    }
                    if ((double)sinalp <= 1.0E-4) {
                        gl = 180.0f;
                        gl = (float)Math.IEEEremainder(gl, 360.0);
                    } else {
                        float cosbet = (1.0f - x * x - 4.0f * y * y) / sinalp;
                        if (cosbet > 1.0f) {
                            gl = 0.0f;
                            gb = 0.0f;
                        } else {
                            float ll;
                            float beta = (float)(Math.acos(cosbet) * 57.2957795);
                            gl = ll = 2.0f * beta;
                            if (x > 0.0f) {
                                gl = 360.0f - gl;
                            }
                            if ((float)ii > 36.0f) {
                                gl -= 360.0f;
                            }
                        }
                    }
                    n_lonlat[0][kk] = gl;
                    n_lonlat[1][kk] = gb;
                    continue;
                }
                n_lonlat[0][kk] = lonlat[0][kk];
                n_lonlat[1][kk] = lonlat[1][kk];
            }
        }
        return n_lonlat;
    }

    private FlatField makeSphericalSkyMap() {
        int i;
        int jj;
        int ii;
        float[][] lonlat_c = new float[2][this.length_0 * this.length_1];
        float[] samples_c = new float[this.length_0 * this.length_1];
        lonlat_c = this.getLonLat(this.lonlat_b, this.length_0, this.length_1);
        float[][] lonlat_e = new float[2][this.length_0 * (this.length_1 - 1)];
        float[][] samples_e = new float[1][this.length_0 * (this.length_1 - 1)];
        for (int ii2 = 1; ii2 < this.length_1; ++ii2) {
            for (int jj2 = 0; jj2 < this.length_0; ++jj2) {
                int i2 = ii2 * this.length_0 + jj2;
                int i22 = (ii2 - 1) * this.length_0 + jj2;
                lonlat_e[0][i22] = lonlat_c[0][i2];
                lonlat_e[1][i22] = lonlat_c[1][i2];
                samples_e[0][i22] = this.lonlat_b[0][i2] < -400.0f || this.lonlat_b[1][i2] < -400.0f ? Float.NaN : this.image_b[0][i2];
            }
        }
        float[] firsts = new float[this.length_1 - 1];
        for (ii = 0; ii < this.length_1 - 1; ++ii) {
            boolean foundFirst = false;
            firsts[ii] = Float.NaN;
            for (jj = 0; jj < this.length_0; ++jj) {
                i = ii * this.length_0 + jj;
                if (Float.isNaN(samples_e[0][i]) || foundFirst) continue;
                firsts[ii] = samples_e[0][i];
                foundFirst = true;
            }
        }
        for (ii = 0; ii < this.length_1 - 1; ++ii) {
            for (jj = 0; jj < this.length_0; ++jj) {
                i = ii * this.length_0 + jj;
                if (!Float.isNaN(samples_e[0][i])) continue;
                samples_e[0][i] = firsts[ii];
            }
        }
        FlatField f_fieldRS = null;
        try {
            Gridded2DSet g_set = new Gridded2DSet((MathType)this.lonlat_range, lonlat_e, this.length_0, this.length_1 - 1);
            FlatField f_field = new FlatField(new FunctionType(this.lonlat_range, this.radiance), g_set);
            f_field.setSamples(samples_e);
            f_fieldRS = (FlatField)f_field.resample(new LinearLatLonSet((MathType)this.lonlat_range, -180.0, 180.0, 60, -77.0, 67.0, 50), 101, 202);
        }
        catch (VisADException e1) {
            System.out.println(e1.getMessage());
        }
        catch (RemoteException e2) {
            System.out.println(e2.getMessage());
        }
        return f_fieldRS;
    }

    private native void getcon_c(int[] var1);

    private native void ismgsc_c(float[] var1, int[] var2, float[] var3, float[] var4, float[] var5, float[] var6);

    private native void profile_c(int var1, int var2, float var3, float var4, float var5, float[] var6, float[] var7);

    private native void galtosol(float var1, float var2, float var3, float[] var4);

    class ContourCell
    extends CellImpl {
        ContourControl control;
        DataReference ref;
        double value;

        ContourCell(ContourControl c, DataReference r) throws VisADException, RemoteException {
            this.control = c;
            this.ref = r;
            this.value = ((Real)this.ref.getData()).getValue();
        }

        public void doAction() throws VisADException, RemoteException {
            double val = ((Real)this.ref.getData()).getValue();
            if (val == val && val != this.value) {
                this.control.setSurfaceValue((float)((Real)this.ref.getData()).getValue());
                this.control.enableContours(true);
                this.value = val;
            }
        }
    }
}

