/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.BitWriter;
import loci.formats.codec.ByteVector;
import loci.formats.codec.Codec;
import loci.formats.codec.LZWTreeNode;

public class LZWCodec
extends BaseCodec
implements Codec {
    protected static final int CLEAR_CODE = 256;
    protected static final int EOI_CODE = 257;

    public byte[] compress(byte[] input, int x, int y, int[] dims, Object options) throws FormatException {
        if (input == null || input.length == 0) {
            return input;
        }
        LZWTreeNode symbols = new LZWTreeNode(-1);
        symbols.initialize();
        int nextCode = 258;
        int numBits = 9;
        BitWriter out = new BitWriter();
        out.write(256, numBits);
        ByteVector omega = new ByteVector();
        for (int i = 0; i < input.length; ++i) {
            byte k = input[i];
            LZWTreeNode omegaNode = symbols.nodeFromString(omega);
            LZWTreeNode omegaKNode = omegaNode.getChild(k);
            if (omegaKNode != null) {
                omega.add(k);
                continue;
            }
            out.write(omegaNode.getCode(), numBits);
            omega.add(k);
            symbols.addTableEntry(omega, nextCode++);
            omega.clear();
            omega.add(k);
            if (nextCode == 512) {
                numBits = 10;
                continue;
            }
            if (nextCode == 1024) {
                numBits = 11;
                continue;
            }
            if (nextCode == 2048) {
                numBits = 12;
                continue;
            }
            if (nextCode != 4096) continue;
            out.write(256, numBits);
            symbols.initialize();
            nextCode = 258;
            numBits = 9;
        }
        out.write(symbols.codeFromString(omega), numBits);
        out.write(257, numBits);
        return out.toByteArray();
    }

    public byte[] decompress(byte[] input, Object options) throws FormatException {
        int code;
        if (input == null || input.length == 0) {
            return input;
        }
        byte[][] symbolTable = new byte[4096][1];
        int bitsToRead = 9;
        int nextSymbol = 258;
        int oldCode = -1;
        ByteVector out = new ByteVector(8192);
        BitBuffer bb = new BitBuffer(input);
        byte[] byteBuffer1 = new byte[16];
        byte[] byteBuffer2 = new byte[16];
        while ((code = bb.getBits(bitsToRead)) != 257 && code != -1) {
            ByteVector symbol;
            if (code == 256) {
                for (int i = 0; i < 256; ++i) {
                    symbolTable[i][0] = (byte)i;
                }
                nextSymbol = 258;
                bitsToRead = 9;
                code = bb.getBits(bitsToRead);
                if (code == 257 || code == -1) break;
                out.add(symbolTable[code]);
                oldCode = code;
                continue;
            }
            if (code < nextSymbol) {
                out.add(symbolTable[code]);
                symbol = new ByteVector(byteBuffer1);
                try {
                    symbol.add(symbolTable[oldCode]);
                }
                catch (ArrayIndexOutOfBoundsException a) {
                    throw new FormatException("Sorry, old LZW codes not supported");
                }
                symbol.add(symbolTable[code][0]);
                symbolTable[nextSymbol] = symbol.toByteArray();
                oldCode = code;
                ++nextSymbol;
            } else {
                symbol = new ByteVector(byteBuffer2);
                symbol.add(symbolTable[oldCode]);
                symbol.add(symbolTable[oldCode][0]);
                byte[] outString = symbol.toByteArray();
                out.add(outString);
                symbolTable[nextSymbol] = outString;
                oldCode = code;
                ++nextSymbol;
            }
            if (nextSymbol == 511) {
                bitsToRead = 10;
            }
            if (nextSymbol == 1023) {
                bitsToRead = 11;
            }
            if (nextSymbol != 2047) continue;
            bitsToRead = 12;
        }
        return out.toByteArray();
    }

    public static void main(String[] args) throws FormatException {
        LZWCodec c = new LZWCodec();
        c.test();
    }
}

