/* These BLEP routines were coded by aciddose, and he agreed on 
** using the WTFPL license for the code.
*/

#include <stdint.h>
#include "pt_blep.h"
#include "pt_helpers.h"

/* Why this table is not represented as readable float numbers:
** Accurate float representation in string format requires at least 7 digits and normalized
** (scientific) notation, notwithstanding compiler issues with precision or rounding error.
** Also, don't touch this table ever, just keep it exactly identical!
*/

static const uint32_t blepData_f[48] =
{
    0x3F7FE1F1, 0x3F7FD548, 0x3F7FD6A3, 0x3F7FD4E3,
    0x3F7FAD85, 0x3F7F2152, 0x3F7DBFAE, 0x3F7ACCDF,
    0x3F752F1E, 0x3F6B7384, 0x3F5BFBCB, 0x3F455CF2,
    0x3F26E524, 0x3F0128C4, 0x3EACC7DC, 0x3E29E86B,
    0x3C1C1D29, 0xBDE4BBE6, 0xBE3AAE04, 0xBE48DEDD,
    0xBE22AD7E, 0xBDB2309A, 0xBB82B620, 0x3D881411,
    0x3DDADBF3, 0x3DE2C81D, 0x3DAAA01F, 0x3D1E769A,
    0xBBC116D7, 0xBD1402E8, 0xBD38A069, 0xBD0C53BB,
    0xBC3FFB8C, 0x3C465FD2, 0x3CEA5764, 0x3D0A51D6,
    0x3CEAE2D5, 0x3C92AC5A, 0x3BE4CBF7, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};

void blepAdd(blep_t *b, float offset_f, float amplitude_f)
{
    int8_t n;
    int32_t i;
    const float *blepSrc_f;
    float f;

    MY_ASSERT((offset_f >= 0.0f) && (offset_f < 1.0f));

    // FIXME: Figure out if this still happens (it used to), if not remove ASAP!
    if ((offset_f < 0.0f) || (offset_f >= 1.0f))
        return;

    f = offset_f * BLEP_SP;

    i = (int32_t)(f); // get integer part of f (should use SSE on x86/x86_64)
    blepSrc_f = (const float *)(blepData_f) + i + BLEP_OS;
    f -= i; // remove integer part of f (should also use SSE)

    i = b->index;

    n = BLEP_NS;
    while (n--)
    {
        MY_ASSERT((blepSrc_f < ((const float *)(&blepData_f) + 47)) && (i <= BLEP_RNS));

        b->buffer_f[i] += (amplitude_f * LERP(blepSrc_f[0], blepSrc_f[1], f));
        i = (i + 1) & BLEP_RNS;

        blepSrc_f += BLEP_SP;
    }

    b->samplesLeft = BLEP_NS;
}

float blepRun(blep_t *b)
{
    float blepOutput_f;

    blepOutput_f = b->buffer_f[b->index];
    b->buffer_f[b->index] = 0.0f;

    b->index = (b->index + 1) & BLEP_RNS;

    b->samplesLeft--;
    return (blepOutput_f);
}
