/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2005
 *     Brian Gerkey
 *                      
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
 %module playertcp_java

%include "typemaps.i"
%include "arrays_java.i"

// Tell SWIG that an int* function argument should be treated as an array
// of ints
%apply int[ANY] {int*};

// Should not need these typemaps, but the ones generated by SWIG does not
// work
%typemap(in) int* {
  $1 = (int*)(jenv->GetIntArrayElements($input, 0));
}
%typemap(freearg) int* {
  jenv->ReleaseIntArrayElements($input, (jint*)$1, 0);
}
%typemap(argout) int* {
}

// The stuff between the braces gets copied verbatim into the output
%{
#include <libplayertcp/playertcp.h>
#include <libplayerinterface/functiontable.h>
%}

%include <libplayertcp/playertcp.h>
%include <libplayerinterface/functiontable.h>
