/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_timeHPP
#define yf_timeHPP

#include <ctime>
#include <iostream>

#include <yf/defs.hpp>
#ifdef YF_ENABLE_CHECKS
	#include <yf/exception/exception.hpp>
#endif

#ifdef OS_LINUX
	#include <sys/time.h>
	#include <unistd.h>
#endif

namespace yf
{
	/**
	 * @brief	Cross-platform analog for sleep
	 */
	inline void wait( ulong milliseconds )
	{
		#ifdef OS_LINUX
			usleep(milliseconds*1000);
		#else
			#ifdef OS_WINDOWS
				Sleep(milliseconds);
			#else
				#error yf::wait() - Unsupported OS
			#endif
		#endif
	}
	//--------------------------------------------------------------

	//--------------------------------------------------------------
	const ulong microsec_in_second = 1000000ul;
	#if defined(OS_WINDOWS)
		typedef ullong 			precise_time_t;
	#elif	defined(OS_LINUX)
		typedef struct timeval 	precise_time_t;
	#endif
	//--------------------------------------------------------------
	precise_time_t precise_time();
	double get_micro_time( precise_time_t mt_beg, precise_time_t mt_end );
	inline float get_milli_time( precise_time_t mt_beg, precise_time_t mt_end )
		{ return (float)get_micro_time(mt_beg, mt_end); }
	//--------------------------------------------------------------
	void write_milli_time( precise_time_t mt_beg, precise_time_t mt_end, std::ostream& os = std::cout );
	void write_micro_time( precise_time_t mt_beg, precise_time_t mt_end, std::ostream& os = std::cout );
}
//---------------------------------------------------------------------------
#endif
