/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef uPlot_H
#define uPlot_H

#include "uPlotBase.h"

class MvRequest;

class QAction;
class QComboBox;
class QGraphicsRectItem;
class QGraphicsScene;
class QGraphicsView;
class QLabel;
class QScrollArea;
class QSlider;
class QSplitter;
class QTabWidget;
class QTreeView;
class QTimer;
class QWidgetAction;

class ExportDialog;
class MgQPlotScene;
class MgQSceneItem;
class MvQCursorDataWidget;
class MvQDataWidget;
class MvQStepModel;
class MvQLayerWidget;
class MvQPlaceMarkWidget;
class MvQPlotView;
class MvQProgressBarPanel;
//class MvQProgressItem;
class MvQStepWidget;
class MvQTreeView;
class MvQZoomStackWidget;

using namespace std;

class MvQSceneComboBox : public QComboBox
{
    Q_OBJECT

public:
    MvQSceneComboBox(QWidget *parent=0) : QComboBox(parent) {}
	void hidePopup();
signals:
	void cursorLeft();	
};

class uPlot : public uPlotBase
{
    Q_OBJECT

public:
	uPlot(QWidget *parent = 0);
	~uPlot();
	
	void newRequestForDriversBegin();
	void newRequestForDriversEnd();
	void progressMessage(const string&);

public slots:
	void slotShowControlPanel(bool);		
	void slotPlay();
	void slotStop();
	void slotToFirst();
	void slotToLast();
	void slotToNext();
	void slotToPrev();
	void slotStepTo(int);
	void slotStepTo(const QModelIndex&);
	void slotSetSpeed(int);
	void slotLayerUpdate();
	void slotSelectActiveScene();
	void slotActiveSceneSelected(QPointF);
	void slotSetActiveScene(MgQSceneItem*);
	void slotSetActiveScene(int);
	void slotHighlightActiveScene(bool);
	void slotHighlightScene(int);
	void slotNotHighlightScene();	
	void slotAnimatedScenes(bool);
   void slotLayerTransparencyChanged(QString,int);
   void slotLayerVisibilityChanged(QString,bool);
   void slotLayerStackingOrderChanged(QList<QPair<QString,int> >);
   void slotControlTabChanged(int);
	void slotPlotScaleChanged();
   void slotShareTarget();

protected:
	void setupFileActions();
   void setupShareActions();
	void setupViewActions();
	void setupToolsActions();
	void setupAnimationActions();
   void setupProgressBarActions();

	bool setDropTarget(QPoint);
	bool setDropTargetInView(QPoint);
	
	void updateAnimationActionState();
	int currentStep();
	int stepNum();
	
	void loadStarted();
	void loadFinished();
	
	void readSettings();
	void writeSettings();
	
	QWidget*	controlWidget_;
	QTabWidget*     controlTab_;	

	MvQStepWidget*  stepWidget_;
	MvQLayerWidget* layerWidget_;
	MvQDataWidget* dataWidget_;
	MvQPlaceMarkWidget* placeMarkWidget_;	
        MvQCursorDataWidget* cursorWidget_;

        QAction* actionAntialias_;
	QAction* actionControlPanel_;
	
	//Animation control
	QAction* actionPlay_;
	QAction* actionStop_;
	QAction* actionNext_;
	QAction* actionPrevious_;
	QAction* actionFirst_;
	QAction* actionLast_;
	QSlider*       speedSlider_;
	QTimer*        timer_;
	vector<float>  speed_;
	int            actSpeedIndex_;
	QLabel*        speedLabel_;

        QAction* actionHighlightScene_;
	QList<MgQSceneItem*> animatedScenes_;
	QAction* actionAnimatedScenes_;
	MvQSceneComboBox* sceneCb_;
	QWidget* sceneWidget_;
	
//	MvQProgressItem* progressItem_;

   // Progress Bar
   MvQProgressBarPanel* progressBar_;
   QWidgetAction* acltb_;
   QWidgetAction* acptb_;

	QSplitter*  mainSplitter_;
	
	bool weatherRoom_;
};

#endif
