/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef BUFRKEYWIDGET_H
#define BUFRKEYWIDGET_H

#include "ui_BufrKeyWidget.h"

#include <QWidget>

class MvQBufrDataItem;
class MvEccBufrMessage;
class MvQKeyProfileModel;
class MvQKeyProfileSortFilterModel;

class BufrKeyWidget : public QWidget, protected Ui::BufrKeyWidget
{
public:
    explicit BufrKeyWidget(QWidget *parent=0);
    void setData(MvQBufrDataItem*,int,MvEccBufrMessage*);
    void clear();

protected:
    QString formatKey(QString);
    QString formatValue(QString);
    QString formatRow(QString key,QString val);
    QString formatElementBlock(QString val);

    MvQKeyProfileModel* model_;
    MvQKeyProfileSortFilterModel* sortModel_;
};

#endif // BUFRKEYWIDGET_H
