//  MaCoPiX = Mascot Construnctive Pilot for X
//                                (ActX / Gtk+ Evolution)
//
//
//      pixmap.c  
//      Management of Image loading & rendering for MaCoPiX
//       (using gdk-pixbuf)
//
//                            Copyright 2002-2007  K.Chimari
//                                     http://rosegray.sakura.ne.jp/
//
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.
//

#include "main.h"

#ifdef USE_BIFF
#include "def_biff.xpm"
#include "def_biff_r.xpm"
#endif


// *** GLOBAL ARGUMENT ***
extern GtkWidget *win_main, *clock_main, *balloon_main, *biff_pix;
#ifdef USE_WIN32
extern GtkWidget *clock_fg, *balloon_fg;
#endif
extern GtkWidget *popup_menu; 
extern gint window_x, window_y;

extern GdkDrawable *pixmap_main[2], *pixmap_clk[2], *pixmap_bal[2];

extern GdkGC *MPCreatePen();

extern gchar* to_utf8();

#ifdef __GTK_STATUS_ICON_H__
extern void trayicon_set_tooltip();
#endif

#ifdef __GTK_STOCK_H__
extern GtkWidget* gtkut_button_new_from_stock();
#endif

extern void my_signal_connect();
extern gboolean my_main_iteration();


#ifdef USE_WIN32
void GdkWinChangeAlpha();
void GdkWinChangeAlphaFG();
#endif

//CallbackϤ碌¤ ǥեȥեѹ
typedef struct{
  gchar *fn;
  GtkFontSelectionDialog *fsd;
}confDefFont;




// Prototype of Functions in this file
gboolean TestLoadPixmaps();
void LoadPixmaps();
#ifdef USE_BIFF
void LoadBiffPixmap();
#endif
gint DrawMascot0();
gint DrawMascot();
gint DrawMascotTemp();
gint DrawMascotWithDigit();
void ReInitGC();

void create_default_font_selection_dialog();
void ChangeDefFontname();
static void close_child_dialog();

gboolean TestLoadPixmaps(typMascot *mascot, gchar *filename, gint i_pix)
{
  GdkPixbuf *pixbuf = NULL,*pixbuf2 = NULL;
  gint w=0,h=0;
  gint ipstyle;
  gchar *tmp_open;

  
  tmp_open=to_utf8(filename);
#ifdef USE_GTK2
  pixbuf = gdk_pixbuf_new_from_file(tmp_open, NULL);
#else
  pixbuf = gdk_pixbuf_new_from_file(tmp_open);
#endif
  g_free(tmp_open);
  if(!pixbuf) return(FALSE);
  
  w = gdk_pixbuf_get_width(pixbuf)*((gfloat)(mascot->magnify)/100);
  h = gdk_pixbuf_get_height(pixbuf)*((gfloat)(mascot->magnify)/100);

  switch(mascot->ip_style){
  case MAG_IP_NEAREST:
    ipstyle=GDK_INTERP_NEAREST;
    break;
    
  case MAG_IP_TILES:
    ipstyle=GDK_INTERP_TILES;
    break;
    
  case MAG_IP_BILINEAR:
    ipstyle=GDK_INTERP_BILINEAR;
    break;
    
  case MAG_IP_HYPER:
    ipstyle=GDK_INTERP_HYPER;
    break;
    
  default:
    ipstyle=GDK_INTERP_BILINEAR;
  }
    
  pixbuf2=gdk_pixbuf_scale_simple(pixbuf,w,h,ipstyle);
  if(mascot->sprites[i_pix].pixmap) 
#ifdef USE_GTK2
    g_object_unref(G_OBJECT(mascot->sprites[i_pix].pixmap));
#else
    gdk_pixmap_unref(mascot->sprites[i_pix].pixmap);
#endif
  if(mascot->sprites[i_pix].mask) 
#ifdef USE_GTK2
    g_object_unref(G_OBJECT(mascot->sprites[i_pix].mask));
#else
    gdk_pixmap_unref(mascot->sprites[i_pix].mask);
#endif
  gdk_pixbuf_render_pixmap_and_mask(pixbuf2, &mascot->sprites[i_pix].pixmap,
				      &mascot->sprites[i_pix].mask, 0xc0);
#ifdef USE_GTK2
  g_object_unref(G_OBJECT(pixbuf));
  g_object_unref(G_OBJECT(pixbuf2));
#else
  gdk_pixbuf_unref(pixbuf);
  gdk_pixbuf_unref(pixbuf2);
#endif

  DrawMascotTemp(mascot,i_pix);

  return(TRUE);
  
}

void LoadPixmaps(GtkWidget *widget, GtkWidget *draw, 
		 typMascot *mascot, typSprite *sprites){
  int i=0;
  //GdkImlibImage* im = NULL;
  GdkPixbuf *pixbuf = NULL, *pixbuf2 = NULL;
  gint w=0,h=0;
  gint ipstyle;
#ifndef USE_GTK2
  gchar *fontset=NULL;
#endif
  gchar *tmp_open;

#ifdef USE_WIN32
  GdkWinChangeAlpha(win_main->window, mascot->alpha_main);
#ifdef USE_BIFF
  GdkWinChangeAlpha(biff_pix->window, mascot->alpha_biff);
#endif
  if((mascot->flag_balfg)&&(mascot->alpha_bal!=100)){
    GdkWinChangeAlphaFG(balloon_fg->window, mascot->colbalbg);
  }
  GdkWinChangeAlpha(balloon_main->window, mascot->alpha_bal);
  if((mascot->flag_clkfg)&&(mascot->alpha_clk!=100)){
    GdkWinChangeAlphaFG(clock_fg->window, mascot->colclkbg);
  }
  GdkWinChangeAlpha(clock_main->window, mascot->alpha_clk);
#endif


  while(sprites[i].filename){
    if (sprites[i].pixmap)
#ifdef USE_GTK2
      g_object_unref(G_OBJECT(sprites[i].pixmap));
#else
      gdk_pixmap_unref(sprites[i].pixmap);
#endif
    if (sprites[i].mask)
#ifdef USE_GTK2
      g_object_unref(G_OBJECT(sprites[i].mask));
#else
      gdk_pixmap_unref(sprites[i].mask);
#endif
    //im = gdk_imlib_load_image(sprites[i].filename);
  tmp_open=to_utf8(sprites[i].filename);
#ifdef USE_GTK2
    pixbuf = gdk_pixbuf_new_from_file(tmp_open, NULL);
#else
    pixbuf = gdk_pixbuf_new_from_file(tmp_open);
#endif
    // if(im==NULL){
    if(pixbuf==NULL){
      //g_print (_("Cannot Load Image %s\n"), sprites[i].filename);
      g_print (_("Cannot Load Image %s\n"), tmp_open);
      g_free(tmp_open);
      exit(1);
    }
    g_free(tmp_open);

    w = gdk_pixbuf_get_width(pixbuf)*((gfloat)(mascot->magnify)/100);
    h = gdk_pixbuf_get_height(pixbuf)*((gfloat)(mascot->magnify)/100);
    
    // ImlibѤ
    //w = im->rgb_width*((gfloat)(mascot->magnify)/100);
    //h = im->rgb_height*((gfloat)(mascot->magnify)/100);
    //gdk_imlib_render(im, w, h);
    //sprites[i].pixmap = gdk_imlib_move_image(im);
    //sprites[i].mask = gdk_imlib_move_mask(im);

    switch(mascot->ip_style){
    case MAG_IP_NEAREST:
      ipstyle=GDK_INTERP_NEAREST;
      break;

    case MAG_IP_TILES:
      ipstyle=GDK_INTERP_TILES;
      break;

    case MAG_IP_BILINEAR:
      ipstyle=GDK_INTERP_BILINEAR;
      break;

    case MAG_IP_HYPER:
      ipstyle=GDK_INTERP_HYPER;
      break;

    default:
      ipstyle=GDK_INTERP_BILINEAR;
    }
    
    pixbuf2=gdk_pixbuf_scale_simple(pixbuf,w,h,ipstyle);
    gdk_pixbuf_render_pixmap_and_mask(pixbuf2, &sprites[i].pixmap,
				      &sprites[i].mask, 0xc0);

#ifdef USE_GTK2
    g_object_unref(G_OBJECT(pixbuf));
    g_object_unref(G_OBJECT(pixbuf2));
#else
    gdk_pixbuf_unref(pixbuf);
    gdk_pixbuf_unref(pixbuf2);
#endif
    i++;
  }
  mascot->width=w;
  mascot->height=h;
  gtk_drawing_area_size (GTK_DRAWING_AREA(draw), 
			 mascot->width, mascot->height);
  gdk_window_resize (widget->window, w, h);

  
  // եȤΥ
#ifdef USE_GTK2
  if (mascot->fontclk!=NULL){
    pango_font_description_free(mascot->fontclk);
    mascot->fontclk=NULL;
  }
#else
  mascot->fontclk=NULL;
#endif

  if(mascot->fontname_clk){
#ifdef USE_GTK2
    mascot->fontclk=pango_font_description_from_string(mascot->fontname_clk);
#else
    fontset = g_strdup(mascot->fontname_clk);
    mascot->fontclk=gdk_fontset_load(fontset);
#endif
  }
  if(mascot->fontclk==NULL){
#ifdef USE_GTK2
    mascot->fontclk=pango_font_description_from_string(mascot->deffontname_clk);
#else
    fontset = g_strdup(mascot->deffontname_clk);
    mascot->fontclk=gdk_fontset_load(fontset);
#endif
    while(mascot->fontclk==NULL){
      create_default_font_selection_dialog(mascot,INIT_DEF_FONT_CLK);
#ifdef USE_GTK2
      mascot->fontclk=pango_font_description_from_string(mascot->deffontname_clk);
#else
      fontset = g_strdup(mascot->deffontname_clk);
      mascot->fontclk=gdk_fontset_load(fontset);
#endif
    }
    mascot->fontname_clk=mascot->deffontname_clk;
  }

#ifdef USE_GTK2
  if (mascot->fontbal!=NULL){
    pango_font_description_free(mascot->fontbal);
    mascot->fontbal=NULL;
  }
#else
  mascot->fontbal=NULL;
#endif

  if(mascot->fontname_bal){
#ifdef USE_GTK2
    mascot->fontbal=pango_font_description_from_string(mascot->fontname_bal);
#else
    fontset = g_strdup(mascot->fontname_bal);
    mascot->fontbal=gdk_fontset_load(fontset);
#endif
  }
  if(mascot->fontbal==NULL){
#ifdef USE_GTK2
    mascot->fontbal=pango_font_description_from_string(mascot->deffontname_bal);
#else
    fontset = g_strdup(mascot->deffontname_bal);
    mascot->fontbal=gdk_fontset_load(fontset);
#endif
    while(mascot->fontbal==NULL){
      create_default_font_selection_dialog(mascot,INIT_DEF_FONT_BAL);
#ifdef USE_GTK2
      mascot->fontbal=pango_font_description_from_string(mascot->deffontname_bal);
#else
      fontset = g_strdup(mascot->deffontname_bal);
      mascot->fontbal=gdk_fontset_load(fontset);
#endif
    }
    mascot->fontname_bal=mascot->deffontname_bal;
  }

#ifdef USE_GTK2
  gtk_widget_modify_font(mascot->w_clkdraw,mascot->fontclk);
  mascot->fontname_clk=pango_font_description_to_string(mascot->fontclk);
  gtk_widget_modify_font(mascot->w_baldraw,mascot->fontbal);
  mascot->fontname_bal=pango_font_description_to_string(mascot->fontbal);
#else
  g_free(fontset);
#endif



  mascot->nPixmap = i;
  mascot->sprites = sprites;
  mascot->drag=FALSE;
  strcpy(mascot->digit,"00:00:00");
  mascot->w_drawing=draw;
  // ե졼ѥޥڽФ


  gtk_widget_shape_combine_mask( win_main, 
				 mascot->sprites[mascot->frame_pix[0][0]].mask,
				 0, 0 ); 

#ifdef __GTK_STATUS_ICON_H__
  trayicon_set_tooltip(mascot);
#endif

}


#ifdef USE_BIFF
void LoadBiffPixmap(GtkWidget *widget, typMascot *mascot){
  gchar *fontset=NULL;
  int i=0;
  //GdkImlibImage* im = NULL;
  GdkPixbuf *pixbuf = NULL, *pixbuf2 = NULL;
  gint ipstyle;
  gint w=0,h=0;
  gchar *tmp_open;

  switch(mascot->ip_style){
  case MAG_IP_NEAREST:
    ipstyle=GDK_INTERP_NEAREST;
    break;
    
  case MAG_IP_TILES:
    ipstyle=GDK_INTERP_TILES;
    break;
    
  case MAG_IP_BILINEAR:
    ipstyle=GDK_INTERP_BILINEAR;
    break;
    
  case MAG_IP_HYPER:
    ipstyle=GDK_INTERP_HYPER;
    break;
    
  default:
    ipstyle=GDK_INTERP_BILINEAR;
  }


  // ᥤpixmap
  if (mascot->mail.pixmap)
#ifdef USE_GTK2
    g_object_unref(G_OBJECT(mascot->mail.pixmap));
#else
    gdk_pixmap_unref(mascot->mail.pixmap);
#endif
  if (mascot->mail.mask)
#ifdef USE_GTK2
    g_object_unref(G_OBJECT(mascot->mail.mask));
#else
    gdk_pixmap_unref(mascot->mail.mask);
#endif
  if(mascot->mail.pix_file){
  tmp_open=to_utf8(mascot->mail.pix_file);
#ifdef USE_GTK2
    pixbuf = gdk_pixbuf_new_from_file(tmp_open, NULL);
#else
    pixbuf = gdk_pixbuf_new_from_file(tmp_open);
#endif
    g_free(tmp_open);
  }
  else{
    if(mascot->mail.pix_pos==MAIL_PIX_LEFT){
      pixbuf = gdk_pixbuf_new_from_xpm_data(def_biff);
    }
    else{
      pixbuf = gdk_pixbuf_new_from_xpm_data(def_biff_r);
    }
  }
  w = gdk_pixbuf_get_width(pixbuf)*((gfloat)(mascot->magnify)/100);
  h = gdk_pixbuf_get_height(pixbuf)*((gfloat)(mascot->magnify)/100);

  pixbuf2=gdk_pixbuf_scale_simple(pixbuf,w,h,ipstyle);
  gdk_pixbuf_render_pixmap_and_mask(pixbuf2, &mascot->mail.pixmap,
				      &mascot->mail.mask, 0xc0);
#ifdef USE_GTK2
  g_object_unref(G_OBJECT(pixbuf));
  g_object_unref(G_OBJECT(pixbuf2));
#else
  gdk_pixbuf_unref(pixbuf);
  gdk_pixbuf_unref(pixbuf2);
#endif
  gtk_drawing_area_size (GTK_DRAWING_AREA(mascot->mail.w_draw), w, h);
  gdk_window_resize (widget->window, w, h);


  // ե졼ѥޥڽФ
  gdk_window_set_back_pixmap(mascot->mail.w_draw->window,
			     mascot->mail.pixmap,
			     FALSE);

  gtk_widget_shape_combine_mask( widget, 
				 mascot->mail.mask,
				 0, 0 ); 
}
#endif

// ޥåȤѴݤ˥ХåեƤ
gint DrawMascot0(typMascot *mascot)
{
  gint i_work;

  for(i_work=0;i_work<2;i_work++){
#ifdef USE_GTK2
    gdk_draw_drawable(pixmap_main[i_work],
#else
    gdk_draw_pixmap(pixmap_main[i_work],
#endif
		  mascot->gc_main[i_work],
                  mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].pixmap,
                  0, 0,
                  0, 0,
		  mascot->width, mascot->height);
  }

  return(0);
}


// BufferؤΥޥåȤν񤭹
gint DrawMascot(typMascot *mascot)
{
  gint work_page;

  work_page =mascot->pixmap_page;
  work_page^=1;



  /*  gdk_gc_set_clip_mask(mascot->gc_main[work_page], NULL);

  gdk_gc_set_clip_mask(
       mascot->gc_main[work_page],
       mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].mask);
       gdk_gc_set_clip_origin(mascot->gc_main[work_page], 0, 0);*/


#ifdef USE_GTK2
  gdk_draw_drawable(pixmap_main[work_page],
#else
  gdk_draw_pixmap(pixmap_main[work_page],
#endif
		  mascot->gc_main[work_page],
                  mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].pixmap,
                  0, 0,
                  0, 0,
		  mascot->width, mascot->height);

  gdk_window_set_back_pixmap(mascot->w_drawing->window,
			     pixmap_main[work_page],
			     FALSE);

  /*XSetWindowBackgroundPixmap(GDK_WINDOW_XDISPLAY(win_main->window),
			     GDK_WINDOW_XWINDOW(win_main->window),
			     (Pixmap )pixmap_main[work_page]);*/
  gtk_widget_shape_combine_mask( win_main,
				 mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].mask,
				 0, 0 );


#ifdef USE_GTK2
  gdk_draw_drawable(mascot->w_drawing->window,
#else
  gdk_draw_pixmap(mascot->w_drawing->window,
#endif
		  mascot->w_drawing->style->fg_gc[GTK_WIDGET_STATE(mascot->w_drawing)],
		  pixmap_main[work_page],
		  0,0,0,0,
		  mascot->width, mascot->height);

  mascot->pixmap_page=work_page;


  while (my_main_iteration(FALSE));


  gdk_flush();

  return(0);
}

gint DrawMascotTemp(typMascot *mascot, gint i_pix)
{
  gint work_page;

  work_page =mascot->pixmap_page;
  //work_page^=1;


#ifdef USE_GTK2
  gdk_draw_drawable(pixmap_main[work_page],
#else
  gdk_draw_pixmap(pixmap_main[work_page],
#endif
		  mascot->gc_main[work_page],
                  mascot->sprites[i_pix].pixmap,
                  0, 0,
                  0, 0,
		  mascot->width, mascot->height);

  gdk_window_set_back_pixmap(mascot->w_drawing->window,
			     pixmap_main[work_page],
			     FALSE);

  gtk_widget_shape_combine_mask( win_main, 
				 mascot->sprites[i_pix].mask,
				 0, 0 ); 

#ifdef USE_GTK2
  gdk_draw_drawable(mascot->w_drawing->window,
#else
  gdk_draw_pixmap(mascot->w_drawing->window,
#endif
		  mascot->w_drawing->style->fg_gc[GTK_WIDGET_STATE(mascot->w_drawing)],
		  pixmap_main[work_page],
		  0,0,0,0,
		  mascot->width, mascot->height);
  mascot->pixmap_page=work_page;
  
  while (my_main_iteration(FALSE));

  gdk_flush();

  return(0);
}

// BufferؤΥޥåȤν񤭹
gint DrawMascotWithDigit(typMascot *mascot)
{
  gint clk_width,clk_height;
  //GdkGC *gc;
  gint work_page;
  gint as=0;
#ifdef USE_GTK2
  PangoLayout *pango_text;
#else
  gint lb,rb,ds;
#endif

  work_page =mascot->pixmap_page;
  work_page^=1;


#ifdef USE_GTK2
  gdk_draw_drawable(pixmap_main[work_page],
#else
  gdk_draw_pixmap(pixmap_main[work_page],
#endif
		  mascot->gc_main[work_page],
                  mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].pixmap,
                  0, 0,
                  0, 0,
		  mascot->width, mascot->height);


#ifdef USE_GTK2
  pango_text=gtk_widget_create_pango_layout(mascot->w_clkdraw,
					    mascot->digit);
#endif

  if(mascot->flag_clksd){
#ifdef USE_GTK2
    gdk_draw_layout(pixmap_main[work_page],
		    mascot->gc_mainsd[work_page],
		    mascot->clktext_x*((gfloat)(mascot->magnify)/100)+1,
		    1,
		    pango_text);
#else		    
    gdk_draw_string(pixmap_main[work_page],mascot->fontclk,
    		    mascot->gc_mainsd[work_page],
    	    mascot->clktext_x*((gfloat)(mascot->magnify)/100)+1,
    	    mascot->clktext_y*((gfloat)(mascot->magnify)/100)+1,
    	    mascot->digit);
#endif
  }
#ifdef USE_GTK2
  gdk_draw_layout(pixmap_main[work_page],
		  mascot->gc_main[work_page],
		  mascot->clktext_x*((gfloat)(mascot->magnify)/100),
		  0,
		  pango_text);
#else		    
  gdk_draw_string(pixmap_main[work_page],mascot->fontclk,
  	  mascot->gc_main[work_page],
  	  mascot->clktext_x*((gfloat)(mascot->magnify)/100),
  	  mascot->clktext_y*((gfloat)(mascot->magnify)/100),
  	  mascot->digit);
#endif

  switch(mascot->clktype){
  case CLOCK_TYPE_12S:
  case CLOCK_TYPE_12M:
#ifdef USE_GTK2
    pango_layout_get_pixel_size(pango_text,&clk_width,&clk_height);
#else
    gdk_string_extents(mascot->fontclk,mascot->digit,
		       &lb,&rb,&clk_width,&as,&ds);
    clk_height=as+ds;
#endif

    // digital clock
    if(mascot->flag_clksd){
      if(mascot->clk_pm){
	gdk_draw_arc(pixmap_main[work_page],mascot->gc_mainsd[work_page],
		     TRUE,
		     mascot->clktext_x*((gfloat)(mascot->magnify)/100)+1+clk_width,
		     mascot->clktext_y*((gfloat)(mascot->magnify)/100)+1+clk_height*2/3-as,
		     clk_height/3,clk_height/3,
		     0,(360*64));
      }
      else{
	gdk_draw_arc(pixmap_main[work_page],mascot->gc_mainsd[work_page],
		     TRUE,
		     mascot->clktext_x*((gfloat)(mascot->magnify)/100)+1+clk_width,
		     mascot->clktext_y*((gfloat)(mascot->magnify)/100)+1-as,
		     clk_height/3,clk_height/3,
		     0,(360*64));
      }
    }
    
    if(mascot->clk_pm){
      gdk_draw_arc(pixmap_main[work_page],mascot->gc_main[work_page],
		   TRUE,
		   mascot->clktext_x*((gfloat)(mascot->magnify)/100)+clk_width,
		   mascot->clktext_y*((gfloat)(mascot->magnify)/100)+clk_height*2/3-as,
		   clk_height/3,clk_height/3,
		   0,(360*64));
    }
    else{
      gdk_draw_arc(pixmap_main[work_page],mascot->gc_main[work_page],
		   TRUE,
		   mascot->clktext_x*((gfloat)(mascot->magnify)/100)+clk_width,
		   mascot->clktext_y*((gfloat)(mascot->magnify)/100)-as,
		   clk_height/3,clk_height/3,
		   0,(360*64));
    }

    break;
  }



  gdk_window_set_back_pixmap(mascot->w_drawing->window,
			     pixmap_main[work_page],
			     FALSE);

  gtk_widget_shape_combine_mask( win_main, 
				 mascot->sprites[mascot->frame_pix[mascot->anime_ptn][mascot->anime_frm]].mask,
				 0, 0 ); 

#ifdef USE_GTK2
  gdk_draw_drawable(mascot->w_drawing->window,
#else
  gdk_draw_pixmap(mascot->w_drawing->window,
#endif
		  mascot->w_drawing->style->fg_gc[GTK_WIDGET_STATE(mascot->w_drawing)],
		  pixmap_main[work_page],
		  0,0,0,0,
		  mascot->width, mascot->height);
  mascot->pixmap_page=work_page;

#ifdef USE_GTK2
  g_object_unref(G_OBJECT(pango_text));
#endif

  while (my_main_iteration(FALSE));

  gdk_flush();

  return(0);
}


void ReInitGC(typMascot *mascot)
{
  int i_page;

  for(i_page=0;i_page<2;i_page++){
    if(mascot->gc_main[i_page]){
       gdk_gc_unref(mascot->gc_main[i_page]);
       gdk_gc_unref(mascot->gc_mainsd[i_page]);
    }
    mascot->gc_main[i_page] = MPCreatePen(pixmap_main[i_page], mascot->colclk);
    mascot->gc_mainsd[i_page] = MPCreatePen(pixmap_main[i_page], mascot->colclksd);

    if(mascot->gc_bal[i_page]){
       gdk_gc_unref(mascot->gc_bal[i_page]);
       gdk_gc_unref(mascot->gc_balbg[i_page]);
       gdk_gc_unref(mascot->gc_balbd[i_page]);
    }
    mascot->gc_bal[i_page] = MPCreatePen(pixmap_bal[i_page], mascot->colbal);
    mascot->gc_balbg[i_page] = MPCreatePen(pixmap_bal[i_page], mascot->colbalbg);
    mascot->gc_balbd[i_page] = MPCreatePen(pixmap_bal[i_page], mascot->colbalbd);

    if(mascot->gc_clk[i_page]){
       gdk_gc_unref(mascot->gc_clk[i_page]);
       gdk_gc_unref(mascot->gc_clkbg[i_page]);
       gdk_gc_unref(mascot->gc_clkbd[i_page]);
       gdk_gc_unref(mascot->gc_clksd[i_page]);
    }
    mascot->gc_clk[i_page] = MPCreatePen(pixmap_clk[i_page], mascot->colclk);
    mascot->gc_clkbg[i_page] = MPCreatePen(pixmap_clk[i_page], mascot->colclkbg);
    mascot->gc_clkbd[i_page] = MPCreatePen(pixmap_clk[i_page], mascot->colclkbd);
    mascot->gc_clksd[i_page] = MPCreatePen(pixmap_clk[i_page], mascot->colclksd);
  }
}


void create_default_font_selection_dialog(typMascot *mascot, gint bal_clk)
{
  GtkWidget *fdialog;
  GtkWidget *button;
  GtkWidget *label;
  confDefFont *cdata;
  gchar *tmp_label;
  ConfigFile *cfgfile;

  tmp_label=g_malloc0(sizeof(gchar)*256);

  fdialog = gtk_dialog_new();
  gtk_container_set_border_width(GTK_CONTAINER(fdialog),5);

  switch(bal_clk){
  case INIT_DEF_FONT_CLK:
    gtk_window_set_title(GTK_WINDOW(fdialog),
			 _("Cannot Load Default Clock Font"));
    label=gtk_label_new(_("Cannot Load Default Clock Font"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->vbox),
		       label,TRUE,TRUE,0);
    sprintf(tmp_label,"\"%s\"",mascot->deffontname_clk);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->vbox),
		       label,TRUE,TRUE,0);
    break;
  case INIT_DEF_FONT_BAL:
    gtk_window_set_title(GTK_WINDOW(fdialog),
			 _("Cannot Load Default Balloon Font"));
    label=gtk_label_new(_("Cannot Load Default Balloon Font"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->vbox),
		       label,TRUE,TRUE,0);
    sprintf(tmp_label,"\"%s\"",mascot->deffontname_bal);
    label=gtk_label_new(tmp_label);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->vbox),
		       label,TRUE,TRUE,0);
    break;
  }

  label=gtk_label_new(_("Please Change..."));
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->vbox),
		     label,TRUE,TRUE,0);

#ifdef __GTK_STOCK_H__
  button=gtkut_button_new_from_stock(_("OK"),GTK_STOCK_OK);
#else
  button=gtk_button_new_with_label(_("OK"));
#endif
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fdialog)->action_area),
		     button,TRUE,TRUE,0);
  my_signal_connect(button,"clicked",close_child_dialog,fdialog);

  gtk_widget_show_all(fdialog);
  gtk_main();


  cdata=g_malloc0(sizeof(confDefFont));

  // WinۤϽŤΤExpose٥򤹤٤ƽƤ
  while (my_main_iteration(FALSE));

  
  fdialog = gtk_font_selection_dialog_new(_("Default Font Selection"));

  cdata->fsd=GTK_FONT_SELECTION_DIALOG(fdialog);

  cdata->fn=NULL;

  switch(bal_clk){
  case INIT_DEF_FONT_CLK:
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    mascot->deffontname_clk);
    break;
  case INIT_DEF_FONT_BAL:
    gtk_font_selection_dialog_set_font_name(cdata->fsd,
					    mascot->deffontname_bal);
    break;
  }

  my_signal_connect(GTK_FONT_SELECTION_DIALOG(fdialog)->ok_button,
		    "clicked", ChangeDefFontname, (gpointer)cdata);
    
  my_signal_connect(fdialog,"destroy",close_child_dialog, fdialog);
  
  my_signal_connect(GTK_FONT_SELECTION_DIALOG(fdialog)->cancel_button,
		    "clicked", close_child_dialog,fdialog);
  
  gtk_widget_show(fdialog);

  gtk_main();


  if(cdata->fn){
    switch(bal_clk){
    case INIT_DEF_FONT_CLK:
      mascot->deffontname_clk=cdata->fn;
      cfgfile = xmms_cfg_open_file(mascot->rcfile);
      if (!cfgfile)  cfgfile = xmms_cfg_new();
      xmms_cfg_write_string(cfgfile, "General",
			    "font_clock",mascot->deffontname_clk);
      xmms_cfg_write_file(cfgfile, mascot->rcfile);
      xmms_cfg_free(cfgfile);
      break;
    case INIT_DEF_FONT_BAL:
      mascot->deffontname_bal=cdata->fn;
      cfgfile = xmms_cfg_open_file(mascot->rcfile);
      if (!cfgfile)  cfgfile = xmms_cfg_new();
      xmms_cfg_write_string(cfgfile, "General",
			    "font_balloon",mascot->deffontname_bal);
      xmms_cfg_write_file(cfgfile, mascot->rcfile);
      xmms_cfg_free(cfgfile);
      break;
    }
  }

  g_free(cdata);
  g_free(tmp_label);
}
  

// եΥեȤѹ
void ChangeDefFontname(GtkWidget *w, gpointer gdata)
{ 
  confDefFont *cdata;
  cdata=(confDefFont *)gdata;

  cdata->fn=gtk_font_selection_dialog_get_font_name(cdata->fsd);

  gtk_widget_destroy(GTK_WIDGET(cdata->fsd));
  gtk_main_quit();
}


static void close_child_dialog(GtkWidget *w, GtkWidget *dialog)
{
  //gdk_pointer_ungrab(GDK_CURRENT_TIME);

  gtk_widget_destroy(dialog);
  gtk_main_quit();
}

