/*
    Copyright (C) 2015 Tomas Flouri, Diego Darriba

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Contact: Tomas Flouri <Tomas.Flouri@h-its.org>,
    Exelixis Lab, Heidelberg Instutute for Theoretical Studies
    Schloss-Wolfsbrunnenweg 35, D-69118 Heidelberg, Germany
*/

#include "pll.h"

/* maps for encoding sequences */

const unsigned int pll_map_bin[256] =
 {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0,
   1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  };

const unsigned int pll_map_nt[256] =
 {
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 15,
   0,  1, 14,  2, 13,  0,  0,  4, 11,  0,  0, 12,  0,  3, 15, 15,
   0,  0,  5,  6,  8,  8,  7,  9, 15, 10,  0,  0,  0,  0,  0,  0,
   0,  1, 14,  2, 13,  0,  0,  4, 11,  0,  0, 12,  0,  3, 15, 15,
   0,  0,  5,  6,  8,  8,  7,  9, 15, 10,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 };

const unsigned int pll_map_aa[256] =
 {
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0, 0xfffff,       0,       0, 0xfffff,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0, 0xfffff,
         0, 0x00001, 0x0000c, 0x00010, 0x00008, 0x00040, 0x02000, 0x00080,
   0x00100, 0x00200,       0, 0x00800, 0x00400, 0x01000, 0x00004,       0,
   0x04000, 0x00020, 0x00002, 0x08000, 0x10000,       0, 0x80000, 0x20000,
   0xfffff, 0x40000, 0x00060,       0,       0,       0,       0,       0,
         0, 0x00001, 0x0000c, 0x00010, 0x00008, 0x00040, 0x02000, 0x00080,
   0x00100, 0x00200,       0, 0x00800, 0x00400, 0x01000, 0x00004,       0,
   0x04000, 0x00020, 0x00002, 0x08000, 0x10000,       0, 0x80000, 0x20000,
   0xfffff, 0x40000, 0x00060,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0,
         0,       0,       0,       0,       0,       0,       0,       0
 };


/*
  maps for fasta and phylip parsing

  legal symbols: ?*- 0123456789 abcdefghijklmnopqrstuvxyz (also upper case)
  fatal symbols: period (.), ascii 0-8, ascii 14-31
  silently stripped: tab (9), newline (10 and 13), vt (11), formfeed (12)
  stripped: !"#$&'()+,/:;<=>@^_`æøåÆØÅ§¨´

  includes both amino acid and nucleotide sequences, adapt to nt only

  TODO: Would be more suitable to create separate maps for parsing nt data,
  aa data, binary, etc
*/

const unsigned int pll_map_phylip[256] =
  {
    /*
    0=stripped, 1=legal, 2=fatal, 3=silently stripped
    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O
    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _
    */

/*  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F        */
    2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  2,  2,  /* 0 */
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  /* 1 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  0,  /* 2 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  1,  /* 3 */
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  /* 4 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  /* 5 */
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  0,  /* 6 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  /* 7 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* 8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* 9 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* A */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* B */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* C */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* D */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* E */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0   /* F */
  };
const unsigned int pll_map_fasta[256] =
  {
    /*
    0=stripped, 1=legal, 2=fatal, 3=silently stripped
    @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O
    P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _
    */

/*  0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F        */
    2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  2,  2,  /* 0 */
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  /* 1 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  0,  /* 2 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  1,  /* 3 */
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  /* 4 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  /* 5 */
    0,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  1,  1,  1,  1,  0,  /* 6 */
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  /* 7 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* 8 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* 9 */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* A */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* B */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* C */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* D */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  /* E */
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0   /* F */
  };

/* GTR protein substitution rate parameters (values above main diagonal) */

const double pll_aa_rates_dayhoff[190] =
 {
    27.00,   98.00,  120.00,   36.00,   89.00,  198.00,  240.00,   23.00,   65.00,   41.00,
    26.00,   72.00,   18.00,  250.00,  409.00,  371.00,    0.00,   24.00,  208.00,   32.00,
     0.00,   23.00,  246.00,    1.00,    9.00,  240.00,   64.00,   15.00,  464.00,   90.00,
    14.00,  103.00,  154.00,   26.00,  201.00,    8.00,   24.00,  905.00,    0.00,  103.00,
   148.00,  139.00,  535.00,   77.00,   34.00,  318.00,    1.00,   14.00,   42.00,  495.00,
   229.00,   23.00,   95.00,   15.00,    0.00,  134.00, 1153.00,  125.00,   86.00,   24.00,
     0.00,   71.00,    0.00,    0.00,   13.00,   95.00,   66.00,    0.00,    0.00,   18.00,
     0.00,    0.00,   11.00,   28.00,   44.00,    0.00,    0.00,    0.00,    0.00,   19.00,
   161.00,   16.00,    0.00,   96.00,   49.00,  716.00,   28.00,  606.00,   18.00,   73.00,
   153.00,  114.00,    0.00,  153.00,   56.00,   53.00,    0.00,    0.00,   35.00,   81.00,
    43.00,   61.00,   11.00,   83.00,   30.00,    0.00,   51.00,   79.00,   34.00,    0.00,
    22.00,   37.00,   10.00,    0.00,    7.00,   27.00,   17.00,   15.00,   34.00,  234.00,
    30.00,    0.00,    0.00,   54.00,    7.00,   44.00,   26.00,    0.00,   48.00,   94.00,
    35.00,   22.00,   27.00,  127.00,   44.00,  257.00,   46.00,  336.00,  196.00,   12.00,
    24.00,  192.00,    0.00,   37.00,  889.00,   18.00,  527.00,  157.00,   32.00,   17.00,
    33.00,   46.00,   28.00,  175.00,  243.00,    0.00,   33.00,   96.00,  136.00,    0.00,
    13.00,   10.00,   92.00,   17.00,   62.00,  104.00,    0.00,    0.00,  258.00,   11.00,
    46.00,   13.00,   76.00,  698.00,   12.00,  245.00,   78.00,    0.00,    0.00,   48.00,
   550.00,   75.00,   34.00,   30.00,    0.00,   42.00,  157.00,   61.00,    0.00,   28.00
 };

const double pll_aa_rates_lg[190] =
 {
   0.4250930, 0.2768180, 0.3951440, 2.4890840, 0.9698940, 1.0385450, 2.0660400, 0.3588580, 0.1498300, 0.3953370,
   0.5365180, 1.1240350, 0.2537010, 1.1776510, 4.7271820, 2.1395010, 0.1807170, 0.2189590, 2.5478700, 0.7518780,
   0.1239540, 0.5345510, 2.8079080, 0.3639700, 0.3901920, 2.4266010, 0.1269910, 0.3018480, 6.3260670, 0.4841330,
   0.0527220, 0.3325330, 0.8581510, 0.5789870, 0.5936070, 0.3144400, 0.1708870, 5.0761490, 0.5287680, 1.6957520,
   0.5417120, 1.4376450, 4.5092380, 0.1915030, 0.0684270, 2.1450780, 0.3710040, 0.0895250, 0.1617870, 4.0083580,
   2.0006790, 0.0453760, 0.6120250, 0.0836880, 0.0625560, 0.5233860, 5.2438700, 0.8449260, 0.9271140, 0.0106900,
   0.0150760, 0.2829590, 0.0255480, 0.0174160, 0.3944560, 1.2402750, 0.4258600, 0.0298900, 0.1351070, 0.0379670,
   0.0848080, 0.0034990, 0.5692650, 0.6405430, 0.3206270, 0.5940070, 0.0132660, 0.8936800, 1.1052510, 0.0753820,
   2.7844780, 1.1434800, 0.6701280, 1.1655320, 1.9592910, 4.1285910, 0.2679590, 4.8135050, 0.0728540, 0.5824570,
   3.2342940, 1.6725690, 0.0358550, 0.6242940, 1.2238280, 1.0801360, 0.2361990, 0.2573360, 0.2103320, 0.3488470,
   0.4238810, 0.0442650, 0.0696730, 1.8071770, 0.1737350, 0.0188110, 0.4194090, 0.6119730, 0.6045450, 0.0778520,
   0.1200370, 0.2450340, 0.3114840, 0.0087050, 0.0442610, 0.2966360, 0.1395380, 0.0895860, 0.1969610, 1.7399900,
   0.1298360, 0.2684910, 0.0546790, 0.0767010, 0.1088820, 0.3663170, 0.6972640, 0.4424720, 0.6821390, 0.5088510,
   0.9900120, 0.5842620, 0.5970540, 5.3068340, 0.1190130, 4.1450670, 0.1590690, 4.2736070, 1.1127270, 0.0782810,
   0.0641050, 1.0337390, 0.1116600, 0.2325230,10.6491070, 0.1375000, 6.3123580, 2.5926920, 0.2490600, 0.1822870,
   0.3029360, 0.6196320, 0.2996480, 1.7027450, 0.6566040, 0.0239180, 0.3903220, 0.7486830, 1.1368630, 0.0499060,
   0.1319320, 0.1852020, 1.7988530, 0.0998490, 0.3469600, 2.0203660, 0.6961750, 0.4813060, 1.8987180, 0.0944640,
   0.3618190, 0.1650010, 2.4571210, 7.8039020, 0.6546830, 1.3381320, 0.5714680, 0.0951310, 0.0896130, 0.2965010,
   6.4722790, 0.2488620, 0.4005470, 0.0983690, 0.1408250, 0.2458410, 2.1881580, 3.1518150, 0.1895100, 0.2493130
 };

const double pll_aa_rates_dcmut[190] =
 {
   0.267828, 0.984474, 1.199805, 0.360016, 0.887753, 1.961167,  2.386111, 0.228116, 0.653416, 0.406431,
   0.258635, 0.717840, 0.183641, 2.485920, 4.051870, 3.680365,  0.000000, 0.244139, 2.059564, 0.327059,
   0.000000, 0.232374, 2.439939, 0.000000, 0.087791, 2.383148,  0.632629, 0.154924, 4.610124, 0.896321,
   0.136906, 1.028313, 1.531590, 0.265745, 2.001375, 0.078012,  0.240368, 8.931515, 0.000000, 1.028509,
   1.493409, 1.385352, 5.290024, 0.768024, 0.341113, 3.148371,  0.000000, 0.138503, 0.419244, 4.885892,
   2.271697, 0.224968, 0.946940, 0.158067, 0.000000, 1.348551, 11.388659, 1.240981, 0.868241, 0.239248,
   0.000000, 0.716913, 0.000000, 0.000000, 0.133940, 0.956097,  0.660930, 0.000000, 0.000000, 0.178316,
   0.000000, 0.000000, 0.107278, 0.282729, 0.438074, 0.000000,  0.000000, 0.000000, 0.000000, 0.187550,
   1.598356, 0.162366, 0.000000, 0.953164, 0.484678, 7.086022,  0.281581, 6.011613, 0.180393, 0.730772,
   1.519078, 1.127499, 0.000000, 1.526188, 0.561828, 0.525651,  0.000000, 0.000000, 0.346983, 0.811907,
   0.439469, 0.609526, 0.112880, 0.830078, 0.304803, 0.000000,  0.507003, 0.793999, 0.340156, 0.000000,
   0.214717, 0.367250, 0.106802, 0.000000, 0.071514, 0.267683,  0.170372, 0.153478, 0.347153, 2.322243,
   0.306662, 0.000000, 0.000000, 0.538165, 0.076981, 0.443504,  0.270475, 0.000000, 0.475927, 0.933709,
   0.353643, 0.226333, 0.270564, 1.265400, 0.438715, 2.556685,  0.460857, 3.332732, 1.951951, 0.119152,
   0.247955, 1.900739, 0.000000, 0.374834, 8.810038, 0.180629,  5.230115, 1.565160, 0.316258, 0.171432,
   0.331090, 0.461776, 0.286572, 1.745156, 2.411739, 0.000000,  0.335419, 0.954557, 1.350599, 0.000000,
   0.132142, 0.103850, 0.921860, 0.170205, 0.619951, 1.031534,  0.000000, 0.000000, 2.565955, 0.110506,
   0.459901, 0.136655, 0.762354, 6.952629, 0.123606, 2.427202,  0.782857, 0.000000, 0.000000, 0.485026,
   5.436674, 0.740819, 0.336289, 0.303836, 0.000000, 0.417839,  1.561997, 0.608070, 0.000000, 0.279379
 };

const double pll_aa_rates_jtt[190] =
 {
    58.00,  54.00,  81.00,  56.00,  57.00, 105.00, 179.00,  27.00,  36.00,  30.00,
    35.00,  54.00,  15.00, 194.00, 378.00, 475.00,   9.00,  11.00, 298.00,  45.00,
    16.00, 113.00, 310.00,  29.00, 137.00, 328.00,  22.00,  38.00, 646.00,  44.00,
     5.00,  74.00, 101.00,  64.00, 126.00,  20.00,  17.00, 528.00,  34.00,  86.00,
    58.00,  81.00, 391.00,  47.00,  12.00, 263.00,  30.00,  10.00,  15.00, 503.00,
   232.00,   8.00,  70.00,  16.00,  10.00,  49.00, 767.00, 130.00, 112.00,  11.00,
     7.00,  26.00,  15.00,   4.00,  15.00,  59.00,  38.00,   4.00,  46.00,  31.00,
     9.00,   5.00,  59.00,  69.00,  17.00,  23.00,   7.00,  31.00,  78.00,  14.00,
   223.00,  42.00, 115.00, 209.00,  62.00, 323.00,  26.00, 597.00,   9.00,  72.00,
   292.00,  43.00,   4.00, 164.00,  53.00,  51.00,  18.00,  24.00,  20.00, 119.00,
    26.00,  12.00,   9.00, 181.00,  18.00,   5.00,  18.00,  30.00,  32.00,  10.00,
     7.00,  45.00,  23.00,   6.00,   6.00,  27.00,  14.00,   5.00,  24.00, 201.00,
    33.00,  55.00,   8.00,  47.00,  16.00,  56.00,  45.00,  33.00,  40.00, 115.00,
    73.00,  46.00,   8.00, 573.00,  11.00, 229.00,  21.00, 479.00,  89.00,  10.00,
    40.00, 245.00,   9.00,  32.00, 961.00,  14.00, 388.00, 248.00, 102.00,  59.00,
    25.00,  52.00,  24.00, 180.00,  65.00,   4.00,  21.00,  47.00, 103.00,  10.00,
     8.00,  14.00,  43.00,  16.00,  29.00, 226.00,  24.00,  18.00, 323.00,  17.00,
    92.00,  12.00,  53.00, 536.00,  62.00, 285.00, 118.00,   6.00,  10.00,  23.00,
   477.00,  35.00,  63.00,  38.00,  12.00,  21.00, 112.00,  71.00,  25.00,  16.00
 };

const double pll_aa_rates_mtrev[190] =
 {
    23.18,  26.95,  17.67,  59.93,    1.90,   9.77, 120.71,  13.90,  96.49,  25.46,
     8.36, 141.88,   6.37,  54.31,  387.86, 480.72,   1.90,   6.48, 195.06,  13.24,
     1.90, 103.33, 220.99,   1.90,   23.03, 165.23,   1.90,  15.58, 141.40,   1.90,
     4.69,  23.64,   6.04,   2.08,   21.95,   1.90,   7.64, 794.38,  58.94, 173.56,
    63.05,  53.30, 496.13,  27.10,   15.16, 608.70,  65.41,  15.20,  73.31, 494.39,
   238.46,  10.68, 191.36,   1.90,    1.90,  55.28, 583.55,  56.77, 113.99,   4.34,
     1.90,   2.31,   1.90,   4.98,   13.43,  69.02,  28.01,  19.86,  21.21,   1.90,
    75.24,   1.90,  30.71, 141.49,   62.73,  25.65,   1.90,   6.18,  70.80,  31.26,
   277.05, 179.97,  33.60, 254.77,    1.90, 313.56,   6.75, 582.40,   8.34,  39.70,
   465.58,  47.37,  19.11, 137.29,   54.11,  94.93,   1.90,  38.82,  19.00,  28.28,
    49.12,   3.31,   1.90, 313.86,    1.90,   2.67,  12.83,  54.71,  14.82,   1.90,
    13.12,  21.14,   1.90,   5.98,    2.41,  22.73,   1.90,   1.90,   1.90, 125.93,
    11.17,  10.92,   3.21,   2.53,   12.26,  11.49, 127.67,  11.97,  48.16,  60.97,
    77.46,  44.78,   7.08, 670.14,    1.90, 329.09,  19.57, 517.98,  84.67,  20.63,
    47.70, 368.43,   1.90,  25.01, 1222.94,  14.88, 537.53, 216.06,  40.10,  73.61,
   126.40,  32.44,  44.15,  91.67,   91.37,   6.44,  50.10, 105.79, 136.33,  24.00,
    51.17,   1.90,  90.82,  18.84,  111.16, 528.17,  21.71,  39.96, 387.54,  17.31,
    64.29,  33.85,   7.84, 465.58,    6.35, 169.90, 128.22,   4.21,  16.21,   8.23,
   597.21,  38.58,  64.92,   1.90,    9.99,  38.73, 204.54,  26.25,   5.37,   1.90
 };

const double pll_aa_rates_wag[190] =
 {
   0.551571, 0.509848, 0.738998, 1.027040, 0.908598, 1.582850, 1.416720, 0.316954, 0.193335, 0.397915,
   0.906265, 0.893496, 0.210494, 1.438550, 3.370790, 2.121110, 0.113133, 0.240735, 2.006010, 0.635346,
   0.147304, 0.528191, 3.035500, 0.439157, 0.584665, 2.137150, 0.186979, 0.497671, 5.351420, 0.683162,
   0.102711, 0.679489, 1.224190, 0.554413, 1.163920, 0.381533, 0.251849, 5.429420, 0.265256, 1.543640,
   0.947198, 1.125560, 3.956290, 0.554236, 0.131528, 3.012010, 0.198221, 0.096162, 0.195081, 3.974230,
   2.030060, 0.071917, 1.086000, 0.196246, 0.030295, 0.616783, 6.174160, 0.865584, 0.930676, 0.039437,
   0.084805, 0.479855, 0.103754, 0.046730, 0.423984, 1.071760, 0.374866, 0.129767, 0.325711, 0.152335,
   0.098818, 0.021352, 0.306674, 0.248972, 0.170135, 0.384287, 0.074034, 0.390482, 0.398020, 0.109404,
   1.407660, 0.512984, 0.717070, 0.543833, 1.002140, 5.469470, 0.330052, 4.294110, 0.113917, 0.869489,
   3.894900, 1.545260, 0.099921, 0.933372, 1.028870, 0.857928, 0.215737, 0.227710, 0.301281, 0.567717,
   0.570025, 0.127395, 0.154263, 2.584430, 0.315124, 0.081134, 0.682355, 0.704939, 0.822765, 0.156557,
   0.196303, 0.588731, 0.249410, 0.030450, 0.061304, 0.373558, 0.174100, 0.049931, 0.243570, 1.341820,
   0.225833, 0.336983, 0.103604, 0.187247, 0.138190, 0.499462, 0.890432, 0.404141, 0.679371, 0.696198,
   0.740169, 0.473307, 0.262569, 3.873440, 0.118358, 3.170970, 0.323832, 4.257460, 1.059470, 0.099929,
   0.319440, 1.458160, 0.212483, 0.420170, 7.821300, 0.257555, 4.854020, 2.115170, 0.415844, 0.344739,
   0.326622, 0.665309, 0.398618, 1.800340, 0.934276, 0.088836, 0.556896, 0.967130, 1.386980, 0.137505,
   0.133264, 0.305434, 1.190630, 0.171329, 0.493905, 1.516120, 0.515706, 0.428437, 2.058450, 0.161444,
   0.545931, 0.171903, 1.529640, 6.454280, 0.649892, 1.613280, 0.795384, 0.139405, 0.216046, 0.314887,
   4.378020, 0.523742, 0.786993, 0.232739, 0.110864, 0.291148, 1.388230, 2.485390, 0.365369, 0.314730
 };

const double pll_aa_rates_rtrev[190] =
 {
    34.00,   51.00,   10.00,  439.00,   32.00,   81.00,  135.00,   30.00,    1.00,   45.00,
    38.00,  235.00,    1.00,   97.00,  460.00,  258.00,    5.00,   55.00,  197.00,   35.00,
    30.00,   92.00,  221.00,   10.00,   41.00,   90.00,   24.00,   18.00,  593.00,   57.00,
     7.00,   24.00,  102.00,   64.00,   13.00,   47.00,   29.00,  384.00,  128.00,  236.00,
    79.00,   94.00,  320.00,   35.00,   15.00,  123.00,    1.00,   49.00,   33.00,  294.00,
   148.00,   16.00,   28.00,   21.00,    1.00,   78.00,  542.00,   61.00,   91.00,    1.00,
     5.00,   20.00,    1.00,    1.00,   55.00,  136.00,   55.00,    1.00,    1.00,    6.00,
    70.00,    1.00,   48.00,  124.00,  104.00,  110.00,   16.00,  156.00,   70.00,    1.00,
    75.00,  117.00,   55.00,  131.00,  295.00,  372.00,   18.00,  387.00,   33.00,   54.00,
   309.00,  158.00,    1.00,   68.00,  225.00,  146.00,   10.00,   45.00,   36.00,   70.00,
    34.00,    1.00,   21.00,  141.00,    1.00,    1.00,   52.00,   95.00,   82.00,   17.00,
     1.00,   35.00,   68.00,    1.00,    3.00,   30.00,   37.00,    7.00,   17.00,  152.00,
     7.00,   23.00,   21.00,    3.00,   34.00,   51.00,   76.00,  116.00,  141.00,   44.00,
   183.00,   49.00,   48.00,  307.00,    1.00,  385.00,   34.00,  375.00,   64.00,   10.00,
     4.00,   72.00,   39.00,   26.00, 1048.00,   23.00,  581.00,  179.00,   22.00,   24.00,
    25.00,   47.00,   64.00,  112.00,  134.00,   14.00,   43.00,   77.00,  110.00,    6.00,
     1.00,   19.00,  247.00,    1.00,    1.00,  131.00,  111.00,   74.00,  236.00,   11.00,
    20.00,   69.00,  182.00, 1017.00,   92.00,  134.00,   62.00,    9.00,   14.00,   25.00,
   671.00,   14.00,   31.00,   39.00,    1.00,   34.00,  196.00,  176.00,   26.00,   59.00
 };

const double pll_aa_rates_cprev[190] =
 {
    105.00,  227.00,  175.00,  669.00,  157.00,  499.00,  665.00,   66.00,  145.00,  197.00,
    236.00,  185.00,   68.00,  490.00, 2440.00, 1340.00,   14.00,   56.00,  968.00,  357.00,
     43.00,  823.00, 1745.00,  152.00,  243.00,  715.00,  136.00,  203.00, 4482.00,  125.00,
     53.00,   87.00,  385.00,  314.00,  230.00,  323.00,   92.00, 4435.00,  538.00,  768.00,
   1055.00,  653.00, 1405.00,  168.00,  113.00, 2430.00,   61.00,   97.00,  173.00, 2085.00,
   1393.00,   40.00,  754.00,   83.00,   10.00,  400.00, 3691.00,  431.00,  331.00,   10.00,
     10.00,  412.00,   47.00,   22.00,  170.00,  590.00,  266.00,   18.00,  281.00,   75.00,
     10.00,   10.00,  303.00,  441.00,  280.00,  396.00,   48.00,  159.00,  726.00,  285.00,
   2331.00,  576.00,  435.00, 1466.00,  592.00, 3122.00,  133.00, 1269.00,   92.00,  286.00,
   3313.00,  202.00,   10.00,  323.00,  396.00,  241.00,   53.00,  391.00,   54.00,  379.00,
    162.00,  148.00,   82.00, 2629.00,  113.00,  145.00,  185.00,  568.00,  369.00,   63.00,
    142.00,  200.00,   19.00,   40.00,   20.00,  263.00,   21.00,   25.00,   28.00,  691.00,
     92.00,   82.00,   10.00,   91.00,   29.00,   66.00,  305.00,   10.00,  127.00,  152.00,
    303.00,   32.00,   69.00, 1971.00,   25.00, 1745.00,  345.00, 1772.00,  454.00,  117.00,
    216.00, 1040.00,   42.00,   89.00, 4797.00,  218.00, 1351.00, 1268.00,  219.00,  516.00,
    156.00,  159.00,  189.00,  865.00,  193.00,   72.00,  302.00,  868.00,  918.00,   10.00,
    247.00,  249.00,  327.00,  100.00,   93.00,  645.00,   86.00,  215.00,  475.00,   43.00,
    487.00,  148.00,  468.00, 2370.00,  317.00, 1202.00,  260.00,   49.00,   97.00,  122.00,
   2151.00,   73.00,  522.00,  167.00,   29.00,   71.00,  760.00,  346.00,   10.00,  119.00
 };

const double pll_aa_rates_vt[190] =
 {
   1.2412691067876198, 1.2184237953498958, 1.3759368509441177, 2.4731223087544874, 2.2155167805137470,
   2.3379911207495061, 3.3386555146457697, 0.9615841926910841, 0.8908203061925510, 1.0778497408764076,
   1.4932055816372476, 1.9006455961717605, 0.6883439026872615, 2.7355620089953550, 6.4208961859142883,
   5.2892514169776437, 0.5488578478106930, 0.5411769916657778, 4.6501894691803214, 1.5720770753326880,
   0.7550654439001206, 1.4414262567428417, 5.5120819705248678, 1.3542404860613146, 1.3121700301622004,
   4.9238668283945266, 0.4323005487925516, 0.8386701149158265,10.0173308173660018, 1.2488638689609959,
   0.4224945197276290, 1.3091837782420783, 1.9202994262316166, 1.3363401740560601, 1.5170142153962840,
   0.8912614404565405, 0.7807017855806767, 7.8584219153689405, 0.9784679122774127, 3.0143201670924822,
   2.0093434778398112, 2.4117632898861809, 6.1974384977884114, 0.9179291175331520, 0.4098311270816011,
   4.4034547578962568, 0.9378803706165143, 0.5044944273324311, 0.7103720531974738, 6.1234512396801764,
   3.8852506105922231, 0.1808525752605976, 1.0894926581511342, 0.4586061981719967, 0.2272488448121475,
   1.6562495638176040, 9.6883451875685065, 1.9142079025990228, 2.1459640610133781, 0.2161660372725585,
   0.3574207468998517, 1.4521790561663968, 0.4075239926000898, 0.1675129724559251, 1.0714605979577547,
   2.2161944596741829, 1.5066839872944762, 0.2496584188151770, 0.7447620891784513, 0.4594535241660911,
   0.4587469126746136, 0.4519167943192672, 1.1034605684472507, 1.5196756759380692, 0.9126668032539315,
   1.4081315998413697, 0.3371091785647479, 1.2213054800811556, 1.6953951980808002, 0.4326227078645523,
   3.6366815408744255, 1.7557065205837685, 1.6275179891253113, 2.1579775140421025, 2.2627456996290891,
   6.8124601839937675, 0.8776110594765502, 7.9943228564946525, 0.4882733432879921, 1.3318097154194044,
   6.0519085243118811, 1.9106190827629084, 0.3573432522499545, 2.3019177728300728, 2.3193703643237220,
   2.1576510103471440, 0.8959082681546182, 0.9183596801412757, 0.6366932501396869, 1.3860121390169038,
   1.6360079688522375, 0.4035497929633328, 0.5610717242294755, 4.3290086529582830, 0.7471936218068498,
   0.2317194387691585, 1.5132807416252063, 1.8273535587773553, 1.5839981708584689, 0.4198391148111098,
   0.5818111331782764, 0.8940572875547330, 0.8561248973045037, 0.2888075033037488, 0.3578662395745526,
   0.8945563662345198, 0.5954812791740037, 0.3693722640980460, 0.7744933618134962, 3.0637776193717610,
   0.7147489676267383, 0.9349753595598769, 0.3374467649724478, 0.6193321034173915, 0.5787937115407940,
   1.0765007949562073, 1.8085136096039203, 1.3808291710019667, 1.3629765501081097, 1.8370555852070649,
   1.9699895187387506, 1.6136654573285647, 0.6301954684360302, 7.7587442309146040, 0.5333220944030346,
   6.0019110258426362, 0.6244297525127139, 6.7597899772045418, 2.2864286949316077, 0.4811402387911145,
   0.6047491507504744, 2.6344778384442731, 0.5604648274060783, 0.8626796044156272,14.8729334615190609,
   0.5642322882556321, 8.0327792947421148, 4.3611548063555778, 1.0084320519837335, 0.8953754669269811,
   1.0192004372506540, 1.5183114434679339, 1.2452243224541324, 3.5458093276667237, 1.7129670976916258,
   0.3910559903834828, 1.3918935593582853, 1.9776630140912268, 2.5513781312660280, 0.5851920879490173,
   0.7835447533710449, 0.7801080335991272, 2.3201373546296349, 0.4953193808676289, 1.0657482318076852,
   3.3628488360462363, 1.4680478689711018, 1.0899165770956820, 4.0584577156753401, 0.3746821107962129,
   1.1079144700606407, 0.6882725908872254, 3.3448437239772266,10.3848523331334590, 1.7039730522675411,
   3.5465914843628927, 1.9485376673137556, 0.4326058001438786, 0.4819109019647465, 0.5985498912985666,
   8.8479984061248178, 0.6791126595939816, 0.9547229305958682, 0.9305232113028208, 0.4514203099376473,
   0.8564314184691215, 3.4242218450865543, 4.5377235790405388, 0.5658969249032649, 1.0000000000000000
 };

const double pll_aa_rates_blosum62[190] =
 {
   0.735790389698, 0.485391055466, 0.543161820899, 1.459995310470, 1.199705704602,
   1.170949042800, 1.955883574960, 0.716241444998, 0.605899003687, 0.800016530518,
   1.295201266783, 1.253758266664, 0.492964679748, 1.173275900924, 4.325092687057,
   1.729178019485, 0.465839367725, 0.718206697586, 2.187774522005, 1.297446705134,
   0.500964408555, 0.227826574209, 3.020833610064, 1.360574190420, 0.418763308518,
   1.456141166336, 0.232036445142, 0.622711669692, 5.411115141489, 0.983692987457,
   0.371644693209, 0.448133661718, 1.122783104210, 0.914665954563, 0.426382310122,
   0.720517441216, 0.438388343772, 3.180100048216, 0.397358949897, 1.839216146992,
   1.240488508640, 1.355872344485, 2.414501434208, 0.283017326278, 0.211888159615,
   1.593137043457, 0.648441278787, 0.354861249223, 0.494887043702, 2.904101656456,
   1.898173634533, 0.191482046247, 0.538222519037, 0.312858797993, 0.240836614802,
   1.190945703396, 3.761625208368, 0.798473248968, 0.778142664022, 0.418555732462,
   0.218131577594, 1.032447924952, 0.222621897958, 0.281730694207, 0.730628272998,
   1.582754142065, 0.934187509431, 0.145345046279, 0.261422208965, 0.258129289418,
   0.329801504630, 0.140748891814, 0.418203192284, 0.354058109831, 0.774894022794,
   0.831842640142, 0.285078800906, 0.767688823480, 0.441337471187, 0.356008498769,
   1.197188415094, 1.119831358516, 0.527664418872, 0.470237733696, 1.116352478606,
   5.528919177928, 0.609846305383, 2.435341131140, 0.236202451204, 0.580737093181,
   3.945277674515, 2.494896077113, 0.144356959750, 0.858570575674, 1.934870924596,
   1.277480294596, 0.758653808642, 0.958989742850, 0.530785790125, 0.423579992176,
   1.626891056982, 0.186848046932, 0.372625175087, 2.802427151679, 0.555415397470,
   0.291409084165, 0.926563934846, 1.769893238937, 1.071097236007, 0.407635648938,
   0.596719300346, 0.524253846338, 0.539859124954, 0.189296292376, 0.217721159236,
   0.752042440303, 0.459436173579, 0.368166464453, 0.504086599527, 1.509326253224,
   0.641436011405, 0.508358924638, 0.308055737035, 0.253340790190, 0.252718447885,
   0.348072209797, 1.022507035889, 0.984311525359, 0.714533703928, 0.527007339151,
   1.117029762910, 0.585407090225, 0.301248600780, 4.218953969389, 0.201555971750,
   3.890963773304, 0.406193586642, 3.364797763104, 1.517359325954, 0.388355409206,
   0.357544412460, 1.179091197260, 0.341985787540, 0.674617093228, 8.311839405458,
   0.445570274261, 6.030559379572, 2.064839703237, 0.374555687471, 0.352969184527,
   0.915259857694, 0.691474634600, 0.811245856323, 2.231405688913, 1.073061184332,
   0.266924750511, 1.047383450722, 1.752165917819, 1.303875200799, 0.332243040634,
   0.717993486900, 0.498138475304, 1.773855168830, 0.454123625103, 0.918723415746,
   1.488548053722, 0.888101098152, 0.951682162246, 2.575850755315, 0.233597909629,
   0.540027644824, 0.488206118793, 2.074324893497, 6.747260430801, 0.838119610178,
   1.169129577716, 1.005451683149, 0.252214830027, 0.369405319355, 0.496908410676,
   5.151556292270, 0.387925622098, 0.796751520761, 0.561925457442, 0.513128126891,
   0.801010243199, 2.253074051176, 4.054419006558, 0.266508731426, 1.000000000000
 };

const double pll_aa_rates_mtmam[190] =
 {
    32.00,    2.00,   11.00,    0.00,    0.00,    0.00,   78.00,    8.00,   75.00,   21.00,
     0.00,   76.00,    0.00,   53.00,  342.00,  681.00,    5.00,    0.00,  398.00,    4.00,
     0.00,  186.00,  246.00,    0.00,   18.00,  232.00,    0.00,    6.00,   50.00,    0.00,
     0.00,    9.00,    3.00,    0.00,   16.00,    0.00,    0.00,  864.00,    0.00,    8.00,
     0.00,   47.00,  458.00,   19.00,    0.00,  408.00,   21.00,    6.00,   33.00,  446.00,
   110.00,    6.00,  156.00,    0.00,    0.00,   49.00,  569.00,   79.00,   11.00,    0.00,
     0.00,    0.00,    0.00,    5.00,    2.00,   16.00,    0.00,    0.00,    0.00,   10.00,
     0.00,    0.00,    0.00,  305.00,   41.00,   27.00,    0.00,    0.00,    7.00,    0.00,
   347.00,  114.00,   65.00,  530.00,    0.00,  274.00,    0.00,  550.00,    0.00,   20.00,
   242.00,   22.00,    0.00,   51.00,   30.00,    0.00,    0.00,   54.00,   33.00,   22.00,
    22.00,    0.00,    0.00,  215.00,    0.00,    0.00,    0.00,   21.00,    4.00,    0.00,
     0.00,   20.00,    0.00,    0.00,    0.00,    0.00,    0.00,    0.00,    0.00,  112.00,
     0.00,    0.00,    1.00,    5.00,    0.00,   26.00,    0.00,    0.00,    0.00,   53.00,
    20.00,    1.00,    0.00, 1525.00,    0.00,  232.00,    6.00,  378.00,   57.00,    5.00,
     0.00,  360.00,    0.00,   16.00, 2220.00,    4.00,  609.00,  246.00,   43.00,   74.00,
    34.00,   12.00,   25.00,  100.00,   59.00,    0.00,   18.00,   65.00,   50.00,    0.00,
    67.00,    0.00,   11.00,    0.00,   47.00,  691.00,   13.00,    0.00,  832.00,   17.00,
    90.00,    8.00,    0.00,  682.00,    6.00,  202.00,   78.00,    7.00,    8.00,    0.00,
   614.00,   17.00,  107.00,    0.00,    0.00,    0.00,  237.00,   14.00,    0.00,    0.00
 };

/*
 * WARNING:
 *    This matrix is different in PhyML and PAML/PLL
 */
const double pll_aa_rates_mtart[190] =
 {
     0.20,    0.20,    1.00,  254.00,    0.20,    0.20,  200.00,    0.20,   26.00,    4.00,
     0.20,  121.00,   13.00,   49.00,  673.00,  244.00,    0.20,    1.00,  340.00,    0.20,
     4.00,   36.00,  154.00,    0.20,    0.20,   41.00,    2.00,    2.00,  209.00,    5.00,
     5.00,    0.20,    3.00,    0.20,    0.20,    4.00,    0.20,  500.00,   98.00,  262.00,
   183.00,  121.00,  180.00,   21.00,   13.00,  467.00,   79.00,   20.00,   17.00,  398.00,
   166.00,    8.00,  251.00,   23.00,   11.00,    0.20,  862.00,   12.00,    0.20,    7.00,
     1.00,    2.00,    0.20,    0.20,    0.20,   44.00,    0.20,    0.20,    0.20,    0.20,
     0.20,    0.20,   81.00,   12.00,   63.00,   79.00,    0.20,  312.00,  184.00,    0.20,
   664.00,  183.00,   22.00,   72.00,  350.00,  262.00,    3.00,  314.00,   11.00,   16.00,
   349.00,   67.00,    0.20,   39.00,   52.00,   44.00,    7.00,   87.00,    0.20,   44.00,
    15.00,    7.00,    2.00,  106.00,    0.20,    0.20,    8.00,   31.00,   43.00,   11.00,
     8.00,   14.00,    0.20,    3.00,    1.00,    0.20,   56.00,    1.00,    0.20,  226.00,
     0.20,    2.00,    9.00,    3.00,    0.20,    6.00,    0.20,    0.20,   14.00,    1.00,
    11.00,   19.00,    0.20,  191.00,    0.20,  515.00,    3.00,  515.00,  118.00,    0.20,
     7.00,  204.00,    0.20,   12.00, 1855.00,    4.00,  885.00,  263.00,   12.00,    8.00,
    48.00,   21.00,   20.00,   85.00,  106.00,   11.00,   17.00,  144.00,   70.00,   16.00,
   117.00,   26.00,  322.00,    5.00,  112.00,  289.00,   71.00,   71.00,  281.00,   15.00,
    36.00,   14.00,   54.00,  792.00,   52.00,   87.00,   47.00,    0.20,   18.00,   32.00,
   660.00,    2.00,   30.00,   61.00,    0.20,   46.00,  544.00,   38.00,    0.20,    2.00
 };

const double pll_aa_rates_mtzoa[190] =
 {
     3.30,    1.70,   16.10,  272.50,    7.30,   17.10,  289.30,    2.30,   33.20,   15.60,
     0.20,  136.50,   26.50,   61.80,  644.90,  378.10,    3.10,    2.10,  321.90,   33.60,
     3.20,   61.10,  231.00,    6.40,    7.20,   61.70,    0.20,    4.10,  292.30,    3.80,
     0.20,    7.50,   11.80,    3.20,   16.90,   13.80,    5.10,  617.00,   94.60,  190.30,
   174.00,   99.30,  228.90,   24.30,    7.90,  413.40,   73.70,   12.90,   22.60,  420.20,
   184.60,    6.40,  141.60,    7.10,    9.50,   19.30,  883.60,   26.00,   55.60,    1.50,
     0.50,    0.20,    0.20,    2.00,    0.20,   51.40,    2.30,    0.20,   13.90,    3.70,
    49.10,    3.40,   82.40,   37.50,   48.80,   59.70,    0.20,  264.80,  167.80,    8.10,
   656.30,  199.00,   36.10,   76.70,  243.80,  349.40,    8.90,  421.80,    0.20,   23.00,
   334.00,   83.90,    9.50,   52.20,   96.40,   39.40,    6.10,   52.30,    9.00,   43.10,
    14.90,    7.30,    1.00,  163.20,    0.20,    0.20,   20.60,   38.40,   34.50,    3.50,
    10.00,   16.30,    7.40,    3.40,    3.50,   10.10,   52.20,    5.80,    1.30,  257.10,
     5.20,   12.30,    4.30,   23.70,    1.60,    6.60,   23.90,    7.10,   13.10,   15.60,
    23.10,   19.40,    4.50,  266.50,    0.30,  425.20,    8.40,  449.70,   90.30,    2.60,
     7.20,  222.30,    9.70,   13.10, 1710.60,    6.70,  636.30,  234.20,   11.40,   15.20,
    50.00,   27.20,    5.70,  126.10,   83.00,   16.30,   24.30,  144.90,   75.50,    6.60,
    45.00,   11.10,  215.60,    5.40,   95.30,  305.10,   48.70,   41.40,  279.60,   10.50,
    32.20,   19.30,   58.20,  590.50,   59.60,   79.70,   56.90,    1.30,    4.20,   17.90,
   666.30,   10.30,   29.70,   49.50,    3.60,   29.00,  396.40,   79.80,   13.70,   15.60
 };

const double pll_aa_rates_pmb[190] =
 {
   0.674995699, 0.589645178, 0.462499504, 1.065445546, 1.111766964,
   1.046334652, 1.587964372, 0.580830874, 0.464590585, 0.804404505,
   0.831998835, 1.546725076, 0.546169219, 1.241586045, 3.452308792,
   1.751412803, 0.350110510, 0.573154753, 2.063050067, 1.189067034,
   0.605460903, 0.314448330, 2.967840934, 1.201770702, 0.523770553,
   1.457127446, 0.359645860, 0.520701585, 4.956476453, 0.813462540,
   0.303437244, 0.655773380, 0.910144334, 0.895171490, 0.618778365,
   0.628599063, 0.388680158, 3.573373315, 0.589852457, 2.299755865,
   1.277836748, 1.374854049, 2.283037894, 0.426069419, 0.410094470,
   2.037575629, 0.737846301, 0.425193716, 0.711495595, 2.572577221,
   1.823161023, 0.422407388, 0.720013799, 0.474418852, 0.246951424,
   1.686058219, 4.399995525, 0.734992057, 0.839348444, 0.266775558,
   0.269124919, 1.114178954, 0.341932741, 0.219005213, 0.775624818,
   1.440896785, 0.994227284, 0.362495245, 0.436220437, 0.275658381,
   0.245163782, 0.091071867, 0.317066320, 0.411543728, 0.417547309,
   0.450795211, 0.274163536, 0.618614612, 0.669206193, 0.198679914,
   0.998700980, 0.847312432, 0.445669347, 0.556261630, 0.998911631,
   4.159678990, 0.596789898, 1.812173605, 0.315256838, 0.625792937,
   3.521346591, 2.067388546, 0.406042546, 0.850116543, 1.348272505,
   1.320626678, 0.720384740, 0.728970584, 0.634408285, 0.463812837,
   0.877842609, 0.304215290, 0.320784710, 2.415974716, 0.531773639,
   0.224154698, 0.794584081, 1.205509425, 0.949599791, 0.261258229,
   0.507200030, 0.527640634, 0.476331437, 0.180198883, 0.259854426,
   0.581001076, 0.465349326, 0.354028910, 0.588254139, 1.402122097,
   0.542185658, 0.378748270, 0.284727562, 0.314700907, 0.285186418,
   0.363981358, 0.985885486, 0.380925433, 0.576231691, 0.456058589,
   0.799966711, 0.830392810, 0.724367510, 2.210952064, 0.305792277,
   4.162454693, 0.374784947, 3.658070120, 1.495264661, 0.366232942,
   0.530641901, 1.114132523, 0.516260502, 0.570562395, 8.002789424,
   0.498011337, 5.002338375, 2.392638293, 0.430073179, 0.402471997,
   0.779827336, 0.794797115, 0.811019594, 2.113077156, 0.661095832,
   0.269496317, 1.036079005, 1.234648153, 1.290709079, 0.433409620,
   0.664884513, 0.526184203, 2.306919847, 0.337502282, 0.945453716,
   1.551488041, 0.768395107, 0.932536060, 1.737356217, 0.481144863,
   0.613230817, 0.718895136, 3.295193440, 5.894735673, 0.983844803,
   1.217683028, 0.780913179, 0.499869138, 0.433748126, 0.551333603,
   4.448982584, 0.496334956, 0.593795813, 0.507506011, 0.383723610,
   0.523549536, 1.899650790, 2.996248013, 0.429570747, 0.716795463
 };

const double pll_aa_rates_hivb[190] =
 {
    0.30750700,  0.00500000,  1.45504000,  0.12375800,  0.05511280,
    1.48135000,  2.13536000,  0.08476130,  0.00500000,  0.21525600,
    0.00500000,  0.01866430,  0.01412690,  2.12217000,  2.46633000,
   15.91830000,  0.00500000,  0.00500000,  7.61428000,  0.29554300,
    0.00500000,  0.35172100,  3.42150000,  0.07492180,  3.65345000,
    9.04044000,  0.67728900,  0.70142700, 20.45000000,  2.51394000,
    0.00500000,  1.28355000,  3.47910000,  2.86868000,  0.99133800,
    0.00991826,  0.08124540, 17.66120000,  0.08606420,  0.67205200,
    0.07926330,  0.32340100,  7.64585000,  0.68056500,  0.00500000,
    7.90443000,  0.00500000,  0.00500000,  0.00739578, 13.14470000,
    6.88667000,  0.00500000,  1.76417000,  0.02665600,  0.00500000,
    0.00500000, 10.58720000,  2.83806000,  1.91690000,  0.01767920,
    0.00876048,  0.00500000,  0.00500000,  0.00500000,  0.03426580,
    0.52823000,  0.27472400,  0.00500000,  0.67465300,  1.04793000,
    0.00500000,  0.00500000,  0.89787100,  0.24007300,  0.00500000,
    0.12977700,  0.00500000,  0.00500000,  9.29815000,  0.00500000,
    4.69314000,  0.73996900,  2.63277000,  7.57932000,  0.42002700,
    2.56020000,  0.06191370,  7.05545000,  0.00500000,  1.49456000,
    6.54737000,  0.30367600,  0.00500000,  4.47211000,  0.11631100,
    0.24358900,  0.02665600,  0.11303300,  0.02091530,  3.92775000,
    0.11974000,  0.00609079,  0.00500000,  4.61482000,  0.17578900,
    0.00500000,  0.01202260,  0.00500000,  0.28977400,  0.00500000,
    0.07926330,  1.02847000,  0.00500000,  0.00500000,  0.00500000,
    0.52170500,  0.00500000,  0.29156100,  0.00500000,  4.38041000,
    0.36961500,  1.21674000,  0.00500000,  0.95315500,  0.10311100,
    1.74171000,  0.00500000,  0.00500000,  0.14555800,  2.45318000,
    0.38274700,  0.71159400,  0.06951790, 18.69430000,  0.00500000,
    5.95879000,  0.32231900, 11.20650000,  3.39836000,  0.04105930,
    1.21803000,  8.61217000,  0.00500000,  0.14816800, 17.73890000,
    0.08149950,  5.31961000,  8.52484000,  2.07757000,  0.92765600,
    0.04376730,  0.74884300,  0.11198600,  1.41036000,  1.28246000,
    0.03426580,  0.03138620,  0.50411100,  4.67142000,  0.00500000,
    0.00500000,  0.26582900,  0.18802500,  0.00500000,  0.00500000,
    4.94026000,  0.08907800,  0.00500000,  6.85320000,  0.00500000,
    0.95647200,  0.01412690,  0.82934300, 15.34000000,  0.72327400,
    5.37762000,  2.01417000,  0.04445060,  0.03043810,  0.00500000,
    8.93107000,  0.02487280,  0.64802400,  0.07492180,  0.00500000,
    0.10565200,  0.70922600,  1.28022000,  0.00500000,  0.04105930
 };

const double pll_aa_rates_hivw[190] =
 {
    0.0744808,  0.6175090,  4.4352100,  0.1676530,  0.0050000,
    5.5632500,  1.8685000,  0.0050000,  0.0050000,  0.1602400,
    0.5927840,  0.0050000,  0.5979230,  1.0098100,  8.5942000,
   24.1422000,  0.0050000,  0.0050000, 24.8094000,  0.1602400,
    0.0674539,  2.8636400, 10.6746000,  0.0251632, 13.4379000,
    6.8440500,  1.3406900,  0.5867570, 39.8897000,  3.2865200,
    0.0050000,  0.4047230,  8.3502400,  0.9282030,  5.9656400,
    0.0050000,  0.2794250, 29.4087000,  0.0604932,  0.3420680,
    0.2015260,  0.0604932,  8.5987600,  0.9870280,  0.0050000,
   10.6655000,  0.2015260,  0.0050000,  0.3448480, 14.5699000,
    4.5420600,  0.0050000,  5.0647500,  0.0744808,  0.0050000,
    0.0050000, 12.1233000, 10.3969000,  2.3177900,  0.1451240,
    0.0050000,  0.8943130,  0.0050000,  0.0050000,  0.0050000,
    0.4278810,  0.6303950,  0.0050000,  2.2815400,  2.9178600,
    0.0050000,  0.0050000,  0.0489798,  0.0050000,  0.0050000,
    0.0050000,  0.0050000,  0.0050000,  0.3629590,  0.0050000,
    1.1219500,  0.0050000,  5.4989400,  8.3483500,  0.0050000,
    3.2065600,  0.0604932, 18.5465000,  0.0342252,  2.8904800,
   13.0705000,  0.0050000,  0.0050000,  3.0450200,  0.1602400,
    0.2030910,  0.0443298,  0.0050000,  0.0050000, 14.7801000,
    0.0050000,  0.0390512,  0.1298390, 23.9626000,  0.0050000,
    0.0050000,  0.0050000,  0.0050000,  0.4587430,  0.0050000,
    0.0050000,  2.1995200,  0.0050000,  0.0050000,  0.0489798,
    0.2794250,  0.0489798,  0.0050000,  0.0050000,  6.2796600,
    0.0489798,  2.8258000,  0.0050000,  2.7962200,  0.0050000,
    1.7638200,  0.2240600,  0.0050000,  0.0050000, 13.9444000,
    0.7251570,  0.9595600,  0.0050000, 47.4889000,  0.8274790,
    9.1024600,  0.8174810, 17.3064000,  1.4828800,  0.0050000,
    0.7400910,  9.3634500,  0.0050000,  0.1145120, 24.8231000,
    0.0050000, 11.3839000,  7.4878100,  9.8309500,  6.1439600,
    0.0050000,  1.3703100,  0.0050000,  2.9534400,  4.0956400,
    0.0050000,  0.1119280,  0.0050000,  4.0480200,  0.0050000,
    0.0050000,  0.1280650,  0.0050000,  0.0050000,  0.3925750,
    7.4131300,  0.0050000,  0.5791980, 14.7683000,  0.0342252,
    4.2793900,  0.1145120,  0.0050000,  4.1272800,  2.2800000,
   14.2490000,  4.3370100,  0.0050000,  0.0050000,  0.0050000,
    6.3407900,  1.1015600,  0.9331420,  0.8626370,  0.0050000,
    0.4906080,  0.0050000,  0.0050000,  0.0050000,  1.3548200
 };

const double pll_aa_rates_jttdcmut[190] =
 {
   0.531678, 0.557967, 0.827445, 0.574478, 0.556725, 1.066681, 1.740159, 0.219970, 0.361684, 0.310007,
   0.369437, 0.469395, 0.138293, 1.959599, 3.887095, 4.582565, 0.084329, 0.139492, 2.924161, 0.451095,
   0.154899, 1.019843, 3.021995, 0.318483, 1.359652, 3.210671, 0.239195, 0.372261, 6.529255, 0.431045,
   0.065314, 0.710489, 1.001551, 0.650282, 1.257961, 0.235601, 0.171995, 5.549530, 0.313311, 0.768834,
   0.578115, 0.773313, 4.025778, 0.491003, 0.137289, 2.529517, 0.330720, 0.073481, 0.121804, 5.057964,
   2.351311, 0.027700, 0.700693, 0.164525, 0.105625, 0.521646, 7.766557, 1.272434, 1.032342, 0.115968,
   0.061486, 0.282466, 0.190001, 0.032522, 0.127164, 0.589268, 0.425159, 0.057466, 0.453952, 0.315261,
   0.091304, 0.053907, 0.546389, 0.724998, 0.150559, 0.164593, 0.049009, 0.409202, 0.678335, 0.123653,
   2.155331, 0.469823, 1.104181, 2.114852, 0.621323, 3.417706, 0.231294, 5.684080, 0.078270, 0.709004,
   2.966732, 0.456901, 0.045683, 1.608126, 0.548807, 0.523825, 0.172206, 0.254745, 0.179771, 1.115632,
   0.243768, 0.111773, 0.097485, 1.731684, 0.175084, 0.043829, 0.191994, 0.312449, 0.331584, 0.114381,
   0.063452, 0.465271, 0.201696, 0.053769, 0.069492, 0.269840, 0.130379, 0.050212, 0.208081, 1.874296,
   0.316862, 0.544180, 0.052500, 0.470140, 0.181788, 0.540571, 0.525096, 0.329660, 0.453428, 1.141961,
   0.743458, 0.477355, 0.128193, 5.848400, 0.121827, 2.335139, 0.202562, 4.831666, 0.777090, 0.098580,
   0.405119, 2.553806, 0.134510, 0.303445, 9.533943, 0.146481, 3.856906, 2.500294, 1.060504, 0.592511,
   0.272514, 0.530324, 0.241094, 1.761439, 0.624581, 0.024521, 0.216345, 0.474478, 0.965641, 0.089134,
   0.087904, 0.124066, 0.436181, 0.164215, 0.285564, 2.114728, 0.201334, 0.189870, 3.038533, 0.148483,
   0.943971, 0.138904, 0.537922, 5.484236, 0.593478, 2.788406, 1.176961, 0.069965, 0.113850, 0.211561,
   4.777647, 0.310927, 0.628608, 0.408532, 0.080556, 0.201094, 1.143980, 0.747889, 0.239697, 0.165473
 };

const double pll_aa_rates_flu[190] =
 {
   0.138658765,  0.053366579,  0.584852306,  0.026447095,  0.353753982,
   1.484234503,  1.132313122,  0.214757862,  0.149926734,  0.023116952,
   0.474333610,  0.058745423,  0.080490909,  0.659311478,  3.011344519,
   5.418298175,  0.196000000,  0.018289288,  3.532005270,  0.161000889,
   0.006771843,  0.167207008,  3.292716942,  0.124897617,  1.190624465,
   1.879569938,  0.246117172,  0.296045557, 15.300096620,  0.890162346,
   0.016100000,  0.154027180,  0.950138410,  0.183076905,  1.369429408,
   0.099855497,  0.103964386,  7.737392871,  0.000013000,  0.530642655,
   0.061652192,  0.322524648,  1.387096032,  0.218571975,  0.000836000,
   2.646847965,  0.005251688,  0.000836000,  0.036400000,  3.881310531,
   2.140332316,  0.000536000,  0.373101927,  0.010257517,  0.014100000,
   0.145469388,  5.370511279,  1.934832784,  0.887570549,  0.014085917,
   0.005730682,  0.290042980,  0.041762964,  0.000001060,  0.188539456,
   0.338372183,  0.135481233,  0.000014900,  0.525398543,  0.297123975,
   0.002547334,  0.000000000,  0.116941459,  0.021800000,  0.001112158,
   0.005613627,  0.000003830,  0.111457310,  0.104053666,  0.000000000,
   0.336263345,  0.011975266,  0.094106680,  0.601692431,  0.054904564,
   1.195629122,  0.108051341,  5.330313412,  0.028839950,  1.020366955,
   2.559587177,  0.190259181,  0.032680657,  0.712769599,  0.487822499,
   0.602340963,  0.044000000,  0.072205935,  0.406697814,  1.593098825,
   0.256491863,  0.014200000,  0.016499536,  3.881488809,  0.313974351,
   0.001003501,  0.319558828,  0.307140298,  0.280124895,  0.155245492,
   0.104092870,  0.285047948,  0.058774527,  0.000016300,  0.006516229,
   0.264148929,  0.001500467,  0.001236645,  0.038631761,  1.585646577,
   0.018808030,  0.196486447,  0.074814997,  0.337229619,  0.243190142,
   0.321611694,  0.347302791,  0.001273509,  0.119028506,  0.924466914,
   0.580704250,  0.368713573,  0.022400000,  6.448954446,  0.098631355,
   3.512072282,  0.227707997,  9.017954203,  1.463357278,  0.080543327,
   0.290381075,  2.904052286,  0.032132150,  0.273934263, 14.394052190,
   0.129223639,  6.746936485,  2.986800036,  0.634308521,  0.570766693,
   0.044926357,  0.431277663,  0.340058468,  0.890598579,  1.331291619,
   0.320000000,  0.195750632,  0.283807672,  1.526964200,  0.000049800,
   0.012416222,  0.073127930,  0.279910509,  0.056900000,  0.007026588,
   2.031511321,  0.070460039,  0.874272175,  4.904842235,  0.007132430,
   0.996685670,  0.000134906,  0.814753094,  5.393924245,  0.592587985,
   2.087385344,  0.542251094,  0.000431021,  0.000182000,  0.058971975,
   2.206859934,  0.099835753,  0.392552240,  0.088256423,  0.207066206,
   0.124898020,  0.654109108,  0.427755430,  0.256900461,  0.167581647
 };

const double pll_aa_rates_stmtrev[190] =
 {
   0.1159435373,  0.2458816714,  0.9578712472,  0.2327281954,  0.3309250853,
   0.6946680829,  2.8076062202,  0.2275494971,  0.0627691644,  0.0305818840,
   0.2231434272,  0.1874527991,  0.0458112245,  1.5133910481,  2.3008246523,
   4.3546170435,  0.0565037747,  0.0358664532,  3.2116908598,  0.1355713516,
   0.0775041665,  9.1379470330,  5.2854173238,  0.0966719296,  3.0815651393,
   2.8251848421,  0.5712158076,  0.1930408758,  6.0541970908,  0.2427875732,
   0.0310030750,  0.7858555362,  0.7625702322,  1.0655012755,  6.7852754661,
   0.0714121777,  0.0108028571,  8.4408676914,  0.1137687264,  0.1727184754,
   0.2990806606,  0.5575702616,  9.5228608030,  0.2238609194,  0.0540967250,
   4.3977466558,  0.0433577842,  0.0233493970,  0.3000131148,  1.9431704326,
   1.6534489471,  0.0000010442,  0.3036789915,  0.0860833645,  0.0582110367,
   0.8191776581,  7.3729791633,  2.2627839242,  2.3191131858,  0.0205779319,
   0.0018843293,  0.1347413792,  0.0000022173,  0.0000080023,  0.3337627573,
   0.6961369276,  0.0985354973,  0.0000002842,  1.3220740967,  0.0426724431,
   0.0009722083,  0.0005604799,  1.1721237455,  0.0483235836,  0.1527276944,
   0.2406073246,  0.0001480536,  0.0927357503,  0.8419347601,  0.0036260499,
   2.3726544756,  0.1940108923,  0.9529353202,  1.7972997876,  0.3652373073,
   3.5773486727,  0.0482085663,  4.4138715270,  0.0206129952,  0.3299454620,
   5.2864094506,  0.0109238300,  0.0027817812,  1.5386413234,  0.1837198343,
   0.3415280861,  0.0009844045,  0.0066458178,  0.0287789552,  3.3184632572,
   0.0343694246,  0.0328079744,  0.0373753435,  6.8883522181,  0.0663619185,
   0.0361207581,  0.5196922389,  0.9087013201,  0.2794040892,  0.0002705734,
   0.3052655031,  0.1484349765,  0.0948383460,  0.1239000315,  0.0005918940,
   0.5345755286,  0.0128777966,  0.0490593583,  0.0221252552,  2.5477016916,
   0.1657005971,  0.5068170211,  0.0174305437,  0.5158740953,  0.0802374651,
   0.1192904610,  0.3991624551,  0.0722334577,  0.0197089530,  1.0171151697,
   0.3081949928,  0.2704552047,  0.0000932799, 21.9842817264,  0.0059791370,
   1.3184058362,  0.2107928508,  4.3016010974,  0.3634155844,  0.0534088166,
   0.1713464632,  2.3418182855,  0.0050518699,  0.1070890246,  3.3648305163,
   0.1055933141,  1.1493262595,  2.1032860162,  6.0377879080,  2.7297706102,
   0.0426297282,  0.3163744815,  0.0770894218,  0.8763855707,  0.4773694701,
   0.0861057517,  0.4350064365,  0.3416923226,  1.2152488582,  0.0000023280,
   0.1929529483,  0.0776875418,  0.1735660361,  0.1634497017,  0.0730798705,
   4.6553742047,  0.1010587493,  0.0561599188,  0.9145670668,  0.3545179411,
   4.0107845583,  0.0068797851,  0.2890102379,  1.6748429971,  0.3963331926,
   8.4630191575,  1.1613183519,  0.0041564377,  0.0021338646,  0.1080226203,
   2.2213527952,  0.0495269526,  1.8890678523,  0.0640951379,  0.0002026765,
   0.2834320440,  0.2278998021,  0.3134203648,  0.0388755869,  0.1836950254
};


/* TODO: Check why with the uncommented rates (Phy-LG) the lnL is largely different! */
const double pll_aa_rates_lg4m[4][190] = {
    /*Q_fnBL6.txt.Const.all.R0.train [] =*/ {
        0.26934280, 0.25461130, 0.23682090, 2.50654400, 0.35907970, 0.30467340,
        1.69201300, 0.25197360, 1.08521900, 0.67635210, 0.17915450, 1.63681500,
        0.23549800, 1.26560400, 5.36839900, 1.53939200, 0.14094360, 0.19983620,
        9.43551900, 0.15098790, 0.03186329, 0.93859340, 0.34828740, 0.15599960,
        0.28663770, 0.92163180, 0.32562380, 0.60236520, 0.97133710, 0.51521650,
        0.12393210, 0.04016254, 0.47095170, 0.32678820, 0.37561060, 0.14685680,
        0.28593410, 0.65964710, 0.97573520, 0.69770720, 0.37770330, 0.56509390,
        1.26760800, 0.81865750, 0.21702660, 1.34371700, 0.67046060, 0.09979260,
        0.17335380, 5.26713400, 1.68816700, 0.02516310, 0.80627370, 0.39566980,
        0.17553280, 0.08657297, 0.44913980, 0.38035710, 0.30969120, 0.03781349,
        0.00753344, 0.13374340, 0.07125161, 0.03042488, 0.02757850, 0.78050410,
        0.28373730, 0.00275714, 0.23424560, 0.13089020, 0.09596710, 0.06470629,
        0.61794460, 0.39042810, 1.14414900, 1.59577300, 0.12246790, 1.53484600,
        0.89727760, 0.25996120, 4.98606600, 1.38928100, 0.80145490, 1.43696800,
        6.09725600, 4.34259000, 0.20205750, 2.34405600, 0.53456650, 0.67114200,
        0.98385630, 5.28863600, 0.11222930, 0.58037300, 0.89055260, 0.32982020,
        0.25725290, 0.31966880, 0.51625820, 0.26434140, 0.21774950, 0.22279270,
        0.15842380, 0.99412660, 0.25562750, 0.02252940, 0.08804067, 0.37794840,
        0.23176980, 0.10367780, 0.01007609, 0.50366440, 0.10484230, 0.06268171,
        0.07046250, 0.22091550, 0.09419773, 0.04748821, 0.14559490, 1.75551300,
        0.11701670, 0.13299520, 0.03685847, 0.22295970, 0.56743070, 0.76425370,
        0.41058010, 0.25722870, 0.76291290, 0.14367620, 0.78635120, 0.44997610,
        0.34583380, 3.50331300, 0.14914330, 8.22651900, 0.38748610, 25.66713000,
        1.34425800, 0.29885910, 0.52724500, 3.53159600, 0.37715540, 0.59863150,
        13.66616000, 0.18110980, 6.81968200, 0.86569030, 1.02011600, 0.66778210,
        0.72158520, 0.83964610, 0.73896810, 2.98817100, 1.59121000, 0.03892116,
        0.00071409, 0.65994690, 0.49758750, 0.17696940, 0.15443560, 0.16272460,
        2.03083100, 0.19001890, 0.73191980, 2.69169400, 0.50568100, 0.57899910,
        5.97382000, 0.09396377, 0.83766840, 0.15208830, 1.67016800, 4.24551900,
        0.84341500, 1.35562900, 0.69803890, 0.09129804, 0.07452385, 0.59739300,
        16.32128000, 0.21009530, 0.45419460, 0.70114820, 0.01316515, 0.23291260,
        4.67999700, 1.17848900, 0.30008510, 0.41626170},
    /*Q_fnBL6.txt.Const.all.R1.train [] =*/ {
        0.13371940, 0.33721130, 0.11091780, 3.99344900, 0.41207430, 0.43529400,
        7.83751900, 0.20387160, 0.03971810, 0.07578343, 0.17766200, 0.42078270,
        0.07126828, 0.95912460, 11.72148000, 2.84706000, 0.03020326, 0.06718319,
        0.67939570, 0.74905010, 0.10508700, 0.18830420, 2.58576700, 0.19827740,
        0.16460650, 2.13032800, 0.02455306, 0.08009098, 10.37368000, 0.19276460,
        0.01965227, 1.49658100, 0.35940670, 0.21846230, 0.38729140, 0.13010040,
        0.04156719, 4.77347400, 1.59032800, 1.90687900, 0.29636490, 0.43172290,
        9.37445400, 0.13525370, 0.08497062, 1.03671800, 0.32954390, 0.08875255,
        0.37779320, 2.39915200, 1.85538100, 0.11887730, 0.34872920, 0.09240737,
        0.30494100, 0.43836590, 7.47031300, 0.15384920, 1.08087500, 0.01497853,
        0.01412830, 0.03830303, 0.00833141, 0.01354686, 0.33200920, 0.21946360,
        0.10980810, 0.06728678, 0.06179819, 0.02370129, 0.24207490, 0.00844306,
        1.79971100, 0.15245720, 0.14749760, 0.30834640, 0.04302966, 0.88313980,
        0.56660740, 0.31819160, 9.10416800, 4.34703600, 0.19023980, 0.30119750,
        1.27118400, 3.29550600, 0.26974360, 12.29910000, 0.03396370, 0.50083470,
        2.18102700, 1.40332000, 0.07187819, 1.38696600, 0.76756110, 0.76584550,
        0.12211310, 0.09538220, 0.11556570, 0.24286530, 0.27958850, 0.00558536,
        0.02283258, 0.32116410, 0.16867260, 0.02005025, 0.91590110, 0.23522860,
        0.16456870, 0.00702274, 0.09576353, 0.05527683, 0.08971406, 0.00724765,
        0.02299941, 0.10304980, 0.16072760, 0.04102144, 0.22425430, 3.62120900,
        0.31202340, 0.13741040, 0.04462787, 0.08698783, 0.02274551, 0.16126980,
        0.45950100, 0.61257180, 0.62535980, 2.61147200, 0.97195230, 0.23156860,
        0.58513910, 2.10737800, 0.06077868, 1.51167800, 0.02121451, 1.52088500,
        0.38280490, 0.02935137, 0.03377961, 0.35632650, 0.02063377, 0.04610516,
        8.23514500, 0.07839444, 7.76324500, 1.76305400, 0.06824966, 0.04303484,
        0.15959620, 0.22882350, 0.10011670, 0.60941870, 0.30790260, 0.04464431,
        1.54235200, 0.23692790, 0.40320870, 0.00012165, 0.01707327, 0.06176381,
        1.55190700, 0.04752526, 0.31996290, 1.13515900, 0.47486080, 0.19238230,
        0.58196020, 0.18271460, 0.12497680, 0.10690250, 3.13512000, 8.36761900,
        0.18418700, 0.84064910, 0.26918970, 0.03031264, 0.00093668, 0.08024588,
        9.81645500, 0.09382966, 0.13741560, 0.09803237, 0.11915190, 0.04472207,
        1.43834600, 4.17977100, 0.02343856, 0.03912392},
    /*Q_fnBL6.txt.Const.all.R2.train [] =*/ {
        0.42101640, 0.31623520, 0.28598360, 4.03402700, 0.88697060, 0.76052420,
        0.75410180, 0.57142140, 0.16215150, 0.30800540, 0.39016040, 1.04229700,
        0.36247560, 1.75548900, 3.97505600, 2.56507600, 0.28363040, 0.24251280,
        2.79581500, 0.69333950, 0.05992560, 1.35770600, 2.79161900, 0.23305060,
        0.40289360, 2.31945100, 0.08522849, 0.28705110, 7.66320100, 0.36455100,
        0.07343902, 0.08704999, 0.89339690, 0.53405560, 0.49792580, 0.19915650,
        0.10713010, 6.15821300, 0.70808700, 1.70182800, 0.37872290, 2.22744100,
        5.57996700, 0.09569181, 0.05699418, 1.66363900, 0.29322170, 0.12924450,
        0.09932472, 5.49630800, 2.14399100, 0.07545344, 0.47220640, 0.06090851,
        0.06366891, 0.48434610, 4.03266300, 1.10268800, 0.88537490, 0.00612935,
        0.00710160, 0.10512910, 0.03798303, 0.02007767, 0.16381660, 1.39731200,
        0.41138780, 0.04379366, 0.08593687, 0.02972422, 0.41428570, 0.08197704,
        0.41657600, 1.43927400, 0.49093610, 0.95898750, 0.13502880, 1.48651800,
        1.99248100, 0.24285090, 3.57511600, 2.27908200, 1.33532100, 2.03978500,
        2.98642300, 4.94040600, 0.45937590, 4.10197500, 0.10484330, 0.57898980,
        3.36447100, 1.68175000, 0.11454890, 0.32293860, 1.38529600, 0.89300460,
        0.30860480, 0.26275100, 0.19726710, 0.50840810, 0.57674450, 0.04551347,
        0.06711922, 0.65261760, 0.19241420, 0.02327192, 0.06294316, 0.57619070,
        0.52820810, 0.14013670, 0.08457753, 0.19697670, 0.42879900, 0.00470479,
        0.02440311, 0.45770150, 0.07049779, 0.06449029, 0.19869820, 1.73328600,
        0.13573120, 0.15079690, 0.03224689, 0.04432684, 0.09893366, 0.34298310,
        0.82367290, 0.22262550, 1.49179200, 0.19290420, 1.02125400, 0.51874000,
        1.40972500, 7.76231800, 0.11675080, 3.80552400, 0.12985740, 4.52961800,
        1.11343600, 0.06294764, 0.06513125, 0.97266080, 0.11986760, 0.15396540,
        7.14430400, 0.14562940, 4.78172500, 2.13200400, 0.18028330, 0.12911440,
        0.28070020, 0.81833010, 0.29982720, 1.84862000, 0.66530740, 0.04167697,
        0.05965500, 0.60030720, 0.89008530, 0.08059106, 0.11725500, 0.11801950,
        1.92865200, 0.12932310, 0.38727510, 1.82875300, 1.06601600, 0.43821440,
        1.99969400, 0.06577772, 0.44600080, 0.18902770, 3.75468300, 14.50622000,
        0.70574630, 1.29849200, 0.56377760, 0.07341449, 0.08918012, 0.27276310,
        7.78813900, 0.43504590, 0.35276610, 0.09693529, 0.19727190, 0.21541670,
        1.82098000, 5.05424000, 0.21700630, 0.17297470},
    /*Q_fnBL6.txt.Const.all.R3.train [] =*/ {
        0.57616080, 0.56760750, 0.82436030, 0.82272580, 1.25424000, 1.21861700,
        1.80344600, 0.51686300, 0.18089820, 0.45209940, 0.66418730, 0.86441700,
        0.32447860, 1.07304500, 3.83756900, 2.10603000, 0.16372080, 0.24116720,
        1.82458900, 0.49864400, 0.05069799, 4.52924400, 2.16981300, 0.15450210,
        0.60467420, 2.87427000, 0.44458720, 0.86632370, 2.90289200, 0.83505050,
        0.20894760, 0.17382680, 0.88434390, 0.75001760, 0.81810360, 0.30244040,
        0.43579540, 3.30140700, 1.29181000, 1.42798300, 0.41147190, 2.12550000,
        4.84577800, 0.55097000, 0.20103380, 2.10197500, 0.63264990, 0.28033950,
        0.04198516, 4.57192000, 2.32332900, 0.07232197, 1.05509700, 0.17908640,
        0.10193050, 0.44947440, 3.17228300, 1.27638600, 0.71967430, 0.02354243,
        0.02673095, 0.12798850, 0.07920137, 0.04168297, 0.27033610, 0.94275240,
        0.33591570, 0.06827474, 0.24694000, 0.09173919, 0.86868100, 0.05023885,
        1.59868200, 3.82568400, 2.34957700, 2.81399500, 0.20021820, 2.10593500,
        4.78848600, 0.12129970, 6.59284000, 1.65467600, 3.30544200, 9.74196100,
        3.60957700, 2.13866500, 0.50265430, 4.04028300, 0.37016040, 1.64518100,
        2.50593800, 1.63354700, 0.10702220, 0.35138510, 1.08006500, 1.19401900,
        0.37379080, 0.24989510, 0.64950820, 0.47949100, 0.29277310, 0.14218710,
        0.13555630, 0.75951010, 0.21646210, 0.06771136, 0.22856540, 0.46539740,
        0.61723230, 0.05432272, 0.12997300, 0.65668270, 0.59664390, 0.01661852,
        0.07215253, 0.33356940, 0.25241970, 0.17132030, 0.22531800, 3.13762000,
        0.31867200, 0.47658840, 0.05236271, 0.22523430, 0.50078910, 1.16881900,
        0.62310070, 0.66540750, 3.32478500, 0.37608950, 1.11966900, 0.80103140,
        1.10036200, 11.54252000, 0.47343770, 5.69612700, 0.54745480, 7.99412000,
        2.96533400, 0.05802696, 0.36251700, 4.45585000, 0.39294680, 1.04745100,
        19.89729000, 0.36365630, 11.75120000, 5.13385300, 0.39035480,
        0.60235570, 0.58019200, 1.70332600, 1.31967000, 3.00200100, 1.09684400,
        0.08485586, 0.21423000, 0.71694090, 1.38421300, 0.08572005, 0.13977040,
        0.45292660, 4.04259900, 0.05895445, 0.50679720, 3.52247500, 1.72551900,
        1.33022800, 3.92960500, 0.12629960, 1.44448700, 0.47312930, 5.43626300,
        26.56232000, 1.69216200, 1.43256100, 0.43271880, 0.05310831, 0.04698571,
        0.37020460, 5.71631100, 0.49859530, 0.73765430, 0.37350210, 0.23183280,
        0.31346020, 3.32982800, 5.16510800, 0.32659360, 0.86074460 } };

const double pll_aa_rates_lg4x[4][190] =
  {{
      0.295719, 0.067388, 0.253712, 1.029289, 0.107964, 0.514644, 10.868848, 0.380498, 0.084223, 0.086976,
      0.188789, 0.286389, 0.155567, 1.671061, 2.132922, 0.529591, 0.115551, 0.102453, 0.916683, 0.448317,
      0.457483, 0.576016, 1.741924, 0.736017, 0.704334, 5.658311, 0.123387, 0.221777, 93.433377, 0.382175,
      0.235965, 6.535048, 0.525521, 0.303537, 0.641259, 0.289466, 0.102065, 2.358429, 0.251987, 0.216561,
      0.503084, 0.435271, 4.873453, 0.090748, 0.033310, 0.746537, 0.128905, 0.127321, 0.904011, 0.939733,
      0.435450, 0.046646, 0.262076, 0.043986, 0.189008, 0.599450, 109.901504, 1.070052, 5.229858, 0.052764,
      0.021407, 0.621146, 0.081091, 0.205164, 5.164456, 0.747330, 0.308078, 0.260889, 0.185083, 0.080708,
      0.029955, 0.084794, 1.862626, 0.553477, 0.151733, 0.230320, 0.096955, 0.352526, 0.590018, 0.386853,
      1.559564, 0.606648, 0.587531, 0.592318, 0.885230, 4.117654, 0.246260, 6.508329, 0.054187, 0.195703,
      1.669092, 0.810168, 0.066081, 2.437439, 0.165666, 0.106333, 0.093417, 0.035149, 0.072549, 1.202023,
      1.634845, 0.060194, 0.069359, 2.448827, 0.232297, 0.064822, 3.537387, 0.435384, 0.290413, 0.280695,
      0.105999, 0.206603, 0.404968, 0.048984, 0.069963, 0.256662, 0.228519, 0.241077, 4.320442, 3.656545,
      0.290216, 0.307466, 0.096556, 0.306067, 0.204296, 0.504221, 1.991533, 0.655465, 6.799829, 11.291065,
      0.961142, 0.448965, 6.227274, 20.304886, 0.205944, 1.495537, 0.091940, 1.994320, 0.754940, 0.170343,
      0.050315, 0.372166, 0.206332, 0.097050, 5.381403, 0.122332, 3.256485, 2.261319, 0.848067, 0.064441,
      0.102493, 0.459041, 0.133091, 0.561215, 0.457430, 0.163849, 5.260446, 0.360946, 0.389413, 0.033291,
      0.115301, 0.112593, 1.559944, 0.426508, 0.132547, 0.498634, 0.559069, 0.264728, 0.693307, 0.438856,
      0.306683, 0.109129, 18.392863, 66.647302, 0.400021, 4.586081, 2.099355, 0.411347, 0.476350, 0.584622,
      3.634276, 0.101797, 0.148995, 0.089177, 0.034710, 0.063603, 0.755865, 20.561407, 0.133790, 0.154902
  },{
      0.066142, 0.590377, 0.069930, 9.850951, 1.101363, 0.150375, 0.568586, 0.051668, 0.127170, 0.292429,
      0.071458, 1.218562, 0.075144, 7.169085, 30.139501, 13.461692, 0.021372, 0.045779, 4.270235, 0.468325,
      0.013688, 0.302287, 1.353957, 0.028386, 0.037750, 0.262130, 0.016923, 0.064289, 0.855973, 0.079621,
      0.011169, 0.161937, 0.276530, 0.161053, 0.081472, 0.036742, 0.030342, 2.851667, 3.932151, 8.159169,
      0.219934, 0.421974, 2.468752, 0.344765, 0.210724, 1.172204, 0.763553, 0.082464, 0.726566, 11.149790,
      4.782635, 0.058046, 0.498072, 0.258487, 0.146882, 0.249672, 0.560142, 0.046719, 0.106259, 0.003656,
      0.004200, 0.014189, 0.009876, 0.002656, 0.040244, 0.267322, 0.053740, 0.006597, 0.027639, 0.012745,
      0.582670, 0.005035, 0.275844, 0.098208, 0.445038, 1.217010, 0.033969, 1.988516, 0.681161, 0.825960,
      18.762977, 11.949233, 0.286794, 0.534219, 4.336817, 3.054085, 0.129551, 4.210126, 0.165753, 1.088704,
      1.889645, 3.344809, 0.111063, 2.067758, 3.547017, 2.466507, 0.188236, 0.203493, 0.281953, 0.037250,
      0.029788, 0.008541, 0.014768, 0.125869, 0.056702, 0.004186, 0.110993, 0.201148, 0.139705, 0.009201,
      0.012095, 0.043812, 0.013513, 0.002533, 0.005848, 0.031390, 0.021612, 0.004854, 0.129497, 0.976631,
      0.053397, 0.019475, 0.004964, 0.015539, 0.031779, 0.064558, 0.065585, 0.079927, 0.095591, 0.196886,
      0.408834, 0.126088, 0.037226, 0.452302, 0.016212, 7.278994, 0.029917, 7.918203, 0.450964, 0.169797,
      0.104288, 1.578530, 0.015909, 0.094365, 16.179952, 0.042762, 14.799537, 1.506485, 0.637893, 0.123793,
      0.641351, 0.154810, 0.140750, 3.416059, 0.259400, 0.009457, 0.090576, 0.292108, 0.297913, 0.017172,
      0.021976, 0.032578, 1.375871, 0.457399, 0.598048, 4.418398, 0.239749, 0.168432, 2.950318, 0.143327,
      0.328689, 0.125011, 0.562720, 1.414883, 0.227807, 3.478333, 2.984862, 0.061299, 0.077470, 1.050562,
      13.974326, 0.154326, 0.224675, 0.112000, 0.060703, 0.123480, 5.294490, 0.447011, 0.033381, 0.045528
  },{
      0.733336, 0.558955, 0.503360, 4.149599, 1.415369, 1.367574, 1.263002, 0.994098, 0.517204, 0.775054,
      0.763094, 1.890137, 0.540460, 0.200122, 4.972745, 1.825593, 0.450842, 0.526135, 3.839269, 0.597671,
      0.058964, 2.863355, 2.872594, 0.258365, 0.366868, 2.578946, 0.358350, 0.672023, 5.349861, 0.691594,
      0.063347, 0.032875, 0.821562, 0.580847, 0.661866, 0.265730, 0.395134, 5.581680, 1.279881, 1.335650,
      0.397108, 1.840061, 5.739035, 0.284730, 0.109781, 1.612642, 0.466979, 0.141582, 0.019509, 4.670980,
      1.967383, 0.088064, 0.581928, 0.145401, 0.225860, 0.434096, 2.292917, 1.024707, 0.821921, 0.027824,
      0.021443, 0.088850, 0.060820, 0.018288, 0.042687, 1.199607, 0.420710, 0.037642, 0.141233, 0.090101,
      1.043232, 0.209978, 0.823594, 3.039380, 1.463390, 1.983693, 0.397640, 2.831098, 4.102068, 0.059723,
      5.901348, 2.034980, 2.600668, 5.413080, 4.193725, 4.534772, 0.377181, 4.877840, 0.370939, 1.298542,
      3.509873, 2.646440, 0.087872, 0.072299, 1.139018, 0.864479, 0.390688, 0.322761, 0.625409, 0.496780,
      0.532488, 0.232460, 0.169219, 0.755219, 0.379926, 0.020447, 0.023282, 0.503875, 0.577513, 0.109318,
      0.153776, 0.696533, 0.398817, 0.008940, 0.043707, 0.436013, 0.087640, 0.064863, 0.036426, 1.673207,
      0.124068, 0.218118, 0.039217, 0.104335, 0.349195, 0.838324, 0.888693, 0.488389, 1.385133, 0.050226,
      0.962470, 0.502294, 1.065585, 8.351808, 0.377304, 5.102837, 0.561690, 7.010411, 3.054968, 0.039318,
      0.204155, 2.653232, 0.564368, 0.854294, 15.559906, 0.401070, 8.929538, 5.525874, 0.067505, 0.273372,
      0.437116, 1.927515, 0.940458, 2.508169, 1.357738, 0.043394, 0.023126, 0.567639, 1.048288, 0.120994,
      0.180650, 0.449074, 3.135353, 0.012695, 0.570771, 2.319555, 1.856122, 0.975427, 3.404087, 0.015631,
      0.458799, 0.151684, 4.154750, 11.429924, 1.457957, 0.233109, 0.077004, 0.011074, 0.026268, 0.052132,
      8.113282, 0.377578, 0.429221, 0.260296, 0.222293, 0.273138, 2.903836, 4.731579, 0.564762, 0.681215
  },{
      0.658412, 0.566269, 0.854111, 0.884454, 1.309554, 1.272639, 1.874713, 0.552007, 0.227683, 0.581512,
      0.695190, 0.967985, 0.344015, 0.978992, 3.427163, 2.333253, 0.154701, 0.221089, 2.088785, 0.540749,
      0.058015, 5.851132, 2.294145, 0.182966, 0.684164, 3.192521, 0.528161, 1.128882, 3.010922, 1.012866,
      0.227296, 0.156635, 0.878405, 0.802754, 0.830884, 0.431617, 0.456530, 3.060574, 1.279257, 1.438430,
      0.431464, 2.075952, 4.840271, 0.644656, 0.266076, 2.084975, 0.720060, 0.291854, 0.028961, 4.071574,
      2.258357, 0.073037, 1.238426, 0.199728, 0.160296, 0.482619, 2.992763, 1.296206, 0.841829, 0.031467,
      0.048542, 0.132774, 0.133055, 0.056045, 0.209188, 0.925172, 0.360522, 0.094591, 0.313945, 0.118104,
      0.992259, 0.086318, 2.149634, 5.103188, 3.775817, 3.954021, 0.190734, 1.776095, 4.495841, 0.264277,
      7.063879, 2.221150, 3.017954, 8.558815, 4.310199, 2.130054, 0.571406, 4.137385, 0.437589, 2.071689,
      2.498630, 1.763546, 0.116381, 0.296578, 1.033710, 1.283423, 0.312579, 0.305772, 0.681277, 0.507160,
      0.351381, 0.189152, 0.217780, 0.767361, 0.278392, 0.092075, 0.177263, 0.451893, 0.653836, 0.074620,
      0.181992, 0.752277, 0.679853, 0.025780, 0.082005, 0.326441, 0.343977, 0.195877, 0.217424, 3.057583,
      0.377558, 0.401252, 0.072258, 0.241015, 0.665865, 1.266791, 0.680174, 0.717301, 4.001286, 0.362942,
      1.189259, 0.964545, 1.350568, 12.869737, 0.531100, 8.904999, 0.652629, 10.091413, 2.671718, 0.086367,
      0.359932, 4.797423, 0.336801, 1.021885, 23.029406, 0.440178, 14.013035, 5.069337, 0.539010, 0.742569,
      0.780580, 1.331875, 1.531589, 4.414850, 1.082703, 0.091278, 0.172734, 0.693405, 1.422571, 0.068958,
      0.163829, 0.481711, 4.643214, 0.121821, 0.584083, 4.216178, 1.677263, 1.575754, 5.046403, 0.161015,
      1.531223, 0.599244, 5.832025, 33.873091, 1.914768, 1.287474, 0.444362, 0.076328, 0.079916, 0.466823,
      5.231362, 0.548763, 0.831890, 0.382271, 0.208791, 0.307846, 3.717971, 5.910440, 0.282540, 0.964421
  }};

/* protein model frequencies */

/*
 * WARNING:
 *    In PhyML/PAML the last frequency is 0.064718 instead of 064717.
 *    It makes the frequencies summing to 1.000001 instead of 1.
 *
 *    This happens also with other frequencies. For example, last freq
 *    in LG is different in PhyML and in RAxML (.069147 vs .069146)
 */
const double pll_aa_freqs_dayhoff[20] =
 {
    0.087127, 0.040904, 0.040432, 0.046872, 0.033474,
    0.038255, 0.049530, 0.088612, 0.033618, 0.036886,
    0.085357, 0.080482, 0.014753, 0.039772, 0.050680,
    0.069577, 0.058542, 0.010494, 0.029916, 0.064717
 };

const double pll_aa_freqs_lg[20] =
 {
    0.079066, 0.055941, 0.041977, 0.053052, 0.012937,
    0.040767, 0.071586, 0.057337, 0.022355, 0.062157,
    0.099081, 0.064600, 0.022951, 0.042302, 0.044040,
    0.061197, 0.053287, 0.012066, 0.034155, 0.069146
 };

const double pll_aa_freqs_dcmut[20] =
 {
   0.087127, 0.040904, 0.040432, 0.046872, 0.033474,
   0.038255, 0.049530, 0.088612, 0.033619, 0.036886,
   0.085357, 0.080481, 0.014753, 0.039772, 0.050680,
   0.069577, 0.058542, 0.010494, 0.029916, 0.064717
 };

const double pll_aa_freqs_jtt[20] =
 {
   0.076748, 0.051691, 0.042645, 0.051544, 0.019803,
   0.040752, 0.061830, 0.073152, 0.022944, 0.053761,
   0.091904, 0.058676, 0.023826, 0.040126, 0.050901,
   0.068765, 0.058565, 0.014261, 0.032102, 0.066004
 };

const double pll_aa_freqs_mtrev[20] =
 {
   0.072, 0.019, 0.039, 0.019, 0.006,
   0.025, 0.024, 0.056, 0.028, 0.088,
   0.169, 0.023, 0.054, 0.061, 0.054,
   0.072, 0.086, 0.029, 0.033, 0.043
 };

const double pll_aa_freqs_wag[20] =
 {
   0.0866279, 0.043972,  0.0390894, 0.0570451, 0.0193078,
   0.0367281, 0.0580589, 0.0832518, 0.0244313, 0.048466,
   0.086209,  0.0620286, 0.0195027, 0.0384319, 0.0457631,
   0.0695179, 0.0610127, 0.0143859, 0.0352742, 0.0708957
 };

const double pll_aa_freqs_rtrev[20] =
{
  0.0646, 0.0453, 0.0376, 0.0422, 0.0114,
  0.0606, 0.0607, 0.0639, 0.0273, 0.0679,
  0.1018, 0.0751, 0.0150, 0.0287, 0.0681,
  0.0488, 0.0622, 0.0251, 0.0318, 0.0619
};

const double pll_aa_freqs_cprev[20] =
 {
   0.0755, 0.0621, 0.0410, 0.0371, 0.0091,
   0.0382, 0.0495, 0.0838, 0.0246, 0.0806,
   0.1011, 0.0504, 0.0220, 0.0506, 0.0431,
   0.0622, 0.0543, 0.0181, 0.0307, 0.0660
 };

const double pll_aa_freqs_vt[20] =
{
  0.0770764620135024, 0.0500819370772208, 0.0462377395993731, 0.0537929860758246, 0.0144533387583345,
  0.0408923608974345, 0.0633579339160905, 0.0655672355884439, 0.0218802687005936, 0.0591969699027449,
  0.0976461276528445, 0.0592079410822730, 0.0220695876653368, 0.0413508521834260, 0.0476871596856874,
  0.0707295165111524, 0.0567759161524817, 0.0127019797647213, 0.0323746050281867, 0.0669190817443274
};

const double pll_aa_freqs_blosum62[20] =
 {
   0.074, 0.052, 0.045, 0.054, 0.025,
   0.034, 0.054, 0.074, 0.026, 0.068,
   0.099, 0.058, 0.025, 0.047, 0.039,
   0.057, 0.051, 0.013, 0.032, 0.073
 };

const double pll_aa_freqs_mtmam[20] =
 {
   0.0692, 0.0184, 0.0400, 0.0186, 0.0065,
   0.0238, 0.0236, 0.0557, 0.0277, 0.0905,
   0.1675, 0.0221, 0.0561, 0.0611, 0.0536,
   0.0725, 0.0870, 0.0293, 0.0340, 0.0428
 };

const double pll_aa_freqs_mtart[20] =
{
  0.054116, 0.018227, 0.039903, 0.020160, 0.009709,
  0.018781, 0.024289, 0.068183, 0.024518, 0.092638,
  0.148658, 0.021718, 0.061453, 0.088668, 0.041826,
  0.091030, 0.049194, 0.029786, 0.039443, 0.057700
};

const double pll_aa_freqs_mtzoa[20] =
 {
   0.068880, 0.021037, 0.030390, 0.020696, 0.009966,
   0.018623, 0.024989, 0.071968, 0.026814, 0.085072,
   0.156717, 0.019276, 0.050652, 0.081712, 0.044803,
   0.080535, 0.056386, 0.027998, 0.037404, 0.066082
 };

const double pll_aa_freqs_pmb[20] =
 {
   0.076, 0.054, 0.038, 0.045, 0.028,
   0.034, 0.053, 0.078, 0.030, 0.060,
   0.096, 0.052, 0.022, 0.045, 0.042,
   0.068, 0.056, 0.016, 0.036, 0.071
 };

const double pll_aa_freqs_hivb[20] =
 {
   0.060490222, 0.066039665, 0.044127815, 0.042109048, 0.020075899,
   0.053606488, 0.071567447, 0.072308239, 0.022293943, 0.069730629,
   0.098851122, 0.056968211, 0.019768318, 0.028809447, 0.046025282,
   0.050604330, 0.053636813, 0.033011601, 0.028350243, 0.061625237
 };

const double pll_aa_freqs_hivw[20] =
 {
   0.0377494, 0.057321,  0.0891129, 0.0342034, 0.0240105,
   0.0437824, 0.0618606, 0.0838496, 0.0156076, 0.0983641,
   0.0577867, 0.0641682, 0.0158419, 0.0422741, 0.0458601,
   0.0550846, 0.0813774, 0.019597,  0.0205847, 0.0515638
 };

const double pll_aa_freqs_jttdcmut[20] =
 {
   0.076862, 0.051057, 0.042546, 0.051269, 0.020279,
   0.041061, 0.061820, 0.074714, 0.022983, 0.052569,
   0.091111, 0.059498, 0.023414, 0.040530, 0.050532,
   0.068225, 0.058518, 0.014336, 0.032303, 0.066373
 };

const double pll_aa_freqs_flu[20] =
 {
   0.0471, 0.0509, 0.0742, 0.0479, 0.0250,
   0.0333, 0.0546, 0.0764, 0.0200, 0.0671,
   0.0715, 0.0568, 0.0181, 0.0305, 0.0507,
   0.0884, 0.0743, 0.0185, 0.0315, 0.0632
 };

const double pll_aa_freqs_stmtrev[20] =
 {
   0.0461811000, 0.0534080000, 0.0361971000, 0.0233326000, 0.0234170000,
   0.0390397000, 0.0341284001, 0.0389164000, 0.0164640000, 0.0891534000,
   0.1617310001, 0.0551341000, 0.0233262000, 0.0911252000, 0.0344713001,
   0.0771077000, 0.0418603001, 0.0200784000, 0.0305429000, 0.0643851996
 };

const double pll_aa_freqs_lg4m[4][20] =
  {
   {0.082276,0.055172,0.043853,0.053484,0.018957,
    0.028152,0.046679,0.157817,0.033297,0.028284,
    0.054284,0.025275,0.023665,0.041874,0.063071,
    0.066501,0.065424,0.023837,0.038633,0.049465},
   {0.120900,0.036460,0.026510,0.040410,0.015980,
    0.021132,0.025191,0.036369,0.015884,0.111029,
    0.162852,0.024820,0.028023,0.074058,0.012065,
    0.041963,0.039072,0.012666,0.040478,0.114137},
   {0.072639,0.051691,0.038642,0.055580,0.009829,
    0.031374,0.048731,0.065283,0.023791,0.086640,
    0.120847,0.052177,0.026728,0.032589,0.039238,
    0.046748,0.053361,0.008024,0.037426,0.098662},
   {0.104843,0.078835,0.043513,0.090498,0.002924,
    0.066163,0.151640,0.038843,0.022556,0.018383,
    0.038687,0.104462,0.010166,0.009089,0.066950,
    0.053667,0.049486,0.004409,0.012924,0.031963}
  };

const double pll_aa_freqs_lg4x[4][20] =
   {
   {0.147383 , 0.017579 , 0.058208 , 0.017707 , 0.026331 ,
    0.041582 , 0.017494 , 0.027859 , 0.011849 , 0.076971 ,
    0.147823 , 0.019535 , 0.037132 , 0.029940 , 0.008059 ,
    0.088179 , 0.089653 , 0.006477 , 0.032308 , 0.097931},
   {0.063139 , 0.066357 , 0.011586 , 0.066571 , 0.010800 ,
    0.009276 , 0.053984 , 0.146986 , 0.034214 , 0.088822 ,
    0.098196 , 0.032390 , 0.021263 , 0.072697 , 0.016761 ,
    0.020711 , 0.020797 , 0.025463 , 0.045615 , 0.094372},
   {0.062457 , 0.066826 , 0.049332 , 0.065270 , 0.006513 ,
    0.041231 , 0.058965 , 0.080852 , 0.028024 , 0.037024 ,
    0.075925 , 0.064131 , 0.019620 , 0.028710 , 0.104579 ,
    0.056388 , 0.062027 , 0.008241 , 0.033124 , 0.050760},
   {0.106471 , 0.074171 , 0.044513 , 0.096390 , 0.002148 ,
    0.066733 , 0.158908 , 0.037625 , 0.020691 , 0.014608 ,
    0.028797 , 0.105352 , 0.007864 , 0.007477 , 0.083595 ,
    0.055726 , 0.047711 , 0.003975 , 0.010088 , 0.027159}
   };
