/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* yee ole' includes */
#include "includes.h"


void lt_regex_vars_sanity() 
{
	/*
	 * This function will sanity check the value of the config files.
	 * based on the compile time definition's of regex files.  This we
	 * do in case logtool.conf isn't setup properly, and/or user mutzed
	 * up the commandline.
	 */
	
	if(strncmp(yellowfile, "", 256) == 0) {
		strncpy(yellowfile, YELLOWFILE, 128);
	}
	
	
	if(strncmp(greenfile, "", 256) == 0) {
		strncpy(greenfile, GREENFILE, 128);
	}

	if(strncmp(excludefile, "", 256) == 0) {
		strncpy(excludefile, EXCLUDEFILE, 128);
	}
	
	#ifdef DEBUG
	printf("Include: %s\nExclude: %s\nGreen: %s\nYellow: %s\n", includefile, excludefile, greenfile, yellowfile);
	#endif	
}
		

/* A regex function to match paterns */
int lt_match(const char *string, char *pattern) /* This means "what you want to search", "what you want to search for" */
{
	int    status;
	regex_t    re;

        if (regcomp(&re, pattern, REG_EXTENDED|REG_NOSUB) != 0) {
		return(FALSE);      /* report error */
         } 
         status = regexec(&re, string, (size_t) 0, NULL, 0);
         regfree(&re);
         if (status != 0) {
             return(FALSE);      /* report error */
         }
         return(TRUE);
}


void lt_load_regex(char file[1024], char *dest) {
	char line[1024];
	char tmp[1024];
	char count = 1;
	FILE *fileptr;

        fileptr = fopen(file, "r");
        if( ! fileptr ) {
		perror(file);
		exit (1);
	}
	
	while(fgets(line, 200, fileptr) != NULL) {
		if(lt_match(line, "^#|^$") == 0) {
			sscanf(line, "%[^\n]", tmp);
			if(count == 1) {
				strncat(dest, tmp, sizeof(tmp));
				count = 2;
			} else {
				strncat(dest, "|", 2);
				strncat(dest, tmp, sizeof(tmp));
			}
		}
	}
	fclose(fileptr);
}


int lt_setgreen() {
	
	lt_load_regex(greenfile, greenstrings);

	if(strncmp(greenstrings, "", 32) == 0) {
		checks.green = FALSE;
	} else {
		checks.green = TRUE;
	}

	#ifdef DEBUG
	printf("Greenstrings: >%s<\n", greenstrings);
	#endif
	return TRUE;

}



int lt_setexclude() {
	
	lt_load_regex(excludefile, excludestrings);

	if(strncmp(excludestrings, "", 32) == 0) {
		checks.exclude = FALSE;
	} else {
		checks.exclude = TRUE;
	}

	#ifdef DEBUG
	printf("Excludestrings: >%s<\n", excludestrings);
	#endif
	return TRUE;

}

int lt_setyellow() {
	
	lt_load_regex(yellowfile, yellowstrings);

	if(strncmp(yellowstrings, "", 32) == 0) {
		checks.yellow = FALSE;
	} else {
		checks.yellow = TRUE;
	}

	#ifdef DEBUG
	printf("Yellowstrings: >%s<\n", yellowstrings);
	#endif
	return TRUE;

}


int lt_setinclude() {
	lt_load_regex(includefile, includestrings);

	if(strncmp(includestrings, "", 32) == 0) {
		checks.include = FALSE;
	} else {
		checks.include = TRUE;
	}

	#ifdef DEBUG
	printf("Includestrings: >%s<\n", includestrings);
	#endif
	return TRUE;

}


void lt_loadstrings() {
	/* We check this first -> if file doesn't exist, don't want to try and open it */
	if(checks.include == TRUE) {
		lt_setinclude();
	}
	lt_setexclude();
	lt_setgreen();
	lt_setyellow();
}


void lt_regexinit() {
	lt_regex_vars_sanity();
	lt_loadstrings();
	#ifdef DEBUG
	printf("Include value: %u, Exclude value: %u\n", checks.include, checks.exclude);
	#endif
}


int lt_fmtcheck(char *tmp) {

	/* Laurent Jacquot: I have got some lines not matching ^[A-Z] ... 			*/
	char format[256] = "^[A-Za-z][a-z][a-z] .[0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] .* .*: .*$";

	/* Dec 24 19:38:47 localhost NETGEAR: line 1 channel 2, call 298, C01, Call Terminated */
	/* the above is a sample line from my logfile I used to design the format checker */

	if(lt_match(tmp, format) == 1) {
		return 1;
	} else {
		return 0;
	}
		
	return 1;
}
