/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

void lt_colorset_ansi() { /* this sets up color definitions for the output module */

        /* If redbeep is set, the add a "\a" to the "red" color definition */
	if(redbeep == TRUE) {
                strncpy(color.red, "\a\033[01;31m", 31);
        } else {
                strncpy(color.red, "\033[01;31m", 31);
        }

        /* the rest will be static, just set them once */
        strncpy(color.green, "\033[32m", 127);
        strncpy(color.yellow, "\033[01;33m", 127);
        strncpy(color.white, "\033[0m", 127);
        strncpy(color.cyan, "\033[36m", 127);
        strncpy(color.brightcyan, "\033[01;36m", 127);
        strncpy(color.unknown, "\033[01;36m", 127);
	strncpy(color.end, "\033[0m", 127);
}



void lt_parse_ansi() {
	/* Set up the colors for ANSI output mode */
	lt_colorset_ansi();
	
	/* Open up stdin and read the input one line at a time till EOF */
	while(fgets(event.raw, 1024, stdin) != NULL) {
		/* Make sure the format of the input is correct */
		if(lt_fmtcheck(event.raw) != 1) {
			continue;
		}
	
		/* If we can parse up the line properly, then print it */	
		if (lt_do_parse() == TRUE) {

			/* Figure out what color (red/green/yellow) this message should be */
			lt_set_event_color();
			
			/* Always set the color to default white before we start */
			printf("%s", color.white);
			
			/* Do the timefmt stuff as a switch statement to give us more flex later */			
			switch(timefmt) {
				case DATE_SHORT:
					printf("%s", event.time);
					break;

				case DATE_LONG:
					printf("%s %s %s", event.month, event.day, event.time);
					break;

				default:
					printf("%s %s %s", event.month, event.day, event.time);
					
			}
			printf("%s", color.end); /* the "end of color" color (white usually) */
			
			/* if we're supposed to print the source hostname of the event */
			if(showsrc == TRUE) {
				printf(" %s%s%s ", color.brightcyan, event.source, color.end);
			}

			/* If user didn't ask us not to display the program, then display it */
			if(showprog == TRUE) {
				printf(" %s%-16s%s ", color.cyan, event.program, color.end);
			}

			printf("%s", event.pcolor);
			/* Always print the message from the log event */
			printf(" %s%s\n", event.message, color.end);
			fflush(stdout);
		}
	}
}
