#ifndef _FTFMT_OPTIONS_H
#define _FTFMT_OPTIONS_H

/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $RCSfile: ftfmt-options.h,v $
 * $Revision: 1.5 $
 * $Date: 1999/03/17 11:25:42 $
 *
 *      This program contains the options parsing function
 *      declarations for theuser level floppy tape formatting stuff
 *      for the QIC-40/80/3010/3020 floppy-tape driver "ftape" for
 *      Linux.
 */

#include <linux/ftape-vendors.h>

#define FTAPE_DEF_LABEL "Ftape - The Linux Floppy Tape Project!"
#define FTAPE_DEF_TAPE "/dev/rawft0"

#define UNSET(opt) ((opt) == (typeof(opt))-1)

/*  settings that affect the tape format itself
 */
typedef struct ftfmtparms_virtual format_parms;

/*  general tape drive information
 */
typedef struct ftfmt_tpparms {
    format_parms fmt_parms;      /* format parameters passed to ioctl calls */
    int frst_header_segment;     /* first header segment */
    int scnd_header_segment;     /* second header segment */
    int frst_data_segment;       /* first data segment found in hseg */
    int last_data_segment;       /* last data segment found in hseg */
    u_int8_t drive_status;       /* result of last drive status query */
    u_int8_t drive_config;       /* result of last drive config query */
    u_int8_t tape_status;        /* result of last tape status query  */
    const vendor_struct *vendor; /* vendor struct for this drive */
} ftfmt_tpparms_t;


/*  parameters that affect the behavior of the program
 */
struct opt_parms {
    u_int8_t *label;
    char *tape_dev;
    unsigned long dma_size;
    enum op_mode { AUTO = 0, FORCE,	PROBING	} mode;
    int erase;        /* erase using phys. forward/reverse */
    int read_hseg;    /* read old header segment */
    int write_hseg;   /* write new header segment */
    int print_hseg;   /* print header segment */
    int write_bursts; /* write reference bursts  */
    int do_format;    /* really format the cartridge */
    int verbose;      /* unused yet */
    int debug;        /* unused yet */
    int notty;        /* produce output without bs, newline separated */
    int keepbsm;      /* don't initiailze the bsm to zero, only useful with
		       * --verify-only
		       */
    int zero_tape;    /* erase cartridge before verifying. This seems
		       * to help a little bit with some strange Ditto Max
		       * behaviour.
		       */
};

extern void parse_options(int argc, char *argv[],
			  struct opt_parms *optp,
			  format_parms *fmt_parms);
extern int autodetect(const int tape_fd,
		      struct opt_parms *opts,
		      ftfmt_tpparms_t *tpparms);
extern void report_format_parms(FILE *channel, const format_parms *fmt_opts);

#endif

/*
 * Local variables:
 *  version-control: t
 *  kept-new-versions: 5
 *  c-basic-offset: 4
 * End:
 */
