dnl       Copyright (C) 1998 Claus-Justus Heine

dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.

dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 
dnl $RCSfile: acinclude.m4,v $
dnl $Revision: 1.5 $
dnl $Date: 1999/02/25 19:22:46 $

dnl set prefix to its proper value, so that one can define substitutions
dnl depending on the value of prefix

AC_DEFUN(AC_SET_PREFIX,
[test "x$prefix" = xNONE && prefix=$ac_default_prefix
# Let make expand exec_prefix.
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'
])

define([AC_FIND_PROGRAM],dnl
[if test x$3 = x; then _PATH=$PATH; else _PATH=$3; fi
if test -z "[$]$1"; then
  # Extract the first word of `$2', so it can be a program name with args.
  set dummy $2; word=[$]2
  echo checking for $word
  IFS="${IFS= 	}"; saveifs="$IFS"; IFS="${IFS}:"
  for dir in $_PATH; do
    test -z "$dir" && dir=.
    if test -f $dir/$word; then
      $1=$dir/$word
      break
    fi
  done
  IFS="$saveifs"
fi
test -n "[$]$1" && test -n "$verbose" && echo "	setting $1 to [$]$1"
AC_SUBST($1)dnl
])dnl

dnl
dnl

define([AC_ECHON],dnl
[echo checking for echo -n
if test "`echo -n foo`" = foo ; then
  ECHON=bsd
  test -n "$verbose" && echo '	using echo -n'
elif test "`echo 'foo\c'`" = foo ; then
  ECHON=sysv
  test -n "$verbose" && echo '	using echo ...\\c'
else
  ECHON=none
  test -n "$verbose" && echo '	using plain echo'
fi])dnl

dnl
dnl

define([AC_LISPDIR],dnl
[AC_MSG_CHECKING(for Emacs Lisp files)
if test -n "$with_lispdir"; then
  LISPDIR=${with_lispdir}
else
  if test "x$prefix" != xNONE; then
    GNATS_PREFIX=$prefix
  else
    GNATS_PREFIX=$ac_default_prefix
  fi
  for f in $GNATS_PREFIX/share/emacs/site-lisp \
	   $GNATS_PREFIX/lib/emacs/site-lisp \
	   $GNATS_PREFIX/lib/emacs/lisp; do
    if test -d $f; then
      if test -n "$prefix"; then
	LISPDIR=`echo $f | sed "s,^$prefix,"'$(prefix),'`
      else
	LISPDIR=$f
      fi
      break
    fi
  done
fi
if test -z "$LISPDIR"; then
dnl # Change this default when Emacs 19 has been around for a while
  LISPDIR='$(prefix)/share/emacs/lisp'
fi
AC_MSG_RESULT(${LISPDIR})
AC_SUBST(LISPDIR)dnl
])dnl

dnl
dnl

define([AC_PASSWD],dnl
[echo checking how to access passwd database
PASSWD="cat /etc/passwd"
if test -f /bin/domainname && test -n "`/bin/domainname`"; then
  if test -f /usr/bin/niscat && 
     /usr/bin/niscat passwd.org_dir > /dev/null 2>&1; then
    PASSWD="/usr/bin/niscat passwd.org_dir"
  elif test -f /usr/bin/ypcat && /usr/bin/ypcat passwd > /dev/null 2>&1; then
    PASSWD="/usr/bin/ypcat passwd"
  fi
fi
test -n "$verbose" && echo "	setting PASSWD to ${PASSWD}"
AC_SUBST(PASSWD)dnl
])dnl

AC_DEFUN(AC_FUNC_STRPTIME,
[AC_MSG_CHECKING(for working strptime())
AC_TRY_RUN(#include <time.h>
void main() {
	struct tm tm;
	char buf[1024];

	strptime("00:00:00 01/01/80", "%T %D", &tm);
	strftime(buf, 1024, "%T %D", &tm);

	if (strcmp(buf, "00:00:00 01/01/80") == 0) {
		exit(0);
	} else {
		exit(1);
	}
},
[AC_DEFINE(HAVE_STRPTIME)
AC_MSG_RESULT(yes)],
[test "z${ac_objext}" = "z" && ac_objext=o
LIBOBJS="$LIBOBJS strptime.${ac_objext}"
AC_MSG_RESULT(using own version)])
])


