/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "seg7_sa5211cgkwa.h"

#ifdef HAVE_GTK
#include "seg7_sa5211cgkwa_gui_gtk.h"
#endif

#define COMP_(x)	seg7_sa5211cgkwa_ ## x

void *
COMP_(gui_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_e,
	struct sig_std_logic *port_d,
	struct sig_std_logic *port_anode0,
	struct sig_std_logic *port_c,
	struct sig_std_logic *port_dp,
	struct sig_std_logic *port_b,
	struct sig_std_logic *port_a,
	struct sig_std_logic *port_anode1,
	struct sig_std_logic *port_f,
	struct sig_std_logic *port_g,
	struct sig_opt_rgb *port_opt_a,
	struct sig_opt_rgb *port_opt_b,
	struct sig_opt_rgb *port_opt_c,
	struct sig_opt_rgb *port_opt_d,
	struct sig_opt_rgb *port_opt_e,
	struct sig_opt_rgb *port_opt_f,
	struct sig_opt_rgb *port_opt_g,
	struct sig_opt_rgb *port_opt_dp
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return COMP_(gui_gtk_create)(page, name,
				port_manage,
				port_e,
				port_d,
				port_anode0,
				port_c,
				port_dp,
				port_b,
				port_a,
				port_anode1,
				port_f,
				port_g,
				port_opt_a,
				port_opt_b,
				port_opt_c,
				port_opt_d,
				port_opt_e,
				port_opt_f,
				port_opt_g,
				port_opt_dp);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
COMP_(gui_destroy)(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_destroy)(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_suspend)(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_suspend)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
COMP_(gui_resume)(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		COMP_(gui_gtk_resume)(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
