## Contributing to Toolkit

We love contributors! Yes we do! If you would like to contribute to Toolkit, please follow the following guidelines:

* Where possible, we would prefer to stay away from Ruby functionality. If something can be done entirely within Sass, it should be.
* With limited exception, such as where Toolkit expands upon the functionality in a way that is not contribute-able back upstream, additions should non mimic functionality provided by Compass, other [Team Sass](https://github.com/Team-Sass) extensions, or any included Compass extension. Currently included Compass extensions are [Breakpoint](https://github.com/Team-Sass/breakpoint), [Singularity](https://github.com/Team-Sass/Singularity), [Color Schemer](https://github.com/Team-Sass/color-schemer), and [Sassy Strings](https://github.com/Snugug/Sassy-Strings).
* With limited exception, Toolkit is primarily a place for functionality, not components or UI elements. UI elements belong in [UI Kit](https://github.com/Team-Sass/uikit).
* All functions and mixins that have defaulted arguments *must* provide globally configurable namespaced default variables for their defaults instead of only having them inside the mixin definition. This provides users with a great deal more flexibility and makes the tools in Toolkit more useful.
* When writing mixins that have no required input arguments, such as the [Clearfix](https://github.com/Team-Sass/toolkit/blob/master/compass/stylesheets/toolkit/_clearfix.scss) mixin, also include sensible namespaced silent selectors to extend from, where applicable. When doing so, be sure to include an option in the mixin for using the extended version instead of writing the output of the mixin. This argument should be called `$extend` and, where appropriate, be defaulted to `true`.
* When writing mixins that have static properties that do not change based on user input, have those styles be included via an `@extend` with a silent selector. Be sure to provide separate mixins for the pieces that do change, so a user can easily override only the pieces that change. A good example can be found in use with [Intrinsic Ratios](https://github.com/Team-Sass/toolkit/blob/master/compass/stylesheets/toolkit/_intrinsic-ratio.scss). The option to extend should be up to the user, and should use the `$extend` argument, where appropriate, defaulted to `true`.
* In any mixin that you have written includes an extend, be sure to provide a non-extend fallback within the same mixin.
* All new features require documentation the README file in order for them to be considered for inclusion. Documentation should follow the existing documentation standard as used in the README file. 
* Each individual feature you would like to add, or bug you would like to squash, should be an individual pull request. Each pull request should be from an individual feature branch to either the latest stable or development branch. **The current *stable* branch is 1.x.x. The current *development* branch is 2.x.x**. Contributions that are not in the form of a pull request will not be considered. If your pull request does not apply cleanly we will ask you to fix that before we will look into pulling it in. We may ask you to update or make changes to the code you've submitted, please don't take this the wrong way. If a pull request smells (such as if a large amount of code is all within a single commit, or the coding standards aren't in line with core Toolkit) we may ask you to rewrite your commit.
