/*
 * ExportPictureDlg.java
 *
 * Created on 9 mars 2008, 20:45
 */

package rene.dialogs;

import eric.ImageFilter;
import eric.JGlobals;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileSystemView;

/**
 *
 * @author  thecat
 */
public class ExportPictureDlg extends javax.swing.JDialog {
    
    /** Creates new form ExportPictureDlg */
    public ExportPictureDlg(java.awt.Frame parent) {
        super(parent, true);
        initComponents();
        TitledBorder tb=(TitledBorder)jPanelOption.getBorder();
        tb.setTitle(JGlobals.Loc("pngdialog.options"));
        jLabel2.setText(JGlobals.Loc("pngdialog.scale"));
        jLabel3.setText(JGlobals.Loc("pngdialog.originsize"));
        jLabel4.setText(JGlobals.Loc("pngdialog.scaledsize"));
        setPercentScale(100);
        pictureHeight = 0;
        pictureScaledWidth = 0;
   
        FileSystemView vueSysteme = FileSystemView.getFileSystemView();
        File def = vueSysteme.getHomeDirectory();
        File desk = vueSysteme.getChild(def, "Desktop");
        File choice = (desk == null) ? def : desk;
        jFileChooser1.setCurrentDirectory(choice);
        jFileChooser1.setAcceptAllFileFilterUsed(false);
        jFileChooser1.addChoosableFileFilter(new ImageFilter());
        

        
        jFileChooser1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                if (evt.getActionCommand().equals(JFileChooser.CANCEL_SELECTION)){
                    cancel();
                }else if (evt.getActionCommand().equals(JFileChooser.APPROVE_SELECTION)){
                    ok();
                }
            }
        });        
      

        
        setLocationRelativeTo(parent);
    }
    
    public boolean select() {
        this.setVisible(true);
        return finalResult;
    }
    private boolean finalResult = false;
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jFileChooser1 = new javax.swing.JFileChooser();
        jPanelOption = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jSliderScale = new javax.swing.JSlider();
        jSpinnerScale = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jTextFieldOriginalWidth = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldOriginalHeight = new javax.swing.JTextField();
        jTextFieldScaledWidth = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jTextFieldScaledHeight = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        jFileChooser1.setDialogType(javax.swing.JFileChooser.SAVE_DIALOG);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 0.5;
        getContentPane().add(jFileChooser1, gridBagConstraints);

        jPanelOption.setBorder(javax.swing.BorderFactory.createTitledBorder("Export options"));
        jPanelOption.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Scale:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 0);
        jPanelOption.add(jLabel2, gridBagConstraints);

        jSliderScale.setMaximum(300);
        jSliderScale.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSliderScaleStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOption.add(jSliderScale, gridBagConstraints);

        jSpinnerScale.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerScaleStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 18;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 0);
        jPanelOption.add(jSpinnerScale, gridBagConstraints);

        jLabel3.setText("Originale size:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 0);
        jPanelOption.add(jLabel3, gridBagConstraints);

        jLabel4.setText("Scaled size:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 0);
        jPanelOption.add(jLabel4, gridBagConstraints);

        jTextFieldOriginalWidth.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jTextFieldOriginalWidth, gridBagConstraints);

        jLabel5.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jLabel5, gridBagConstraints);

        jTextFieldOriginalHeight.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jTextFieldOriginalHeight, gridBagConstraints);

        jTextFieldScaledWidth.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jTextFieldScaledWidth, gridBagConstraints);

        jLabel6.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jLabel6, gridBagConstraints);

        jTextFieldScaledHeight.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        jPanelOption.add(jTextFieldScaledHeight, gridBagConstraints);

        jLabel7.setText("%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 4, 5, 0);
        jPanelOption.add(jLabel7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jPanelOption, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jSpinnerScaleStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSpinnerScaleStateChanged
        int value = ((Integer)jSpinnerScale.getValue()).intValue();
        setPercentScale(value);
    }//GEN-LAST:event_jSpinnerScaleStateChanged

    private void jSliderScaleStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jSliderScaleStateChanged
        int value = jSliderScale.getValue();
        setPercentScale(value);
    }//GEN-LAST:event_jSliderScaleStateChanged
    
    
  
    public void ok() {
        finalResult = true;
        setVisible(false);   
    }
    
    public void cancel() {
          setVisible(false);      
    }
    
    
    private String fileName;
    
    private int pictureHeight;
    private int pictureWidth;

    private int pictureScaledHeight;
    private int pictureScaledWidth;

    
    private int percentScale;
    public int getPercentScale() {
        return percentScale;
    }
    public void setPercentScale(int percentScale) {
        int oldValue = this.percentScale;
        this.percentScale = percentScale;
        
        jSpinnerScale.setValue(new Integer(percentScale));
        jSliderScale.setValue(percentScale);
        
        double scale = (double)percentScale / 100.0;
        setPictureScaledWidth((int)(pictureWidth * scale));
        setPictureScaledHeight((int)(pictureHeight * scale));
        
        
        
        firePropertyChange("percentScale", oldValue, percentScale);
    }
    


    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JFileChooser jFileChooser1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanelOption;
    private javax.swing.JSlider jSliderScale;
    private javax.swing.JSpinner jSpinnerScale;
    private javax.swing.JTextField jTextFieldOriginalHeight;
    private javax.swing.JTextField jTextFieldOriginalWidth;
    private javax.swing.JTextField jTextFieldScaledHeight;
    private javax.swing.JTextField jTextFieldScaledWidth;
    // End of variables declaration//GEN-END:variables

    public int getPictureHeight() {
        return pictureHeight;
    }

    public void setPictureHeight(int pictureHeight) {
        int oldValue = this.pictureHeight;
        this.pictureHeight = pictureHeight;
        jTextFieldOriginalHeight.setText(new Integer(getPictureHeight()).toString());
        firePropertyChange("pictureHeight", oldValue, pictureHeight);
    }

    public int getPictureWidth() {
        return pictureWidth;
    }

    public int getPictureScaledHeight() {
        return pictureScaledHeight;
    }

    public int getPictureScaledWidth() {
        return pictureScaledWidth;
    }

    public void setPictureScaledWidth(int pictureScaledWidth) {
        int oldValue = this.pictureScaledWidth;
        this.pictureScaledWidth = pictureScaledWidth;
        jTextFieldScaledWidth.setText(new Integer(getPictureScaledWidth()).toString());
        firePropertyChange("pictureScaledWidth", oldValue, pictureScaledWidth);
    }

    public void setPictureWidth(int pictureWidth) {
        int oldValue = this.pictureWidth;
        this.pictureWidth = pictureWidth;
        jTextFieldOriginalWidth.setText(new Integer(getPictureWidth()).toString());
        firePropertyChange("pictureWidth", oldValue, pictureWidth);
    }

    public void setPictureScaledHeight(int pictureScaledHeight) {
        int oldValue = this.pictureScaledHeight;
        this.pictureScaledHeight = pictureScaledHeight;
        jTextFieldScaledHeight.setText(new Integer(getPictureScaledHeight()).toString());
        firePropertyChange("pictureScaledHeight", oldValue, pictureScaledHeight);
    }

    public String getFileName() {
        String result = "";
        try {
            File outputfile = jFileChooser1.getSelectedFile();
   
            String strFilename = outputfile.getAbsolutePath();
            String ext = (outputfile.getAbsolutePath().endsWith(".png")) ? "" : ".png";
            result = strFilename + ext;
        } catch (Exception e) {
                //            warning(e.toString());
        }        
        
        return result;
    }

    
}
