#include "beef.h"

void code_dump (struct instruction *code, long indent)
{
  long i;

  while (code->type != ']') {
    switch (code->type) {
      case '[':
          code_dump (code->loop, indent + 1);
        break;
      default:
          for (i = 0; i < indent; i++)
            printf ("\t");
          printf ("%c (%ld)\n", code->type, code->quantity);
        break;
    }
    if (code->type != ']')
      code = code->next;
  }
}

