//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _spin2root_5.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/spin2rootlist.h>

using namespace std;
using namespace bagel;

void Spin2RootList::spin2root5(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[5] = {8.176317629750606e-01,2.472333925728521e+00,5.116006122967180e+00,9.044146511367595e+00,1.504988167696164e+01
    };
  constexpr double aw[5] = {1.980155433947152e-01,3.473439742008963e-01,1.116138000341106e-01,7.631466765335309e-03,6.540969451109020e-05
    };
  constexpr double x[1920] = {  2.318489066085380e-01, -7.956139295629345e-03,  1.781679569032828e-04, -2.729509001451717e-06,  1.620284387840667e-08,
  6.055094346081009e-10, -2.530906011018285e-11,  4.940866718769280e-13, -3.007620128849770e-15, -1.590013036545961e-16,  6.645813036702878e-18, -1.296681788792768e-19,
  6.383091318994880e-01, -1.713324488949626e-02,  1.868258066042386e-04,  2.027636229899657e-06, -9.918014265040615e-08,  5.317646032726502e-10,  4.234701747216910e-11,
 -9.521165512027909e-13, -9.850671353436585e-15,  7.457239172233309e-16, -6.229744112533893e-18, -3.872559306115114e-19,  1.135675815056198e+00, -1.973398304552693e-02,
 -7.546942131488202e-05,  5.038509529851748e-06,  5.043871037222568e-08, -2.220734021710461e-09, -3.771232934647998e-11,  1.143076802609168e-12,  2.868446966900673e-14,
 -6.160204152862372e-16, -2.257096671563616e-17,  3.160645783465887e-19,  1.604612999154918e+00, -1.300359403264736e-02, -2.399783957459274e-04, -1.536909568264283e-06,
  5.770484733323381e-08,  2.044097427810269e-09,  1.867552328305331e-11, -6.920264283687380e-13, -2.869925188729513e-14, -3.054928498880404e-16,  1.043810326535668e-17,
  4.710314361829003e-19,  1.919759309959731e+00, -3.199934511301994e-03, -9.194438268930699e-05, -2.197375978944182e-06, -4.473960393265786e-08, -7.391681718787388e-10,
 -7.993014548339564e-12,  3.876955897328251e-14,  5.292495346655451e-15,  1.842449284018177e-16,  4.407822312650362e-18,  7.352847999948376e-20,  2.026747865968344e-01,
 -6.656676571138329e-03,  1.472743183448516e-04, -2.401928794108149e-06,  2.328662413326932e-08,  1.495117930897630e-10, -1.337775356678275e-11,  3.471824628425848e-13,
 -5.196334829857576e-15,  7.527622999796802e-18,  2.155162016174062e-18, -6.756879754347471e-20,  5.728828412561358e-01, -1.556716841683672e-02,  2.021403258484922e-04,
  5.716471941803646e-07, -8.062821474349885e-08,  1.214994122942436e-09,  1.482015274782824e-11, -9.099655204207593e-13,  9.806649774588935e-15,  3.084398104277032e-16,
 -1.212474203620911e-17,  8.334507519526553e-20,  1.055929888137068e+00, -2.008580511912429e-02, -1.175662916993582e-05,  5.453466198339617e-06, -5.114398223526634e-12,
 -2.663830840308573e-09,  2.791364989527080e-12,  1.572164843393356e-12, -4.471170166020548e-15, -1.041775899781310e-15,  4.546947120122270e-18,  7.475779407333600e-19,
  1.548668568598784e+00, -1.497827252569314e-02, -2.514763621884303e-04, -2.707721984161897e-07,  1.009338451689963e-07,  2.149790430916504e-09, -1.438880111611873e-11,
 -1.662737549764513e-12, -2.687015356718691e-14,  5.496232674298943e-16,  3.128425940505621e-17,  3.133230073343528e-19,  1.905302718877271e+00, -4.054320500747555e-03,
 -1.231274747853411e-04, -3.041094346590243e-06, -6.122350240509365e-08, -8.913311488069911e-10, -3.259336703089921e-12,  3.547131634747757e-13,  1.588463001873445e-14,
  4.241545756257250e-16,  7.307322057212163e-18,  3.075724420721953e-20,  1.782310401396519e-01, -5.587311660639574e-03,  1.207370928813366e-04, -2.019890343054111e-06,
  2.375932538836082e-08, -7.296907428024302e-11, -5.853498691559914e-12,  1.971447448298617e-13, -3.928809638965921e-15,  5.130180531713935e-17,  3.654174733393653e-19,
 -2.216155183429716e-20,  5.138634408301568e-01, -1.394260532801753e-02,  2.021023699023166e-04, -5.126040924632666e-07, -5.461986869311389e-08,  1.307561871963358e-09,
 -5.201160430662902e-12, -5.008466669208240e-13,  1.364672946978267e-14, -4.552991167306941e-17, -4.920570885943043e-18,  1.767800821786615e-19,  9.758078020094968e-01,
 -1.992204688633898e-02,  5.197741062984347e-05,  5.045068014413845e-06, -4.926733032417176e-08, -2.116667369912998e-09,  3.976472699177540e-11,  9.221524196874295e-13,
 -3.182373514281437e-14, -3.317055102549129e-16,  2.606685836793798e-17,  9.829530519700796e-20,  1.484754088226073e+00, -1.697256530688530e-02, -2.437246665784418e-04,
  1.652117760001946e-06,  1.363134348199780e-07,  1.175906007233237e-09, -6.821108108920060e-11, -1.954349207821555e-12,  1.610283944512517e-14,  1.768293655893077e-15,
  2.012469914860968e-17, -9.665612546808650e-19,  1.886858969509576e+00, -5.203326405355702e-03, -1.660879601876698e-04, -4.162922699842551e-06, -7.866378644307511e-08,
 -7.768081041385663e-10,  1.648361728445211e-11,  1.162478432104764e-12,  3.610541897792549e-14,  6.664047506451735e-16,  1.909843672768522e-18, -3.763823679737714e-19,
  1.576690004165508e-01, -4.712059263575507e-03,  9.871098112551839e-05, -1.657405422224088e-06,  2.127627782086761e-08, -1.596540998242691e-10, -1.805621997069254e-12,
  1.021220807725681e-13, -2.020627710427705e-15,  4.964839627447145e-17, -4.151812359979271e-19, -1.683331624130399e-20,  4.612692656534135e-01, -1.236332470659446e-02,
  1.915376796792315e-04, -1.188004649072675e-06, -3.060806608095051e-08,  1.061262979643222e-09, -1.355035404501287e-11, -1.152581695987542e-13,  1.000782512958859e-14,
 -1.247867046545279e-16, -1.414076195532439e-19,  3.153620718216510e-20,  8.973119849292013e-01, -1.928031059680489e-02,  1.065783658129903e-04,  3.976614758296385e-06,
 -8.058122194849150e-08, -9.714668192324889e-10,  5.093931575559559e-11, -9.312170478618622e-14, -2.628210179916017e-14,  5.490610823406314e-16,  1.287433536274098e-17,
 -5.847689071784289e-19,  1.413143661834128e+00, -1.880485962325169e-02, -2.103717865439274e-04,  3.915560993438069e-06,  1.395911996416973e-07, -9.977406754879141e-10,
 -1.056443276798668e-10, -3.725079802959528e-13,  8.045591073109209e-14,  1.357727891921809e-15, -4.615185719457610e-17, -1.665398946702183e-18,  1.863040366182011e+00,
 -6.754222562016273e-03, -2.240013152652454e-04, -5.510641462788522e-06, -8.684007744794025e-08,  1.615494884370121e-10,  6.865341647564347e-11,  2.667619627360052e-12,
  5.489637703581814e-14,  1.136989542351403e-16, -3.868427022373024e-17, -1.623559130182282e-18,  1.402820124532492e-01, -3.996393336664931e-03,  8.075402337794347e-05,
 -1.344023675427253e-06,  1.785017308797993e-08, -1.744815552853759e-10,  3.860265446590268e-13,  6.141379855451114e-14, -7.083150777281770e-16,  1.870138809718406e-17,
 -1.091153852423519e-18, -1.088631762099654e-20,  4.147805063007171e-01, -1.089487755359781e-02,  1.749848993403111e-04, -1.526100771343354e-06, -1.272693332546012e-08,
  7.293517046082903e-10, -1.297237924549367e-11,  1.325739274093292e-13,  5.430971882955188e-15, -1.354260773758653e-16, -9.260576854211468e-19, -4.112103998345051e-20,
  8.221658601435694e-01, -1.825977977984001e-02,  1.461299684876917e-04,  2.595967649834098e-06, -8.840118550657338e-08,  1.452807953200366e-10,  3.993616735017647e-11,
 -5.705021759841188e-13, -3.623944623786439e-15,  5.429363587047584e-16, -1.177183180467542e-17, -4.021093292165050e-19,  1.334906339153599e+00, -2.026432455937784e-02,
 -1.510851785685774e-04,  5.853737019504694e-06,  9.507539478690211e-08, -3.338169646178188e-09, -7.594367183709200e-11,  2.507928306833529e-12,  8.227718298124565e-14,
 -1.489259094527844e-15, -7.955726899591790e-17,  5.521616304405693e-19,  1.831988526680814e+00, -8.833396839454702e-03, -2.979912222877825e-04, -6.755830963572856e-06,
 -6.009171761794975e-08,  2.893178760628245e-09,  1.654790238037984e-10,  4.023692156627166e-12,  9.805612252269596e-15, -3.292278785477798e-15, -1.385460591271155e-16,
 -2.436210261627180e-18,  1.254928699443195e-01, -3.410278246811481e-03,  6.622732635180550e-05, -1.085291129613456e-06,  1.458072436963523e-08, -1.468390812777997e-10,
  1.825736256693560e-12,  4.051762247898643e-14, -8.797115180971576e-16, -2.801117564215693e-17, -1.043365755860636e-18,  1.669335491405330e-20,  3.738812159566933e-01,
 -9.570706718201781e-03,  1.558806481425592e-04, -1.628396831036990e-06, -8.714017101572838e-10,  4.773593023873000e-10, -7.628915202206239e-12,  2.182750581121174e-13,
 -4.440698999626068e-16, -1.954684223064116e-16, -1.521891918804777e-18,  3.380761927375782e-20,  7.516288521393966e-01, -1.698964677270886e-02,  1.690446644317220e-04,
  1.251397241161344e-06, -7.720993586889254e-08,  9.130933710207554e-10,  2.447761437219628e-11, -4.891835286894423e-13,  4.721478255674538e-15, -1.111010668110702e-16,
 -1.657482972612873e-17,  1.864462547657933e-19,  1.251905737966320e+00, -2.117174606670863e-02, -7.416074371391029e-05,  6.770199312881694e-06,  1.702742882347305e-08,
 -4.090029803106676e-09,  1.922008702521743e-11,  3.765389584062336e-12, -1.548934811937693e-14, -3.422532192898781e-15, -3.281350076893417e-18,  2.387879804817616e-18,
  1.791358353147959e+00, -1.155196524095819e-02, -3.821192035905557e-04, -7.001474977816008e-06,  4.617773281346075e-08,  8.100097401043532e-09,  2.561465046976235e-10,
  1.221351979001464e-12, -2.241610633947069e-13, -9.669948396446457e-15, -1.218397451272036e-16,  5.770484179808853e-18,  1.128342382708997e-01, -2.928793747514663e-03,
  5.451526557220849e-05, -8.727989243496097e-07,  1.215272451764205e-08, -9.375912966614650e-11,  2.369056868029734e-12, -9.636731480137680e-15, -2.346587083806235e-15,
 -4.205254467488684e-17,  6.970019145920360e-19,  6.490147694742814e-20,  3.379692739784469e-01, -8.401390748746089e-03,  1.365444840065274e-04, -1.573947306139881e-06,
  7.302837931525911e-09,  3.591960331399824e-10, -2.828561855920061e-12,  8.518627449803089e-14, -7.823450292389560e-15, -1.821498168189551e-16,  3.414150543130013e-18,
  1.999894991551263e-19,  6.864425012750105e-01, -1.559665037985940e-02,  1.773431414360456e-04,  1.896142113415337e-07, -5.412523137164297e-08,  1.345563490764179e-09,
  1.152100663316023e-11, -5.047159541369523e-13, -7.835255426536322e-15, -4.584476428301822e-16,  2.688871534267736e-18,  6.640601084085759e-19,  1.166545470478074e+00,
 -2.144131611184757e-02,  6.190441667761160e-06,  6.446707772373008e-06, -5.238033718924736e-08, -2.529402972829333e-09,  1.001543801316200e-10,  1.468477127552035e-12,
 -1.174853163734824e-13, -1.676527603829237e-15,  8.157906270589094e-17,  1.247689086346346e-18,  1.738541153725515e+00, -1.491796356697291e-02, -4.552885505899615e-04,
 -4.639868911041114e-06,  2.668053504459552e-07,  1.351044571491976e-08,  1.353697392368832e-10, -1.163477592494732e-11, -5.480346755865350e-13, -3.854485946685546e-15,
  5.475077842085576e-16,  2.299125540664056e-17,  1.019294774919157e-01, -2.531384002139075e-03,  4.515581470459103e-05, -6.905267770287132e-07,  1.077565847589742e-08,
 -4.967904856859555e-11,  8.947180519609649e-13, -9.727840204267552e-14, -2.571702684791003e-15,  5.214147403530259e-17,  3.994104702116708e-18,  5.691454643057291e-20,
  3.064322988436320e-01, -7.382074233028412e-03,  1.185841573033958e-04, -1.403081590890452e-06,  1.383414395316083e-08,  2.870032754938598e-10, -4.633420849875156e-12,
 -2.239755345947705e-13, -9.443462046061122e-15,  1.644349179592310e-16,  1.394974699711363e-17,  1.861587389008829e-19,  6.268898037930171e-01, -1.418140951531616e-02,
  1.753444816827610e-04, -4.515666441878372e-07, -2.579718062125583e-08,  1.411162710960556e-09, -8.096469560905812e-12, -9.364217222492888e-13, -1.464441248713541e-14,
  2.987235063718907e-16,  3.475882154395814e-17,  5.623003696058328e-19,  1.081345134395721e+00, -2.109955763003461e-02,  7.729479038939400e-05,  5.340381392764001e-06,
 -7.794358919227832e-08, -8.808344870557920e-11,  8.457873093782517e-11, -2.539201495323710e-12, -1.087946562178823e-13,  2.371342142920670e-15,  1.132647844820227e-16,
  8.499762815852802e-20,  1.671362182459410e+00, -1.868942670533476e-02, -4.762533102330690e-04,  1.821013237939780e-06,  5.330324096062067e-07,  1.093807978208224e-08,
 -4.158827227389241e-10, -2.536316312228369e-11, -8.370697629931792e-14,  3.303754713491310e-14,  9.837512792841768e-16, -2.026614158273793e-17,  9.247799604395558e-02,
 -2.200424887878469e-03,  3.787208606252644e-05, -5.259579311565424e-07,  9.739729519471502e-09, -6.728820446595336e-11, -2.466088881535215e-12, -1.170471240749353e-13,
  2.263391046317284e-15,  2.001467139972294e-16,  1.341943186205063e-18, -2.173607435723376e-19,  2.787005367936188e-01, -6.496601729080237e-03,  1.032380346895990e-04,
 -1.144493521421560e-06,  1.781572184842872e-08,  7.593105946644456e-11, -1.343532990129909e-11, -3.184532777682564e-13,  6.765446002318933e-15,  6.803394989617219e-16,
  4.870518613974909e-18, -7.414214367466952e-19,  5.729281361228434e-01, -1.280531669838068e-02,  1.683201491778930e-04, -6.587328912396893e-07, -1.834971749344861e-09,
  8.694993179872316e-10, -3.720011612269498e-11, -9.445475839383548e-13,  2.253375783583970e-14,  1.640033563332574e-15,  1.382693417271469e-17, -1.900989459158730e-18,
  9.985601099105259e-01, -2.024562331107345e-02,  1.341156349986332e-04,  4.159542131763587e-06, -6.675227840849251e-08,  8.044927912940607e-10, -1.644211515781344e-11,
 -3.835673283574855e-12,  4.883650498996132e-14,  5.747684321798381e-15,  1.178736867761241e-17, -5.769367217055098e-18,  1.589343562636107e+00, -2.225512246728499e-02,
 -3.984053710089674e-04,  1.132660427465044e-05,  5.983181457266524e-07, -6.571041548723656e-09, -9.487868349835514e-10, -4.787364342337298e-12,  1.356961832747577e-12,
  2.913988559269273e-14, -1.605523431416178e-15, -7.169593014235646e-17,  8.424585027093928e-02, -1.920172782719066e-03,  3.243827316391604e-05, -3.849865628639159e-07,
  7.606789964773570e-09, -1.511392776563891e-10, -3.702846932391314e-12,  5.807339549193904e-14,  7.545815860946572e-15,  9.707044233646058e-18, -1.059272820204070e-17,
 -1.639843909941256e-19,  2.542857918978281e-01, -5.720797929214301e-03,  9.120119297761858e-05, -8.671157952515673e-07,  1.560898535987404e-08, -3.069592747949658e-10,
 -1.581785759913569e-11,  2.488761595478149e-13,  2.485686680832789e-14,  3.684092921806278e-17, -3.621184990021544e-17, -5.686612801029593e-19,  5.243505243648803e-01,
 -1.148990356604171e-02,  1.606364221420040e-04, -6.043092893822453e-07,  5.135762255787771e-09, -2.056914133266445e-10, -4.507402564095932e-11,  6.237376216924880e-13,
  6.575553582494853e-14,  6.588379798480843e-18, -9.368202646753475e-17, -1.487102213545792e-18,  9.200151998959786e-01, -1.899027338080251e-02,  1.779965084711727e-04,
  3.167814536024076e-06, -6.161764917538499e-08, -5.221750197875787e-10, -7.359683351828717e-11,  5.343915569297566e-13,  1.897944949262825e-13, -1.488756582459531e-17,
 -2.861300048137355e-16, -3.384189795347723e-18,  1.495016051600385e+00, -2.475381276036167e-02, -2.132877623278986e-04,  1.866087825650831e-05,  2.557923998027822e-07,
 -2.563653038703224e-08, -4.319690042958908e-10,  3.885378090132890e-11,  8.139285876593007e-13, -5.954350952779201e-14, -1.565047948757838e-15,  8.994724464833572e-17,
  7.705749676921531e-02, -1.677333346824262e-03,  2.843593436144094e-05, -2.912708048509944e-07,  3.958303748352393e-09, -1.959313450704827e-10,  7.528440885205251e-13,
  2.218705187069873e-13,  4.752010174677438e-16, -3.424959122454044e-16, -1.779638014803341e-18,  5.029469365146483e-19,  2.328011502224092e-01, -5.029146815979499e-03,
  8.203505212690087e-05, -6.832124637225232e-07,  6.669673337276126e-09, -5.222726602199241e-10,  4.221960607155351e-13,  7.808432739663723e-13,  8.333008866804806e-16,
 -1.162915503631393e-15, -5.605952697131224e-18,  1.741527779975118e-18,  4.809162999385757e-01, -1.023307057475467e-02,  1.535775884704384e-04, -6.038707203176332e-07,
 -7.249661703802742e-09, -8.668011602859532e-10, -3.441190249586781e-12,  1.998173528763629e-12,  8.970242835583105e-16, -3.040641518502305e-15, -1.033769040802075e-17,
  4.639080497677149e-18,  8.471173990131996e-01, -1.743235048044199e-02,  2.094814934779459e-04,  2.019052366888542e-06, -8.525966423219249e-08, -1.502835053720929e-09,
  1.061864605414010e-11,  4.455944596270319e-12,  1.989435768784072e-15, -8.443344282699490e-15,  9.145232882941064e-19,  1.374435857064195e-17,  1.394051044276934e+00,
 -2.553548931031711e-02,  1.753157289696102e-05,  1.848338346506231e-05, -2.665521530818112e-07, -2.219794142537525e-08,  6.641128150038130e-10,  2.754049274957885e-11,
 -1.344419209866802e-12, -3.171889061037767e-14,  2.482071226882122e-15,  3.030734388475489e-17,  7.078214948029803e-02, -1.463031535756910e-03,  2.520008084791953e-05,
 -2.563043735728620e-07,  6.857429469223050e-10, -1.124209381580922e-10,  5.471640084849025e-12,  6.754493743255451e-14, -8.217589436522288e-15, -3.929976649389664e-17,
  1.263867414655792e-17, -4.452720042438956e-20,  2.139467619605606e-01, -4.404601284708598e-03,  7.415326013630923e-05, -6.525042534454191e-07, -2.045863979851141e-09,
 -2.833407681842768e-10,  1.690142877472773e-11,  2.371945426429120e-13, -2.816915201604818e-14, -1.056601973480176e-16,  4.320852889666055e-17, -1.981129274168609e-19,
  4.423909175394886e-01, -9.036663955220681e-03,  1.450979281948217e-04, -8.452059132127654e-07, -2.127129742032389e-08, -3.691368059948798e-10,  3.810446199862464e-11,
  5.699243803768599e-13, -7.193475430719155e-14, -1.434553079857345e-16,  1.123287509737116e-16, -7.937915337768369e-19,  7.808577544270238e-01, -1.568476974054289e-02,
  2.246869715611714e-04,  4.674675524595379e-07, -1.037263691688055e-07,  3.132462431267484e-12,  9.689999082288861e-11,  7.102555133884588e-13, -1.799099967544518e-13,
  4.458890189301133e-16,  3.015119516006478e-16, -4.170616701552905e-18,  1.293455709790858e+00, -2.460773057909874e-02,  2.023878496001926e-04,  1.170089711345461e-05,
 -5.157496193932887e-07, -2.236751271395592e-09,  7.961182012956224e-10, -1.534800726548419e-11, -8.731679616596291e-13,  4.301399142396339e-14,  4.395282332153637e-16,
 -7.681832335054918e-17,  6.531384328030838e-02, -1.273670439261863e-03,  2.213967222531766e-05, -2.560613249795621e-07, -2.437410517793357e-10,  1.371761367535169e-11,
  4.077819899256670e-12, -1.369647681915620e-13, -2.826832658785991e-15,  2.448967935925979e-16, -5.784571385808703e-19, -3.361210688811035e-19,  1.974640506228182e-01,
 -3.843535425290071e-03,  6.601307257717419e-05, -7.080446533364500e-07, -3.620146548823610e-09,  1.072758629973951e-10,  1.241132152234286e-11, -4.515982301855016e-13,
 -9.144638155096399e-15,  8.336112387281753e-16, -3.090666595686692e-18, -1.132818465071977e-18,  4.084931026131827e-01, -7.922465896906285e-03,  1.328347237275662e-04,
 -1.193959373399850e-06, -1.947988449406916e-08,  4.991302643169312e-10,  2.628702066067915e-11, -1.124923075566277e-12, -2.020493878004961e-14,  2.122118425348136e-15,
 -1.367889903791136e-17, -2.831415693954264e-18,  7.217103917079828e-01, -1.389223449075518e-02,  2.207423862738109e-04, -1.069338728330103e-06, -8.183763459939100e-08,
  2.000633072330231e-09,  5.174359090484097e-11, -3.085617048339271e-12, -2.783853104103864e-14,  5.357894218421668e-15, -7.141836151624075e-17, -6.709900400041716e-18,
  1.198957143015021e+00, -2.256481577687075e-02,  2.946774169278628e-04,  3.944606134752179e-06, -4.144925582782630e-07,  9.966881506555217e-09,  2.000867274494966e-10,
 -2.042659325261938e-11,  3.839738632328767e-13,  1.679779374262955e-14, -1.074966702118979e-15,  9.223921855853158e-18,  6.055390465091865e-02, -1.108861780672571e-03,
  1.906602545542795e-05, -2.538387179459120e-07,  6.778979947901160e-10,  6.275019761279221e-11,  1.391380637009900e-13, -1.121800069212228e-13,  3.177729302206333e-15,
  5.597558747632211e-17, -5.643657773729435e-18,  8.195168825860754e-20,  1.830912364480049e-01, -3.350156056815099e-03,  5.727977867756911e-05, -7.371818103150011e-07,
  4.171655431182237e-10,  2.452940591677854e-10, -4.223680391742829e-13, -3.584661449914772e-13,  1.077055282136183e-14,  1.712959070882571e-16, -1.895218521540061e-17,
  3.053214131873829e-19,  3.788315864425995e-01, -6.921470892292559e-03,  1.170470027188324e-04, -1.402693949031962e-06, -5.846970946408395e-09,  7.411358795155712e-10,
 -4.575189849873411e-12, -8.234412177655726e-13,  2.775655914892034e-14,  3.348457831201892e-16, -4.697881491847343e-17,  9.109585071726870e-19,  6.695650197381626e-01,
 -1.219655025990325e-02,  2.015126951345763e-04, -2.020348379324777e-06, -3.627418710965778e-08,  2.253479761151170e-09, -2.428500513982610e-11, -1.792920055088927e-12,
  7.645063471342106e-14,  2.313245116410886e-16, -1.109043449074839e-16,  3.049137749922871e-18,  1.113574415556552e+00, -2.011479989687395e-02,  3.091837217686608e-04,
 -9.966450358768222e-07, -2.048897770026090e-07,  9.589892151749823e-09, -1.598963968214169e-10, -5.279417558418263e-12,  4.081332987222654e-13, -9.079854527149226e-15,
 -1.713278969847352e-16,  1.793538178410592e-17,  5.640460432456802e-02, -9.682413098460299e-04,  1.612464600636084e-05, -2.336217957838245e-07,  1.774207155922568e-09,
  4.041968342102405e-11, -1.531673384211919e-12, -1.222432624059031e-14,  2.343858660360381e-15, -6.635997400273279e-17, -4.726025090542850e-19,  9.214625968214393e-20,
  1.705516929781045e-01, -2.926833799951641e-03,  4.862618466959285e-05, -6.944948539062171e-07,  4.617679356909295e-09,  1.549409724335713e-10, -5.556653801780451e-12,
 -2.739539951945150e-14,  7.573678716421743e-15, -2.256668600766819e-16, -1.183147075626695e-18,  3.019773382430036e-19,  3.529110028074746e-01, -6.052958221784779e-03,
  1.001062056611519e-04, -1.389630093358643e-06,  6.536168415964480e-09,  4.554704184557034e-10, -1.543279174806232e-11, -1.132107087646179e-14,  1.763107883788271e-14,
 -5.792646549508051e-16, -9.046984017348263e-19,  7.113823991749185e-19,  6.238397230809450e-01, -1.068813742353414e-02,  1.751359557750854e-04, -2.284089114792727e-06,
  2.725687240151399e-10,  1.328582547256293e-09, -4.349322621018863e-11,  2.046903663479609e-13,  3.825871544619148e-14, -1.532807997256278e-15,  9.187581704541654e-18,
  1.475959295745594e-18,  1.037925052096141e+00, -1.773183294953087e-02,  2.831261862608752e-04, -2.976789764969900e-06, -5.716547364014641e-08,  5.135967108183717e-09,
 -1.764264588555889e-10,  2.383328510925698e-12,  8.963423736295936e-14, -6.433100318206635e-15,  1.698828840666905e-16,  3.356371347970947e-20,  5.277262403268595e-02,
 -8.499269990733881e-04,  1.351170282740826e-05, -2.007567850529476e-07,  2.221751504586899e-09,  5.846545952731908e-12, -1.173599835715796e-12,  2.672194364420196e-14,
  2.739159656811194e-16, -3.826365841040796e-17,  1.158222801004816e-18, -4.382086893254367e-21,  1.595716199283805e-01, -2.569715258304642e-03,  4.081459861528659e-05,
 -6.029305451395344e-07,  6.430938231094288e-09,  3.243727289935637e-11, -4.102599782456859e-12,  9.457951671864809e-14,  7.132580462280072e-16, -1.233462403263513e-16,
  3.901558637065763e-18, -2.075381930642224e-20,  3.301985191879268e-01, -5.316468129189354e-03,  8.429548076248498e-05, -1.231500827195858e-06,  1.216669644688289e-08,
  1.266789528724384e-10, -1.077418620301820e-11,  2.547834999289205e-13,  8.863770575956527e-16, -2.845766130224213e-16,  9.790302317830074e-18, -8.056107522252020e-20,
  5.837180822153474e-01, -9.394943301565815e-03,  1.484561794978944e-04, -2.120041619706673e-06,  1.738540644588174e-08,  4.456541065550521e-10, -2.791360306814810e-11,
  6.966643155759088e-13, -1.644713186642229e-15, -5.965075836367671e-16,  2.439337460483430e-17, -3.416178139887059e-19,  9.712881173576678e-01, -1.561881821207704e-02,
  2.446322912632703e-04, -3.273516710177995e-06,  9.548469304082536e-09,  1.857456095873190e-09, -9.554229756945596e-11,  2.752701540471908e-12, -3.454996465691105e-14,
 -1.102363419898076e-15,  8.081078397472084e-17, -2.414741539615007e-18,  4.957469968088443e-02, -7.508651537873168e-04,  1.131551945015059e-05, -1.655447904266970e-07,
  2.118441458652966e-09, -1.332475624880099e-11, -4.511447478002290e-13,  2.144010804550877e-14, -3.967488817604030e-16, -3.631086121976393e-18,  4.975593229647898e-19,
 -1.625860665272081e-20,  1.499024659501554e-01, -2.270370866049391e-03,  3.420335881564293e-05, -4.992911320458792e-07,  6.309157230113258e-09, -3.477323850499733e-11,
 -1.607121848377459e-12,  7.292884640560488e-14, -1.385366747878326e-15, -9.384378029403001e-18,  1.590594505310062e-18, -5.401700708303077e-20,  3.101926057517223e-01,
 -4.697793777015204e-03,  7.073012333649315e-05, -1.028227965078591e-06,  1.267778056611286e-08, -5.009880135593613e-11, -4.303467190259513e-12,  1.842660664956195e-13,
 -3.664475177921167e-15, -1.111984885027548e-17,  3.601744615051933e-18, -1.317691486490308e-19,  5.483597947231148e-01, -8.303854328288918e-03,  1.248783343340803e-04,
 -1.800639075131860e-06,  2.108618046398195e-08, -1.008152972319951e-11, -1.122565297760511e-11,  4.545857158212350e-13, -9.803337252491671e-15,  2.579112113061249e-17,
  7.189253324457006e-18, -3.081662107010197e-19,  9.124846897459523e-01, -1.381415769168383e-02,  2.071546322989693e-04, -2.924465502299042e-06,  2.927537721376363e-08,
  3.454011041687723e-10, -3.653371923608176e-11,  1.455592131971317e-12, -3.743023245030605e-14,  4.759515089088568e-16,  1.011063476288720e-17, -8.240657704208663e-19,
  4.674048904546502e-02, -6.677341012040630e-04,  9.522146803235275e-06, -1.341921319713865e-07,  1.784769448870802e-09, -1.839759040657821e-11, -2.799430153572337e-14,
  9.287802380514219e-15, -3.119175062113939e-16,  5.261236762159624e-18,  2.995494719398849e-20, -5.239536805453745e-21,  1.413326297441524e-01, -2.019057272081220e-03,
  2.878948396394672e-05, -4.054003833088256e-07,  5.367435394529415e-09, -5.382542226524732e-11, -1.726108011936163e-13,  3.150095572076096e-14, -1.046863767656298e-15,
  1.816892306850111e-17,  6.801775301939343e-20, -1.655856950758727e-20,  2.924596987105748e-01, -4.177964236690500e-03,  5.956143642336618e-05, -8.374921685332604e-07,
  1.099364996370964e-08, -1.043423705512658e-10, -7.043776847087764e-13,  7.888526230886604e-14, -2.591745734198607e-15,  4.726817468159805e-17,  2.748016880166532e-20,
 -3.660069335302656e-20,  5.170135624930706e-01, -7.385614335385876e-03,  1.052512117593835e-04, -1.475795703258744e-06,  1.904721443625832e-08, -1.599259282330353e-10,
 -2.482616011542993e-12,  1.897377745926919e-13, -6.210931059216068e-15,  1.234510905271064e-16, -5.399075841877221e-19, -6.884976296543872e-20,  8.603318907572225e-01,
 -1.228905691509566e-02,  1.749776056747050e-04, -2.436794372231128e-06,  3.008986006867243e-08, -1.604443098126845e-10, -9.728333673481175e-12,  5.582211254993383e-13,
 -1.893722838657329e-14,  4.496051280519528e-16, -5.982962860671747e-18, -6.612173119636594e-20,  4.421235701774317e-02, -5.975405289280305e-04,  8.071116092902721e-06,
 -1.085455611011311e-07,  1.426078812420268e-09, -1.690202421622912e-11,  1.204938135877817e-13,  2.248225405317235e-15, -1.372084255789317e-16,  3.863293008995088e-18,
 -6.283975811240243e-20, -8.840391912730794e-23,  1.336881748746298e-01, -1.806822714253471e-03,  2.440437156506985e-05, -3.281190847394415e-07,  4.303924156377917e-09,
 -5.057318629500460e-11,  3.363831933024330e-13,  7.992834890748009e-15, -4.566755931659429e-16,  1.285591317470811e-17, -2.147453133778962e-19,  1.993473174520569e-23,
  2.766411840957596e-01, -3.738843552027495e-03,  5.049676877701205e-05, -6.786049551229960e-07,  8.874734248708246e-09, -1.025926269429016e-10,  5.874159171691218e-13,
  2.123633530982173e-14, -1.111805772742440e-15,  3.139459890928107e-17, -5.493387830568084e-19,  1.418603289660120e-21,  4.890499403975785e-01, -6.609518610391791e-03,
  8.925823112795384e-05, -1.198413260917167e-06,  1.558365617821480e-08, -1.743633810000187e-10,  6.624476035404577e-13,  5.414601160257899e-14, -2.571990647395045e-15,
  7.364007579266470e-17, -1.396713749459405e-18,  9.206052384846030e-21,  8.138012645043862e-01, -1.099832205697665e-02,  1.484896530001681e-04, -1.989456374585443e-06,
  2.551557049994815e-08, -2.615901233136786e-10, -4.888423795970778e-13,  1.636725019685841e-13, -7.133496504007134e-15,  2.153697938348254e-16, -4.813156733491227e-18,
  6.716100144410402e-20,  4.194359841790034e-02, -5.378184887245801e-04,  6.894866800462043e-06, -8.826154544522665e-08,  1.119974837164064e-09, -1.363939510870886e-11,
  1.395207237288156e-13, -3.824599918172887e-16, -4.037963034269143e-17,  1.664626580486642e-18, -4.193134569176716e-20,  6.750246030603640e-22,  1.268279721975563e-01,
 -1.626240537446424e-03,  2.084830903674885e-05, -2.668580754729702e-07,  3.384389747607350e-09, -4.109564863514345e-11,  4.137917937515985e-13, -7.874055119513626e-16,
 -1.361980559295924e-16,  5.484193875324015e-18, -1.386492108885153e-19,  2.284192692162601e-21,  2.624453937061672e-01, -3.365178724154480e-03,  4.314065846916673e-05,
 -5.521162630391513e-07,  6.995147692166054e-09, -8.448029208681300e-11,  8.252312482037260e-13, -2.006036601187951e-16, -3.370267217634643e-16,  1.313866106015793e-17,
 -3.349914442512547e-19,  5.747628471304862e-21,  4.639545624419276e-01, -5.948995285966856e-03,  7.626208818146119e-05, -9.757331431274866e-07,  1.233918507129872e-08,
 -1.474824356073096e-10,  1.354017359858201e-12,  4.552881059896914e-15, -7.892733136243218e-16,  2.967087601880852e-17, -7.718949139817614e-19,  1.421715890193236e-20,
  7.720418880949028e-01, -9.899354129271397e-03,  1.268942732592696e-04, -1.622525194915483e-06,  2.043036624781983e-08, -2.381452491742371e-10,  1.831998795188699e-12,
  2.798321699815384e-14, -2.153145340044327e-15,  7.894041935140996e-17, -2.174585107808227e-18,  4.626417907404657e-20,  3.989633864808696e-02, -4.866110518066968e-04,
  5.934818241195633e-06, -7.234797763839162e-08,  8.792471781840196e-10, -1.052023423425842e-11,  1.177442264632091e-13, -9.846287296210127e-16, -4.010129613717701e-18,
  5.188579975182524e-19, -1.742174941232383e-20,  4.052520884684040e-22,  1.206375233646694e-01, -1.471401724637935e-03,  1.794550087460431e-05, -2.187579176299966e-07,
  2.658105530588229e-09, -3.177289431807921e-11,  3.538568258730040e-13, -2.873055857127747e-15, -1.635984053468279e-17,  1.715693616440523e-18, -5.701618189813313e-20,
  1.333012903725664e-21,  2.496354940564287e-01, -3.044773857145887e-03,  3.713447883508298e-05, -4.526536984387635e-07,  5.498399445722425e-09, -6.560466565162313e-11,
  7.239796568870626e-13, -5.546653878254570e-15, -5.018230171020778e-17,  4.122358027972300e-18, -1.351174138303505e-19,  3.191796382987093e-21,  4.413090761912924e-01,
 -5.382590170329229e-03,  6.564625180846116e-05, -8.001349625661040e-07,  9.713580193795370e-09, -1.155082001578880e-10,  1.252505934210532e-12, -8.467602751844576e-15,
 -1.443853865160605e-16,  9.275814786669572e-18, -2.999031823948766e-19,  7.240301423614833e-21,  7.343588566574476e-01, -8.956869698543899e-03,  1.092363021343307e-04,
 -1.331198873580801e-06,  1.613961399659867e-08, -1.904465507913343e-10,  1.978836923059289e-12, -8.795336017027938e-15, -4.678443571082484e-16,  2.389289775773136e-17,
 -7.722819021853112e-19,  1.971191469888531e-20,  3.803967083409922e-02, -4.423810937546580e-04,  5.144578394379576e-06, -5.981917631974495e-08,  6.948512563086350e-10,
 -8.026490722982837e-12,  9.040377406799363e-14, -9.188434208147335e-16,  5.652854180810242e-18,  9.609727410364025e-20, -5.497480172307006e-21,  1.612279124547614e-22,
  1.150233795261483e-01, -1.337660527899125e-03,  1.555603260096328e-05, -1.808782819894206e-07,  2.100944536538306e-09, -2.426098165498486e-11,  2.728086498965732e-13,
 -2.750895317199577e-15,  1.592438735686597e-17,  3.334608601762512e-19, -1.798767116408962e-20,  5.250758555793020e-22,  2.380181359186423e-01, -2.768023695177813e-03,
  3.219009085896531e-05, -3.742866145629628e-07,  4.347009304059714e-09, -5.016844546735827e-11,  5.624471398085034e-13, -5.588439979745925e-15,  2.849949778196884e-17,
  8.547808051572944e-19, -4.251645307053657e-20,  1.234134614463852e-21,  4.207717566650121e-01, -4.893349928302405e-03,  5.690595545040828e-05, -6.616524800046611e-07,
  7.683166886756693e-09, -8.857594608947216e-11,  9.875355714323722e-13, -9.536786894417410e-15,  3.553128969674027e-17,  2.068702461465914e-18, -9.340649190190173e-20,
  2.702120519008518e-21,  7.001838240389797e-01, -8.142760075984322e-03,  9.469369897775366e-05, -1.100961881562279e-06,  1.277962803705508e-08, -1.469834397610598e-10,
  1.618117006333343e-12, -1.456658707816487e-14,  1.183898399285250e-18,  5.684539379576857e-18, -2.315467690644682e-19,  6.770849829885703e-21,  3.634816510752156e-02,
 -4.039182637177104e-04,  4.488515428975064e-06, -4.987625941826690e-08,  5.540490525663560e-10, -6.143117095477707e-12,  6.749359565075185e-14, -7.137449603288928e-16,
  6.481299389991836e-18, -2.228452928047070e-20, -1.219453880789412e-21,  5.050619412734424e-23,  1.099086480887514e-01, -1.221357658614975e-03,  1.357225515252446e-05,
 -1.508142354404192e-07,  1.675289665748042e-09, -1.857320635983862e-11,  2.039519006013828e-13, -2.151349484152409e-15,  1.929585129765012e-17, -5.580966211654106e-20,
 -4.075568209737642e-21,  1.641526235449903e-22,  2.274342112134493e-01, -2.527358085897908e-03,  2.808508867386785e-05, -3.120790665855687e-07,  3.466571000155376e-09,
 -3.842542747157675e-11,  4.215398281707974e-13, -4.426079627544818e-15,  3.878904175820423e-17, -7.153366844175027e-20, -9.919328124847810e-21,  3.838482282522062e-22,
  4.020613494837902e-01, -4.467898490343334e-03,  4.964917991944617e-05, -5.516940254173910e-07,  6.127905259253498e-09, -6.790302701186462e-11,  7.436029952708737e-13,
 -7.741127919882252e-15,  6.483843573443915e-17,  1.920390055248734e-20, -2.252820789628380e-20,  8.295043594292654e-22,  6.690488390754421e-01, -7.434790983185042e-03,
  8.261845203410714e-05, -9.180318620487958e-07,  1.019590207509990e-08, -1.129013201806240e-10,  1.231599412571122e-12, -1.257466440897961e-14,  9.386364363316165e-17,
  5.925121945867362e-19, -5.724807910419571e-20,  1.998315081650394e-21,  3.480071882897769e-02, -3.702622971909448e-04,  3.939402083763259e-06, -4.191274693578950e-08,
  4.458834445345776e-10, -4.740641081720376e-12,  5.024505863482024e-14, -5.251933862189515e-16,  5.197037333598421e-18, -4.122397258781094e-20, -2.425685368728188e-24,
  1.206219383099970e-23,  1.052295198038994e-01, -1.119589621992818e-03,  1.191186230311978e-05, -1.267346185083030e-07,  1.348244314190163e-09, -1.433413068747411e-11,
  1.518987104005712e-13, -1.586433187074362e-15,  1.564055332923775e-17, -1.217152562607868e-19, -1.098704942938348e-22,  3.964405242864644e-23,  2.177516806938867e-01,
 -2.316769298873411e-03,  2.464924132629697e-05, -2.622519756587982e-07,  2.789900713806356e-09, -2.965980957426944e-11,  3.142093958542154e-13, -3.276729622848661e-15,
  3.208776183748309e-17, -2.408190283013145e-19, -6.154632656568916e-22,  9.412472522518653e-23,  3.849444382030144e-01, -4.095616835643791e-03,  4.357526421010567e-05,
 -4.636118855551353e-07,  4.931949148974753e-09, -5.242722578780563e-11,  5.550989288188837e-13, -5.773203542144937e-15,  5.583082960251710e-17, -3.897434973277554e-19,
 -2.366313377515598e-21,  2.067355286952323e-22,  6.405655013749358e-01, -6.815297355868247e-03,  7.251125159382692e-05, -7.714691127044859e-07,  8.206732004289659e-09,
 -8.722116367331115e-11,  9.224230056355520e-13, -9.537216597573438e-15,  8.964633970233674e-17, -5.149066137160194e-19, -8.792470763767736e-21,  5.012729621494986e-22,
  3.337967693129744e-02, -3.406444156852961e-04,  3.476324457769724e-06, -3.547627398372761e-08,  3.620296658778761e-10, -3.693783859771446e-12,  3.764926467922224e-14,
 -3.818970276832916e-16,  3.797578256313318e-18, -3.502316927514522e-20,  2.349319433484481e-22,  1.141949205053050e-24,  1.009326098163375e-01, -1.030031834823716e-03,
  1.051162049950885e-05, -1.072722314036836e-07,  1.094694579963880e-09, -1.116905917722390e-11,  1.138359237877260e-13, -1.154396108117731e-15,  1.146561569308417e-17,
 -1.051932833297865e-19,  6.848306302883071e-22,  4.273196885738232e-24,  2.088600752671602e-01, -2.131447177780030e-03,  2.175171939924748e-05, -2.219786146271675e-07,
  2.265248724336857e-09, -2.311175672980334e-11,  2.355353025445147e-13, -2.387410051442448e-15,  2.366118851009085e-17, -2.150318362181953e-19,  1.321294080915824e-21,
  1.193697001831001e-23,  3.692257349969936e-01, -3.768001847587573e-03,  3.845298967183896e-05, -3.924167046061877e-07,  4.004521885420746e-09, -4.085602797191685e-11,
  4.163021061623569e-13, -4.216121241983020e-15,  4.162279632453408e-17, -3.716466749848113e-19,  2.025359340996400e-21,  3.123324670613657e-23,  6.144088462399944e-01,
 -6.270130818719260e-03,  6.398756430451049e-05, -6.529991455977198e-07,  6.663656471343778e-09, -6.798204683827222e-11,  6.924680806460435e-13, -7.000509339434902e-15,
  6.853175612852508e-17, -5.878145472863062e-19,  2.230027032709494e-21,  8.996582306248345e-23,  3.207015626102723e-02, -3.144435217885759e-04,  3.083075780605767e-06,
 -3.022911298335791e-08,  2.963899353186477e-10, -2.905885895922050e-12,  2.848107981233299e-14, -2.787025535615247e-16,  2.708307340583858e-18, -2.561518399625099e-20,
  2.191728846171072e-22, -1.183589772273544e-24,  9.697291484713294e-02, -9.508062452430905e-04,  9.322525339713393e-06, -9.140601240509128e-08,  8.962159737420686e-10,
 -8.786719685186791e-12,  8.611884379250902e-14, -8.426506389677293e-16,  8.185371855063821e-18, -7.729039508739958e-20,  6.566570081850131e-22, -3.378069659688964e-24,
  2.006662696143969e-01, -1.967505489743981e-03,  1.929112245472547e-05, -1.891466548105788e-07,  1.854540624386213e-09, -1.818229300635796e-11,  1.782003683242944e-13,
 -1.743393733997801e-15,  1.692347531254480e-17, -1.593290682724536e-19,  1.336224950635291e-21, -6.239163594362906e-24,  3.547406118450392e-01, -3.478183465137543e-03,
  3.410311331420847e-05, -3.343760430817186e-07,  3.278479242130642e-09, -3.214264443961930e-11,  3.150078282297242e-13, -3.081041255569660e-15,  2.987180868510467e-17,
 -2.797365040072551e-19,  2.290008524402870e-21, -8.609179312395455e-24,  5.903049256741346e-01, -5.787859528446065e-03,  5.674917051617823e-05, -5.564172208106379e-07,
  5.455531176697612e-09, -5.348596956160109e-11,  5.241291993799089e-13, -5.123723211001234e-15,  4.954926860101108e-17, -4.587115549334236e-19,  3.552798221693607e-21,
 -5.530774148038297e-24,  3.085952225281388e-02, -2.911534830525371e-04,  2.746975429862045e-06, -2.591716382940819e-08,  2.445227880026672e-10, -2.306985043942690e-12,
  2.176353501949033e-14, -2.052083438727586e-16,  1.930386754201661e-18, -1.798639999789064e-20,  1.617562987838789e-22, -1.277874826150583e-24,  9.331223082594664e-02,
 -8.803824243644587e-04,  8.306233749821196e-06, -7.836765373617745e-08,  7.393816643889510e-10, -6.975797227489448e-12,  6.580769741726428e-14, -6.204858490800781e-16,
  5.836190678459323e-18, -5.435012821991170e-20,  4.877274204550133e-22, -3.816985752163050e-24,  1.930912079815589e-01, -1.821777320012383e-03,  1.718810806206712e-05,
 -1.621663589242689e-07,  1.530003907450100e-09, -1.443501499277214e-11,  1.361748454944137e-13, -1.283907392286248e-15,  1.207367509652693e-17, -1.123317622497243e-19,
  1.004128468332714e-21, -7.723973366032891e-24,  3.413493129335496e-01, -3.220563188536251e-03,  3.038537553846204e-05, -2.866799294137270e-07,  2.704761420979697e-09,
 -2.551836484744589e-11,  2.407281713471953e-13, -2.269506712421983e-15,  2.133413959299757e-17, -1.981581217628545e-19,  1.758929357677772e-21, -1.309958134170239e-23,
  5.680211796309708e-01, -5.359167374412241e-03,  5.056268211543857e-05, -4.770487529456180e-07,  4.500846921785182e-09, -4.246356862917940e-11,  4.005708677765367e-13,
 -3.775882483944661e-15,  3.546739240756482e-17, -3.282853975609226e-19,  2.870475524220845e-21, -1.983416415016765e-23,  2.973697971759500e-02, -2.703585247299703e-04,
  2.458007919157754e-06, -2.234737242378946e-08,  2.031746132698504e-10, -1.847186214778364e-12,  1.679346265424313e-14, -1.526523433175698e-16,  1.386565566207471e-18,
 -1.255359607969062e-20,  1.122416934063410e-22, -9.595825875998816e-25,  8.991791553815111e-02, -8.175031634826563e-04,  7.432461216247312e-06, -6.757341066528470e-08,
  6.143541649925389e-10, -5.585473234400775e-12,  5.077957466716400e-14, -4.615824839293237e-16,  4.192477347741971e-18, -3.795128864544244e-20,  3.390872077926277e-22,
 -2.890960348847342e-24,  1.860673437638342e-01, -1.691661124881650e-03,  1.538000861739316e-05, -1.398298093985563e-07,  1.271284402724415e-09, -1.155802863379533e-11,
  1.050780463634732e-13, -9.551400109136317e-16,  8.674831033727119e-18, -7.850356437494242e-20,  7.005483714299519e-22, -5.943179123074675e-24,  3.289324284476114e-01,
 -2.990541976107752e-03,  2.718899232857562e-05, -2.471930731748036e-07,  2.247394044935569e-09, -2.043243212355566e-11,  1.857576886806881e-13, -1.688467773581136e-15,
  1.533341170710809e-17, -1.386892557428832e-19,  1.234923540218957e-21, -1.038355277631574e-23,  5.473589046380760e-01, -4.976401347810412e-03,  4.524375148671322e-05,
 -4.113408002060134e-07,  3.739768080823144e-09, -3.400048412663278e-11,  3.091070327724824e-13, -2.809549906633755e-15,  2.550856611217957e-17, -2.304795727256617e-19,
  2.042950108999540e-21, -1.685344320091425e-23,  2.869324983320577e-02, -2.517145440733648e-04,  2.208192240898531e-06, -1.937159783561048e-08,  1.699393511659126e-10,
 -1.490809019241752e-12,  1.307816599080473e-14, -1.147234867780236e-16,  1.006137495317177e-18, -8.814618127778528e-21,  7.689254509905769e-23, -6.601873581814171e-25,
  8.676191191975589e-02, -7.611279736084756e-04,  6.677074985066241e-06, -5.857533999208270e-08,  5.138582430430152e-10, -4.507869823623533e-12,  3.954540898199450e-14,
 -3.468971631847323e-16,  3.042294449766498e-18, -2.665173741105364e-20,  2.324399987347248e-22, -1.993943375394696e-24,  1.795366184165407e-01, -1.575003818380722e-03,
  1.381688620215157e-05, -1.212100819872872e-07,  1.063328002879294e-09, -9.328144386571455e-12,  8.183135460930524e-14, -7.178322858004121e-16,  6.295287645330994e-18,
 -5.514438349983397e-20,  4.807484777577654e-22, -4.117586551799212e-24,  3.173873216892905e-01, -2.784313573316832e-03,  2.442568287247353e-05, -2.142768621557229e-07,
  1.879765950023422e-09, -1.649042070773881e-11,  1.446624546875697e-13, -1.268985349297771e-15,  1.112847059292081e-17, -9.746617418321644e-20,  8.491307042682635e-22,
 -7.252722416740140e-24,  5.281473084482998e-01, -4.633227665765315e-03,  4.064547567779242e-05, -3.565666931543531e-07,  3.128018140068748e-09, -2.744082222758021e-11,
  2.407245926590405e-13, -2.111622970882686e-15,  1.851688877774478e-17, -1.621256056083901e-19,  1.410496793077119e-21, -1.197923805348800e-23,  2.772031289372142e-02,
 -2.349347797391419e-04,  1.991115718390833e-06, -1.687507400117488e-08,  1.430193692054381e-10, -1.212115247372571e-12,  1.027287746215773e-14, -8.706324601110852e-17,
  7.378155432224959e-19, -6.250536307296196e-21,  5.287762414478118e-23, -4.448617780221748e-25,  8.381997018998794e-02, -7.103897531684023e-04,  6.020684571608154e-06,
 -5.102641535918706e-08,  4.324582949684598e-10, -3.665162914926645e-12,  3.106286035755454e-14, -2.632594525071545e-16,  2.230979903913338e-18, -1.889986517166323e-20,
  1.598762665171821e-22, -1.344670369876248e-24,  1.734488518141981e-01, -1.470011105328440e-03,  1.245861605180193e-05, -1.055890754287957e-07,  8.948869154283655e-10,
 -7.584329676780158e-12,  6.427843678516620e-14, -5.447628152459824e-16,  4.616543527260221e-18, -3.910827811423506e-20,  3.307823549093522e-22, -2.780737446665554e-24,
  3.066252835378270e-01, -2.598706000415759e-03,  2.202451408211711e-05, -1.866618305307488e-07,  1.581993483418445e-09, -1.340768266408792e-11,  1.136322820877443e-13,
 -9.630375598594678e-16,  8.161103885235526e-18, -6.913232110999446e-20,  5.846082916799624e-22, -4.910299333944133e-24,  5.102387749478396e-01, -4.324368006451316e-03,
  3.664981880837150e-05, -3.106139930531127e-07,  2.632510935145396e-09, -2.231100802015103e-11,  1.890893246133530e-13, -1.602533952407550e-15,  1.358017858210801e-17,
 -1.150268304305108e-19,  9.723083217357881e-22, -8.152520259554594e-24,  2.681120171583033e-02, -2.197787155878493e-04,  1.801585931714736e-06, -1.476809007062108e-08,
  1.210580516602599e-10, -9.923457148670351e-13,  8.134523027228129e-15, -6.668063100732817e-17,  5.465863351534598e-19, -4.479965064776821e-21,  3.670249902432592e-23,
 -3.001220738757588e-25,  8.107102315889342e-02, -6.645612356395546e-04,  5.447589270359710e-06, -4.465537146725446e-08,  3.660522273957396e-10, -3.000629478662692e-12,
  2.459696128881179e-14, -2.016271489444079e-16,  1.652752168843086e-18, -1.354633347693623e-20,  1.109772671197797e-22, -9.073996739863527e-25,  1.677604495735320e-01,
 -1.375178051490948e-03,  1.127270866305030e-05, -9.240546006527256e-08,  7.574726926546806e-10, -6.209209265051601e-12,  5.089854513970402e-14, -4.172274004506913e-16,
  3.420038159449624e-18, -2.803120586140131e-20,  2.296353412920922e-22, -1.877314733922293e-24,  2.965692472384963e-01, -2.431058813840127e-03,  1.992805056869365e-05,
 -1.633556526603946e-07,  1.339070720599090e-09, -1.097672609143490e-11,  8.997914771157341e-14, -7.375800486383919e-16,  6.045973917669822e-18, -4.955318859950593e-20,
  4.059215681519996e-22, -3.317612580116133e-24,  4.935050614621250e-01, -4.045395267760511e-03,  3.316120572930150e-05, -2.718314260436080e-07,  2.228276139566192e-09,
 -1.826578398864443e-11,  1.497294811561384e-13, -1.227366549566572e-15,  1.006072819652625e-17, -8.245633884866412e-20,  6.753714024551140e-22, -5.516944966162163e-24,
  2.595983443430540e-02, -2.060434111307906e-04,  1.635368183009874e-06, -1.297993019513084e-08,  1.030218083879870e-10, -8.176848929851119e-13,  6.489970493453807e-15,
 -5.151089269840711e-17,  4.088396984255064e-19, -3.244848787064820e-21,  2.574994714337504e-23, -2.042102898378695e-25,  7.849668063859987e-02, -6.230287747847883e-04,
  4.944984310785212e-06, -3.924837956160845e-08,  3.115146982871841e-10, -2.472494577432014e-12,  1.962420599627524e-14, -1.557573084633840e-16,  1.236238675431908e-18,
 -9.811676597005334e-21,  7.786146680255672e-23, -6.174652122246731e-25,  1.624333568376448e-01, -1.289234837338743e-03,  1.023266709592571e-05, -8.121675962241908e-08,
  6.446180619421433e-10, -5.116338554692390e-12,  4.060841300625952e-14, -3.223089255620206e-16,  2.558150362544579e-18, -2.030327454850651e-20,  1.611168797339815e-22,
 -1.277647591798664e-24,  2.871519388880013e-01, -2.279127209036228e-03,  1.808945067561069e-05, -1.435761129950668e-07,  1.139564741519022e-09, -9.044734173283169e-12,
  7.178811410629207e-14, -5.697821208330048e-16,  4.522330369643148e-18, -3.589225997316595e-20,  2.848185163585983e-22, -2.258416624494855e-24,  4.778342210779877e-01,
 -3.792573990218411e-03,  3.010168974226966e-05, -2.389173494091567e-07,  1.896288886553919e-09, -1.505085952532998e-11,  1.194587671912205e-13, -9.481438263408442e-16,
  7.525358234323943e-18, -5.972591450372105e-20,  4.739315280394704e-22, -3.757375669786233e-24  };
  constexpr double w[1920] = {  5.882472092450335e-03, -7.924183300918967e-04,  6.626389929822969e-05, -4.341003566479913e-06,  2.421840042200989e-07,
 -1.199189056920721e-08,  5.398766472761845e-10, -2.244542397083054e-11,  8.710531789492477e-13, -3.179818825138298e-14,  1.098242723376196e-15, -3.601044671596979e-17,
  3.234404387643113e-02, -6.556605917747259e-03,  7.871137508950322e-04, -7.072200061993132e-05,  5.206765244557325e-06, -3.293139840016583e-07,  1.841307273186421e-08,
 -9.276532333428012e-10,  4.268135228038136e-11, -1.811401593161571e-12,  7.145524497933710e-14, -2.632808728376595e-15,  6.730053519041732e-02, -1.913540858364763e-02,
  3.047434869027198e-03, -3.476407565033779e-04,  3.139234182870374e-05, -2.367543297860071e-06,  1.541579864641621e-07, -8.862972894362261e-09,  4.572493286925087e-10,
 -2.142724148092758e-11,  9.207284813037982e-13, -3.650835093533271e-14,  7.684645858698860e-02, -2.750296309862340e-02,  5.338047596630433e-03, -7.194824877719891e-04,
  7.482304983536611e-05, -6.362747105803939e-06,  4.589452247924518e-07, -2.879486687451972e-08,  1.600553819009884e-09, -7.992511634559518e-11,  3.625062666306339e-12,
 -1.504594596166102e-13,  4.401465728458315e-02, -1.781234098067152e-02,  3.861365996541114e-03, -5.716794289906211e-04,  6.435112297790333e-05, -5.850221257771581e-06,
  4.464584653798802e-07, -2.937841602284762e-08,  1.700057179437774e-09, -8.782674247694001e-11,  4.099032034770607e-12, -1.742586340758679e-13,  3.516767622125868e-03,
 -4.193251840541305e-04,  3.131534522152806e-05, -1.848855891137664e-06,  9.369950099857523e-08, -4.243694457489010e-09,  1.758094352730885e-10, -6.762935699572935e-12,
  2.440540068334068e-13, -8.323607079571161e-15,  2.697784798610573e-16, -8.337297013796838e-18,  1.482991924890883e-02, -2.617431455784166e-03,  2.799196369756603e-04,
 -2.276257760183556e-05,  1.534796547579245e-06, -8.974927431156538e-08,  4.676639011643681e-09, -2.210811360550350e-10,  9.602342697741142e-12, -3.867791457846938e-13,
  1.455138393565894e-14, -5.136583405564976e-16,  2.165558884198081e-02, -5.520173566860432e-03,  8.032151359972136e-04, -8.491179560331683e-05,  7.183236590555846e-06,
 -5.119364963649455e-07,  3.172469488403149e-08, -1.746306213851649e-09,  8.670004132857681e-11, -3.927096323299972e-12,  1.637361263769278e-13, -6.321244443437955e-15,
  1.717538193526453e-02, -5.797095693682939e-03,  1.069680505920800e-03, -1.381678803740672e-04,  1.385991717510005e-05, -1.142838651035436e-06,  8.027366869850164e-08,
 -4.921902970770264e-09,  2.681481111188653e-10, -1.315690610513928e-11,  5.875830310664408e-13, -2.405771195779420e-14,  7.572333278443788e-03, -3.010429489148812e-03,
  6.418995383598478e-04, -9.367318697550753e-05,  1.041296937327875e-05, -9.363369472819098e-07,  7.077039784714015e-08, -4.617257242753461e-09,  2.651565016790909e-10,
 -1.360456488916598e-11,  6.310211674004520e-13, -2.667544295652137e-14,  2.229026646226653e-03, -2.372877722024851e-04,  1.592182023534488e-05, -8.508393518954260e-07,
  3.929086414408009e-08, -1.631104290010874e-09,  6.226259604569370e-11, -2.217301580835507e-12,  7.439999538841872e-14, -2.368867446648820e-15,  7.195659524718855e-17,
 -2.092079893846134e-18,  7.558090979424200e-03, -1.158395734783726e-03,  1.100880610976803e-04, -8.079912642701443e-06,  4.973876590654072e-07, -2.679805561731841e-08,
  1.296445073513581e-09, -5.727792899624932e-11,  2.338632054461589e-12, -8.901688443986988e-14,  3.179858508813761e-15, -1.070555413720107e-16,  7.965166552136617e-03,
 -1.790077958740316e-03,  2.352218397816731e-04, -2.282186667841252e-05,  1.793355808822835e-06, -1.198535882477984e-07,  7.019450904748638e-09, -3.675708220964728e-10,
  1.745784780129922e-11, -7.601644063825517e-13,  3.059829451765406e-14, -1.144812102260302e-15,  4.272250138925106e-03, -1.336147105675300e-03,  2.313380629264186e-04,
 -2.834002442704539e-05,  2.718883979193216e-06, -2.158406327426384e-07,  1.467464630478412e-08, -8.747540126693251e-10,  4.650260101142595e-11, -2.233284268926141e-12,
  9.787731462805230e-14, -3.941618531396497e-15,  1.357898344038953e-03, -5.269712804255375e-04,  1.099481281612335e-04, -1.574971531968061e-05,  1.723202249846055e-06,
 -1.528442073542997e-07,  1.141557685331348e-08, -7.370469156755055e-10,  4.193769933528072e-11, -2.134117333053946e-12,  9.826068025552817e-14, -4.126400875495142e-15,
  1.482336423644242e-03, -1.421063078111428e-04,  8.622248187970351e-06, -4.190846262195657e-07,  1.769918948125697e-08, -6.754171382532807e-10,  2.380622514470667e-11,
 -7.859456476845060e-13,  2.454522745681463e-14, -7.298296636032786e-16,  2.076954685260265e-17, -5.677545504845621e-19,  4.220278979057778e-03, -5.621860336641730e-04,
  4.747587266615053e-05, -3.142793398701603e-06,  1.763966061001080e-07, -8.740116868134688e-09,  3.916578693195707e-10, -1.612785186017532e-11,  6.171354427973766e-13,
 -2.212488036501574e-14,  7.477906601614578e-16, -2.392236474481478e-17,  3.340549593281871e-03, -6.523445804070692e-04,  7.667140994026336e-05, -6.771726111808304e-06,
  4.906428886606635e-07, -3.053874296528514e-08,  1.679455334180845e-09, -8.315288224660427e-11,  3.756501076563265e-12, -1.563923853263851e-13,  6.046631429915111e-15,
 -2.182026394269812e-16,  1.204454849104681e-03, -3.416836978174432e-04,  5.468568513192692e-05, -6.279239311490984e-06,  5.705894989341336e-07, -4.325516717342393e-08,
  2.826758865814464e-09, -1.628369934786872e-10,  8.402862514615494e-12, -3.931931360264940e-13,  1.684373046304367e-14, -6.648521048768155e-16,  2.572219819374370e-04,
 -9.652786922523566e-05,  1.956265090315524e-05, -2.735091939348997e-06,  2.932097533593541e-07, -2.556029640480041e-08,  1.880839793746849e-09, -1.198792713817824e-10,
  6.744504604597766e-12, -3.398130944824662e-13,  1.550822190871270e-14, -6.461445275314393e-16,  1.025675079315256e-03, -8.928674504302586e-05,  4.929956333077145e-06,
 -2.190692837198663e-07,  8.495058579003964e-09, -2.989471431714470e-10,  9.757895544808214e-12, -2.991611011449362e-13,  8.708740020422917e-15, -2.422270942179184e-16,
  6.459120020143156e-18, -1.659731754623598e-19,  2.545929799912725e-03, -2.958468107104106e-04,  2.224231295449360e-05, -1.329272317820291e-06,  6.803931789759677e-08,
 -3.098885229798471e-09,  1.284980678734043e-10, -4.924468223244008e-12,  1.762649133289256e-13, -5.938502272981223e-15,  1.894236703642051e-16, -5.741930582136539e-18,
  1.584559778683083e-03, -2.658792538775427e-04,  2.775803580975706e-05, -2.218146091015524e-06,  1.473293075457602e-07, -8.492347575247925e-09,  4.361297063389924e-10,
 -2.030794775180922e-11,  8.680840595721079e-13, -3.438057707426283e-14,  1.270592575162472e-15, -4.401880878892768e-17,  3.907688027691485e-04, -9.814485945849118e-05,
  1.429252979573596e-05, -1.519098804080754e-06,  1.293929442713421e-07, -9.284067032502474e-09,  5.787115609596803e-10, -3.200020501268654e-11,  1.593478978122200e-12,
 -7.227346960773996e-14,  3.012398704011193e-15, -1.160738176305557e-16,  5.243253443940341e-05, -1.875810636557745e-05,  3.654527117226501e-06, -4.947967083158690e-07,
  5.165662640668528e-08, -4.404342266858359e-09,  3.180529588755383e-10, -1.994750767532620e-11,  1.106703166412325e-12, -5.508405457595460e-14,  2.487066984911571e-15,
 -1.026441621326589e-16,  7.335104166471062e-04, -5.843564506504280e-05,  2.953950357727078e-06, -1.206251684371712e-07,  4.313585289314814e-09, -1.403584917239538e-10,
  4.259104332914072e-12, -1.215693947166562e-13,  3.299031198164471e-15, -8.612413300591668e-17,  2.156357893197535e-18, -5.199155848977828e-20,  1.638446041166614e-03,
 -1.670219787855840e-04,  1.121519829976751e-05, -6.064160277648296e-07,  2.834560253645788e-08, -1.187511428574525e-09,  4.556830768096217e-11, -1.624587904144911e-12,
  5.434739095989547e-14, -1.718439913013657e-15,  5.164658109833056e-17, -1.480615337941847e-18,  8.398557397532734e-04, -1.201984287403907e-04,  1.110266052589699e-05,
 -7.996188697545110e-07,  4.849394729303911e-08, -2.578137553277146e-09,  1.231095730277725e-10, -5.367740471833169e-12,  2.161589700778002e-13, -8.108063451930136e-15,
  2.851676010935318e-16, -9.443804773606505e-18,  1.472315469881230e-04, -3.191331509056484e-05,  4.165437431816705e-06, -4.048284497545598e-07,  3.198872715253406e-08,
 -2.152834810657683e-09,  1.269764970463277e-10, -6.691723238969422e-12,  3.195059442181857e-13, -1.396637376738535e-14,  5.635049592732262e-16, -2.109940468416059e-17,
  1.179455480763098e-05, -3.936792170425924e-06,  7.267436950998887e-07, -9.427553472727720e-08,  9.507026400346052e-09, -7.877294632930789e-10,  5.553792522530742e-11,
 -3.413134741199715e-12,  1.860932111223917e-13, -9.123876652251432e-15,  4.065653868224631e-16, -1.658705299641983e-17,  5.392780214373404e-04, -3.960300277038075e-05,
  1.843191028804647e-06, -6.948562206677892e-08,  2.304235307728979e-09, -6.942209496148861e-11,  1.964082012571487e-12, -5.258181198343161e-14,  1.325576360569686e-15,
 -3.247336387303104e-17,  7.732026282022396e-19, -1.733508247867574e-20,  1.112625843038743e-03, -1.001819199822229e-04,  6.033003260124969e-06, -2.960110858011691e-07,
  1.266360046058728e-08, -4.887431492319487e-10,  1.737115729856318e-11, -5.763729177513222e-13,  1.802177618636180e-14, -5.345970951111605e-16,  1.512407517456983e-17,
 -4.096111905417998e-19,  4.904493799565134e-04, -5.965087679954946e-05,  4.869089884924801e-06, -3.155362061171016e-07,  1.743157458682917e-08, -8.527620626253151e-10,
  3.775047466834189e-11, -1.536102542216053e-12,  5.808610480362855e-14, -2.056136093356030e-15,  6.856148963302479e-17, -2.162479748708265e-18,  6.447793022365715e-05,
 -1.176588480754222e-05,  1.359400911443708e-06, -1.195200550521532e-07,  8.678134789560855e-09, -5.431970777316489e-10,  3.007975922385094e-11, -1.500062603488656e-12,
  6.822896241567990e-14, -2.857245256588253e-15,  1.109869416037235e-16, -4.018323974031891e-18,  3.024333727813460e-06, -9.119041678162933e-07,  1.564704349246560e-07,
 -1.917704077963826e-08,  1.848175714360760e-09, -1.475803990269267e-10,  1.009104803415436e-11, -6.043980228879585e-13,  3.224065719529843e-14, -1.551332837466817e-15,
  6.801510818530925e-17, -2.735954019094906e-18,  4.058401616853136e-04, -2.765709162624508e-05,  1.191861238176139e-06, -4.159056761511659e-08,  1.288779590064144e-09,
 -3.605686931700462e-11,  9.451792047715847e-13, -2.412016079285451e-14,  5.693087444552028e-16, -1.262829663989993e-17,  2.973375989780818e-19, -6.378472817660663e-21,
  7.899697909373883e-04, -6.330081021474051e-05,  3.434785230879672e-06, -1.534477559261063e-07,  6.024736686878588e-09, -2.146704506370451e-10,  7.078332079347256e-12,
 -2.187795393164016e-13,  6.397289839364621e-15, -1.781611307411627e-16,  4.744033902445762e-18, -1.212068441755448e-19,  3.110849630881825e-04, -3.213869898414540e-05,
  2.320265778580157e-06, -1.354121185334310e-07,  6.804389690190540e-09, -3.060840771417489e-10,  1.254879421339070e-11, -4.751817417848705e-13,  1.683461629605368e-14,
 -5.612920494761568e-16,  1.768029785041577e-17, -5.295062709167851e-19,  3.257707624127088e-05, -4.894347816826207e-06,  4.963169960207785e-07, -3.917183601937924e-08,
  2.592024319707298e-09, -1.498338869954988e-10,  7.736948580651087e-12, -3.626450612827090e-13,  1.561615531130428e-14, -6.228666375556219e-16,  2.316269019406611e-17,
 -8.067896850511248e-19,  9.175829098914832e-07, -2.386502476257701e-07,  3.717776614386724e-08, -4.230888374572364e-09,  3.845189325445597e-10, -2.928358221696171e-11,
  1.925635526234980e-12, -1.116371077873750e-13,  5.793650882736530e-15, -2.723187243037932e-16,  1.170122908266448e-17, -4.625698581501398e-19,  3.115521818855958e-04,
 -1.981580588780192e-05,  7.961436158406349e-07, -2.570393774871565e-08,  7.488970096392015e-10, -1.976837307335280e-11,  4.701099379312898e-13, -1.134959927655688e-14,
  2.729017165641195e-16, -5.121830648565998e-18,  1.007789017551984e-19, -3.129378716753727e-21,  5.820090586391026e-04, -4.182450312311728e-05,  2.055171151875887e-06,
 -8.390051350493567e-08,  3.032393315547584e-09, -1.000032486028637e-10,  3.065400509511616e-12, -8.842204346262959e-14,  2.418826852467124e-15, -6.324957399860113e-17,
  1.591065984445373e-18, -3.832710296695475e-20,  2.114735956565952e-04, -1.860321110490166e-05,  1.189368738176856e-06, -6.277904804196966e-08,  2.866801246023348e-09,
 -1.184221771150191e-10,  4.508616845333135e-12, -1.586408334533659e-13,  5.239809714205083e-15, -1.648647985870241e-16,  4.905105820422061e-18, -1.381560591395672e-19,
  1.872445574067331e-05, -2.275004788558939e-06,  2.014182439378872e-07, -1.423424803873161e-08,  8.523891364842089e-10, -4.523605178214415e-11,  2.168550172338416e-12,
 -9.495340176287643e-14,  3.847638204125759e-15, -1.455094416668595e-16,  5.152288504510201e-18, -1.716403252246695e-19,  3.408087580596434e-07, -7.198808085615670e-08,
  9.929714586564630e-09, -1.029468703171875e-09,  8.685253089473056e-11, -6.231277925128590e-12,  3.901367572032443e-13, -2.170891344606690e-14,  1.088533782463596e-15,
 -4.969375508479241e-17,  2.082474222318457e-18, -8.057326845154942e-20,  2.433261582598537e-04, -1.450328234204237e-05,  5.482723046291672e-07, -1.636375309343808e-08,
  4.450739756395857e-10, -1.146088600423350e-11,  2.510438305458205e-13, -5.018048108812457e-15,  1.341191466985730e-16, -3.140636493356180e-18,  1.830449610156890e-20,
 -3.906277852936444e-22,  4.422096609363026e-04, -2.871520451023690e-05,  1.284448447268410e-06, -4.809307618230128e-08,  1.605129497208291e-09, -4.913153319900234e-11,
  1.402494738374456e-12, -3.784669733140777e-14,  9.723513063151482e-16, -2.378197842421619e-17,  5.619573258576446e-19, -1.309610712085914e-20,  1.522233536530353e-04,
 -1.147001270306755e-05,  6.486826124177006e-07, -3.120685754510596e-08,  1.299406319307085e-09, -4.894669931470167e-11,  1.735902052066308e-12, -5.738655749076500e-14,
  1.747483184693972e-15, -5.119609394509886e-17,  1.478126842413087e-18, -3.928048895674392e-20,  1.202066040657642e-05, -1.169090391739274e-06,  8.976169289396203e-08,
 -5.710096281823347e-09,  3.083369098083222e-10, -1.489659370004188e-11,  6.622441152383057e-13, -2.705455962951040e-14,  1.022272698906337e-15, -3.646215533799491e-17,
  1.231732837386795e-18, -3.893004099666927e-20,  1.575412959776264e-07, -2.530510221484777e-08,  3.018068990853870e-09, -2.805866896273537e-10,  2.159960102072392e-11,
 -1.439653913909979e-12,  8.492203352249134e-14, -4.491964582258370e-15,  2.157365798363741e-16, -9.502914381588572e-18,  3.862415649203672e-19, -1.454483261943601e-20,
  1.929921081893063e-04, -1.079700387041961e-05,  3.880182477439804e-07, -1.078928503093164e-08,  2.668075019085707e-10, -6.736207594402145e-12,  1.546927617640616e-13,
 -2.377231784229458e-15,  3.745533158989555e-17, -1.998429812581423e-18,  4.964777800935224e-20,  9.982786826844589e-22,  3.447759101173109e-04, -2.037585031188182e-05,
  8.340696926191072e-07, -2.874904264408991e-08,  8.885621133792766e-10, -2.533208682574881e-11,  6.751260620729547e-13, -1.701274100406669e-14,  4.124131328331446e-16,
 -9.620000472955015e-18,  2.088858738613516e-19, -4.361728027787768e-21,  1.147670779429256e-04, -7.487050587079412e-06,  3.727112730683925e-07, -1.643522975719556e-08,
  6.336197521223757e-10, -2.161414888531392e-11,  6.999510763390930e-13, -2.227060380950342e-14,  6.483748739408468e-16, -1.660970857655922e-17,  4.370104589146757e-19,
 -1.296341087229663e-20,  8.440843932362223e-06, -6.593000205932799e-07,  4.323457851166836e-08, -2.500399054733657e-09,  1.229565647876751e-10, -5.337355718640378e-12,
  2.176768062522772e-13, -8.408322106771793e-15,  2.972869786174332e-16, -9.708727091060028e-18,  3.111065437209220e-19, -9.738941340585456e-21,  8.939645152131479e-08,
 -1.038916564007796e-08,  1.042962372932671e-09, -8.653124248756515e-11,  5.997761010970050e-12, -3.647812793478624e-13,  2.005147971649140e-14, -1.001455544957328e-15,
  4.559760223197524e-17, -1.916676090744785e-18,  7.522019555096829e-20, -2.750825715721151e-21,  1.552828764522849e-04, -8.147205378962877e-06,  2.803103397852402e-07,
 -7.417337688327993e-09,  1.642907539541793e-10, -3.738213414405439e-12,  9.714086061971673e-14, -1.899160865730583e-15,  5.753367909340033e-18,  1.680819188248830e-19,
  3.921373155857440e-20, -1.470160414794937e-21,  2.747294784107697e-04, -1.487505083428702e-05,  5.601298267373019e-07, -1.784354611066168e-08,  5.118990649353183e-10,
 -1.362432530661378e-11,  3.411483187428771e-13, -8.048351827658277e-15,  1.806482752983230e-16, -4.025471980030943e-18,  8.965824443541309e-20, -1.703721061814619e-21,
  8.973953889663576e-05, -5.149733149507897e-06,  2.245160920738186e-07, -9.018757473803460e-09,  3.289508521802742e-10, -1.040880521448280e-11,  2.957125326489006e-13,
 -8.597736970141922e-15,  2.624534490651951e-16, -6.837485335768497e-18,  1.270766971168108e-19, -2.603989474875676e-21,  6.343803735444123e-06, -4.065980255083796e-07,
  2.225068035271025e-08, -1.167360181303571e-09,  5.382356554603129e-11, -2.117546967113863e-12,  7.609800284689878e-14, -2.736097122004649e-15,  9.609045953864156e-17,
 -2.958717196090732e-18,  7.939139866948413e-20, -2.285370759254075e-21,  5.969082672995401e-08, -4.989771789071346e-09,  4.039615030438533e-10, -3.000344810843303e-11,
  1.884998240831741e-12, -1.028256382735715e-13,  5.143159293798739e-15, -2.413913906691223e-16,  1.047269242707428e-17, -4.148328955515211e-19,  1.530127288654997e-20,
 -5.420707430899391e-22,  1.266718286116468e-04, -6.221014631892313e-06,  2.049691226182533e-07, -5.277682492532232e-09,  1.086928484856993e-10, -2.011092121748936e-12,
  4.882356339491003e-14, -1.450935023944095e-15,  2.352194001170311e-17,  4.103622620397250e-19, -1.978758449413052e-20, -5.756246321804399e-22,  2.230077364200064e-04,
 -1.112942260849733e-05,  3.874141738655556e-07, -1.145456231527281e-08,  3.059215812647235e-10, -7.600259974220284e-12,  1.791077256763222e-13, -4.024026345210421e-15,
  8.472382623378875e-17, -1.668646386605453e-18,  3.436773523807701e-20, -8.356497304753627e-22,  7.215562825464444e-05, -3.710692426901621e-06,  1.420612935872250e-07,
 -5.102722149631747e-09,  1.762998737965271e-10, -5.447967517373287e-12,  1.416246874366160e-13, -3.307021651011245e-15,  9.070119693906844e-17, -3.003831525761024e-18,
  7.703980678781136e-20, -7.513291787745971e-22,  5.001808023680669e-06, -2.726675702666541e-07,  1.227477717686872e-08, -5.666323724176670e-10,  2.497581362260269e-11,
 -9.434482450275982e-13,  3.001130480419429e-14, -8.983673396161132e-16,  2.990139490907844e-17, -1.036565147558922e-18,  2.896241608267199e-20, -5.403511630131031e-22,
  4.447631261114647e-08, -2.807398099869791e-09,  1.737843287906583e-10, -1.134845241431887e-11,  6.648749917998091e-13, -3.312556885686862e-14,  1.463692592611804e-15,
 -6.172128740225733e-17,  2.558235943155865e-18, -9.980850358595832e-20,  3.477751553307830e-21, -1.093491138310287e-22,  1.047043253290024e-04, -4.807731117182320e-06,
  1.509165609133080e-07, -3.808872519656758e-09,  7.737351693602852e-11, -1.234171791755293e-12,  1.975111723733676e-14, -6.300752444539966e-16,  2.296137207864861e-17,
 -3.670530001716714e-19, -1.031615533854577e-20,  6.065535501795046e-22,  1.839220725788865e-04, -8.506922558089270e-06,  2.749754858194518e-07, -7.575729155920075e-09,
  1.891530952460022e-10, -4.394926493109528e-12,  9.690442004823884e-14, -2.066753284708218e-15,  4.260724535142515e-17, -8.084182463243065e-19,  1.320020382213434e-20,
 -2.180645581822418e-22,  5.925615864182310e-05, -2.778396425284432e-06,  9.468176412837525e-08, -2.995587563588181e-09,  9.517279151012024e-11, -2.912630731864797e-12,
  7.721447343062993e-14, -1.616070330450134e-15,  2.838932381436865e-17, -7.557493934369381e-19,  3.298163269217529e-20, -1.037378264752579e-21,  4.072446527700862e-06,
 -1.960899480126389e-07,  7.357451956926639e-09, -2.858150012666865e-10,  1.171026867814405e-11, -4.444349700997691e-13,  1.399561843978622e-14, -3.560269756453769e-16,
  8.499228931925787e-18, -2.725528602570424e-19,  1.068573507486405e-20, -3.198068352472181e-22,  3.536643911451993e-08, -1.821318114842652e-09,  8.446906890955653e-11,
 -4.557694073919610e-12,  2.502580969718204e-13, -1.203486091790576e-14,  4.895373516607074e-16, -1.769803634218668e-17,  6.317433170343184e-19, -2.380399755179518e-20,
  8.842659326901014e-22, -2.856475175564995e-23,  8.762601066373857e-05, -3.763911838905187e-06,  1.118936508913937e-07, -2.747287406913899e-09,  5.637219039950580e-11,
 -9.026706219817214e-13,  1.011981545847220e-14, -1.394553589997914e-16,  7.865225153853096e-18, -3.554389594497713e-19,  6.974222651932073e-21,  1.104007919943473e-22,
  1.537829892341501e-04, -6.625250864276644e-06,  1.996863327461043e-07, -5.143319894205582e-09,  1.205183687952825e-10, -2.633214771513318e-12,  5.438663967249018e-14,
 -1.081804740508205e-15,  2.127457692235343e-17, -4.141475416848841e-19,  7.339420925160924e-21, -9.514435085191734e-23,  4.946126473623667e-05, -2.142686324468122e-06,
  6.623697469658017e-08, -1.851943020074312e-09,  5.223687608696231e-11, -1.517871686539010e-12,  4.194582954825863e-14, -9.661695192205393e-16,  1.571688811719113e-17,
 -1.458546574175999e-19,  3.182392385048800e-21, -2.943050297178106e-22,  3.387821253870082e-06, -1.483361395744114e-07,  4.809513921539032e-09, -1.542385230326817e-10,
  5.502171248146739e-12, -2.041559710902644e-13,  6.808066107436817e-15, -1.820079926511394e-16,  3.611316717240242e-18, -5.800418602825468e-20,  1.729459700545574e-21,
 -9.410232087463608e-23,  2.916263728774801e-08, -1.311108916374993e-09,  4.754680439535306e-11, -1.976330859226212e-12,  9.607899799116103e-14, -4.546690373005637e-15,
  1.852533422519602e-16, -6.300164954078417e-18,  1.860154237342604e-19, -5.458029729900866e-21,  1.869519213899850e-22, -7.045638691257675e-24,  7.417180773881598e-05,
 -2.986590494389782e-06,  8.378222950669541e-08, -1.977510968483564e-09,  4.053541398680826e-11, -6.880153554965524e-13,  8.217233856545950e-15, -3.640318775862509e-17,
  2.089864585793760e-19, -8.664128817194958e-20,  4.829878600091876e-21, -1.198062644051934e-22,  1.301276009897494e-04, -5.245446349398245e-06,  1.480029088581769e-07,
 -3.574493013671762e-09,  7.879920105303334e-11, -1.626438242572192e-12,  3.174439616676104e-14, -5.906642719515127e-16,  1.070692784295428e-17, -1.968833202671573e-19,
  3.731644549178603e-21, -6.610959023283561e-23,  4.182697718417081e-05, -1.689468873813411e-06,  4.818098643868008e-08, -1.212547814936489e-09,  3.003001189859519e-11,
 -7.833915158718284e-13,  2.122074828014617e-14, -5.386124193626785e-16,  1.100869197906318e-17, -1.362471108266657e-19, -3.584555355449786e-22,  3.410036247718682e-23,
  2.861473710220972e-06, -1.160272491395974e-07,  3.376658712976125e-09, -9.151007557535288e-11,  2.700732408794075e-12, -9.046176519487148e-14,  3.076997120723872e-15,
 -9.204148317066947e-17,  2.145596084136983e-18, -3.287961477082292e-20,  1.876713285389767e-22, -1.530396295228102e-24,  2.455819659065949e-08, -1.005061801511656e-09,
  3.069712478378231e-11, -9.747596106098694e-13,  3.817173220116869e-14, -1.686708568476689e-15,  7.023099790336675e-17, -2.494468596919911e-18,  7.284039054727528e-20,
 -1.760417956476565e-21,  3.967824297573837e-23, -1.145324951153131e-24,  6.342994296835639e-05, -2.401205478077721e-06,  6.352314503261917e-08, -1.428670276931433e-09,
  2.866041559128938e-11, -5.040719344984713e-13,  7.031615874474186e-15, -5.201174099777671e-17, -5.949540408608413e-19,  1.473045234922918e-20,  7.550686325083436e-22,
 -5.408645886471071e-23,  1.112695079712509e-04, -4.213793959594192e-06,  1.117205029158985e-07, -2.537542591091840e-09,  5.272509792110421e-11, -1.029967289918592e-12,
  1.911271012849931e-14, -3.376570264883490e-16,  5.706716805484467e-18, -9.469332001025503e-20,  1.638119109445484e-21, -3.085207708826826e-23,  3.575800409856872e-05,
 -1.355088838229911e-06,  3.607347811096159e-08, -8.342081784409758e-10,  1.841999319088346e-11, -4.198077474010743e-13,  1.033393622314097e-14, -2.642003183792047e-16,
  6.259981356597011e-18, -1.170810893660042e-19,  1.155771390980058e-21,  1.746496419103722e-23,  2.445320436246096e-06, -9.278712783624795e-08,  2.489012900856025e-09,
 -5.950997241367461e-11,  1.456876402453035e-12, -4.082110523259995e-14,  1.294041510699270e-15, -4.074730403904765e-17,  1.115828870877168e-18, -2.349870014380930e-20,
  2.924202203091567e-22,  1.321444572828131e-24,  2.096692537151311e-08, -7.979603261706532e-10,  2.179299564869404e-11, -5.619706666610756e-13,  1.678194807379477e-14,
 -6.254127332015256e-16,  2.524658722282291e-17, -9.418777163856188e-19,  2.991692450986180e-20, -7.740255572781590e-22,  1.571244081984539e-23, -2.517768890822431e-25,
  5.474297976223369e-05, -1.954510065092348e-06,  4.882608594283368e-08, -1.042112205443222e-09,  2.014001754659729e-11, -3.543345022226687e-13,  5.409066218854749e-15,
 -6.019181225950252e-17,  8.320091412570212e-20,  1.605242666761150e-20, -3.279365800859938e-22, -4.353323748509880e-24,  9.602737548263208e-05, -3.428908960459820e-06,
  8.572458551714171e-08, -1.836692421918621e-09,  3.604173578766008e-11, -6.668348543340718e-13,  1.177937150432846e-14, -1.991648698831008e-16,  3.213825370955790e-18,
 -4.957471145764982e-20,  7.525516282397368e-22, -1.220148441170338e-23,  3.085775339225996e-05, -1.102094322706546e-06,  2.759188260066029e-08, -5.953365513733902e-10,
  1.200647894837980e-11, -2.414801979623723e-13,  5.175967250630716e-15, -1.215951953972531e-16,  2.958613643026354e-18, -6.638132735223889e-20,  1.174487031157570e-21,
 -1.057394860858676e-23,  2.109962783277071e-06, -7.538798126778461e-08,  1.892372068581009e-09, -4.136842836967513e-11,  8.764423464162517e-13, -2.012043280730695e-14,
  5.420778445036143e-16, -1.630675897128160e-17,  4.793085775049392e-19, -1.223004355058323e-20,  2.411209299898938e-22, -2.729903181071077e-24,  1.808647652568871e-08,
 -6.468006396447756e-10,  1.633382792894848e-11, -3.679154016412101e-13,  8.660760720078107e-15, -2.496754133381585e-16,  8.842037228947853e-18, -3.277932004918776e-19,
  1.112478789392816e-20, -3.227980979078745e-22,  7.635120823154819e-24, -1.370782757032638e-25,  4.763403433720410e-05, -1.608940243452458e-06,  3.804162867238840e-08,
 -7.700737188276635e-10,  1.421846735288489e-11, -2.440003453694391e-13,  3.829176804009649e-15, -5.088559406873025e-17,  4.225441366694292e-19,  3.505459050047861e-21,
 -2.374753364779721e-22,  4.685474688995624e-24,  8.355636323772627e-05, -2.822392586401798e-06,  6.674920845914056e-08, -1.353064161040900e-09,  2.513412601155220e-11,
 -4.408923680064107e-13,  7.410407059761203e-15, -1.199547818858931e-16,  1.865680425146133e-18, -2.768122048099355e-20,  3.907555288679278e-22, -5.399518769267355e-24,
  2.684977626336204e-05, -9.069979075908009e-07,  2.146019706876234e-08, -4.361106590404038e-10,  8.190351088132713e-12, -1.493232795337073e-13,  2.796325304922839e-15,
 -5.710264245094531e-17,  1.288200037372579e-18, -2.999491920410475e-20,  6.442109591519130e-22, -1.107174100806710e-23,  1.835846020287598e-06, -6.202294784914193e-08,
  1.468740395158542e-09, -2.998641315180202e-11,  5.746026515037828e-13, -1.120273476862660e-14,  2.458938207895322e-16, -6.395016726459424e-18,  1.827309841132287e-19,
 -5.047719082436082e-21,  1.216239202718965e-22, -2.306157884382153e-24,  1.573555750374170e-08, -5.317517993004914e-10,  1.261579235762071e-11, -2.602771149387741e-13,
  5.215044939052579e-15, -1.162762512055489e-16,  3.258991286753061e-18, -1.093024387849817e-19,  3.741799449930222e-21, -1.169321615929244e-22,  3.150081743977593e-24,
 -6.984412407268491e-26,  4.175342280370033e-05, -1.338044059175539e-06,  3.001959577244397e-08, -5.770810642850249e-10,  1.015023842807379e-11, -1.676089563456867e-13,
  2.601840717136967e-15, -3.679230910205992e-17,  4.244548282718651e-19, -2.254324752230860e-21, -6.592933999529827e-23,  2.714978515751548e-24,  7.324078802055855e-05,
 -2.347122106168379e-06,  5.266277537969329e-08, -1.012829165717143e-09,  1.785403637178308e-11, -2.974244288584876e-13,  4.756797027619783e-15, -7.358665601772566e-17,
  1.101966235130543e-18, -1.588081422338423e-20,  2.177864571670897e-22, -2.817109118815049e-24,  2.353487613738205e-05, -7.542275461640173e-07,  1.692509287017729e-08,
 -3.257813778345421e-10,  5.765911284035291e-12, -9.758163134553433e-14,  1.642634388505743e-15, -2.904213652374678e-17,  5.692952327738420e-19, -1.237151294259597e-20,
  2.766130039727553e-22, -5.726375973521831e-24,  1.609175610367559e-06, -5.157128607760190e-08,  1.157568315944557e-09, -2.231541246507842e-11,  3.978685843446928e-13,
 -6.928085546748884e-15,  1.270350995841660e-16, -2.691904327368860e-18,  6.757972531716702e-20, -1.835337687329535e-21,  4.789951530779263e-23, -1.099456975745868e-24,
  1.379242096519009e-08, -4.420537267694897e-10,  9.927784254527827e-12, -1.920303464356375e-13,  3.479937810955304e-15, -6.440772669444077e-17,  1.385072203576744e-18,
 -3.770654453791758e-20,  1.194716069001525e-21, -3.797142235265665e-23,  1.102939625095901e-24, -2.789444892267795e-26,  3.684128951729430e-05, -1.123060672621179e-06,
  2.396852120659757e-08, -4.384256299793806e-10,  7.346620200481585e-12, -1.160803454523280e-13,  1.747129962291072e-15, -2.482503086846401e-17,  3.184138394695905e-19,
 -3.165911886524408e-21,  6.273834695528974e-24,  7.876059786725002e-25,  6.462423574158128e-05, -1.969994399398725e-06,  4.204485025364293e-08, -7.691847037867962e-10,
  1.289883746639120e-11, -2.044753573132759e-13,  3.114819466616022e-15, -4.600568009378213e-17,  6.611525625981369e-19, -9.225754262276287e-21,  1.239200214996610e-22,
 -1.577565752855338e-24,  2.076604262678495e-05, -6.330316276375939e-07,  1.351110198731917e-08, -2.472419161338523e-10,  4.151778862177093e-12, -6.620397389449950e-14,
  1.030283835541510e-15, -1.623388658676524e-17,  2.734293772459337e-19, -5.166566664154277e-21,  1.082987002426496e-22, -2.329127790294375e-24,  1.419855704485402e-06,
 -4.328322528162077e-08,  9.238818959746698e-10, -1.691425416632350e-11,  2.847353714731738e-13, -4.589237342352719e-15,  7.416949574651364e-17, -1.296003160826656e-18,
  2.662145611627706e-20, -6.441870055370422e-22,  1.663969666296834e-23, -4.118020773176193e-25,  1.216967645060423e-08, -3.709900463925367e-10,  7.920011789545581e-12,
 -1.451452892815178e-13,  2.456590390908667e-15, -4.052520310479141e-17,  7.079774737233141e-19, -1.480220782681883e-20,  3.899547384442108e-22, -1.166070582333273e-23,
  3.458056585528788e-25, -9.399472891400783e-27,  3.270182860485789e-05, -9.505213867552022e-07,  1.934285726431377e-08, -3.373912449160072e-10,  5.393535610515019e-12,
 -8.144130844049430e-14,  1.178189326021130e-15, -1.636169355251027e-17,  2.145733280070987e-19, -2.508183318310591e-21,  2.125122026579547e-23,  3.985120480997188e-26,
  5.736309187867239e-05, -1.667334405571563e-06,  3.393002436194517e-08, -5.918562182420554e-10,  9.463713984755907e-12, -1.430626447163864e-13,  2.079032624496757e-15,
 -2.932756878295852e-17,  4.036695196376574e-19, -5.427061088461987e-21,  7.097510345042652e-23, -8.928695223712764e-25,  1.843277511033983e-05, -5.357737432172930e-07,
  1.090304332831727e-08, -1.902013008739801e-10,  3.042624381279901e-12, -4.608931219907443e-14,  6.752399051564392e-16, -9.790450367055261e-18,  1.457530771496784e-19,
 -2.352263357046681e-21,  4.293086086149289e-23, -8.679784291284928e-25,  1.260320296174880e-06, -3.663300862235466e-08,  7.454997748920027e-10, -1.300689068643187e-11,
  2.082328047039320e-13, -3.165951862867384e-15,  4.706476650692888e-17, -7.156216439014102e-19,  1.201048372191329e-20, -2.393840430336792e-22,  5.573832603311034e-24,
 -1.369922280423518e-25,  1.080227433770064e-08, -3.139849450512318e-10,  6.390011680417095e-12, -1.115203894990545e-13,  1.788363073222924e-15, -2.740662218381947e-17,
  4.202563939215224e-19, -7.019947705031373e-21,  1.430302353194586e-22, -3.631884831264127e-24,  1.025149016610812e-25, -2.847890353805582e-27,  2.918550664281311e-05,
 -8.106207960398502e-07,  1.576277294005036e-08, -2.627317405392210e-10,  4.014043811171879e-12, -5.796397439797803e-14,  8.037809636380416e-16, -1.077751126005236e-17,
  1.392839154599084e-19, -1.696588519869154e-21,  1.814326113332262e-23, -1.290709391451533e-25,  5.119502155772330e-05, -1.421930307566652e-06,  2.764992243894155e-08,
 -4.608708300782727e-10,  7.041757371473291e-12, -1.017229413076566e-13,  1.412835270329335e-15, -1.905690355795511e-17,  2.511478044435317e-19, -3.243367363766784e-21,
  4.101951908277341e-23, -5.051317515170840e-25,  1.645075622071806e-05, -4.569162277095805e-07,  8.884919105768126e-09, -1.480977095919901e-10,  2.263120688675803e-12,
 -3.271410298401542e-14,  4.556689915619447e-16, -6.211659743260417e-18,  8.468047148354064e-20, -1.198898308582969e-21,  1.860612249359831e-23, -3.281043272223116e-25,
  1.124801815665225e-06, -3.124114633083761e-08,  6.074997795173987e-10, -1.012646590983287e-11,  1.547817336335077e-13, -2.240089209348775e-15,  3.136243891276315e-17,
 -4.356547074043552e-19,  6.288899412883064e-21, -1.018329458897056e-22,  1.968114962434862e-24, -4.400800711814181e-26,  9.640735123295345e-09, -2.677697918414917e-10,
  5.206973555560344e-12, -8.680246134442034e-14,  1.327417578064254e-15, -1.925958389391314e-17,  2.725978097527009e-19, -3.937847235777559e-21,  6.336780424478252e-23,
 -1.257392977759223e-24,  3.067363413069035e-26, -8.175678325367530e-28,  2.617669344431699e-05, -6.961196867108733e-07,  1.296021919317167e-08, -2.068273615553195e-10,
  3.025609142048091e-12, -4.184253445300180e-14,  5.561603559981037e-16, -7.169033515197898e-18,  8.985929745879844e-20, -1.087724969286754e-21,  1.237019103181517e-23,
 -1.214717125228131e-25,  4.591718713873115e-05, -1.221080858053619e-06,  2.273385267802472e-08, -3.628024070723283e-10,  5.307431600316507e-12, -7.340741966219108e-14,
  9.762318092736338e-16, -1.261056932296676e-17,  1.592502939555239e-19, -1.973695977109298e-21,  2.404221705020606e-23, -2.873046527552175e-25,  1.475480259856998e-05,
 -3.923761339528563e-07,  7.305190276285089e-09, -1.165819339765029e-10,  1.705541126753180e-12, -2.359431689462901e-14,  3.140743726475567e-16, -4.072478480845898e-18,
  5.211287967354315e-20, -6.723898153160448e-22,  9.094863784355674e-24, -1.359707846411326e-25,  1.008842873863763e-06, -2.682827612517095e-08,  4.994848185847905e-10,
 -7.971252824229799e-12,  1.166237394761291e-13, -1.613954107579901e-15,  2.152042510618938e-17, -2.809384495242848e-19,  3.679477981318989e-21, -5.073762174203533e-23,
  7.944190251840541e-25, -1.486084969532693e-26,  8.646844378136600e-09, -2.299466000942509e-10,  4.281122703403660e-12, -6.832367623863620e-14,  9.997511220449362e-16,
 -1.384603362490831e-17,  1.852767968840403e-19, -2.453156059297557e-21,  3.368357688126603e-23, -5.242890211143328e-25,  1.011143175172392e-26, -2.362666430544074e-28,
  2.358494285524481e-05, -6.016018863026775e-07,  1.074330912518251e-08, -1.644500228268981e-10,  2.307514956879442e-12, -3.061156482012776e-14,  3.904210738315896e-16,
 -4.834376912708345e-18,  5.841844606798621e-20, -6.888731077650277e-22,  7.850661708912755e-24, -8.373332469788869e-26,  4.137093305018466e-05, -1.055284796098755e-06,
  1.884510713464821e-08, -2.884661549392387e-10,  4.047697876901106e-12, -5.369873956842707e-14,  6.849911856726646e-16, -8.487963436470820e-18,  1.028448459603799e-19,
 -1.223772407380309e-21,  1.433686577566801e-23, -1.654243229991430e-25,  1.329393165739231e-05, -3.391000195484396e-07,  6.055595066376427e-09, -9.269445728315817e-11,
  1.300683533125042e-12, -1.725655854503282e-14,  2.201937498983922e-16, -2.731979759841238e-18,  3.326110234192993e-20, -4.021255020369582e-22,  4.934833765707501e-24,
 -6.396048235945113e-26,  9.089574749496864e-07, -2.318557931932584e-08,  4.140445814640991e-10, -6.337897860866768e-12,  8.893470025918062e-14, -1.180050084339916e-15,
  1.506540311568096e-17, -1.873424447560990e-19,  2.300284900530639e-21, -2.858907524152426e-23,  3.781308500302801e-25, -5.727364065270590e-27,  7.790721344271468e-09,
 -1.987248066751891e-10,  3.548799948153675e-12, -5.432278485199290e-14,  7.622973694666529e-16, -1.011692486238578e-17,  1.293006139611334e-19, -1.615446767338511e-21,
  2.018624923314155e-23, -2.650454212319970e-25,  3.997488353815043e-27, -7.471024275156562e-29,  2.133875869969308e-05, -5.229648062746505e-07,  8.972758589886507e-09,
 -1.319610211297419e-10,  1.779022186609260e-12, -2.267548346504825e-14,  2.778951828193770e-16, -3.307766639817118e-18,  3.847552103223077e-20, -4.385880163961314e-22,
  4.889901681133252e-24, -5.268800888554201e-26,  3.743084570730573e-05, -9.173455351759594e-07,  1.573933875933643e-08, -2.314761585599719e-10,  3.120632845830365e-12,
 -3.977609574496490e-14,  4.874934448158422e-16, -5.803937624914491e-18,  6.757286861068072e-20, -7.728108553596728e-22,  8.708189240010789e-24, -9.682448783619238e-26,
  1.202784340411489e-05, -2.947752924265819e-07,  5.057601763858642e-09, -7.438144100989531e-11,  1.002772112390157e-12, -1.278171926049664e-14,  1.566661098212371e-16,
 -1.865977412691558e-18,  2.176035677416987e-20, -2.503214081205891e-22,  2.873444575247225e-24, -3.365789636969722e-26,  8.223901275017886e-07, -2.015492585468827e-08,
  3.458078039797426e-10, -5.085750478774729e-12,  6.856379978340477e-14, -8.739670563695140e-16,  1.071394548534375e-17, -1.277006057464321e-19,  1.493504635169364e-21,
 -1.735775697995513e-23,  2.056888627665957e-25, -2.615798821231364e-27,  7.048748125688571e-09, -1.727489095504290e-10,  2.963936986441695e-12, -4.359029592241837e-14,
  5.876705850795904e-16, -7.491356863563777e-18,  9.186572301241619e-20, -1.096564148960142e-21,  1.290097207182077e-23, -1.531068320680770e-25,  1.930069047789282e-27,
 -2.820600455907558e-29,  1.938107506373657e-05, -4.570652317250776e-07,  7.546140077753755e-09, -1.067915294804289e-10,  1.385367044025592e-12, -1.699162522165635e-14,
  2.003860462615506e-16, -2.295546332492464e-18,  2.571063254006803e-20, -2.826627589073056e-22,  3.054287664065548e-24, -3.232465404515145e-26,  3.399682429846387e-05,
 -8.017494557381626e-07,  1.323687149559319e-08, -1.873256815113845e-10,  2.430107875835289e-12, -2.980552681566806e-14,  3.515084817877559e-16, -4.027033153634277e-18,
  4.511721366973598e-20, -4.965829356799117e-22,  5.386682620501918e-24, -5.770383130263357e-26,  1.092437189388141e-05, -2.576302171997640e-07,  4.253471069493251e-09,
 -6.019431752816301e-11,  7.808795547159887e-13, -9.577614955272491e-15,  1.129555885875793e-16, -1.294229958683157e-18,  1.450771457925966e-20, -1.600009678404763e-22,
  1.747558768505059e-24, -1.911761778771436e-26,  7.469415164009046e-07, -1.761517341879436e-08,  2.908262575189985e-10, -4.115718852289054e-12,  5.339183142620952e-14,
 -6.548649138784619e-16,  7.723635696313803e-18, -8.851570975707664e-20,  9.931437770488071e-22, -1.099189070744292e-23,  1.215039591510152e-25, -1.377388691577889e-27,
  6.402074190611659e-09, -1.509805586711596e-10,  2.492686920787330e-12, -3.527605118461055e-14,  4.576254620452900e-16, -5.612988582572664e-18,  6.620693099360841e-20,
 -7.590887648308282e-22,  8.533028862529625e-24, -9.512408971660090e-26,  1.077192532587923e-27, -1.306782370351678e-29,  1.766593616542157e-05, -4.014695163797651e-07,
  6.387212985904166e-09, -8.710330702869521e-11,  1.088864334750054e-12, -1.286931757451827e-14,  1.462526123634674e-16, -1.614565720996958e-18,  1.742961479057740e-20,
 -1.848010559593152e-22,  1.929399379782151e-24, -1.983753459232839e-26,  3.098825663139685e-05, -7.042276326702799e-07,  1.120396867824339e-08, -1.527900728009268e-10,
  1.910004163302968e-12, -2.257440821014472e-14,  2.565466210640573e-16, -2.832223413031385e-18,  3.057737948257935e-20, -3.243244882781682e-22,  3.390674843273127e-24,
 -3.501773870952113e-26,  9.957613593448887e-06, -2.262930352216786e-07,  3.600228061688409e-09, -4.909680994038687e-11,  6.137514528311684e-13, -7.253959787508084e-15,
  8.243815044929926e-17, -9.101342325862072e-19,  9.827653402025995e-21, -1.043077505347115e-22,  1.093106853816459e-24, -1.137808151647569e-26,  6.808405159472028e-07,
 -1.547252918195046e-08,  2.461615043702673e-10, -3.356938749282559e-12,  4.196457376734788e-14, -4.959825217397911e-16,  5.636700211743779e-18, -6.223430827207915e-20,
  6.722006042054873e-22, -7.142785614478145e-24,  7.516800766740321e-26, -7.931430215778906e-28,  5.835519111861255e-09, -1.326158442289631e-10,  2.109862944531522e-12,
 -2.877249733463450e-14,  3.596807790532215e-16, -4.251112801385868e-18,  4.831388205901659e-20, -5.334967068897233e-22,  5.765668127503063e-24, -6.140845643827399e-26,
  6.517237310111697e-28, -7.065336730886643e-30,  1.615602746307597e-05, -3.542749944054015e-07,  5.438588868807739e-09, -7.156416565515953e-11,  8.632182258149588e-13,
 -9.844377522384346e-15,  1.079501728485046e-16, -1.149920521135471e-18,  1.197885795631339e-20, -1.225843862791549e-22,  1.236099695511549e-24, -1.230092825119901e-26,
  2.833968834025225e-05, -6.214425514803444e-07,  9.539963580646541e-09, -1.255324777633637e-10,  1.514192538318079e-12, -1.726827045922252e-14,  1.893583305392579e-16,
 -2.017118906131180e-18,  2.101315711366703e-20, -2.150614265295625e-22,  2.169586966190047e-24, -2.162429768579827e-26,  9.106535717866021e-06, -1.996912853787402e-07,
  3.065524860500896e-09, -4.033798769655766e-11,  4.865631899994672e-13, -5.548902992717277e-15,  6.084761563505946e-17, -6.481793596813841e-19,  6.752683855763772e-21,
 -6.912546588360526e-23,  6.979078327058000e-25, -6.975282111977073e-27,  6.226490331598112e-07, -1.365366475601439e-08,  2.096017795976270e-10, -2.758064107036398e-12,
  3.326820828767843e-14, -3.794001834740395e-16,  4.160403369457138e-18, -4.431950457162266e-20,  4.617565935073924e-22, -4.728589958141773e-24,  4.780718343684682e-26,
 -4.801150605396786e-28,  5.336756917023267e-09, -1.170262635266932e-10,  1.796507646588382e-12, -2.363950991851572e-14,  2.851435748781508e-16, -3.251862559465825e-18,
  3.565931014643503e-20, -3.798810970385581e-22,  3.958573607511296e-24, -4.056660494875345e-26,  4.112747023796927e-28, -4.170239093832552e-30,  1.482081886777339e-05,
 -3.139806683054424e-07,  4.656618379663037e-09, -5.919722443437089e-11,  6.898384177216789e-13, -7.600392042981316e-15,  8.051786904494687e-17, -8.286278022372831e-19,
  8.339441378434024e-21, -8.245465244833819e-23,  8.035170131864774e-25, -7.733574995461029e-27,  2.599756583847532e-05, -5.507612750109783e-07,  8.168289755049926e-09,
 -1.038393191821129e-10,  1.210062680972122e-12, -1.333203685245460e-14,  1.412384403521083e-16, -1.453519492957455e-18,  1.462856954542058e-20, -1.446424359081232e-22,
  1.409737900819321e-24, -1.357539641456328e-26,  8.353929621339652e-06, -1.769789124962183e-07,  2.624757955158164e-09, -3.336721487679269e-11,  3.888355804002774e-13,
 -4.284051392244882e-15,  4.538489190042268e-17, -4.670684209197245e-19,  4.700755759545886e-21, -4.648244434564821e-23,  4.531496473229439e-25, -4.367752883037104e-27,
  5.711904463943980e-07, -1.210073206439317e-08,  1.794648430581486e-10, -2.281445411909133e-12,  2.658619159480962e-14, -2.929171936194781e-16,  3.103143662919870e-18,
 -3.193546340678222e-20,  3.214186032981436e-22, -3.178626414292006e-24,  3.100148474472735e-26, -2.992932174950001e-28,  4.895702720750715e-09, -1.037159974687003e-10,
  1.538202409277156e-12, -1.955438616174668e-14,  2.278716260201701e-16, -2.510609114403764e-18,  2.659725736267370e-20, -2.737236541290273e-22,  2.755057936466088e-24,
 -2.725157954030839e-26,  2.660175115453410e-28, -2.576380214331116e-30,  1.363515358035694e-05, -2.793924595164146e-07,  4.007779702541088e-09, -4.927825625414840e-11,
  5.554205038398894e-13, -5.918763106059858e-15,  6.064677079139538e-17, -6.036646730216073e-19,  5.876194571758949e-21, -5.619611066528313e-23,  5.297270421617225e-25,
 -4.933141446792446e-27,  2.391776096081678e-05, -4.900892404030093e-07,  7.030145743913564e-09, -8.644021110023559e-11,  9.742768783626879e-13, -1.038224925074312e-14,
  1.063820138839185e-16, -1.058903735857202e-18,  1.030760768839654e-20, -9.857631395922199e-23,  9.292611508656344e-25, -8.655320653348047e-27,  7.685615376763447e-06,
 -1.574828600471994e-07,  2.259032370142944e-09, -2.777627123635814e-11,  3.130693291863724e-13, -3.336180859845892e-15,  3.418427714104327e-17, -3.402632208934233e-19,
  3.312212087559032e-21, -3.167676731805130e-23,  2.986343896966794e-25, -2.782368788127094e-27,  5.254952192381706e-07, -1.076771162882004e-08,  1.544587716761439e-10,
 -1.899170988297741e-12,  2.140575979005285e-14, -2.281075847127626e-16,  2.337311727698861e-18, -2.326514776302132e-20,  2.264706319157798e-22, -2.165949557063047e-24,
  2.042233014957391e-26, -1.903721716529646e-28,  4.504046576412982e-09, -9.229061068943231e-11,  1.323874083639178e-12, -1.627789232564858e-14,  1.834698708310679e-16,
 -1.955121995126708e-18,  2.003322917869586e-20, -1.994073781621238e-22,  1.941122598731791e-24, -1.856589880499647e-26,  1.750999172438166e-28, -1.633887903656180e-30,
  1.257816510451816e-05, -2.495530135977138e-07,  3.466095952405115e-09, -4.126483408947733e-11,  4.503337376988884e-13, -4.646556562715284e-15,  4.609943498318444e-17,
 -4.442949901232835e-19,  4.187551280406876e-21, -3.877584107291580e-23,  3.539230998145927e-25, -3.191712416147121e-27,  2.206367126872235e-05, -4.377471284871559e-07,
  6.079964847377463e-09, -7.238366858602056e-11,  7.899415750338385e-13, -8.150640097836221e-15,  8.086416369000183e-17, -7.793489657839248e-19,  7.345493125448958e-21,
 -6.801792130933166e-23,  6.208358516713990e-25, -5.599054071754251e-27,  7.089831336994076e-06, -1.406635038851495e-07,  1.953705925818549e-09, -2.325941116568416e-11,
  2.538359309580813e-13, -2.619086515385170e-15,  2.598449265168100e-17, -2.504322139377234e-19,  2.360367660970642e-21, -2.185668689034843e-23,  1.995022388131050e-25,
 -1.799392140798647e-27,  4.847591624294620e-07, -9.617707260820612e-09,  1.335824229415589e-10, -1.590335812047637e-12,  1.735574339869088e-14, -1.790770664209950e-16,
  1.776660278086705e-18, -1.712302502154773e-20,  1.613878182400804e-22, -1.494442801160827e-24,  1.364142775682916e-26, -1.230571069040643e-28,  4.154895736425556e-09,
 -8.243386404900345e-11,  1.144941823832358e-12, -1.363085011798427e-14,  1.487569704513515e-16, -1.534878781628631e-18,  1.522784857067091e-20, -1.467624411258098e-22,
  1.383269180122630e-24, -1.280921919136856e-26,  1.169327326660909e-28, -1.055155410559418e-30  };
  int offset = -5;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 5;
    if (std::isnan(t)) {
      fill_n(rr+offset, 5, 0.5);
      fill_n(ww+offset, 5, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 5; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=5; ++j) {
        const int boxof = it*60+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
