/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.xpath.XPathException;

public class DocumentInstr
extends ExprInstruction {
    private static final int[] treeSizeParameters = new int[]{50, 10, 5, 200};
    boolean textOnly = false;
    String constantText = null;
    String baseURI = null;
    private int validationAction = 3;
    private SchemaType schemaType;

    public DocumentInstr(boolean bl, String string, String string2) {
        this.textOnly = bl;
        this.constantText = string;
        this.baseURI = string2;
    }

    public void setValidationAction(int n) {
        this.validationAction = n;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public SequenceType getResultType() {
        return new SequenceType(NodeKindTest.DOCUMENT, 512);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        int n = 0;
        while (n < this.children.length) {
            if (!(this.children[n] instanceof ExprInstruction)) {
                throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
            }
            this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
            ++n;
        }
        return this;
    }

    public void getXPathExpressions(List list) {
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n] instanceof ExprInstruction) {
                Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
            } else {
                throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
            }
            ++n;
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Item item = this.evaluateItem(xPathContext);
        if (item != null) {
            sequenceReceiver.append(item);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller = xPathContext.getController();
            DocumentInfo documentInfo = null;
            if (this.textOnly) {
                String string;
                if (this.constantText != null) {
                    string = this.constantText;
                } else {
                    SequenceReceiver sequenceReceiver = controller.getReceiver();
                    StringBuffer stringBuffer = new StringBuffer();
                    controller.changeToTextOutputDestination(stringBuffer);
                    this.processChildren(xPathContext);
                    controller.resetOutputDestination(sequenceReceiver);
                    string = stringBuffer.toString();
                }
                documentInfo = new TextFragmentValue(string, this.baseURI);
                documentInfo.setNamePool(controller.getNamePool());
            } else {
                SequenceReceiver sequenceReceiver = controller.getReceiver();
                TinyBuilder tinyBuilder = new TinyBuilder();
                tinyBuilder.setSizeParameters(treeSizeParameters);
                TinyBuilder tinyBuilder2 = tinyBuilder;
                tinyBuilder2.setSystemId(this.baseURI);
                tinyBuilder2.setNamePool(controller.getNamePool());
                tinyBuilder2.startDocument();
                controller.changeOutputDestination(null, tinyBuilder2, false, this.validationAction, this.schemaType);
                this.processChildren(xPathContext);
                controller.resetOutputDestination(sequenceReceiver);
                tinyBuilder2.endDocument();
                documentInfo = tinyBuilder.getCurrentDocument();
                ((TinyDocumentImpl)documentInfo).condense();
            }
            return documentInfo;
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("document-constructor");
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "document-constructor");
        if (this.children.length == 0) {
            System.err.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1, namePool);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

