#!/bin/sh

#
# palette2c.sh - make a header file out of a .vpl
#
# Written by
#  Marco van den Heuvel <blackystardust68@yahoo.com>
#
# This file is part of VICE, the Versatile Commodore Emulator.
# See README for copyright notice.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
#  02111-1307  USA.
#
# Usage: palette2c.sh <header-filename> <array-name>
#                      $1                $2
#

HEADERFILENAME=$1
ARRAYNAME=$2

echo Generating $HEADERFILENAME
echo >$HEADERFILENAME "/* Autogenerated file, do not edit */"
echo >>$HEADERFILENAME ""
echo >>$HEADERFILENAME "$ARRAYNAME = {"

entries=0
while read data
do
    if [ ${#data} -ne 0 ]; then
        if test x"${data:0:1}" != "x#"; then
            red=${data:0:2}
            green=${data:3:2}
            blue=${data:6:2}
            dither=${data:9:1}
            echo >>$HEADERFILENAME "    0x$red, 0x$green, 0x$blue, 0x$dither,"
            entries=`expr $entries + 1`
        fi
    fi
done
echo >>$HEADERFILENAME "    $entries };"
