/*
 * ssi2001-drv.c - SSI2001 (ISA SID card) support wrapper for the SDL port.
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#ifdef HAVE_SSI2001

#ifdef BEOS_COMPILE
#include "../beos/ssi2001-drv.c"
#endif

#ifdef UNIX_COMPILE
#include "../unix/ssi2001-drv.c"
#endif

#if defined(WIN32_COMPILE) && !defined(__XBOX__)
#include "../win32/ssi2001-drv.c"
#endif

#endif
