// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/mains/orp/main.cpp,v 1.42 2002/01/16 11:55:37 xli18 Exp $
//

#include "platform.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <assert.h>
#include <time.h>

#ifdef ORP_NT
#include "orp_process.h"
#elif defined (ORP_POSIX)
#include <signal.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/signal.h>
#include "method_lookup.h"
#endif

#include "Class.h"
#include "Package.h"
#include "properties.h"
#include "environment.h"
#include "Class_File_Loader.h"
 
#include "gc_for_orp.h"
 
#include "exceptions.h"
#include "orp_synch.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "compile.h"
#include "orp_synch.h"
#include "orp_stats.h"
#include "sync_bits.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#include "thread_generic_olv2.h"
#else
#include "object_generic.h"
#endif

#include "ini.h"

#ifdef ORP_POSIX
#include "platform2.h"
#endif

#include "exception_filter.h"
#include "thread_manager.h"
#include "jvmdi_clean.h"

#ifdef __cplusplus
extern "C" {
#endif

void free_this_thread_block(ORP_thread *);

#ifdef __cplusplus
}
#endif

union Scalar_Arg {
    int i;
    unsigned u;
    void *p;
};


bool use_classpath_awt_workaround = false;

// Multiple-JIT support.
#include "jit_intf.h"
#include "internal_jit_intf.h"

#if defined(USE_IA64_JIT)
#include "IA64_O1_JIT_intf.h"
#include "IA64_O3_JIT_intf.h"

#elif defined(USE_IA64_JIT_ON_IA32)
#include "IA64_O1_JIT_intf.h"
#include "IA64_O3_JIT_intf.h"
#include "level_1a_jit_intf.h"
#include "level_3_jit_intf.h"
#include "Dll_JIT_intf.h"

#elif defined(ORP_NT) || defined(ORP_POSIX)

#include "level_1a_jit_intf.h"
#include "level_3_jit_intf.h"
#include "Dll_Jit_intf.h"

#ifdef CLI_TESTING
#include "../../../common/cli/ia32_o0_cli/level_0_jit_cli_intf.h"
#ifdef CLI_O3_COMPILER 
#include "..\..\common\cli_loader\CLI_level_3_jit_intf.h"
#endif // CLI_O3_COMPILER
#endif // CLI_TESTING

#endif

Mem_Manager m(2048);
Class_Table class_table;
Package_Table package_table;
Properties properties;
//Global_Env env(m,class_table,package_table,NULL);
Global_Env env(m, class_table, package_table, properties, NULL);
orp_out orp_cout;

#ifdef ZIP_JAR_ARCHIVE

#include "jarfile_util.h"
extern Properties JarFile_Properties;
bool runjarfile = false;
ExpandableMemBlock class_path;
#endif

#if defined(USE_IA64_JIT)
IA64_O1_JIT  *ia64_o1_jit = NULL;
IA64_O3_JIT  *ia64_o3_jit = NULL;
bool recompilation_thread = false;

#elif defined(USE_IA64_JIT_ON_IA32)
//Level_0_JIT  *ia64_o0_jit = NULL;
IA64_O1_JIT  *ia64_o1_jit = NULL;
IA64_O3_JIT  *ia64_o3_jit = NULL;
JIT *o1_jit = NULL;
JIT *o3_jit = NULL;
bool recompilation_thread = false;

#else
ORPExport JIT *o3_jit = NULL;
ORPExport JIT *o1_jit = NULL;
ORPExport bool recompilation_thread = false;
#endif

ORPExport bool jvmdi_support = false;


ORPExport bool instrumenting = false;

// When this global is set to true (using the command line option "-collect"), 
// the ORP collects hot/cold field data and writes out the information in the form
// of text files on orp_exit.

ORPExport bool collect_hotfield_stats = false;
ORPExport bool split_object_fields_randomly = false;

static bool begin_shutdown_hooks = false;

void wait_until_non_daemon_threads_are_dead()
{

        // the following lines allow MSVC++ "Debug->>>Break" to work
        while (1) {
            DWORD stat = WaitForSingleObject(non_daemon_threads_dead_handle, 2000);
            if (stat == WAIT_OBJECT_0) break;
            assert(stat != WAIT_FAILED);

#ifdef _DEBUG
#if defined(USE_IA64_JIT)
#else
            extern bool enter_the_debugger;  // set to true w/ MSVC++ debugger
            void temp_jvmdi_debugger(uint32 *p_eip_arg);
            // temp_jvmdi_debugger(0);
#endif
#endif
        }

} //wait_until_non_daemon_threads_are_dead




void parse_args(int argc, char *argv[], Global_Env *p_env, String **classname, int *p_arg_num)
{
    int arg_num;
	for (arg_num = 1; arg_num < argc; arg_num++) {
		if (strcmp(argv[arg_num],"-classpath") == 0) {
			// class path argument
			arg_num++;
            if (arg_num >= argc) {
                ////orp_cout << "Bad classpath option" << endl;
                orp_cout << "Bad classpath option";
				exit(1);
            }
			p_env->classpath = argv[arg_num];
#ifdef ZIP_JAR_ARCHIVE
			class_path.AppendBlock(p_env->classpath);
			p_env->classpath = (char*)class_path.toString();
#endif
        } else if (strncmp(argv[arg_num], "-jit", 4) == 0) {
			arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad JIT option" << endl;
                exit(1);
            }
            JIT **jit;
            for(jit = jit_compilers; *jit; jit++) {
                (*jit)->next_command_line_argument(argv[arg_num - 1],
                                                   argv[arg_num]);
            }
#ifdef CLI_TESTING
            for(jit = jit_compilers_cli; *jit; jit++) {
                (*jit)->next_command_line_argument(argv[arg_num - 1],
                                                   argv[arg_num]);
            }
#endif
#ifdef ORP_STATS
        } else if (strcmp(argv[arg_num], "-stats") == 0) {
            orp_print_total_stats = true;
            arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad stats level" << endl;
                exit(1);
            }
            orp_print_total_stats_level = atoi(argv[arg_num]);
#endif
        } else if (strcmp(argv[arg_num], "-version") == 0) {
            //
            // Print the version number and exit
            //
            printf("Open Runtime Platform, version 1.0.9\n");
            exit(0);
        } else if (strcmp(argv[arg_num], "-awt_hack") == 0) {
            //
            // to run GNU Classpath AWT
            //
            use_classpath_awt_workaround = true;
        } else if (strcmp(argv[arg_num], "-recomp_thread") == 0) {
            //
            // need a separate thread for recompilation
            //
            recompilation_thread = true;
        } else if (strcmp(argv[arg_num], "-jvmdi") == 0) {
            //
            // generate jvmdi support
            //
            jvmdi_support = true;
        } else if (strcmp(argv[arg_num], "-collect") == 0) {
			//
			// Turn on field access data collection.
			//
			collect_hotfield_stats = true;
        } else if (strcmp(argv[arg_num], "-randomsplit") == 0) {
			//
			// Throw object fields randomly into hot and cold regions...
			//
#ifndef OBJECT_SPLITTING
			orp_cout << "Option -randomsplit not defined for ORP built without OBJECT_SPLITTING";
			exit(-1);
#endif // OBJECT_SPLITTING
			split_object_fields_randomly = true;
        } else if (strcmp(argv[arg_num], "-dbg") == 0) {
            //
            // simple debugger
            //
            extern bool enter_the_debugger;
            enter_the_debugger = true;
            jvmdi_debugger = true;
            jvmdi_support = true;

        } else if (strcmp(argv[arg_num], "-swapjit") == 0) {
            arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad index for swapping JITs" << endl;
                exit(1);
            }
            unsigned idx1 = atoi(argv[arg_num]);
            arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad index for swapping JITs" << endl;
                exit(1);
            }
            unsigned idx2 = atoi(argv[arg_num]);
            orp_swap_jits(idx1, idx2);

        } else if (strncmp(argv[arg_num], "-gc", 3) == 0) {
			arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad -gc option" << endl;
                exit(1);
            }
            gc_next_command_line_argument(argv[arg_num - 1],
                                          argv[arg_num]);

		} else if ((strcmp(argv[arg_num], "-ms")        == 0) ||
			       (strcmp(argv[arg_num], "-mx")        == 0) ||

                   // These three are marked for elimination.
				   (strcmp(argv[arg_num], "-plan")      == 0) ||
				   (strcmp(argv[arg_num], "-los")       == 0) ||
				   (strcmp(argv[arg_num], "-rf")        == 0) ) {
            arg_num++;
			gc_next_command_line_argument(argv[arg_num - 1],
                                              argv[arg_num]);


//*M WangYong Start ...

		} else if ((strncmp(argv[arg_num], "-Xms",4)    == 0) ||

				   (strncmp(argv[arg_num], "-Xmx",4)    == 0) ) {

			gc_next_command_line_argument(argv[arg_num],argv[arg_num]);

//*M WangYong End.

        } else if ((strcmp(argv[arg_num], "-verbosegc") == 0) ||
                    // fixedgc is marked for elimination
				   (strcmp(argv[arg_num], "-fixedgc")   == 0) ) {
            gc_next_command_line_argument(argv[arg_num],
                                          argv[arg_num]);
 
#ifdef ORP_NT

#if defined(USE_IA64_JIT)
#else
        } else if (strcmp(argv[arg_num], "-dll") == 0) {
            arg_num++;
            if (arg_num >= argc) {
                orp_cout << "Bad JIT dll option" << endl;
                exit(1); //orp_exit(1);
            }
            orp_add_jit(new Dll_JIT(argv[arg_num]));
#endif
#ifdef CLI_TESTING
#ifdef CLI_O3_COMPILER
		} else if (strcmp(argv[arg_num],"-o3dll") == 0) {
			arg_num++;
			if (arg_num >= argc) {
				orp_cout << "Bad O3 JIT option" << endl;
				exit(1);
			}
			orp_add_jit_cli(new CLI_Level_3_JIT(argv[arg_num]));
#endif // CLI_TESTING
#endif // CLI_O3_COMPILER
#endif // ORP_NT
    } else if (strcmp(argv[arg_num], "-prop") == 0) {
        
			arg_num++;
			if (arg_num >= argc) {
                orp_cout << "Bad properties option" << endl;
                exit(1); //orp_exit(1);
            }
			add_to_properties(env.properties, argv[arg_num]);
        }
#ifdef ZIP_JAR_ARCHIVE
		else if (strcmp(argv[arg_num], "-jar") == 0) {
			runjarfile = true;			
		}
#endif
		else {
            char *p = argv[arg_num];
#ifdef ZIP_JAR_ARCHIVE
			if(runjarfile){
				if(!isZIPJARFile(p)){
					orp_cout << "You must specify a jar file to run." << endl;
					exit(1); //orp_exit(1)
				}
				
				if (p_env->classpath == NULL){ //no -classpath specified
					char *cp = getenv("CP");
					if(cp){
						class_path.AppendBlock(cp);
						p_env->classpath = (char*)class_path.toString();
					}
				}

				JarFile *getZIPJARFileFromPool(const char *filename);
				JarFile *jarfl = getZIPJARFileFromPool(p);
				if(!jarfl){
					orp_cout << "ORP can't find the jar file you want to run." << endl;
					exit(1); //orp_exit(1)
				}
				const char *mainclass = getMainClassFromJARFile(jarfl);
				if(!mainclass){
					orp_cout << "Your jar file hasn't specified Main-Class manifest attribute." << endl;
					exit(1); //orp_exit(1)
				}
				*classname = p_env->string_pool.lookup(mainclass);
				if(class_path.GetCurrentPos() == 0)
					class_path.AppendFormatBlock("%s%s", getenv("CP"), (char*)getJARFilePath(jarfl));
				else
					class_path.AppendFormatBlock("%c%s", PATH_SEPARATOR, getJARFilePath(jarfl));
				p_env->classpath = (char*)class_path.toString();
			} else {
#endif
            while(*p) {
                if(*p == '.') {
                    *p = '/';
                }
                p++;
            }
			*classname = p_env->string_pool.lookup(argv[arg_num]);
#ifdef ZIP_JAR_ARCHIVE
			}
#endif
            break;
        }
	}

    //this will ease command line job dramatically
    if(p_env->classpath == NULL){
        p_env->classpath = getenv("CP");
#ifdef ZIP_JAR_ARCHIVE
		class_path.AppendBlock(p_env->classpath);
		p_env->classpath = (char*)class_path.toString();
#endif
	}

    *p_arg_num = arg_num;
} //parse_args


#ifdef ORP_POSIX

void orp_init(Global_Env *env, Loader_Exception *exception);

int run_java_main(String *classname, char **j_argv, int j_argc, Global_Env *p_env)
{
  Loader_Exception exception = LD_NoException;

  orp_init(p_env, &exception);

  Class *clss = load_class(p_env, classname, &exception);
  if (clss == NULL) {
    switch (exception) {
    case LD_ClassCircularityError:
      break;
    case LD_NoClassDefFoundError:
      break;
    case LD_ClassFormatError:
      break;
    }
    orp_cout << "Couldn't load class: " << classname->bytes << endl;
    orp_exit(1);
  }

  //
  // Signal the GC that the ORP is now completely 
  // initialized. Hence GC stop-the-world events
  // can occur at any time, since the ORP is now
  // ready to enumerate live references when asked.
  //
  
  gc_orp_initialized();
  
  class_prepare(clss);
  class_initialize(clss);

  if (jvmdi_debugger)
    {
      void init_jvmdi_debugger();
      init_jvmdi_debugger();
    }

  void *java_argv =
    orp_create_array_of_strings(j_argv, j_argc);
  compile_and_run_class(clss, java_argv);
  return 0;
} //run_java_main

#endif

static HANDLE mainThreadHandle;

int main3(void *p_void) 
{
    Scalar_Arg *arg_array = (Scalar_Arg *)p_void;
    int argc = arg_array[0].i;
    char **argv = (char **)arg_array[1].p;

    Global_Env *p_env = (Global_Env *)arg_array[2].p;

    if (argc < 1) {
		orp_cout << "Not enough args" << endl;
        orp_exit(1);
    }

    orp_initialize_critical_sections();

    // -- begin JIT initialization

#if defined(USE_IA64_JIT)
    orp_add_jit(ia64_o1_jit = new IA64_O1_JIT());
    orp_add_jit(ia64_o3_jit = new IA64_O3_JIT());
#elif defined(USE_IA64_JIT_ON_IA32)
    orp_add_jit(o1_jit = new Level_1a_JIT());
    orp_add_jit(ia64_o1_jit = new IA64_O1_JIT());
    orp_add_jit(ia64_o3_jit = new IA64_O3_JIT());
#elif defined(USE_DLL_JIT)
#else
    orp_add_jit(o1_jit = new Level_1a_JIT());
    orp_add_jit(o3_jit = new Level_3_JIT());

#ifdef CLI_TESTING
    orp_add_jit_cli(new Level_0_JIT_CLI());
#endif

#endif 

    // -- end JIT initialization

    initialize_properties(env.properties);

    int arg_num;
    String *classname = 0;
    parse_args(argc, argv, p_env, &classname, &arg_num);

#ifdef _DEBUG
#ifdef USE_IA64_JIT
#else
#ifdef ORP_NT
    if (jvmdi_debugger == true) {  // the debugger only works with o1 jit
        JIT *p_j = jit_compilers[0];
        jit_compilers[0] = jit_compilers[1];
        jit_compilers[1] = p_j;
    }
#endif
#endif // USE_IA64_JIT
#endif // _DEBUG

    gc_init();

#ifdef OBJECT_LOCK_V2
	p_TLS_orpthread->p_nursery = gc_get_new_nursery();
	p_TLS_orpthread->thread_handle = mainThreadHandle;
    assert(p_TLS_orpthread->app_status == thread_is_birthing);
#endif
#ifdef CONCURRENCY_ANALYSIS
    uint64 start_time = readTimeStampCounter();
#ifdef ORP_POSIX
    fprintf(f_concur, "THREAD_START( tid = %d, time = %llu )\n", p_TLS_orpthread->thread_index, start_time);
#else
    fprintf(f_concur, "THREAD_START( tid = %d, time = %I64u )\n", p_TLS_orpthread->thread_index, start_time);
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS


    if(classname) {

#if defined(USE_IA64_JIT)
#elif defined(ORP_POSIX)
#else
        //
        // create a thread for recompilation
        //
        if (recompilation_thread) {
            o1_jit->thread_recompile_methods();
        }
#endif

        init_loader(*p_env);
        arg_num++;
        int java_argc = argc - arg_num;
		Loader_Exception exception = LD_NoException;

        int result = run_java_main(classname, argv + arg_num, java_argc, p_env);

        assert(p_TLS_orpthread->app_status == thread_is_running);

#ifdef CONCURRENCY_ANALYSIS
    uint64 end_time = readTimeStampCounter();
#ifdef ORP_POSIX
    fprintf(f_concur, "THREAD_END( tid = %d, time = %llu )\n", p_TLS_orpthread->thread_index, end_time);
#else
    fprintf(f_concur, "THREAD_END( tid = %d, time = %llu )\n", p_TLS_orpthread->thread_index, end_time);
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS


        p_TLS_orpthread->app_status = thread_is_dying;
        //  The thread is dying needs to be set before we enable gc so that
        // the GC won't expect a last_java_frame to be available.
        //  BUGBUG does main thread need Thread.exit() code??
        //  BUGBUG main() is _not_ part of any threadGroup
        orp_enable_gc();

        p_thread_lock->_lock_enum();

        orp_disable_gc();

        non_daemon_thread_count--;   
        if (!non_daemon_thread_count) {
            DWORD stat = SetEvent(non_daemon_threads_dead_handle);
            assert(stat);
        }

        p_thread_lock->_unlock_enum();

// vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
// between the v's is code that removes the java main() thread
// from the system

        orp_monitor_enter( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);

#ifndef OBJECT_LOCK_V2
#ifdef _DEBUG
        //assert(p_TLS_orpthread == (ORP_thread *)(p_TLS_orpthread->p_java_lang_thread->PrivateInfo) );
        assert(p_TLS_orpthread->p_current_object == 0);

        POINTER_SIZE_INT *p_header = P_OBJ_INFO(p_TLS_orpthread->p_java_lang_thread);

        ACQUIRE_BUSY_BIT(p_header);

            // BUGBUG did GC move any objects on us??

        if ( (*p_header & SLOW_LOCKING) == SLOW_LOCKING) {    
            Lock_Block *p_lock_chain;
            p_lock_chain =(Lock_Block *)(*p_header & LOCK_BLOCK_POINTER_MASK);
#ifndef MONITOR_STO
            assert(p_lock_chain->lock_recursion_count_shifted_left == QUICK_RECURSION_INC_DEC_REMENT);
            assert( (p_lock_chain->old_object_header & QUICK_THREAD_INDEX_MASK) ==
                            p_TLS_orpthread->quick_thread_index_shifted_left);
        } else
        {
            assert( (*p_header & QUICK_RECURSION_MASK) == QUICK_RECURSION_INC_DEC_REMENT);
            assert( (*p_header & QUICK_THREAD_INDEX_MASK) == 
                p_TLS_orpthread->quick_thread_index_shifted_left);
#endif
        }

        RELEASE_BUSY_BIT(p_header);

#endif // _DEBUG
#endif //#ifndef OBJECT_LOCK_V2

        // notify anyone that called Thread.join()


        java_lang_Object_notifyAll ( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);

        orp_monitor_exit( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);

        // toss try_crit_section((void **)&(p_TLS_orpthread->p_java_lang_thread) );  // TOSS THIS
        orp_enable_gc();
        p_thread_lock->_lock_enum();
        orp_disable_gc();

	    free_this_thread_block(p_TLS_orpthread);

        // turn off for now --> orp_monitor_singlethread();
        p_thread_lock->_unlock_enum();

// end of code that removes java main thread from system
// vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

        _endthreadex(99);


        return result;

    } else {
        orp_cout << "No class specified" << endl;
        orp_exit(1);
    }
    assert(0);
    return 1;

} //main2

#pragma optimize( "", off )
unsigned __stdcall main2(void *p_void){

#ifdef OBJECT_LOCK_V2
	ORP_thread *p_orpthread;
	p_orpthread = get_a_thread_block();
    unsigned int stack_base = get_stack_pointer();
    stack_base &= STACK_MASK;
	//Give the main thread a stack key
	p_orpthread->stack_key = stack_base >> STACK_KEY_SHIFT;

    thread_local_storage_offset = (unsigned int)(&p_orpthread) - stack_base;
#endif	
  
    main3(p_void);
	return 1;
} 
#pragma optimize( "", on )

extern void initialize_signals();

int main(int argc, char *argv[]) 
{
    initialize_signals();
#ifdef ORP_POSIX
    init_linux_thread_system();
#elif defined(ORP_NT)
    OSVERSIONINFO osvi;
    osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
    BOOL result = GetVersionEx(&osvi);
    if(!result) {
        DWORD e = GetLastError();
        printf("Windows error: %d\n", e);
        exit(1);
    }
    if((osvi.dwMajorVersion != 4 || osvi.dwMinorVersion != 0) &&  // NT 4.0
       (osvi.dwMajorVersion != 5 || osvi.dwMinorVersion != 0) &&  // Windows 2000
       (osvi.dwMajorVersion != 5 || osvi.dwMinorVersion != 1)     // Windows Whistler
      ) {
        printf("Windows %d.%d is not supported\n", osvi.dwMajorVersion, osvi.dwMinorVersion);
        exit(1);
    }
#endif


    non_daemon_threads_dead_handle = CreateEvent( 
            NULL,   // pointer to security attributes 
            FALSE,  // flag for manual-reset event  -- auto reset mode 
            FALSE,  // flag for initial state 
            NULL    // pointer to event-object name 
        ); 
    assert(non_daemon_threads_dead_handle);

    ORP_Global_State::loader_env = &env;

    Scalar_Arg arg_array[3];
    arg_array[0].i = argc;
    arg_array[1].p = (void *)argv;
    arg_array[2].p = (void *)&env;

#ifdef CONCURRENCY_ANALYSIS
    char filename[50];
    sprintf(filename, "concurrency-%d.txt", time(NULL));
    f_concur = fopen(filename, "w");
#endif //#ifdef CONCURRENCY_ANALYSIS

    non_daemon_thread_count = 1; // main(String args[]) is first non-daemon
    unsigned thread_id;
    mainThreadHandle = (HANDLE)_beginthreadex(0, (64*1024), main2, arg_array, 0, &thread_id);

    if( non_daemon_thread_count) 
        wait_until_non_daemon_threads_are_dead();

#ifdef CONCURRENCY_ANALYSIS
    fclose(f_concur);
#endif //#ifdef CONCURRENCY_ANALYSIS

    Class *clss = ORP_Global_State::loader_env->java_lang_Runtime_Class;
	String *name   = ORP_Global_State::loader_env->string_pool.lookup("runShutdownHooks");
	String *descr  = ORP_Global_State::loader_env->string_pool.lookup("()V");
	Signature *sig = ORP_Global_State::loader_env->sig_table.lookup(name, descr);
	assert(sig);

	Method *method = class_lookup_method(clss, sig);
	if(method){ // maybe classpath doesn't support Shutdown hooks
	    
	    begin_shutdown_hooks = true;
	    
#ifdef USE_MAIN_THREAD_RUN_SHUTDOWN_HOOKS
		ORP_thread * p_orp_thread = get_a_thread_block();
		assert(p_orp_thread);

		void *temp_nursery = gc_get_new_nursery();
		p_orp_thread->p_nursery = temp_nursery;	

#ifndef OBJECT_LOCK_V2

#ifdef ORP_NT
		p_TLS_orpthread = p_orp_thread;
		assert(p_TLS_orpthread);
#elif ORP_POSIX
		p_orp_thread->thread_handle = (int) pthread_self();
		pthread_setspecific(thread_local_storage_key, p_orp_thread);
#endif

		quick_thread_id[hint_free_quick_thread_id].p_orp_thread = p_TLS_orpthread;
		hint_free_quick_thread_id++;  // to avoid rescanning an already occupied slot
#else //#ifndef OBJECT_LOCK_V2
   		quick_thread_id[next_thread_index++].p_orp_thread = p_TLS_orpthread;
#endif //#ifndef OBJECT_LOCK_V2

        p_orp_thread->app_status = thread_is_running;
        
		//orp_disable_gc();
		orp_execute_java_method(method, 0, clss);
		//orp_enable_gc();
		
#else // USE_MAIN_THREAD_RUN_SHUTDOWN_HOOKS
        
#ifdef OBJECT_LOCK_V2
        unsigned int runShutdownHooks0(void * p_arg );
#else
        unsigned int runShutdownHooks(void * p_arg );
#endif
		_beginthreadex(0, 
                     (64*1024), //set to 64k
#ifdef OBJECT_LOCK_V2
                     ( unsigned int (__stdcall *)(void *) )runShutdownHooks0,
#else
                     ( unsigned int (__stdcall *)(void *) )runShutdownHooks,
#endif
                     method, //args
                     0, // running
                     &thread_id);
        
        wait_until_non_daemon_threads_are_dead();
        
#endif // USE_MAIN_THREAD_RUN_SHUTDOWN_HOOKS
	}

    orp_exit(0);
    return 33;
} //main


#ifndef USE_MAIN_THREAD_RUN_SHUTDOWN_HOOKS

#ifdef OBJECT_LOCK_V2 

#pragma optimize("", off)
unsigned int runShutdownHooks0(void * p_arg ){
    ORP_thread *p_orp_thread = get_a_thread_block();
    unsigned int stack_base = get_stack_pointer();
    stack_base &= STACK_MASK;
	
	unsigned int new_thread_local_storage_offset = (unsigned int)(&p_orp_thread) - stack_base;
    assert(thread_local_storage_offset == new_thread_local_storage_offset);
    
	unsigned int runShutdownHooks(ORP_thread *p_orp_thread, void * p_arg );   
    return runShutdownHooks(p_orp_thread, p_arg);
}
#endif //OBJECT_LOCK_V2
 
#ifndef OBJECT_LOCK_V2
unsigned int runShutdownHooks(void * p_arg )
#else
unsigned int runShutdownHooks(ORP_thread *p_orp_thread, void * p_arg )
#endif
{
    Method *method = (Method *)p_arg;
    Class *clss = method->get_class();
   
#ifndef OBJECT_LOCK_V2
	ORP_thread *p_orp_thread = get_a_thread_block();
#ifdef ORP_NT
    p_TLS_orpthread = p_orp_thread;
    assert(p_TLS_orpthread);

#elif ORP_POSIX
    p_orp_thread->thread_handle = (int) pthread_self();
    pthread_setspecific(thread_local_storage_key, p_orp_thread);

#endif //ORP_NT / ORP_POSIX

    quick_thread_id[hint_free_quick_thread_id].p_orpthread = p_TLS_orpthread;
    hint_free_quick_thread_id++;  // to avoid rescanning an already occupied slot
#else //#ifndef OBJECT_LOCK_V2   
	quick_thread_id[next_thread_index++].p_orpthread = p_TLS_orpthread;
#endif //#ifndef OBJECT_LOCK_V2   

    assert(p_orp_thread->app_status == thread_is_birthing);

    set_orp_last_java_frame(0);

	gc_thread_init();
	
	p_TLS_orpthread->p_nursery = gc_get_new_nursery();

    // SET_THREAD_DATA_MACRO();

    int old_floating_point_state = 0;
    void setup_floating_point_state(int *);
    setup_floating_point_state(&old_floating_point_state);

    // Set the app_status to "running" just before entering Java code. It is 
    // "birthing" till now.
    p_orp_thread->app_status = thread_is_running;

	//orp_disable_gc();
	orp_execute_java_method(method, 0, clss);
	//orp_enable_gc();

    void cleanup_floating_point_state(int);
    cleanup_floating_point_state(old_floating_point_state);

    assert(p_orp_thread->app_status == thread_is_running);
    p_orp_thread->app_status = thread_is_dying;

// vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
// between the v's is code that removes shutdown thread
// from the system

	/** No need for the following block, because:
	  * 1. No p_TLS_orpthread->p_java_lang_thread object.
	  * 2. Java implementation of runShutdownHooks will join all the hooks thread.
	  
    orp_monitor_enter( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);

   // notify anyone that called Thread.join()

    java_lang_Object_notifyAll ( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);

    orp_monitor_exit( (Java_java_lang_Object *)p_TLS_orpthread->p_java_lang_thread);
	*/

    // toss try_crit_section((void **)&(p_TLS_orpthread->p_java_lang_thread) );  // TOSS THIS

    free_this_thread_block(p_TLS_orpthread);

// end of code that removes java main thread from system
// vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    
    gc_thread_kill();
    
    // tell main thread to exit
    SetEvent(non_daemon_threads_dead_handle);
    
     _endthreadex(99);

	return 0;
}
#endif

void interrupt_handler(int x)
{
#if 0 //#ifdef _DEBUG
	printf("Interrupt signal caught....\n");
	fflush(stdout);
#endif
	if(!begin_shutdown_hooks){
		begin_shutdown_hooks = true;
		SetEvent(non_daemon_threads_dead_handle);
	}else
		exit(1); //orp_exit(1);
}
