// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/interface/jit_runtime_support.h,v 1.14 2001/11/28 08:41:27 xhshi Exp $
//



#ifndef _JIT_RUNTIME_SUPPORT_H_
#define _JIT_RUNTIME_SUPPORT_H_

#include "orp_types.h"

//
// This is a complete set of functions used by the code generated by the JIT.
// The address of a function is obtained from the ORP by invoking the
// function orp_get_rt_support_addr (see below).
//
// Unless noted otherwise all calls are __stdcall.
// Functions whose names end with _FASTCALL are _fastcall.
//
enum ORP_RT_SUPPORT {


    ORP_RT_LDC_STRING,
    // Arguments:
    //  - Const pool index pointing to a CONSTANT_Class.
    //  - Class handle of the class owning the const pool
    // Return value (eax):
    //  - Reference to the String object.
    //
    // Returns a reference to the const string represented by an entry in the
    // const pool.


    ORP_RT_NEW_RESOLVED,
    // Arguments:
    //  - Class handle for the class whose object we want to create
    // Return value (eax):
    //  - Reference to the new object
    //
    // Allocates a new object of a given class.  This function should be used
    // for classes which inherit the finalize method of java.lang.Object.


    ORP_RT_NEW_WITH_FINALIZER_RESOLVED,
    // Arguments:
    //  - Class handle for the class whose object we want to create
    // Return value (eax):
    //  - Reference to the new object
    //
    // Allocates a new object of a given class.  This function should be used
    // for classes which define or inherit a finalize method other than
    // java.lang.Object.finalize()V.


    ORP_RT_NEW_VECTOR,
    // Arguments:
    //  - Vector length
    //  - Class handle of the vector class
    // Return value (eax):
    //  - Reference to the new object
    //
    // Create a vector (zero-based, one dimensional array)
    // of the given type.


    ORP_RT_ANEWARRAY_RESOLVED,
    // Arguments:
    //  - Array length
    //  - Class handle of the array class
    // Return value (eax):
    //  - Reference to the new object
    //
    // Create a Java array of the given type.  This function
    // handles only arrays of reference types.


    ORP_RT_NEWARRAY,
    // Arguments:
    //  - Atype
    //  - Length
    // Return value (eax):
    //  - Reference to the new object
    //
    // Create a Java array.  Element type is represented by the atype argument.


    ORP_RT_MULTIANEWARRAY_RESOLVED,
    // There is a variable # of arguments:
    //  - Class handle
    //  - Number of dimensions
    //  - Count_n
    //  - ...
    //  - Count_1
    // Return value (eax):
    //  - Reference to the new object
    //
    // This is __cdecl function and the caller must pop the arguments.
    // Create a multidimensional Java array
    //


    ORP_RT_AASTORE,
    // Arguments:
    //  - Element
    //  - Index
    //  - Array
    // Return value: none.
    //
    // Store a reference element into into an array.


    ORP_RT_IDX_OUT_OF_BOUNDS,
    // Arguments: none
    // Return value: none.
    //
    // Throw the java/lang/ArrayIndexOutOfBoundsException
    // This function never returns.


    ORP_RT_NULL_PTR_EXCEPTION,
    // Arguments: none
    // Return value: none.
    //
    // Throw the java/lang/NullPointerException
    // This function never returns.


    ORP_RT_ATHROW,
    // Arguments:
    //  - Object reference
    // Return value: none.
    //
    // The only argument is a reference to the exception to be thrown.
    // This function never returns.

#ifdef STAT_INDIRECT_CALL
	//
	// For statistics, instrument a call before indirect branches
	//
	ORP_RT_STAT_INDIRECT_CALL,
#endif

	// The following three calls are used by the 01 and 03 JITs. Any new
	// code should use the interfaces ORP_GC_HEAP_WRITE_mumble and
	// ORP_GC_VOLATILE_HEAP_WRITE_mumble interfaces.
    ORP_RT_WRITE_BARRIER_ATOMIC,
    // Arguments:
    //  - base
    //  - ptr
    //  - value
    // Return value: none.
    //
    // Atomically perform the write barrier and the field update.


    ORP_RT_WRITE_BARRIER,
    // Arguments:
    //  - Address of a memory location being written to
    //  - Object reference being written.
    // Return value: none.
    //
    // Write barrier for GC.


    ORP_RT_WRITE_BARRIER_FASTCALL,
    // Arguments:
    //  - Address of a memory location being written to
    //  - Object reference being written.
    // Return value: none.
    //
    // Write barrier for GC.
#ifdef JIT_SAPPHIRE
    ORP_RT_GC_HEAP_REF_EQUAL,
#endif // JIT_SAPPHIRE
    ORP_RT_GC_HEAP_SLOT_WRITE_REF,  // should be removed before release (see jit_runtime_support_ia64.cpp)
    ORP_RT_GC_HEAP_WRITE_REF,
    ORP_RT_GC_HEAP_WRITE_INT8,
    ORP_RT_GC_HEAP_WRITE_INT16,
    ORP_RT_GC_HEAP_WRITE_UINT16,
    ORP_RT_GC_HEAP_WRITE_INT32,
    ORP_RT_GC_HEAP_WRITE_FLOAT,
    ORP_RT_GC_HEAP_WRITE_DOUBLE,
    ORP_RT_GC_HEAP_WRITE_INT64,
    ORP_RT_GC_HEAP_WRITE_POINTER_SIZE_INT,
	// Arguments:
    //  - Address of the base of the object (or array) being written to.
    //  - Address of a memory location being written to
    //  - Value being written.
    // Return value: none.
    //
    // Write barrier for GC. Updates the slot with the value provided.
	// The type being written is indicated in the name.

    ORP_RT_GC_HEAP_WRITE_GLOBAL_SLOT,
	// Arguments:
    //  - Address of a memory location being written to
    //  - Value being written.
    // Return value: none.
    //
	// Updates the slot with the value provided.
	// This routine should be used when writing a heap reference into a non-heap
	// slot that can be seen by more than one thread. This obviously does
	// not include writes to the threads stack since that is not shared.

    ORP_RT_GC_VOLATILE_HEAP_WRITE_REF,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_INT8,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_INT16,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_UINT16,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_INT32,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_FLOAT,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_DOUBLE,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_INT64,
    ORP_RT_GC_VOLATILE_HEAP_WRITE_POINTER_SIZE_INT,
    // Arguments:
    //  - Address of the base of the volatile object (or array) being written to.
    //  - Address of a memory location being written to
    //  - Value being written.
    // Return value: none.
    //
	// Updates the slot with the value provided.
    // Write barrier for GC. The type being written is indicated in the name.
	// These routines should be used when writing volatiles.

#ifdef JIT_SAPPHIRE
	//::
	//Read Barrier functions. Similar with WRITE BARRIER, 2001.5.8 sxh 
	//::
	ORP_RT_GC_READ_BARRIER_DEBUG, //for debug
    ORP_RT_GC_HEAP_READ_REF,
    ORP_RT_GC_HEAP_READ_INT8,
    ORP_RT_GC_HEAP_READ_INT16,
    ORP_RT_GC_HEAP_READ_UINT16,
    ORP_RT_GC_HEAP_READ_INT32,
    ORP_RT_GC_HEAP_READ_FLOAT,
    ORP_RT_GC_HEAP_READ_DOUBLE,
    ORP_RT_GC_HEAP_READ_INT64,
    ORP_RT_GC_HEAP_READ_POINTER_SIZE_INT,
    ORP_RT_GC_HEAP_READ_GLOBAL_SLOT,
    ORP_RT_GC_VOLATILE_HEAP_READ_REF,
    ORP_RT_GC_VOLATILE_HEAP_READ_INT8,
    ORP_RT_GC_VOLATILE_HEAP_READ_INT16,
    ORP_RT_GC_VOLATILE_HEAP_READ_UINT16,
    ORP_RT_GC_VOLATILE_HEAP_READ_INT32,
    ORP_RT_GC_VOLATILE_HEAP_READ_FLOAT,
    ORP_RT_GC_VOLATILE_HEAP_READ_DOUBLE,
    ORP_RT_GC_VOLATILE_HEAP_READ_INT64,
    ORP_RT_GC_VOLATILE_HEAP_READ_POINTER_SIZE_INT,
#endif
    ORP_RT_F2I,
    ORP_RT_F2L,
    ORP_RT_D2I,
    ORP_RT_D2L,
    // Conversions


    ORP_RT_LSHL,
    ORP_RT_LSHR,
    ORP_RT_LUSHR,
    // Arguments:
    //  - (edx:eax) A long value to be shifted
    //  - (ecx)     Count 
    // Return value: (edx:eax)
    //  - The shifted value
    //


    ORP_RT_LMUL,
#ifdef ORP_LONG_OPT
	ORP_RT_LMUL_CONST_MULTIPLIER,
#endif
    ORP_RT_LREM,
    ORP_RT_LDIV,
	ORP_RT_CONST_LDIV ,
	ORP_RT_CONST_LREM ,
    // Long arithmetic


    ORP_RT_IMUL,
    ORP_RT_IREM,
    ORP_RT_IDIV,
    // Int arithmetic


    ORP_RT_FREM,
    ORP_RT_FDIV,
    // Float arithmetic


    ORP_RT_DREM,
    ORP_RT_DDIV,
    // Float arithmetic


    ORP_RT_CHECKCAST,
    // Arguments:
    //  - Object
    //  - Class
    // Return value: (eax)
    //  - Object
    //
    // If object can't be cast to class, throw ClassCastException


    ORP_RT_INSTANCEOF,
    // Arguments:
    //  - Object
    //  - Class
    // Return value: (eax)
    //  - 0 if object can be cast to class
    //  - 1 otherwise


    ORP_RT_INSTANCEOF_CLASS,
    // Arguments:
    //  - Class 1
    //  - Class 2
    // Return value: (eax)
    //  - 0 if object of class 1 can be cast to class 2
    //  - 1 otherwise


    ORP_RT_MONITOR_ENTER,
    // Arguments:
    //  - Object
    // Return value: none.
    //
    // Acquire the monitor associated with the object.


    ORP_RT_MONITOR_EXIT,
    // Arguments:
    //  - Object
    // Return value: none.
    //
    // Release the monitor associated with the object.


    ORP_RT_MONITOR_ENTER_STATIC,
    // Arguments:
    //  - Class handle
    // Return value: none.
    //
    // Acquire the monitor associated with the class passed as the argument.


    ORP_RT_MONITOR_EXIT_STATIC,
    // Arguments:
    //  - Class handle
    // Return value: none.
    //
    // Release the monitor associated with the class passed as the argument.



    ORP_RT_GET_INTERFACE_VTABLE_VER0,
    // Arguments:
    //  - Object reference
    //  - Class handle for the interface
    // Return value: (eax)
    //  - Interface vtable with method entries for the implemantation
    //    of that interface by the actual class of the object.


    ORP_RT_INITIALIZE_CLASS,
    // Arguments:
    //  - Class handle
    // Return value: none.
    //
    // If the class hasn't been initialized yet, initialize it.
    //
    // A call to this function must be generated before every putstatic
    // and getstatic unless the JIT can prove that the class would have
    // been already initialized at that point.


    ORP_RT_THROW_LINKING_EXCEPTION,
    // Arguments:
    //  - Const pool index.
    //  - Class handle of the class owning the const pool.
    //  - Loader exception returned by the ORP.
    // Return value: none.
    //
    // Throws a linking exception reported by the ORP at compile-time.


    ORP_RT_ARRAY_STORE_EXCEPTION,
    // Arguments: none
    // Return value: none.
    //
    // Throw the java/lang/ArrayStoreException
    // This function never returns.


    ORP_RT_ATHROW_LAZY,
    // Arguments:
    //  - Method handle
    //  - ...
    //  - arg 2
    //  - arg 1
    //  - Class handle
    // Return value: none.
    //
    // The arguments to the constructor are pushed the same way they would have
    // been pushed to invoke the constructor, except that the (non-existing)
    // this pointer is replaced with the class handle of the exception.
    // The method handle representing the constructor is pushed last.
    //
    // This function never returns.


    ORP_RT_NEW_RESOLVED_ALIGNED,
    // Arguments:
    //  - Class handle for the class whose object we want to create
    // Return value (eax):
    //  - Reference to the new object
    //
    // Allocates a new object of a given class.  This function should be used
    // for classes which inherit the finalize method of java.lang.Object.
    // The class of the object will be consulted for the alignment requirement.

    JVMDI_RT_EVENT_METHOD_ENTRY,
    JVMDI_RT_EVENT_METHOD_EXIT,

}; //ORP_RT_SUPPORT



ORPExport void *
orp_get_rt_support_addr(ORP_RT_SUPPORT f);





ORPExport void orp_enumerate_root_reference(GC_Enumeration_Handle gc_handle, void **ref);

ORPExport void orp_enumerate_root_interior_pointer(GC_Enumeration_Handle gc_handle,
                                                   void **slot, int offset);


#ifdef CLI_TESTING
#include "jit_intf.h"

// For enumerating reference fields in unboxed instances of value types.
ORPExport void orp_enumerate_roots_in_value_type(GC_Enumeration_Handle gc_handle,
                                                 Class_Handle cl,
                                                 void *inst);
#endif


#endif
