// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/orp_synch.h,v 1.8 2001/12/06 20:45:14 xli18 Exp $//




#ifndef OBJECT_LOCK_V2
#ifndef _ORP_SYNCH_
#define _ORP_SYNCH_

#include "lock_manager.h"
#include "object_layout.h"
#include "gc_header_format.h"
#include "orp_utils.h"

#ifdef ORP_POSIX
#ifdef __linux__
#include <asm/bitops.h>
#else
#define ADDR (*(volatile long *) addr)
/**
 * test_and_set_bit - Set a bit and return its old value
 * @nr: Bit to set
 * @addr: Address to count from
 *
 * This operation is atomic and cannot be reordered.  
 * It also implies a memory barrier.
 *
 * Thanks to: Jake Burkholder <jake@k7.locore.ca>
 */
static __inline int
test_and_set_bit(int nr, volatile void *addr)
{
        char c = 0;

        __asm __volatile("lock ; bts %2, %1 ; setc %0"
            : "+br" (c) : "m" (*(volatile int *)addr), "r" (nr));
        return (c != 0);
}
/**
 * test_and_clear_bit - Clear a bit and return its old value
 * @nr: Bit to clear
 * @addr: Address to count from
 *
 * This operation is atomic and cannot be reordered.  
 * It also implies a memory barrier.
 *
 * Thanks to: Jake Burkholder <jake@k7.locore.ca>
 */
static __inline int
test_and_clear_bit(int nr, volatile void *addr)
{
        char c = 0;

        __asm __volatile("lock ; btr %2, %1 ; setc %0"
            : "+br" (c) : "m" (*(volatile int *)addr), "r" (nr));
        return (c != 0);
}

#endif /* __linux__ */
#endif

#ifdef __cplusplus
extern "C" {
#endif
class Global_Env; // defined in Environment.h

void orp_initialize_critical_sections();

void __stdcall orp_monitor_enter(Java_java_lang_Object *) stdcall__;
void __stdcall orp_monitor_exit(Java_java_lang_Object *) stdcall__;

POINTER_SIZE_INT orp_monitor_cmp_value(Java_java_lang_Object *p_obj);

void __stdcall orp_monitor_enter_naked(Java_java_lang_Object *);
void __stdcall orp_monitor_exit_naked(Java_java_lang_Object *);

extern void (__stdcall *p_mon_enter_code)  (Java_java_lang_Object *); 
extern void (__stdcall *p_mon_exit_code)  (Java_java_lang_Object *); 

void __stdcall java_lang_Object_wait_x(Java_java_lang_Object *, __int64);
void __stdcall java_lang_Object_notifyAll_x(Java_java_lang_Object *p_obj);

void orp_thread_init(Global_Env *p_env);

void orp_monitor_init();
// turn off for now --> void orp_monitor_singlethread();
void orp_monitor_multithread();

// Various routines needed to support synchronization across several platforms.


// An efficient implementation of cpmxchg.  Unfortunately,
// we have to call that function through a function pointer
// because there's no portable way to generate inline assembly.
void *getaddress__orp_atomic_compare_exchange();
extern void *(*orp_atomic_compare_exchange)(void ** ,void *,void *);

#ifdef ORP_POSIX
PVOID InterlockedCompareExchange(IN OUT PVOID *Destination,
				 IN PVOID Exchange,
				 IN PVOID Comperand
				 );
#endif

#ifdef POINTER64
// Use the InterlockedCompareExchangePointer interface in winbase.h
#else
// The Win2000 for IA64 has a InterlockedCompareExchangePointer which differs
// from InterlockedCompareExchange in that it exchanges 64 bits instead of
// 32. For IA32 InterlockedCompareExchange and INterlockedCompareExchangePointer
// should be the same. Make it so. Hopefully, winbase.h will define this
// for Win2000 on IA32 someday and we can delete this.
#define InterlockedCompareExchangePointer InterlockedCompareExchange
#endif

// Use InterlockedIncrement and InterlockedDecrement with this counter.
extern long busy_bit_debug_counter;

// RLH I am assuming that the volatile here results in 
// ld.acq and st.rel on IA64

#ifdef ORP_POSIX

inline 
void acquire_header_lock (volatile POINTER_SIZE_INT *p_header)
{
    while (true) {
        // Try to grab the lock.
        volatile PVOID free_header =(PVOID)(*p_header & BUSY_FORWARDING_BIT_MASK);
        volatile PVOID locked_header =(PVOID)((POINTER_SIZE_INT)free_header | BUSY_FORWARDING_BIT);
        assert (locked_header != free_header);

        // IA64 - What are the semantics of test_and_set_bit with regards to acq and rel?
        // Hopefully, test_and_set_bit will have acquire semantics and
        // test_and_clear_bit will have release semantics.
        if ( test_and_set_bit (BUSY_FORWARDING_BIT_OFFSET, (PVOID *)p_header) == 0) 
        {
            assert ((*p_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT);

            return; // got it this is the only way out.
        }
        // Try until you get the lock.
        
        while ((*p_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT) {
          Sleep (0); // Sleep until it might be free.
        }
    }
}

// Since Linux does not provide a compare exchange interface we use what
// they do provide which is a bit test and set sequence.
inline 
void release_header_lock (volatile POINTER_SIZE_INT *p_header)
{
    // On IA64 this will not be atomic with respect to the ACQUIRE which uses a 
    // InterlockedCompareExchangePointer
    // so we need to make it atomic by using an Interlocked instructions
    assert(*p_header & BUSY_FORWARDING_BIT);
#ifdef _DEBUG
    POINTER_SIZE_INT locked_header = *p_header;
    POINTER_SIZE_INT free_header = locked_header & BUSY_FORWARDING_BIT_MASK;
    assert (free_header != locked_header);
    assert (locked_header != free_header);
#endif

    POINTER_SIZE_INT ss = test_and_clear_bit (BUSY_FORWARDING_BIT_OFFSET, (PVOID *)p_header);
}


#else // must be NT

// IA64 - There seems to be no way to specify in the InterlockedCompareExchangePointer
// if the routine has acquire or if it has release semantics. We need to use
// acq for acquire_header_lock and rel for release_header_lock.

inline 
void acquire_header_lock (volatile POINTER_SIZE_INT *p_header)
{
    while (true) {
        // Try to grab the lock.
        volatile PVOID free_header =(PVOID)(*p_header & BUSY_FORWARDING_BIT_MASK);
        volatile PVOID locked_header =(PVOID)((POINTER_SIZE_INT)free_header | BUSY_FORWARDING_BIT);
        assert (locked_header != free_header);
        if (InterlockedCompareExchangePointer ((PVOID *)p_header, 
                                        locked_header,
                                        free_header)
            == free_header) {
          
          assert ((*p_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT);
#ifdef _DEBUG
          InterlockedIncrement (&busy_bit_debug_counter);
          // Busted in SMP. busy_bit_debug_counter++;
#endif
          return; // got it this is the only way out.
        }
        // Try until you get the lock.
        
        while ((*p_header & BUSY_FORWARDING_BIT) == BUSY_FORWARDING_BIT) {
          Sleep (0); // Sleep until it might be free.
        }
    }
}

//
// For NT since we don't have a bit test and set interface we use the 
// compare exchange interface provided.
//

inline 
void release_header_lock (volatile POINTER_SIZE_INT *p_header)
{
    // On IA64 this will not be atomic with respect to the ACQUIRE which 
    // uses a InterlockedCompareExchangePointer
    // so we need to make it atomic by using an Interlocked instructions
    assert(*p_header & BUSY_FORWARDING_BIT);
    POINTER_SIZE_INT locked_header = *p_header;
    POINTER_SIZE_INT free_header = locked_header & BUSY_FORWARDING_BIT_MASK;
    assert (free_header != locked_header);
    assert (locked_header != free_header);
    if (InterlockedCompareExchangePointer ((PVOID *)p_header, 
                                    (PVOID)free_header,
                                    (PVOID)locked_header)
            != (PVOID)locked_header) {
          assert (0); // The header had better still be locked...
          orp_exit (911);
    }
#ifdef _DEBUG
          InterlockedDecrement (&busy_bit_debug_counter);
          if (busy_bit_debug_counter < 0) {
//              orp_cout << " busy_bit_debug_counter incorrect. " << endl;
              // assert (0);
          }
#endif
//    assert(busy_bit_debug_counter >=0);
}


#endif  // ORP_POSIX

// A couple of Macros that can be used to highlight the lock acquires and releases.
#define ACQUIRE_BUSY_BIT(p_header) acquire_header_lock(p_header)
#define RELEASE_BUSY_BIT(p_header) release_header_lock(p_header)



#ifdef __cplusplus
}
#endif

#endif  // _ORP_SYNCH_
#else //#ifndef OBJECT_LOCK_V2

#ifdef ORP_POSIX
PVOID InterlockedCompareExchange(IN OUT PVOID *Destination,
				 IN PVOID Exchange,
				 IN PVOID Comperand
				 );
#endif

#define InterlockedCompareExchangePointer InterlockedCompareExchange

// An efficient implementation of cpmxchg.  Unfortunately,
// we have to call that function through a function pointer
// because there's no portable way to generate inline assembly.
void *getaddress__orp_atomic_compare_exchange();
extern void *(*orp_atomic_compare_exchange)(void ** ,void *,void *);
void orp_initialize_critical_sections();
#include "root_set_enum.h"
#include "../../base_natives/common_olv2/mon_enter_exit_olv2.h"
#include "../../base_natives/common_olv2/thread_manager_olv2.h"
#endif //#ifndef OBJECT_LOCK_V2

