// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/String_Pool.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _STRING_POOL_H_
#define _STRING_POOL_H_

#include <string.h>
#include "Arena.h"
#include "object_layout.h"

extern "C" {
	typedef struct String {
#ifdef _DEBUG
		unsigned id;	// id for debugging
#endif
		Java_java_lang_String *intern;	// for java.lang.String.intern()
		unsigned short len;
		char bytes[2];		// 2 bytes so that struct is word aligned
	} String;
};



class String_Pool {
public:
	String_Pool();

	//
	// lookup string in string table & insert if not found
	//
	ORPExport String *lookup(const char *str);
	String *lookup(const char *str, unsigned len);

    // Iterators for GC
	String *get_first_string();
    String *get_first_string_intern(unsigned *);

    String *get_next_string(String *);
    String *get_next_string_intern(String *, unsigned *);

    // The GC enumeration code needs to lock and unlock the 
    // pool in order to enumerate it in a thread safe manner.
    void lock_pool();
    void unlock_pool ();
private:
	//
	// Entry in string table
	//
	class _Entry {
	public:
		_Entry *const next;
		String str;
		_Entry(const char *s,unsigned short len,_Entry *n) : next(n) {
			str.len = len;
			str.intern = NULL;
			strcpy(str.bytes,s);
		}
		void *operator new(size_t sz,void *mem) {return mem;}
	};
	//
	// string table size
	//

#define STRING_TABLE_SIZE  4001
	//
	// table of string entries
	//
	_Entry	*_table[STRING_TABLE_SIZE];
	//
	// memory arena containing string pool
	//
	Arena	*_arena;
	//
	// size of each string pool arena area
	//
#define STRING_ARENA_SIZE 1024

    // sufficient to compile empty class and its prerequisites
#define INITIAL_STRING_ARENA_SIZE 94000

};

#endif // _STRING_POOL_H_
