// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc_v2/include/gc_globals.h,v 1.9 2002/01/11 15:47:38 weldon Exp $
//


// Globals in the GC - need to eliminate.
//

#ifndef _gc_globals_h_
#define _gc_globals_h_

// #include "mrl_gc_v1.h"
#include "pair_table.h"
#include "gc_interface.h"
#include "block_store.h"
#include "lock_manager.h"
#include "slot_offset_list.h"

extern char *p_plan_file_name;
extern unsigned long final_heap_size_bytes;
extern bool verbose_gc;
extern bool stats_gc;
extern bool fixed_gc;
extern bool copy_gc;
extern bool use_zeroing_thread;
extern bool use_fetcher_thread;
extern bool use_cheney_clock;
extern int  fetcher_gap;

extern unsigned long initial_heap_size_bytes;
extern unsigned long large_object_size;
extern unsigned long current_heap_size_bytes;


// Put some counts here so that we don't have to redo them at the start of 
// each GC.
// NOT THREAD SAFE IF USED WITH ++ OR --
extern int gc_global_free_count;
extern int gc_global_used_count;
extern int gc_global_step_count;
extern int gc_global_los_count;
extern int gc_global_train_count;
extern int gc_global_nursery_count;

// Set to true if the heap has been extended. This will make the algorithm more paranoid.
extern boolean heap_was_extended;
//
// This is a global pointer to the base of the GC heap for debugging.
//
extern void *p_gc_base;

//
// This debugging pointer is to the top of the reserved virtual space
// for the GC heap.
//
extern void *p_gc_ceiling;

#ifdef SPACE_DEMOGRAPHICS
#include "gc_consts.h"
extern volatile unsigned space_demographics_size[DEMOGRAPHICS_ARRAY_SIZE];
#endif

//
// This remembered set has an entry per loaded class.
// It is used for determining valid vtable pointers
// when examining candidate objects.
//
extern Pair_Table *p_loaded_vtable_directory;

//
// The size to determine if object is large or small.
//

extern unsigned los_threshold_bytes;

extern Gc_Interface *p_gc;

extern Block_Store *p_global_bs;

//extern Directory *p_global_gc_dir; obsolete

extern bool global_verbose_gc;

//
// Made global for debugging purposes.
//
extern unsigned int incremental_collection_count;

//
// This is the base of the garbage collected heap. It is a global
// so that the write barrier code can use it.
//
extern POINTER_SIZE_INT global_heap_base;


#if (GC_DEBUG>3)
extern CRITICAL_SECTION _printCriticalSection;
extern bool do_init_print;
#endif

//
// This flag is initially false during ORP startup. It becomes true
// when the ORP is fully initialized. This signals the GC to feel
// free to do a stop-the-world at any time.
//
extern bool orp_initialized;
// GC_INTERIOR_POINTERS
extern slot_offset_list *interior_pointer_table;

#ifdef GC_TORTURE_1
//
// Set to true when we want the next gc_malloc to do a gc.
// This is used for debugging only. One should only use the routine
// force_gc to set this flag. The routine force_gc will
// not set this to true until orp_initialized is also true.
//
extern bool force_gc_flag;
#endif // GC_TORTURE_1

// 
// An unsigned counter used to determine the number of write barrier calls made
// during a run.
//
#ifdef GC_COUNT_WRITE_BARRIERS
extern unsigned int gc_write_barrier_count;
#endif
//
// This was originally a private variable in Step_Plus_Nursery_Gen,
// and was used to ensure that only one thread could get a new 
// nursery at a time. It was also used to guard against multiple
// threads initiating GC at the same time. However, this mechanism
// didn't stop a thread running out of LOS and initiating a GC
// concurrently. We fixed this by making the following CS global, then
// requiring the LOS to acquire this same CS (and doing the requisite
// extra stuff to make sure its stack can be enumerated if it is
// unable to get the CS).
//

// Use the Lock_Manager to protect both the nurseries and the
// Large Object Space code.

GCExport extern Lock_Manager *p_gc_lock;

// Used only by sapphire but always compiled for all versions.
// This avoids having to have #ifdef GC_SAPPHIRE outside the GC project.
GCExport extern Lock_Manager *p_sapphire_link_block_lock;

GCExport extern Lock_Manager *p_ssb_lock;

// Used for exit processing. We can't exit when a sapphire gc is happening.
GCExport extern Lock_Manager *p_sapphire_lock;

// We have several block lists each taking object of a given size.
#define GC_LOS_BUCKETS 10
extern block_info *los_buckets[GC_LOS_BUCKETS];
extern block_info *los_buckets_free_hint[GC_LOS_BUCKETS];

// Current train creation day. Incremented when you create a new train. Will never overflow.
// The date 0 is reserved for YOS (steps and nurseries)

extern POINTER_SIZE_INT current_train_creation_date;

//
#define MAX_NURSERIES 4096

extern block_info *nurseries[MAX_NURSERIES];

#endif // _gc_globals_h_
