// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/slot_offset_list.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


#if 1
#include "gc_for_orp.h"

#include "slot_offset_list.h"
#include "gc_consts.h"
#include "gc_header.h"

slot_offset_list::slot_offset_list() 
{
    _size_in_entries = DEFAULT_OBJECT_SIZE_IN_ENTRIES;

    _store = (slot_offset_entry *)malloc(_size_in_entries * 
                                          sizeof(slot_offset_entry));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating slot offset list" << endl;
        assert(0);
        orp_exit(1);
    }

    _resident_count  = 0;
}

slot_offset_list::~slot_offset_list()
{
    free(_store);
}

void
slot_offset_list::add_entry(void **slot, Java_java_lang_Object *base, int offset)
{
    if (_resident_count >= (_size_in_entries - 1)) {
        _extend();
    }

    _store[_resident_count].slot = slot;
    _store[_resident_count].base = base;
    _store[_resident_count].offset = offset;
    _resident_count++;

    return;
}

void
slot_offset_list::_extend()
{
    slot_offset_list::slot_offset_entry *old_store = _store;

    //
    // Present policy: double it.
    //
    _size_in_entries = _size_in_entries * 2;

#if _DEBUG // DEBUG DELETEME DELETE ME TRASH JUNK
    orp_cout << "extending interior pointer list to " << _size_in_entries << endl;
#endif

    _store = (slot_offset_list::slot_offset_entry *)malloc(_size_in_entries * 
                                          sizeof (slot_offset_entry));

    if (_store==NULL) {
        orp_cout << "Error: malloc failed while creating slot offset list" << endl;
        assert(0);
        orp_exit(1);
    }

    memcpy((void *)_store, 
           (void *)old_store, 
           _resident_count * sizeof(Java_java_lang_Object *));

	free(old_store);
}

void
slot_offset_list::next()
{
    _current_pointer++;
    // to avoid infinite loops of nexts make sure it is called only
    // once when the table is empty.
    assert (_current_pointer < (_resident_count + 1));
    return;
}

void **slot_offset_list::get_slot ()
{
    return _store[_current_pointer].slot;
}

Java_java_lang_Object *slot_offset_list::get_base ()
{
    return _store[_current_pointer].base;
}

int slot_offset_list::get_offset ()
{
    return _store[_current_pointer].offset;
}

Java_java_lang_Object **slot_offset_list::get_last_base_slot ()
{   
    return &_store[_current_pointer - 1].base;
}

void 
slot_offset_list::debug_dump_list()
{
    orp_cout << "Dump of slot_offset_list:" << endl;
    for (unsigned idx = 0; idx < _resident_count; idx++) {
        orp_cout << "entry[" << idx << "].base = " << _store[idx].base << endl;
        orp_cout << "entry[" << idx << "].slot = " << _store[idx].slot << endl;
        orp_cout << "entry[" << idx << "].offset = " << _store[idx].offset << endl;
    }
}


#if (GC_DEBUG>3)
void
slot_base_offset_list::debug_check_list_integrity()
{
    for (unsigned idx = 0; idx < _resident_count; idx++) {
        if (!is_java_object(_store[idx].base)) {
            orp_cout << "Error: bad object at offset " << idx << " in list"<< endl;
            assert(0);
            orp_exit(1);
        }
    }
}
#endif

void
slot_offset_list::rewind()
{
    _current_pointer = 0;
}

bool
slot_offset_list::available()
{
    return (_current_pointer < _resident_count);
}

void
slot_offset_list::reset()
{
    _resident_count = 0;
}

unsigned
slot_offset_list::size()
{
    return _resident_count;
}

#endif // was GC_INTERIOR_POINTERS
// end file gc\slot_base_offset_list.cpp
