// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/include/sapphire.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//


//
// This file is the header file for the code implementing the sapphire algorithm. 
//

#ifndef _SAPPHIRE_H_
#define _SAPPHIRE_H_
#include "gc_header.h"
#include "object_layout.h"
#include "gc_for_orp.h"

//
// If we are using sapphire then we need to use this write barrier. 
// The sapphire write barrier places value into p_slot. 
//
//void sapphire_write_barrier(Java_java_lang_Object *p_base_of_object_with_ref,
//                            Java_java_lang_Object **p_slot,
//                            Java_java_lang_Object *value);

// The version if the value is not a reference.
//void sapphire_write_barrier_non_ref(Java_java_lang_Object *p_base_of_object,
//                                    Java_java_lang_Object **p_slot,
//                                    Java_java_lang_Object *value);
void gc_sapphire_heap_wrote_object(Java_java_lang_Object *p_base_of_object_holding_ref);
//void  sapphire_write_barrier(Java_java_lang_Object *p_object_holding_ref, 
//                             Java_java_lang_Object **p_slot, // BOGUS until JIT provides
//                             Java_java_lang_Object *value    // BOGUS until JIT provides
//                             );
//
// Code for gc algorithms requiring write barriers.
//
// The following routines are the only way to alter any value in the gc heap.  
//
void gc_sapphire_heap_write_ref (Java_java_lang_Object *p_base_of_object_with_ref,
                                 unsigned offset,
                                 Java_java_lang_Object *value);

// Non reference writes caller does conversion.

void gc_sapphire_heap_write_int8 (Java_java_lang_Object *p_base_of_object_with_ref,
                                  unsigned offset,
                                  int8 value);

void gc_sapphire_heap_write_uint16 (Java_java_lang_Object *p_base_of_object_with_ref,
                                    unsigned offset,
                                    uint16 value);

void gc_sapphire_heap_write_int16 (Java_java_lang_Object *p_base_of_object_with_ref,
                                   unsigned offset,
                                   int16 value);

void gc_sapphire_heap_write_int32 (Java_java_lang_Object *p_base_of_object_with_ref,
                                   unsigned offset,
                                   int32 value);

void gc_sapphire_heap_write_float (Java_java_lang_Object *p_base_of_object_with_ref,
                                   unsigned offset,
                                   float value);

void gc_sapphire_heap_write_double (Java_java_lang_Object *p_base_of_object_with_ref,
                                    unsigned offset,
                                    double value);

void gc_sapphire_heap_write_int64 (Java_java_lang_Object *p_base_of_object_with_ref,
                                   unsigned offset,
                                   int64 value);

inline void gc_sapphire_heap_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_ref,
                                                     unsigned offset,
                                                     POINTER_SIZE_INT value)
{
#ifdef POINTER64
    gc_sapphire_heap_write_int64 (p_base_of_object_with_ref,
        offset,
        (int64)value);
#else
    
    gc_sapphire_heap_write_int32 (p_base_of_object_with_ref,
        offset,
        (int32)value);
#endif // POINTER64
}

void gc_sapphire_heap_write_global_slot(Java_java_lang_Object **p_slot,
                                        Java_java_lang_Object *value);

// The following should generate a st.rel followed by a mf to get sequential consistency
// for volatiles. As of June 12, 2000  this is my (RLH) assumption of what the ORP spec 
// will/should be.
void gc_sapphire_volatile_heap_write_ref (Java_java_lang_Object *p_base_of_object_with_ref,
                                          unsigned offset,
                                          Java_java_lang_Object *value);

// Non reference writes caller does conversion.

void gc_sapphire_volatile_heap_write_int8 (Java_java_lang_Object *p_base_of_object_with_ref,
                                           unsigned offset,
                                           int8 value);

void gc_sapphire_volatile_heap_write_int16 (Java_java_lang_Object *p_base_of_object_with_ref,
                                            unsigned offset,
                                            int16 value);

void gc_sapphire_volatile_heap_write_uint16 (Java_java_lang_Object *p_base_of_object_with_ref,
                                             unsigned offset,
                                             uint16 value);

void gc_sapphire_volatile_heap_write_int32 (Java_java_lang_Object *p_base_of_object_with_ref,
                                            unsigned offset,
                                            int32 value);

void gc_sapphire_volatile_heap_write_float (Java_java_lang_Object *p_base_of_object_with_ref,
                                            unsigned offset,
                                            float value);

void gc_sapphire_volatile_heap_write_double (Java_java_lang_Object *p_base_of_object_with_ref,
                                             unsigned offset,
                                             double value);

void gc_sapphire_volatile_heap_write_int64 (Java_java_lang_Object *p_base_of_object_with_ref,
                                            unsigned offset,
                                            int64 value);

inline void gc_sapphire_volatile_heap_write_pointer_size_int (Java_java_lang_Object *p_base_of_object_with_ref,
                                                              unsigned offset,
                                                              POINTER_SIZE_INT value)
{
#ifdef POINTER64
    gc_sapphire_heap_write_int64 (p_base_of_object_with_ref,
        offset,
        (int64)value);
#else
    
    gc_sapphire_heap_write_int32 (p_base_of_object_with_ref,
        offset,
        (int32)value);
#endif // POINTER64
}

void sapphire_note_slot_with_c_ref(Java_java_lang_Object **p_slot);
bool is_object_in_c_space(Java_java_lang_Object *p_obj);

enum sapphire_states {
    normal,
    initialize_phase,
    mark_reserve_phase,
    repoint_phase,
    flip_phase,
    stabilize_phase
}; //GC_Sapphire_states

extern volatile sapphire_states sapphire_state;

#endif // _SAPPHIRE_H_
