// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/generation.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "card_table.h"
#include "remembered_set.h"
#include "generation.h"
#include "gc_interface.h"
#include "gc_plan.h"
#include "gc_hooks.h"
#include "Block_Store.h"
#include "nursery_step_gen.h"
#include "train_generation.h"

Generation::Generation(unsigned long generation_number,
                       Gc_Fast_Hooks *p_gc_hooks,
                       Gc_Plan       *p_gc_plan,
		               Gc_Interface  *p_container,
			           Generation    *p_superior,
                       Card_Table    *p_card_table,
		               Block_Store   *p_block_store) 

                       : Gc_Component(p_gc_hooks,
                                      p_gc_plan,
                                      p_block_store)
{

    _p_gc_plan             = p_gc_plan;
	_p_block_store         = p_block_store;
	_p_card_table          = p_card_table;
	_p_container           = p_container;
	_p_superior_generation = p_superior;
	_generation_number     = generation_number;
	// 
	// During collection, this will store the pending steps (or cars)
	// where the scan pointer lags the free pointer, hence needing scans.
	//
	_p_pending_scans       = new Scan_Set();

	//
	// Initialize the variable that will record which GC
	// space is being scanned, so that we can avoid recursively
	// doing cheney scans, or requesting unnecessary scans.
	//
	_p_space_being_scanned = NULL;
    //
    // Container for young-to-old references discovered
    // during reclamation of this generation.
    //
    // This is used when collecting a step/nursery generation but not when
    // collecting the MOS (train).
    //
    _p_young_to_old_rs = new Remembered_Set();
    return;
}	

//
// Our container GC is asking us to execute all pending cheney scans.
//
// All requests to execute all pending cheney scans end up here.
// This routine needs to know about all 'to' spaces that might 
// need cheney scanning.
//
void
Generation::execute_pending_cheney_scans(bool doing_mos_collection)
{


//    orp_cout << "Executing pending cheney scans" ;
//    inspect (0);


    // Loop through the generations doing cheney scans until 
    // no objects are scanned for an entire iteration.
    // The order that we do the cheney scans is trivial and it
    // is possible that there is a better order. If so this is
    // one routine that can be used to set policy about that order.
    // The routines called are the other places where such a policy
    // might be implemented.
    bool more_work = true;
    while (more_work) {
        more_work = false;
//        orp_cout << "Cheney Scanning YOS generation." << endl;
        if ((p_global_bs->get_young_generation())->scan_cheney_generation(doing_mos_collection)) {
            assert (!doing_mos_collection);
//            orp_cout << " YOS does work scanning." << endl;
            more_work = true;
        }
//        orp_cout << "Cheney Scanning MOS generation." << endl;
        if ((p_global_bs->get_mature_generation())->scan_cheney_generation(doing_mos_collection)) {
            more_work = true;
//            orp_cout << " MOS does work scanning." << endl;
        }
    }
//    orp_cout << "Cheney scans now complete." << endl;
    assert (!(p_global_bs->get_young_generation())->cheney_scan_pending());
    assert (!(p_global_bs->get_mature_generation())->cheney_scan_pending());
    return; 
}

#if (GC_DEBUG>0) // This is normally inlined, if we are here it is for debug reasons. 
bool Generation::is_address_in_my_generation(void *p_addr)
{
    int gen_encoding = p_global_bs->get_address_generation (p_addr);
    bool result = ( _generation_number == (unsigned long)gen_encoding );

    if (p_global_bs->is_address_outside_heap(p_addr)) {
        
        orp_cout << " ************************" << endl;
        orp_cout << " ************* generation.cpp line 146 ***********" << endl;
        orp_cout << " ************************" << endl;
        assert (0); // how is this possible.
        return false;
	}
// return result;
    Generation *p_gen = 
            p_global_bs->p_get_address_generation(p_addr);

	unsigned long gen_num =
		p_gen->get_generation_number();

    if (gen_num == _generation_number) {
        assert (result == true);
		return true;
    }
    assert (result == false);
	return false;
}
#endif

// end file generation.cpp

