// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_space.cpp,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//

#include "platform.h"

#include "gc_space.h"
#include "remembered_set.h"
#include "Block_Store.h"
#include "card_table.h"
#include "descendents.h"
#include "gc_hooks.h"
#include "generation.h"

//
// After our container generation has processed all the
// live references passed to it by the ORP, it calls all
// the steps that have pending cheney scans (that earlier
// notified the generation using register_pending_cheney_
// scans) an opportunity to process them.
//
void 
Gc_Space::execute_cheney_scan(Generation *p_gen, bool doing_mos_collection)
{

#ifdef GC_TRAIN_TRACE
    orp_cout << " --------------------------- Executing cheney scan of " 
             << p_gen << endl;
#endif
	//
	// The input argument is the generation that his being
	// reclaimed, which will dictate the policy for doing
	// the eviction that is part of the cheney scan.
	//
#if (GC_DEBUG>2)
	assert(_p_scan != NULL);
#endif // _DEBUG

	if (_p_scan == _p_free) {
		//
		// Looks like the party was over before I got here.
		// (While the step is being cheney scanned, a 
		// consequent scavenge could re-register this step
		// for subsequent cheney scanning, which would be
		// ultimately unnecessary since that particular
		// cheney scan would have completed the job.)
		//
#ifdef GC_TRAIN_TRACE
    orp_cout << " _p_scan == _p_free so no object is scanned. " << endl;
#endif
		return;
	}
	//
	// Do cheney scan:
	//
	while (_more_objects_to_cheney_scan()) {
#if (GC_DEBUG>2)
		//
		// Need to verify here that the scan pointer hasn't moved past
		// the last object in this block.
		//
#endif
		//
		// Get the first object in the scan queue.
		//
		Object_Gc_Header *p_gc_hdr = (Object_Gc_Header *)_p_scan;

#if (GC_DEBUG>0)
		verify_is_object(p_gc_hdr);
#endif 

		//
		// Get the real object pointer from the GC header.
		//
		Java_java_lang_Object *p_obj = get_object_from_gc_header(p_gc_hdr);

		//
		// Tell the generation to execute the appropriate policy for
		// this cheney scan.
		//

        // Why is the gen that is passed as an arg the one the does
        // the cheney_scan_execure_policy?
        // It should be the generation of p_obj.

		p_gen->cheney_scan_execute_policy(p_obj, doing_mos_collection);
		//
		// Bump the scan pointer forward.
		//
		unsigned int real_object_size_bytes =
			get_real_object_size_bytes(p_gc_hdr);

		if (_advance_scan_pointer(real_object_size_bytes)) {
			//
			// Function returns true if there are objects remaining
			// to be scanned.
			//
			continue;
		} else {
			//
			// No. Nothing left.
			//
			return;
		}
	}
}

//
// Is specified address in a space that this generation contains?
//
bool 
Gc_Space::is_object_in_my_generation(Java_java_lang_Object *p_obj)
{
    return p_container->is_object_in_my_generation(p_obj);
}
//
// Is specified reference in a space that this generation contains?
//
bool 
Gc_Space::is_reference_in_my_generation(Java_java_lang_Object **pp_obj_ref)
{
    return p_container->is_reference_in_my_generation(pp_obj_ref);
}

//
// Is specified object in a space that this generation contains.
//
bool 
Gc_Space::is_address_in_my_generation(void *p_addr)
{
    return p_container->is_address_in_my_generation(p_addr);
}

  
#if 0 // made inline in header
bool 
Gc_Space::_is_object_in_my_generation(Java_java_lang_Object *p_obj)
{
    Gc_Space *p_gc_space = 
        _p_block_store->p_get_object_container(p_obj);

    Generation *p_gen = 
        //p_gc_space->p_my_generation(); // old, hotspot 5/28
        p_gc_space->p_container;

    if (p_container == p_gen) {
        return true;
    }

    return false;
}
#endif

//
// Membership checking routines
//
bool 
Gc_Space::is_my_object(Java_java_lang_Object *p_obj)
{
	Gc_Space *p_container = _p_block_store->p_get_object_container(p_obj);
    assert (p_container);
	if (p_container == this) {
		return true;
	}

	return false;
}

bool 
Gc_Space::is_my_reference(Java_java_lang_Object **pp_obj_ref)
{
	Gc_Space *p_container = _p_block_store->p_get_reference_container(pp_obj_ref);
	if (p_container == this) {
		return true;
	}

	return false;
}

bool 
Gc_Space::is_my_address(void *p_addr)
{
	Gc_Space *p_container = 
		_p_block_store->p_get_address_container(p_addr);
	if (p_container == this) {
		return true;
	}

	return false;
}

bool 
Gc_Space::_is_object_in_my_generation(Java_java_lang_Object *p_obj) 
{
    Gc_Space *p_gc_space = 
        _p_block_store->p_get_object_container(p_obj);

    Generation *p_gen = 
        p_gc_space->p_container;

    if (p_container == p_gen) {
        return true;
    }

    return false;
}

// end file gc_space.cpp


