// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Signature.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include "Signature.h"


Signature_Table::Signature_Table(Mem_Manager& m) : _mem_manager(m)
{
	// initialize table to empty
	for (unsigned i=0; i<SIG_TABLE_SIZE; i++) {
		_table[i] = NULL;
	}
}

unsigned hash(String *name,String *descriptor)
{
	unsigned n = (unsigned)name;
	unsigned d = (unsigned)descriptor;
	return (n^d) >> 2;
}

Signature *Signature_Table::lookup(String *name,String *descriptor)
{
	unsigned h = hash(name,descriptor)%SIG_TABLE_SIZE;
	for (Signature *sig = _table[h]; sig != NULL; sig = sig->next) {
		if (sig->name == name && sig->descriptor == descriptor)
			return sig;
	}
	// signature not found in table; insert it
	return (_table[h] = new(_mem_manager) Signature(name,descriptor,_table[h]));
}

