// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/class_loader/Package.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include <iostream.h>
#include "Mem_Manager.h"
#include "Package.h"
#include "String_Pool.h"
#include "Class.h"

void	Package::add_class(Class *clss)
{
	clss->next_class_in_package = _classes;
	_classes = clss;
	clss->package = this;
}

Package *Package::lookup_subpackage(String *name)
{
	for (Package *p = _subpackages; p != NULL; p = p->_next_subpackage) {
		if (p->_name == name)
			return p;
	}
	return NULL;
}

Class *Package::lookup_class(String *name)
{
	for (Class *c = _classes; c != NULL; c = c->next_class_in_package) {
		if (name == c->name)
			return c;
	}
	return NULL;
}

Package_Table::Package_Table()
{
	// initialize table to empty
	for (unsigned i=0; i<PACKAGE_TABLE_SIZE; i++) {
		_table[i] = NULL;
	}
}

Package *Package_Table::lookup(const String *name)
{
	// hash on string name address
	unsigned h = (((unsigned)name)>>2)%PACKAGE_TABLE_SIZE;
	for (Package *p = _table[h]; 
		 p != NULL; 
		 p = p->table_next) {
		if (p->get_name() == name)
			return p;
	}
	// package not found in table
	return NULL;
}

void Package_Table::insert(Package *p)
{
	// hash on string name address
	const String *name = p->get_name();
	unsigned h = (((unsigned)name)>>2)%PACKAGE_TABLE_SIZE;
	p->table_next = _table[h];
	_table[h] = p;
}
