// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/lock_manager.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include "orp_threads.h"
#include "exceptions.h"
#include "orp_synch.h"

void orp_thread_enumerate_from_native(ORP_thread *thread);

Lock_Manager *p_jit_a_method_lock;
Lock_Manager *p_vtable_patch_lock;
Lock_Manager *p_load_class_lock;
Lock_Manager *p_meth_addr_table_lock;
Lock_Manager *p_thread_lock;
Lock_Manager *p_gc_lock;
// Used by Sapphire only.
Lock_Manager *p_sapphire_link_block_lock;
Lock_Manager *p_ssb_lock;
Lock_Manager *p_sapphire_lock;
 

void *(*orp_atomic_compare_exchange)(void ** ,void *,void *) = 0;


void Lock_Manager::_lock()
{
    EnterCriticalSection(&_critical_section);
    
#if 0 // def _DEBUG
    assert(!_test_for_enum);
    if (_recursion_count == 0)  {
        assert(_thread_id == 0);
    }
    else {
        assert(_thread_id == p_TLS_orpthread->thread_id);
    }
    _recursion_count++;
    
    if (p_TLS_orpthread) {
        _thread_id = p_TLS_orpthread->thread_id;
    }
#endif 
}

void Lock_Manager::_unlock()
{
#if 0  // def _DEBUG
    assert(!_test_for_enum);
    if (p_TLS_orpthread) {
        assert(_thread_id == p_TLS_orpthread->thread_id);
    }
    _recursion_count--;
    if (_recursion_count == 0) {
        _thread_id = 0;
    }
#endif
    
    LeaveCriticalSection(&_critical_section);
}


void Lock_Manager::_lock_enum()
{   
    Lock_Manager::_lock_enum_or_null(0);
}


void Lock_Manager::_unlock_enum()
{
#if 0 //def _DEBUG
    if (p_TLS_orpthread->thread_id)
        assert(_thread_id == p_TLS_orpthread->thread_id);
    assert(_test_for_enum);
    _recursion_count--;
    if (_recursion_count == 0) {
        _thread_id = 0;
        _test_for_enum = false;
    }
#endif
    
    LeaveCriticalSection(&_critical_section);
}


//
// If a lock is immediately available return true
//		otherwise return NULL
//
//	Use unlock_or_null so that the names match.
//

bool Lock_Manager::_lock_or_null()
{
    DWORD stat = TryEnterCriticalSection(&_critical_section);
    if (!stat) {
        return false;
    }
    
    // #ifdef _DEBUG, poll for ctl-c, #endif
    
    return true;
}


void Lock_Manager::_unlock_or_null()
{
    
    LeaveCriticalSection(&_critical_section);
}


void Lock_Manager::_unlock_enum_or_null() 
{
    LeaveCriticalSection(&_critical_section);	
} 

bool Lock_Manager::_lock_enum_or_null(bool return_null_on_fail)
{
    void *old_p_TLS_orpthread = p_TLS_orpthread;

#ifdef GC_SAPPHIRE
    return _lock_enum_or_null_sapphire (return_null_on_fail); 
#endif // GC_SAPPHIRE
    
    if (p_TLS_orpthread->p_stop_object) {
        assert(0);
        throw_java_exception_from_native(p_TLS_orpthread->p_stop_object);
    }
    
    while (true) {

        DWORD stat = TryEnterCriticalSection(&_critical_section);

        if (stat) {
            // #ifdef _DEBUG, poll for ctl-c, #endif
            return true;
        }
        // a GC can't be caused except by a thread is in this critical section
        // already. So someone is trying to get into this section
        // and it is busy. Since a GC can cause this section to be locked out
        // we need to set a trap so that code that is trying to get a nursery
        // can enumerate their references if a GC is going on.
        
        if (return_null_on_fail) {
            return false;
        }
        
        switch (global_safepoint_status) {
            
        case nill:
            {                
                // do nothing
                Sleep(1);
                
                break;
            }
            
        case enumerate_the_universe:
        case java_debugger:
            {
                
#ifdef _DEBUG
                if (!p_the_safepoint_control_thread) {
                    orp_cout << "nt_lock_manager.cpp DIAGNOSTIC: p_the_safepoint_control_thread == 0" << endl;
                }
#endif
                
                assert (orp_is_gc_enabled(p_TLS_orpthread)); 
                //                assert (stack_enumeration_is_possible()); 
                // thread_set_gc_debug_status(gc_waiting_for_resume);
                DWORD wstat = WaitForSingleObject(p_TLS_orpthread->gc_resume_event_handle, INFINITE);

                assert(wstat != WAIT_FAILED);
                // thread_set_gc_debug_status(gc_resumed);
             
                break;
            }
            
        case java_suspend_one_thread:
            {
                if (p_TLS_orpthread->thread_is_java_suspended == true) {
                    
                    assert(p_the_safepoint_control_thread == 0);
                    
                    assert( (p_TLS_orpthread->app_status == thread_is_running) ||
                        (p_TLS_orpthread->app_status == thread_is_dying)      );
                    
                    assert(p_TLS_orpthread->which_trap == x_nothing);
                    p_TLS_orpthread->which_trap = x_java_suspended;
                    assert(p_TLS_orpthread->gc_status == gc_moving_to_safepoint);
                    p_TLS_orpthread->gc_status = gc_at_safepoint;
                    
                    //					assert (stack_enumeration_is_possible());
                    DWORD wstat = WaitForSingleObject(p_TLS_orpthread->event_handle_suspend0, INFINITE);
                    assert(wstat != WAIT_FAILED);
                    
                    if (p_TLS_orpthread->p_stop_object) {
                        assert(0);
                        throw_java_exception_from_native(p_TLS_orpthread->p_stop_object);
                    }
                    // can't do the below, another suspend0 could
                    // hit before the assert()'s are executed
                    // assert(p_the_safepoint_control_thread == 0);
                    // assert(p_TLS_orpthread->which_trap == x_nothing);
                    // assert(p_TLS_orpthread->thread_is_java_suspended == false);
                }
                
                break;
            }
        default:
            {
                assert (0);
                break;
            }
            
        }
        Sleep(1);
    } // end of while loop
    assert (0);
    return true;
}

#ifdef GC_SAPPHIRE
// The version used by sapphire

bool Lock_Manager::_lock_enum_or_null_sapphire(bool return_null_on_fail)
{
    if (p_TLS_orpthread->p_stop_object) {
        assert(0);
        throw_java_exception_from_native(p_TLS_orpthread->p_stop_object);
    }
    while (true) {
        DWORD stat = TryEnterCriticalSection(&_critical_section);
        if (stat) {
            // #ifdef _DEBUG, poll for ctl-c, #endif
            return true;
        }
        
        // a GC can't be caused except by a thread is in this critical section
        // already. So someone is trying to get into this section
        // and it is busy. Since a GC can cause this section to be locked out
        // we need to set a trap so that code that is trying to get a nursery
        // can enumerate their references if a GC is going on.
        
        if (return_null_on_fail) {
            return NULL;
        }
        
        switch (global_safepoint_status) {
            
        case nill:
            {
                // do nothing
                Sleep(1);
                break;
            }
            
        case java_suspend_one_thread:
            {
                if (p_TLS_orpthread->thread_is_java_suspended == true) {
                    
                    assert(p_the_safepoint_control_thread == 0);
                    
                    assert( (p_TLS_orpthread->app_status == thread_is_running) ||
                        (p_TLS_orpthread->app_status == thread_is_dying)      );

                    assert(p_TLS_orpthread->which_trap == x_nothing);
                    p_TLS_orpthread->which_trap = x_java_suspended;
                    assert(p_TLS_orpthread->gc_status == gc_moving_to_safepoint);
                    p_TLS_orpthread->gc_status = gc_at_safepoint;
                                        
                    DWORD wstat = WaitForSingleObject(p_TLS_orpthread->event_handle_suspend0, INFINITE);
                    assert(wstat != WAIT_FAILED);
                    
                    if (p_TLS_orpthread->p_stop_object) {
                        assert(0);
                        throw_java_exception_from_native(p_TLS_orpthread->p_stop_object);
                    }
                    // can't do the below, another suspend0 could
                    // hit before the assert()'s are executed
                    // assert(p_the_safepoint_control_thread == 0);
                    // assert(p_TLS_orpthread->which_trap == x_nothing);
                    // assert(p_TLS_orpthread->thread_is_java_suspended == false);
                }
                break;
            }

        case java_debugger:
            {                
#ifdef _DEBUG
                if (!p_the_safepoint_control_thread) {
                    orp_cout << "nt_lock_manager.cpp DIAGNOSTIC: p_the_safepoint_control_thread == 0" << endl;
                }
#endif
                assert (orp_is_gc_enabled(p_TLS_orpthread)); 
                //                assert (stack_enumeration_is_possible()); 
                //thread_set_gc_debug_status(gc_waiting_for_resume);
                DWORD wstat = WaitForSingleObject(p_TLS_orpthread->gc_resume_event_handle, INFINITE);
                assert(wstat != WAIT_FAILED);
                //thread_set_gc_debug_status(gc_resumed);
                break;
            }

        case enumerate_the_universe:
            {
                switch (p_TLS_orpthread->gc_status) {
                case zero: 
                    {
                        // Sapphire needs nothing.
                        break;
                    }
                case gc_enumeration_done:
                    {
                        break; // Do nothing, Sapphire isn't asking this thread for anything at
                        // this moment.
                    }       // mark_copy 
                case gc_moving_to_safepoint:
                case gc_at_safepoint:
                    {
                        // Sapphire wants something. Stop the thread.
#ifdef _DEBUG
                        if (!p_the_safepoint_control_thread) {
                            orp_cout << "nt_lock_manager.cpp DIAGNOSTIC: p_the_safepoint_control_thread == 0" << endl;
                        }
#endif
                        assert (orp_is_gc_enabled(p_TLS_orpthread)); 
                        //                assert (stack_enumeration_is_possible()); 
                        //thread_set_gc_debug_status(gc_waiting_for_resume);
                        DWORD wstat = WaitForSingleObject(p_TLS_orpthread->gc_resume_event_handle, INFINITE);
                        assert(wstat != WAIT_FAILED);
                        //thread_set_gc_debug_status(gc_resumed);
                        break;
                    }
                default: // p_TLS_orpthread->gc_status
                    {
                        assert (0);
                    }
                } // end switch (p_TLS_orpthread->gc_status)                
                break; 
            } // end default: for switch (global_safepoint_status)
       
        default:
            {
                assert (0);
                break;      
            }
        }

        Sleep(0);
        
    } // end of while loop
    return true;
}
#endif // GC_SAPPHIRE


#ifdef ORP_NT
    // This might need to be int instead of DWORD on linux???
bool Lock_Manager::is_lock_owner(DWORD thread_id) 
{
    return ((void *)thread_id == _critical_section.OwningThread);
}
#endif
