// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_util_ResourceBundle.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include "jni.h"
#include "assert.h"
#include <time.h>

#include "java_util_ResourceBundle.h"


/*
 * Class:     java_util_ResourceBundle
 * Method:    getClassContext
 * Signature: ()[Ljava/lang/Class;
 */


JNIEXPORT jobjectArray JNICALL Java_java_util_ResourceBundle_getClassContext
  (JNIEnv *jenv, jclass clazz)
{
    // Get hold of "VMSecurityManager" class and get the Class context using 
    // "getClassContext" method of that class.

    jclass sec_class = jenv->FindClass("java/lang/VMSecurityManager");
    assert(sec_class);
    
    jmethodID meth_id = 
        jenv->GetStaticMethodID(sec_class, "getClassContext", "()[Ljava/lang/Class;");
    assert(meth_id);

    jobjectArray ret = jenv->CallStaticObjectMethod(sec_class, meth_id);
    return ret;

} // Java_java_util_ResourceBundle_getClassContext


















