// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_lang_System.cpp,v 1.5 2001/12/19 08:18:03 gwu2 Exp $
//



#include "platform.h"
#include <iostream.h>
#include <assert.h>
#include <time.h>

#include "orp_types.h"
#include "object_layout.h"
#include "orp_utils.h"
#include "exceptions.h"

#include "jni.h"
#include "native_utils.h"
#include "jni_utils.h"
#include "jni_direct.h"

#include "environment.h"

#if defined (ORP_NT)
#include <direct.h>

#elif defined (ORP_POSIX)
#include <sys/time.h>
#include <unistd.h>
#endif

#include "Class.h"

#include "java_lang_System.h" 
#include "gnu_classpath_jni_utils.h"

#ifdef OBJECT_LOCK_V2
#include "object_generic_olv2.h"
#else
#include "object_generic.h"
#endif


void __stdcall PropPut(JNIEnv *env, jobject pObj, char *pProp, char *pVal)
{
	assert(pProp);
#if 0 
	// Is this needed?
	assert(pVal);
#endif

	int str_len = strlen(pProp);
	jchar* jprop = CToUnicode(env, pProp, str_len);
	assert(jprop);
	jstring prop_string = env->NewString(jprop, str_len);
	assert(prop_string);
	free((void*)jprop);

	str_len = strlen(pVal);
	jchar* jval = CToUnicode(env, pVal, str_len);
	assert(jval);
	jstring val_string = env->NewString(jval, str_len);
	assert(val_string);
	free((void*)jval);
						
	jclass prop_class = env->FindClass("java/util/Properties");
	jmethodID put_meth_id = env->GetMethodID(prop_class, "put",
                    "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	jvalue jarg[2];
	jarg[0].l = prop_string;
	jarg[1].l = val_string;
	jobject ret_obj = env->CallObjectMethodA(pObj, put_meth_id, jarg);
} //PropPut


/*
 * Class:     java_lang_System
 * Method:    currentTimeMillis
 * Signature: ()J
 */

static bool firstTimeInCurrentTimeMillis = true;
static jlong CurrentTimeMillisOffset_0;

//
// At the first invocation of Java_java_lang_System_currentTimeMillis, we store
// the difference between the value calculated from time(0) and GetTickCount()
// in a static variable.  In subsequent invocations we simply add the current
// value of GetTickCount() to this variable.
//
// We assume that:
// 1. The ORP is restarted every 49.7 days (the value returned by GetTickCount
//    is 32 bits wide and therefore wraps around to zero every 49.7 days).
// 2. The first invocation of java_lang_System_currentTimeMillis is not
//    subject to any race conditions.  This is OK, because is is invoked
//    for the first time when there's only one Java thread.
//


#ifdef FULL_JNI_VERSION
JNIEXPORT jlong JNICALL Java_java_lang_System_currentTimeMillis
  (JNIEnv *jenv, jclass jc)
#else
JNIEXPORT jlong JNICALL Java_java_lang_System_currentTimeMillis_no_extra_args
  ()
#endif
{
#ifdef ORP_NT
    if(firstTimeInCurrentTimeMillis) {
        jlong TickCount_0 = GetTickCount();
        time_t Time_0 = time(0);
        jlong CurrentTimeMillis_0 = 
            (1000 * (jlong)Time_0) + (TickCount_0 % 1000);
        CurrentTimeMillisOffset_0 = CurrentTimeMillis_0 - TickCount_0;
        firstTimeInCurrentTimeMillis = false;
        return CurrentTimeMillis_0;
    } else {
        return CurrentTimeMillisOffset_0 + GetTickCount();
    }
#elif defined (ORP_POSIX)

    struct timeval tv;
    struct timezone tz;

    int status = gettimeofday(&tv, &tz);

    int64 retval = tv.tv_usec / 1000;
    retval += (int64)tv.tv_sec * 1000;

    return retval;

#endif
} // Java_java_lang_System_currentTimeMillis





/*
 * Class:     java_lang_System
 * Method:    setErr
 * Signature: (Ljava/io/PrintStream;)V
 */

JNIEXPORT void JNICALL Java_java_lang_System_setErr
  (JNIEnv *jenv, jclass clazz, jobject newErr)
{
	// Now set "err" to "newErr"
	jfieldID err_id = 
		jenv->GetStaticFieldID(clazz, "err", "Ljava/io/PrintStream;");
	jenv->SetStaticObjectField(clazz, err_id, newErr);
} // Java_java_lang_System_setErr



/*
 * Class:     java_lang_System
 * Method:    setIn
 * Signature: (Ljava/io/InputStream;)V
 */

JNIEXPORT void JNICALL Java_java_lang_System_setIn
  (JNIEnv *jenv, jclass clazz, jobject newIn)
{
	// Now set "in" to "newIn"
	jfieldID in_id = 
		jenv->GetStaticFieldID(clazz, "in", "Ljava/io/InputStream;");
	jenv->SetStaticObjectField(clazz, in_id, newIn);
} // Java_java_lang_System_setIn




/*
 * Class:     java_lang_System
 * Method:    setOut
 * Signature: (Ljava/io/PrintStream;)V
 */

JNIEXPORT void JNICALL Java_java_lang_System_setOut
  (JNIEnv *jenv, jclass clazz, jobject newOut)
{
	// Now set "out" to "newOut"
	jfieldID out_id = 
		jenv->GetStaticFieldID(clazz, "out", "Ljava/io/PrintStream;");
	jenv->SetStaticObjectField(clazz, out_id, newOut);
} // Java_java_lang_System_setOut


/* Arraycopy */


void 
java_lang_System_arraycopy(Java_java_lang_System *,
                           Java_java_lang_Object *src,
                           int32 srcOffset,
                           Java_java_lang_Object *dst,
                           int32 dstOffset,
                           int32 length)
{
    if(!(src && dst)) {
        throw_java_exception("java/lang/NullPointerException");
    }

    Class *src_class = src->vt->clss;
    assert(src_class);
    Class *dst_class = dst->vt->clss;
    assert(dst_class);

    if(!(src_class->is_array && dst_class->is_array)) {
        throw_java_exception("java/lang/ArrayStoreException");
    }
    assert(src_class->name->bytes[0] == '[');
    assert(dst_class->name->bytes[0] == '[');

    if(src_class != dst_class) {
        if(src_class->is_array_of_primitives || dst_class->is_array_of_primitives) {
            throw_java_exception("java/lang/ArrayStoreException");
        }            
    }

    if((srcOffset < 0) || (dstOffset < 0) || (length < 0)) {
        // The exception name has changed in version 1.1.
        throw_java_exception("java/lang/ArrayIndexOutOfBoundsException");
        //throw_java_exception("java/lang/IndexOutOfBoundsException");

    }

    if(!length)
        return;

    // We haven't determined at this point the types of arrays, but the
    // length is always at the same offset from the start of the array, so we
    // safely cast the pointers to any array type to get the lengths.
    int32 src_length = ((JavaArrayOfChar *)src)->length;
    int32 dst_length = ((JavaArrayOfChar *)dst)->length;
    if((srcOffset + length) > src_length ||
       (dstOffset + length) > dst_length) {
        throw_java_exception("java/lang/ArrayIndexOutOfBoundsException");
        //throw_java_exception("java/lang/IndexOutOfBoundsException");

    }

    char src_elem_type = src_class->name->bytes[1];

    switch(src_elem_type) {
    case 'C':
        {
            JavaArrayOfChar *typed_src = (JavaArrayOfChar *)src;
            JavaArrayOfChar *typed_dst = (JavaArrayOfChar *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'B':
        {
            JavaArrayOfByte *typed_src = (JavaArrayOfByte *)src;
            JavaArrayOfByte *typed_dst = (JavaArrayOfByte *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'Z':
        {
            JavaArrayOfBoolean *typed_src = (JavaArrayOfBoolean *)src;
            JavaArrayOfBoolean *typed_dst = (JavaArrayOfBoolean *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'I':
        {
            JavaArrayOfInt *typed_src = (JavaArrayOfInt *)src;
            JavaArrayOfInt *typed_dst = (JavaArrayOfInt *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'J':
        {
            JavaArrayOfLong *typed_src = (JavaArrayOfLong *)src;
            JavaArrayOfLong *typed_dst = (JavaArrayOfLong *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'F':
        {
            JavaArrayOfFloat *typed_src = (JavaArrayOfFloat *)src;
            JavaArrayOfFloat *typed_dst = (JavaArrayOfFloat *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'D':
        {
            JavaArrayOfDouble *typed_src = (JavaArrayOfDouble *)src;
            JavaArrayOfDouble *typed_dst = (JavaArrayOfDouble *)dst;
            memmove(&(typed_dst->body[dstOffset]),
                    &(typed_src->body[srcOffset]),
                    length * sizeof(typed_dst->body[0]));
        }
        break;
    case 'L':
    case '[':
        {
            Java_java_lang_Object **src_body = &(((JavaArrayOfObject *)src)->body[srcOffset]);
            Java_java_lang_Object **dst_body = &(((JavaArrayOfObject *)dst)->body[dstOffset]);

            if(src_class == dst_class) {
#ifdef GC_SAPPHIRE
                for(int count = 0; count < length; count++) {
                    // For non-null elements check if types are compatible.
                    // If ArrayStoreException hasn't been thrown, copy the element.
                    gc_heap_slot_write_ref (dst, &dst_body[count], src_body[count]);
                    // dst_body[count] = src_body[count];
                        // There is not a gc_heap_write_ref call here since
                        // gc is disabled and we use gc_heap_wrote_object interfac below.
                }
#else
                // If the types of arrays are the same, no type conflicts of
                // array elements are possible.
                memmove(dst_body, src_body, length * sizeof(dst_body[0]));
#endif // GC_SAPPHIRE
            } else {
                // If the types are different, the arrays are different and
                // no overlap of the source and destination is possible.
                Class *dst_elem_clss = dst_class->array_element_class;
                assert(dst_elem_clss);
                
                for(int count = 0; count < length; count++) {
                    // For non-null elements check if types are compatible.
                    if(src_body[count]) {
                        Class *src_elem_clss = src_body[count]->vt->clss;

                        if(!orp_instanceof_class(src_elem_clss, dst_elem_clss)) {

                            // Since we only flag the base do it before we throw exception
                            gc_heap_wrote_object(dst);
                            throw_java_exception("java/lang/ArrayStoreException");
                        }
                    }
                    // If ArrayStoreException hasn't been thrown, copy the element.
#ifdef GC_SAPPHIRE
                        gc_heap_slot_write_ref (dst, &dst_body[count], src_body[count]);
#else
                        dst_body[count] = src_body[count];
#endif
                        // There is not a gc_heap_write_ref call here since
                        // gc is disabled and we use gc_heap_wrote_object interfac below.
                    }
            }
#ifndef GC_SAPPHIRE
                gc_heap_wrote_object(dst);
#endif // GC_SAPPHIRE
        return;
        }
        break;
    default:
        orp_cout << "arraycopy: " << src_elem_type << endl;
        assert(0);
        orp_exit(1);
    }
    gc_heap_wrote_object(dst);
} //java_lang_System_arraycopy





/*
 * Class:     System
 * Method:    isWordsBigEndian
 * Signature: ()Z
 */


JNIEXPORT jboolean JNICALL Java_java_lang_System_isWordsBigEndian(JNIEnv *, jclass)
{
    return JNI_FALSE;
} //Java_java_lang_System_isWordsBigEndian







