// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/common/thread_generic.h,v 1.3 2001/12/19 08:50:48 xli18 Exp $
//

#ifndef  OBJECT_LOCK_V2
#ifndef THREAD_GENERIC_HEADER
#define THREAD_GENERIC_HEADER


#ifdef __cplusplus
extern "C" {
#endif

ORP_thread *get_orp_thread_ptr(void *p_ref);

unsigned java_lang_Thread_countStackFrames_generic(ORP_thread *p_thr);

void java_lang_Thread_setPriority_generic(ORP_thread *p_thr, long pty);

long is_this_a_daemon_thread(void *p_ref);

int32 is_thread_private_data_field_in_use(volatile Java_java_lang_Object *p_obj);

void set_thread_priority(ORP_thread *p_orp_thread, 
                         volatile Java_java_lang_Object *p_this_volatile);

void set_java_thread_private_data_field(volatile Java_java_lang_Object *p_obj, 
                                          ORP_thread *p_thr);

void setup_gc_frame_context();

void java_lang_Thread_start_generic
    (volatile Java_java_lang_Object *p_this_volatile);

void java_lang_Thread_interrupt_generic 
    (volatile Java_java_lang_Object *p_java_thr_volatile) ;

void java_lang_Thread_sleep_generic(int64 msec) ;

void set_interrupt_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile);
void set_alive_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile);
void reset_alive_flag_in_thread_object(volatile Java_java_lang_Object *p_java_thr_volatile);


#ifdef __cplusplus
}
#endif

#endif //THREAD_GENERIC_HEADER

#else
#include "../common_olv2/thread_generic_olv2.h"
#endif //#ifndef  OBJECT_LOCK_V2
