// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/o3_profiling.h,v 1.2 2001/08/13 09:52:49 xhshi Exp $
//


#ifndef _O3_PROFILING_H_
#define _O3_PROFILING_H_

/*
   +---------------------------+
   |  BB[0]                    |
   |   ...                     |
   |  BB[n_back_edge-1]        |
   +---------------------------+
   |  label[0]                 |
   |   ...                     | unique_label of corresponding bb
   |  label[n_back_edge-1]     |
   +---------------------------+
   |  Info[0]                  |
   |   ...                     | Information regarding bb
   |  Info[n_back_edge-1]      |
   +---------------------------+
   |  Inner_BB_Counter[0]	   | For Inner_O3_statistics, counters for some BC, eg 'lookupswitch','tableswitch',etc.
   |    ...					   |
   +---------------------------+
*/
#define O3_MIN_INNER_BRANCH_SIZE 500
#define O3_INNER_BRANCH 10			//!!Note!! Be careful of lookupswitch! I wish there're less than basic_number * 50 sub-branches in one method, although maybe fails!
typedef uint64  O3_PROF_COUNTER;
//typedef unsigned O3_PROF_COUNTER;
typedef unsigned O3_UNIQUE_LABEL;
typedef unsigned O3_PROF_INFO;
typedef struct O3_Profile_Rec {
    bool been_recompiled;
	unsigned inner_counter_num;		// How many Inner_BB_Counters 
	O3_PROF_COUNTER* inner_counter ;// counter offset 
    unsigned short n_bb;
    O3_PROF_COUNTER m_entry; // count how many times is a method entered
    O3_PROF_COUNTER bb[1];   // count how many times that a bb is executed
} O3_Profile_Rec;

extern O3_Profile_Rec *create_o3_profile_rec(Method_Handle m_handle,
                                             Compile_Handle comp_handle,
                                             unsigned n_bb);

extern void insert_profiling_code(Flow_Graph *fg, Expressions &exprs);

extern void print_o3_profiling_info(JIT_Handle jit_handle);

extern bool O3_statistics;
extern bool In_O3_statistics ;
extern bool Inner_O3_statistics ;

class Closure ;
class O3_Prof_Closure : public Closure {
public:
    Expressions& exprs;
    O3_Profile_Rec *prof_rec;
    O3_Prof_Closure(Expressions& exprs, O3_Profile_Rec *pr) : 
    exprs(exprs), prof_rec(pr) {}
};


#endif // _O3_PROFILING_H_
