// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/flow_graph_print.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//



#ifdef PRINTABLE_O3

#include "defines.h"
#include <iostream.h>
#include "Flow_Graph.h"
#include "dotfiles.h"
#include "dumpjit.h"
#include "Bit_Vector_Group.h"
#include "mtable.h"

extern O3_Method_Table *O3_dottab;
extern bool O3_statistics ;
extern bool In_O3_statistics ;

//
// For O3 statistics
//
void Flow_Graph::O3_statistics_dump(ostream& cout)
{
    traversal_number ++;

	Method_Handle mh = m_handle() ;
	Class_Handle ch = c_handle() ;
	assert(mh && ch) ;
	cout << "Method_Name: " << class_get_name(ch) << "." << method_get_name(mh) << method_get_descriptor(mh) << endl ;
	In_O3_statistics = O3_statistics ;
	dumpjit_dfs_node(nodes,cout) ;
	In_O3_statistics = false ;
}

void Flow_Graph::print_cfg(const char *suffix)
{
    if (!O3_dottab->accept_this_method(m_handle()))
        return;

    traversal_number ++;
    if (bc_length() < 5000)
        dump_dot_file(cout,this,suffix);
}

void Flow_Graph::dumpjit_dfs(ostream &cout)
{
    dumpjit_dfs_node(nodes,cout);
}

void Flow_Graph::dumpjit_dfs_node(Cfg_Node *root, ostream &cout)
{
    if (root->latest_traversal >= traversal_number)
        return;
    root->latest_traversal = traversal_number;

    if(In_O3_statistics){ // for some special format
#ifdef PRINTABLE_O3
		cout << "BB # " << root->unique_label;
#else
		cout << "BB # " << root->label;
#endif
	}else
		cout << "// BB#" << root->label;
    if (root->eh_in_edge() != NULL)
    {
        cout << " (exception handler)";
    }
    cout << endl;
    dump_jit_bb(cout, root, code_block, "\n");
    
    Cfg_Int edge;
    for (edge=0; edge<root->out_edge_size(); edge++) 
        dumpjit_dfs_node(root->out_edges(edge),cout);
    
    // Process this node's exception handler block.
    Eh_Node *eh = root->eh_out_edge();
    if (eh == NULL || eh->latest_traversal >= traversal_number)
        return;
    
    eh->latest_traversal = traversal_number;
    Cfg_Int i;
    for (i=0; i< eh->out_edge_size(); i++)
        dumpjit_dfs_node(eh->out_edges(i)->handler, cout);
}

static void print_reg(unsigned reg_no, bool &is_first, ostream &cout)
{
    if (!is_first)
        cout << ",";
    if (reg_no < n_reg)
        cout << X86_Reg_Str[reg_no];
    else
        cout << reg_no;
    is_first = false;
}

void Flow_Graph::dumpjit_dot_node(Cfg_Node *root, ostream &cout)
{
    // Print the header of the basic block.
	cout << "BB" << root->unique_label << " [";
    if (root == prolog() || root == epilog())
        cout << "color=blue,";
	cout << "label=\"{";

	if (root->flowgraph->nodes == root)
    {
		cout << "Prolog" << "(" << root->unique_label << ")";
        cout << " (" << class_get_name(root->flowgraph->c_handle()) << "."
		     << method_get_name(root->flowgraph->m_handle())
             << method_get_descriptor(root->flowgraph->m_handle()) << ")";
    }
	else if (root->flowgraph->epilog() == root)
    {
		cout << "Epilog" << "(" << root->unique_label << ")";
        cout << " (" << class_get_name(root->flowgraph->c_handle()) << "."
		     << method_get_name(root->flowgraph->m_handle()) << ")";
    }
	else
		cout << "BB" << root->label << "(" << root->unique_label << ")";
    if (root->loop_depth() > 0) {
        cout << " (loop depth " << root->loop_depth() << ")";
		cout << " loop_header = BB" << root->loop_header->label;
	}
		
    if (root->eh_in_edge() != NULL)
        cout << " (exception handler)";
    if (root->get_enclosing_subr() != NULL)
    {
        cout << " subr " << root->get_enclosing_subr()->unique_label;
        if (did_dead_elim)
            cout << ", ret=v"
            << (root->get_where_is_ret_addr_bb() ? root->get_where_is_ret_addr_bb()->id : 99999);
    }
    if (did_dead_elim && root->live != NULL)
    {
        cout << "\\nRefs=(";
        bool first = true;
        unsigned i;
        if (root->live->is_live_ref(esp_reg))
        {
            cout << "ERROR:esp";
        }
        else
        {
            for (i=0; i<root->live->numbits(); i++)
            {
                if (root->live->is_live_ref(i))
                    print_reg(i, first, cout);
            }
        }
        cout << ")";
        cout << " Unknowns=(";
        if (root->live->is_unknown(esp_reg))
        {
            cout << "ERROR:esp";
        }
        else
        {
            first = true;
            for (i=0; i<root->live->numbits(); i++)
            {
                if (root->live->is_unknown(i))
                    print_reg(i, first, cout);
            }
        }
        cout << ")";
        cout << " Nonrefs=(";
        first = true;
        if (root->live->is_live_nonref(esp_reg))
        {
            cout << "ERROR:esp";
        }
        else
        {
            for (i=0; i<root->live->numbits(); i++)
            {
                if (root->live->is_live_nonref(i))
                    print_reg(i, first, cout);
            }
        }
        cout << ")";
#if 1
        if (root->region_live != NULL)
        {
            cout << "\\nRefs=(";
            bool first = true;
            unsigned i;
            if (root->region_live->is_live_ref(esp_reg))
            {
                cout << "ERROR:esp";
            }
            else
            {
                for (i=0; i<root->region_live->numbits(); i++)
                {
                    if (root->region_live->is_live_ref(i))
                        print_reg(i, first, cout);
                }
            }
            cout << ")";
            cout << " Unknowns=(";
            if (root->region_live->is_unknown(esp_reg))
            {
                cout << "ERROR:esp";
            }
            else
            {
                first = true;
                for (i=0; i<root->region_live->numbits(); i++)
                {
                    if (root->region_live->is_unknown(i))
                        print_reg(i, first, cout);
                }
            }
            cout << ")";
            cout << " Nonrefs=(";
            first = true;
            if (root->region_live->is_live_nonref(esp_reg))
            {
                cout << "ERROR:esp";
            }
            else
            {
                for (i=0; i<root->region_live->numbits(); i++)
                {
                    if (root->region_live->is_live_nonref(i))
                        print_reg(i, first, cout);
                }
            }
            cout << ")";
        }
#endif // 1
    }

    // Print the instructions.
    cout << "|";
    dump_jit_bb_dot(cout, root, code_block, "\\l");
    cout << "}\"];" << endl;

}

void Flow_Graph::dumpjit_dot_dfs_bounds_nodes(ostream &cout)
{
    Cfg_Node_List *bounds = _bounds_nodes.next();
    while (bounds != &_bounds_nodes)
    {
        dumpjit_dot_node(bounds->node(), cout);
        bounds = bounds->next();
    }
}

class Hier_Closure: public Closure
{
public:
    Hier_Closure(ostream &cout): cout(cout) {}
    ostream &cout;
};

static void reset_hierarchy(Cfg_Node *node, Closure *c)
{
    Flow_Graph *fg = node->flowgraph;
    while (fg != NULL)
    {
        fg->nodes_in_fg_capacity = 0;
        fg->nodes_in_fg_size = 0;
        fg->fgs_in_fg_capacity = 0;
        fg->fgs_in_fg_size = 0;
        fg = fg->calling_fg;
    }
}

static void record_flowgraph(Flow_Graph *fg)
{
    Flow_Graph *parent = fg->calling_fg;
    if (parent == NULL)
        return;
    int i;
    for (i=0; i<parent->fgs_in_fg_size; i++)
    {
        if (parent->fgs_in_fg[i] == fg)
            break;
    }
    if (i >= parent->fgs_in_fg_size)
    {
        RESIZE_ARRAY(Flow_Graph *, parent->fgs_in_fg, parent->fgs_in_fg_capacity,
            parent->fgs_in_fg_size, 4, fg->mem_manager);
        parent->fgs_in_fg[parent->fgs_in_fg_size++] = fg;
    }
    record_flowgraph(parent);
}

static void create_hierarchy(Cfg_Node *node, Closure *c)
{
    // Add this node to its flow graph's list.
    Flow_Graph *fg = node->flowgraph;
    RESIZE_ARRAY(Cfg_Node *, fg->nodes_in_fg, fg->nodes_in_fg_capacity,
        fg->nodes_in_fg_size, 10, fg->mem_manager);
    fg->nodes_in_fg[fg->nodes_in_fg_size++] = node;
    // Add this node's flow graph to its parent's flow graph.
    record_flowgraph(fg);
}

static void dump_nodes_hierarchical(Flow_Graph *fg, Flow_Graph *orig_fg,
                                    ostream &cout, bool is_first)
{
    int i;
    if (!is_first)
        cout << "subgraph cluster" << fg->prolog()->unique_label << " {" << endl;
    for (i=0; i<fg->nodes_in_fg_size; i++)
        orig_fg->dumpjit_dot_node(fg->nodes_in_fg[i], cout);
    for (i=0; i<fg->fgs_in_fg_size; i++)
        dump_nodes_hierarchical(fg->fgs_in_fg[i], orig_fg, cout, false);
    if (!is_first)
        cout << "}" << endl;
}

static void dump_edges(Cfg_Node *node, Closure *c)
{
    Hier_Closure *h = (Hier_Closure *) c;
    ostream &cout = h->cout;
    Cfg_Int i;
    for (i=0; i<node->out_edge_size(); i++)
    {
        Cfg_Node *succ = node->out_edges(i);
        cout << "BB" << node->unique_label << " -> BB" << succ->unique_label;
        if (succ->dominates(node))
            cout << " [color=green]";
        cout << ";" << endl;
    }
}

void Flow_Graph::dumpjit_dot_hierarchical(ostream &cout)
{
    Hier_Closure h(cout);
    apply(reset_hierarchy, NULL);
    apply(create_hierarchy, NULL);
    dump_nodes_hierarchical(this, this, cout, true);
    apply(dump_edges, &h);
}

#endif // PRINTABLE_O3
