// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/disass_str.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//

#ifdef PRINTABLE_O3

#include "defines.h"
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include "jit_intf.h"
#include "disass_str.h"
#include "jit_common.h"

#define OFFSET2(array,idx) ((((char*)array)[idx] << 8) | (array)[(idx)+1])
#define OFFSET4(array,idx) (((array)[idx] << 24) | ((array)[(idx)+1] << 16) | ((array)[(idx)+2] << 8) | (array)[(idx)+3])
#define UOFFSET2(array,idx) (((array)[idx] << 8) | (array)[(idx)+1])

static void safe_print(int dothack, ostream &buf, const char *str)
{
    if (dothack)
    {
        int len = strlen(str);
        int i;
        for (i=0; i<len; i++)
        {
            switch (str[i])
            {
            case '<':
            case '>':
                buf << "_";
                break;
            case '"':
                buf << "'";
                break;
            case '\n':
                break;
            default:
                buf << str[i];
                break;
            }
        }
    }
    else
        buf << str;
}

static void print_field_access(Class_Handle ch,unsigned cpidx,
                               const char *opstring,ostream& buf,
                               int dothack)
{
    buf << opstring << " #" << cpidx << " [";
    safe_print(dothack, buf, const_pool_get_field_class_name(ch,cpidx));
    buf << ".";
    safe_print(dothack, buf, const_pool_get_field_name(ch,cpidx));
    buf << ": ";
    safe_print(dothack, buf, const_pool_get_field_descriptor(ch, cpidx));
    buf << "]";
}

static void print_invoke(Class_Handle ch,unsigned cpidx,
                         const char *opstring,ostream& buf,
                         int dothack)
{
    buf << opstring << " #" << cpidx << " [";
    safe_print(dothack, buf, const_pool_get_method_class_name(ch,cpidx));
    buf << ".";
    safe_print(dothack, buf, const_pool_get_method_name(ch,cpidx));
    safe_print(dothack, buf, const_pool_get_method_descriptor(ch, cpidx));
    buf << "]";
}

static void print_invoke_interface(Class_Handle ch,unsigned cpidx,
                                   const char *opstring,ostream& buf,
                                   int dothack)
{
    buf << opstring << " #" << cpidx << " [";
    safe_print(dothack, buf, const_pool_get_interface_method_class_name(ch,cpidx));
    buf << ".";
    safe_print(dothack, buf, const_pool_get_interface_method_name(ch,cpidx));
    safe_print(dothack, buf, const_pool_get_interface_method_descriptor(ch, cpidx));
    buf << "]";
}

static void print_class(Class_Handle ch,unsigned cpidx,
                        const char *opstring,ostream& buf,
                        int dothack)
{
    buf << opstring << " #" << cpidx << " [";
    safe_print(dothack, buf, const_pool_get_class_name(ch,cpidx));
    buf << "]";
}

static void print_ldc(Class_Handle ch, unsigned cpidx,
                      const char *opstring, ostream &buf, int dothack)
{
    buf << opstring << " #" << cpidx << " ";
    Java_Type ty = class_get_const_type(ch, cpidx);
    const void *addr;
    if (ty != JAVA_TYPE_STRING)
        addr = class_get_const_addr(ch, cpidx);
    switch (ty)
    {
    case JAVA_TYPE_INT:
        buf << "int " << *(const int *)addr;
        break;
    case JAVA_TYPE_LONG:
        buf << "long 0x" << hex << ((const int *)addr)[1] << hex
            << ((const int *)addr)[0] << dec;
        break;
    case JAVA_TYPE_FLOAT:
        buf << "float " << *(const float *)addr;
        break;
    case JAVA_TYPE_DOUBLE:
        buf << "double " << *(const double *)addr;
        break;
    case JAVA_TYPE_STRING:
        {
            const char *str = class_get_const_string(ch, cpidx);
            buf << "string '";
            safe_print(dothack, buf, str);
            buf << "'";
        }
        break;
    default:
        break;
    }
}

// idx is updated.
// It's up to the caller to add a newline if desired.
void disass_str(const unsigned char *bc,    // pointer to *first* bytecode
                unsigned &idx,              // bc[idx] is bytecode to disass.
                ostream &buf,
                Class_Handle c_handle,      // class handle
                int dothack                 // don't print "illegal" characters
                )
{
    static char *comparisons[] = {"eq", "ne", "lt", "ge", "gt", "le"};
    static char *types[] = {"boolean", "char", "float", "double",
        "byte", "short", "int", "long"};
    
    switch (bc[idx])
	{
	case 0x00: // nop, p.322
        buf << "nop";
        break;
	case 0x01: // aconst_null, p.159
        buf << "aconst_null";
        break;
	case 0x02: // iconst -1, p.242
        buf << "iconst_m1";
        break;
	case 0x03:
	case 0x04:
	case 0x05:
	case 0x06:
	case 0x07:
	case 0x08: // iconst 0,...,5, p.242
        buf << "iconst_" << (unsigned)(bc[idx]-0x03);
        break;
	case 0x09:
	case 0x0a: // lconst 0,1, p.290
        buf << "lconst_" << (unsigned)(bc[idx]-0x09);
        break;
	case 0x0b: // fconst 0.0F, p.212
        buf << "fconst_0";
        break;
	case 0x0c: // fconst 1.0F, p.212
        buf << "fconst_1";
        break;
	case 0x0d: // fconst 2.0F, p.212
        buf << "fconst_2";
        break;
	case 0x0e: // dconst 0.0, p.184
        buf << "dconst_0";
        break;
	case 0x0f: // dconst 1.0, p.184
        buf << "dconst_1";
        break;
	case 0x10: // bipush, p.171
        buf << "bipush " << (int)(((const char *)bc)[idx+1]);
        break;
	case 0x11: // sipush, p.333
        buf << "sipush " << OFFSET2(bc,idx+1);
        break;
	case 0x12: // ldc, p.291
        print_ldc(c_handle, (unsigned)(bc[idx+1]), "ldc", buf, dothack);
        //buf << "ldc #" << (unsigned)(bc[idx+1]);
        break;
	case 0x13: // ldc_w, p.292
        print_ldc(c_handle, UOFFSET2(bc,idx+1), "ldc_w", buf, dothack);
        //buf << "ldc_w #" << UOFFSET2(bc,idx+1);
        break;
	case 0x14: // ldc2_w, p.294
        print_ldc(c_handle, UOFFSET2(bc,idx+1), "ldc2_w", buf, dothack);
        //buf << "ldc2_w #" << UOFFSET2(bc,idx+1);
        break;
	case 0x15: // iload, p.252
	case 0x16: // lload, p.296
	case 0x17: // fload, p.215
	case 0x18: // dload, p.187
	case 0x19: // aload, p.160
        buf << "ilfda"[bc[idx] - 0x15] << "load " << (unsigned)(bc[idx+1]);
        break;
	case 0x1a:
	case 0x1b:
	case 0x1c:
	case 0x1d: // iload_{0,1,2,3}, p.253
        buf << "iload_" << (unsigned)(bc[idx]-0x1a);
        break;
	case 0x22:
	case 0x23:
	case 0x24:
	case 0x25: // fload_{0,1,2,3}, p.216
        buf << "fload_" << (unsigned)(bc[idx]-0x22);
        break;
	case 0x2a:
	case 0x2b:
	case 0x2c:
	case 0x2d: // aload_{0,1,2,3}, p.161
        buf << "aload_" << (unsigned)(bc[idx]-0x2a);
        break;
	case 0x1e:
	case 0x1f:
	case 0x20:
	case 0x21: // lload_{0,1,2,3}, p.297
        buf << "lload_" << (unsigned)(bc[idx]-0x1e);
        break;
	case 0x26:
	case 0x27:
	case 0x28:
	case 0x29: // dload_{0,1,2,3}, p.188
        buf << "dload_" << (unsigned)(bc[idx]-0x26);
        break;
	case 0x2e: // iaload, p.239
	case 0x2f: // laload, p.286
	case 0x30: // faload, p.209
	case 0x31: // daload, p.181
	case 0x32: // aaload, p.156
	case 0x33: // baload, p.169
	case 0x34: // caload, p.172
	case 0x35: // saload, p.331
        buf << "ilfdabcs"[bc[idx] - 0x2e] << "aload";
        break;
	case 0x36: // istore, p.275
	case 0x37: // lstore, p.307
	case 0x38: // fstore, p.223
	case 0x39: // dstore, p.195
	case 0x3a: // astore, p.165
        buf << "ilfda"[bc[idx] - 0x36] << "store " << (unsigned)(bc[idx+1]);
        break;
	case 0x4b:
	case 0x4c:
	case 0x4d:
	case 0x4e: // astore_{0,1,2,3}, p.166
        buf << "astore_" << (unsigned)(bc[idx]-0x4b);
        break;
	case 0x3b:
	case 0x3c:
	case 0x3d:
	case 0x3e: // istore_{0,1,2,3}, p.276
        buf << "istore_" << (unsigned)(bc[idx]-0x3b);
        break;
	case 0x43:
	case 0x44:
	case 0x45:
	case 0x46: // fstore_{0,1,2,3}, p.224
        buf << "fstore_" << (unsigned)(bc[idx]-0x43);
        break;
	case 0x3f:
	case 0x40:
	case 0x41:
	case 0x42: // lstore_{0,1,2,3}, p.308
        buf << "lstore_" << (unsigned)(bc[idx]-0x3f);
        break;
	case 0x47:
	case 0x48:
	case 0x49:
	case 0x4a: // dstore_{0,1,2,3}, p.196
        buf << "dstore_" << (unsigned)(bc[idx]-0x47);
        break;
	case 0x4f: // iastore, p.241
	case 0x50: // lastore, p.288
	case 0x51: // fastore, p.210
	case 0x52: // dastore, p.182
	case 0x53: // aastore, p.157
	case 0x54: // bastore, p.170
	case 0x55: // castore, p.173
	case 0x56: // sastore, p.332
        buf << "ilfdabcs"[bc[idx] - 0x4f] << "astore";
        break;
	case 0x57: // pop, p.323
        buf << "pop";
        break;
	case 0x58: // pop2, p.324
        buf << "pop2";
        break;
	case 0x59: // dup, p.198
        buf << "dup";
        break;
	case 0x5a: // dup_x1, p.199
        buf << "dup_x1";
        break;
	case 0x5b: // dup_x2, p.200
        buf << "dup_x2";
        break;
	case 0x5c: // dup2, p.201
        buf << "dup2";
        break;
	case 0x5d: // dup2_x1, p.202
        buf << "dup2_x1";
        break;
	case 0x5e: // dup2_x2, p.203
        buf << "dup2_x2";
        break;
	case 0x5f: // swap, p.334
        buf << "swap";
        break;
	case 0x60: // iadd, p.238
	case 0x61: // ladd, p.285
	case 0x62: // fadd, p.207
	case 0x63: // dadd, p.179
        buf << "ilfd"[bc[idx] - 0x60] << "add";
        break;
	case 0x64: // isub, p.277
	case 0x65: // lsub, p.309
	case 0x66: // fsub, p.225
	case 0x67: // dsub, p.197
        buf << "ilfd"[bc[idx] - 0x64] << "sub";
        break;
	case 0x68: // imul, p.254
	case 0x69: // lmul, p.298
	case 0x6a: // fmul, p.217
	case 0x6b: // dmul, p.189
        buf << "ilfd"[bc[idx] - 0x68] << "mul";
        break;
	case 0x6c: // idiv, p.243
	case 0x6d: // ldiv, p.295
	case 0x6e: // fdiv, p.213
	case 0x6f: // ddiv, p.185
        buf << "ilfd"[bc[idx] - 0x6c] << "div";
        break;
	case 0x70: // irem, p.271
	case 0x71: // lrem, p.303
	case 0x72: // frem, p.220
	case 0x73: // drem, p.192
        buf << "ilfd"[bc[idx] - 0x70] << "rem";
        break;
	case 0x74: // ineg, p.255
	case 0x75: // lneg, p.299
	case 0x76: // fneg, p.219
	case 0x77: // dneg, p.191
        buf << "ilfd"[bc[idx] - 0x74] << "neg";
        break;
	case 0x78: // ishl, p.273
        buf << "ishl";
        break;
	case 0x79: // lshl, p.305
        buf << "lshl";
        break;
	case 0x7a: // ishr, p.274
        buf << "ishr";
        break;
	case 0x7b: // lshr, p.306
        buf << "lshr";
        break;
	case 0x7c: // iushr, p.278
        buf << "iushr";
        break;
	case 0x7d: // lushr, p.310
        buf << "lushr";
        break;
	case 0x7e: // iand, p.240
        buf << "iand";
        break;
	case 0x7f: // land, p.287
        buf << "land";
        break;
	case 0x80: // ior, p.270
        buf << "ior";
        break;
	case 0x81: // lor, p.302
        buf << "lor";
        break;
	case 0x82: // ixor, p.279
        buf << "ixor";
        break;
	case 0x83: // lxor, p.311
        buf << "lxor";
        break;
	case 0x84: // iinc, p.251
        buf << "iinc " << (unsigned)(bc[idx+1]) << " "
            << (int)(((const char *)bc)[idx+2]);
        break;
	case 0x85: // i2l, p.236
	case 0x86: // i2f, p.235
	case 0x87: // i2d, p.234
	case 0x88: // l2i, p.284
	case 0x89: // l2f, p.283
	case 0x8a: // l2d, p.282
	case 0x8b: // f2i, p.205
	case 0x8c: // f2l, p.206
	case 0x8d: // f2d, p.204
	case 0x8e: // d2i, p.177
	case 0x8f: // d2l, p.178
	case 0x90: // d2f, p.176
	case 0x91: // i2b, p.232
	case 0x92: // i2c, p.233
	case 0x93: // i2s, p.237
        buf << "iiilllfffdddiii"[bc[idx]-0x85] << '2' << "lfdifdildilfbcs"[bc[idx]-0x85];
        break;
	case 0x94: // lcmp, p.289
	case 0x95: // fcmpl, p.211
	case 0x96: // fcmpg, p.211
	case 0x97: // dcmpl, p.183
	case 0x98: // dcmpg, p.183
        buf << "lffdd"[bc[idx]-0x94] << "cmp" << " lglg"[bc[idx]-0x94];
        break;
	case 0x99:
	case 0x9a:
	case 0x9b:
	case 0x9c:
	case 0x9d:
	case 0x9e: // if{eq,ne,lt,ge,gt,le}, p.247
        buf << "if" << comparisons[bc[idx]-0x99] << " "
            << idx+OFFSET2(bc,idx+1);
        break;
	case 0x9f:
	case 0xa0:
	case 0xa1:
	case 0xa2:
	case 0xa3:
	case 0xa4: // if_icmp{eq,ne,lt,ge,gt,le}, p.245
        buf << "if_icmp" << comparisons[bc[idx]-0x9f] << " "
            << idx+OFFSET2(bc,idx+1);
        break;
	case 0xa5:
	case 0xa6: // if_acmp{eq,ne}, p.244
        buf << "if_acmp" << comparisons[bc[idx]-0xa5] << " "
            << idx+OFFSET2(bc,idx+1);
        break;
	case 0xa7: // goto, p.230
        buf << "goto " << idx+OFFSET2(bc,idx+1);
        break;
	case 0xa8: // jsr, p.280
        buf << "jsr " << idx+OFFSET2(bc,idx+1);
        break;
	case 0xa9: // ret, p.329
        buf << "ret " << (unsigned)(bc[idx+1]);
        break;
	case 0xaa: // tableswitch, p.335
        {
			int new_idx = ((idx + 4) & (~3));
			int default_offset = OFFSET4(bc,new_idx);
			int low = OFFSET4(bc,new_idx+4);
			int high = OFFSET4(bc,new_idx+8);
			int i;
			new_idx += 12;
			int n_entries = high - low + 1;
			buf << "tableswitch[" << low << ":" << high << "], default="
				<< idx+default_offset << ", offsets=";
			for (i=0; i<n_entries; i++)
            {
				int offset = OFFSET4(bc,new_idx);
				if (i > 0)
					buf << ",";
				buf << idx+offset;
				new_idx += 4;
            }
			break;
        }
	case 0xab: // lookupswitch, p.300
        {
			int new_idx = ((idx + 4) & (~3));
			int default_offset = OFFSET4(bc,new_idx);
			int npairs = OFFSET4(bc,new_idx+4);
			int i;
			new_idx += 8;
			buf << "lookupswitch, default=" << idx+default_offset
				<< ", offsets=";
			for (i=0; i<npairs; i++)
            {
				int offset = OFFSET4(bc,new_idx+4);
				if (i > 0)
					buf << ",";
				buf << idx+offset;
				new_idx += 8;
            }
			break;
        }
	case 0xac: // ireturn, p.272
        buf << "ireturn";
        break;
	case 0xb0: // areturn, p.163
		buf << "areturn";
		break;
	case 0xae: // freturn, p.222
		buf << "freturn";
		break;
	case 0xad: // lreturn, p.304
		buf << "lreturn";
		break;
	case 0xaf: // dreturn, p.194
		buf << "dreturn";
		break;
	case 0xb1: // return, p.330
		buf << "return";
		break;
	case 0xb2: // getstatic, p.228
		print_field_access(c_handle,UOFFSET2(bc,idx+1),"getstatic",buf, dothack);
		break;
	case 0xb3: // putstatic, p.327
		print_field_access(c_handle,UOFFSET2(bc,idx+1),"putstatic",buf, dothack);
		break;
	case 0xb4: // getfield, p.226
		print_field_access(c_handle,UOFFSET2(bc,idx+1),"getfield",buf, dothack);
		break;
	case 0xb5: // putfield, p.325
		print_field_access(c_handle,UOFFSET2(bc,idx+1),"putfield",buf, dothack);
		break;
	case 0xb6: // invokevirtual, p.267
		print_invoke(c_handle,UOFFSET2(bc,idx+1),"invokevirtual",buf, dothack);
		break;
	case 0xb7: // invokespecial, p.261
		print_invoke(c_handle,UOFFSET2(bc,idx+1),"invokespecial",buf, dothack);
		break;
	case 0xb8: // invokestatic, p.265
		print_invoke(c_handle,UOFFSET2(bc,idx+1),"invokestatic",buf, dothack);
		break;
	case 0xb9: // invokeinterface, p.258
		print_invoke_interface(c_handle,UOFFSET2(bc,idx+1),"invokeinterface",buf, dothack);
		break;
	case 0xba: // unused
        break;
	case 0xbb: // new, p.318
		print_class(c_handle,UOFFSET2(bc,idx+1),"new",buf, dothack);
		break;
	case 0xbc: // newarray, p.320
        buf << "newarray " << types[bc[idx+1]-4];
        break;
	case 0xbd: // anewarray, p.162
		print_class(c_handle,UOFFSET2(bc,idx+1),"anewarray",buf, dothack);
		break;
	case 0xbe: // arraylength, p.164
        buf << "arraylength";
        break;
	case 0xbf: // athrow, p.167
        buf << "athrow";
        break;
	case 0xc0: // checkcast, p.174
		print_class(c_handle,UOFFSET2(bc,idx+1),"checkcast",buf, dothack);
		break;
	case 0xc1: // instanceof, p.256
		print_class(c_handle,UOFFSET2(bc,idx+1),"instanceof",buf, dothack);
		break;
	case 0xc2: // monitorenter, p.312
        buf << "monitorenter";
        break;
	case 0xc3: // monitorexit, p.314
        buf << "monitorexit";
        break;
	case 0xc4: // wide, p.337
        {
			int indexword = UOFFSET2(bc,idx+2);
			int constword;
			switch (bc[idx+1])
            {
            case 0x84: // iinc, p.251
				constword = OFFSET2(bc,idx+4);
				buf << "iinc_w " << indexword << " " << constword;
				break;
            case 0xa9: // ret, p.329
				buf << "ret_w " << indexword;
				break;
            case 0x15: // iload, p.252
            case 0x16: // lload, p.296
            case 0x17: // fload, p.215
            case 0x18: // dload, p.187
            case 0x19: // aload, p.160
				buf << "ilfda"[bc[idx+1] - 0x15] << "load " << indexword;
				break;
            case 0x36: // istore, p.275
            case 0x37: // lstore, p.307
            case 0x38: // fstore, p.223
            case 0x39: // dstore, p.195
            case 0x3a: // astore, p.165
				buf << "ilfda"[bc[idx+1] - 0x36] << "store " << indexword;
				break;
            default:
				buf << "[illegal wide instruction " << (unsigned)(bc[idx+1])
					<< "]";
				idx += 4;
				break;
            }
        }
		break;
	case 0xc5: // multianewarray, p.316
        buf << "multianewarray[" << (unsigned)(bc[idx+3]) << "] ";
        print_class(c_handle, UOFFSET2(bc,idx+1), "", buf, dothack);
        break;
	case 0xc6: // ifnull, p.250
        buf << "ifnull " << idx+OFFSET2(bc,idx+1);
        break;
	case 0xc7: // ifnonnull, p.249
        buf << "ifnonnull " << idx+OFFSET2(bc,idx+1);
        break;
	case 0xc8: // goto_w, p.231
        buf << "goto_w " << idx+OFFSET4(bc,idx+1);
        break;
	case 0xc9: // jsr_w, p.281
        buf << "jsr_w " << idx+OFFSET4(bc,idx+1);
        break;
	default:
        buf << "[unknown instruction " << (unsigned)(bc[idx]) << "]";
        break;
      }
	  
	  idx += instruction_length(bc,idx);
}

#endif // PRINTABLE_O3
