// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/copy_prop.h,v 1.3 2001/12/14 08:04:22 xhshi Exp $
//

#ifndef _COPY_PROP_H
#define _COPY_PROP_H

#include <string.h>
#include "flow_graph.h"
#include "expression.h"

void copy_prop(Flow_Graph *fg, Expressions &exprs);



#define CP_HASH_SIZE 64

struct Cp_Hash_Entry
{
    Operand *opnd;
    Operand *replace;
};

struct Tp_Hash_Entry
{
    Operand *opnd;
    Class_Handle replace;
};

struct Kill_Set_Entry
{
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Kill_Set_Entry(unsigned b, Kill_Set_Entry *n): bvp(b), next(n) {}
    unsigned bvp;
    Kill_Set_Entry *next;
};

class Prop_Closure : public Closure // abstract class
{
public:
    void *operator new(size_t sz,Mem_Manager& m) {return m.alloc(sz);}
    Prop_Closure(Mem_Manager &m, Mem_Manager &pm, Expressions &e,
        Method_Handle mh, Compile_Handle cmph, bool tp,
        unsigned short traversal_num): mem(m), perm_mem(pm), mh(mh), cmph(cmph), type_prop(tp),
        traversal_num(traversal_num), exprs(e), defined_in_this_bb(NULL),
        num_vars(exprs.reg_map.curr_tmp_reg_id()) {}
    Expressions &exprs;
    Mem_Manager &mem;
    Mem_Manager &perm_mem;
    bool *defined_in_this_bb;
    bool changed;
    bool for_real;
    bool type_prop;
    unsigned short traversal_num;
    Method_Handle mh;
    Compile_Handle cmph;
    unsigned num_vars;
    virtual void init_working_set(Cfg_Node *node) = 0;
    virtual void update_outgoing(Cfg_Node *node, Bit_Vector *node_bv) = 0;
    virtual void update_this_ptr(Flow_Graph *fg, unsigned this_bvp) = 0;
    virtual void init_types(Flow_Graph *fg) = 0;
    virtual void process_bb(Cfg_Node *node) = 0;
    /*virtual*/ Operand *replace_with_prop_value(Operand *opnd, bool update_grc, bool imm_ok)/* = 0*/;
    virtual void set_type(Operand *opnd, Class_Handle ch) = 0;
    virtual Class_Handle get_type(Operand *opnd) = 0;
    virtual Operand *get_replace_opnd(unsigned bvp) = 0;
    virtual bool is_valid_replacement(unsigned bvp, Operand *opnd, Operand *replace) = 0;
    virtual unsigned _hash(unsigned bvp) = 0;
protected:
    static Operand *PROP_CONFLICT;
};

class PC_Exact : public Prop_Closure
{
public:
    PC_Exact(Mem_Manager &m, Mem_Manager &pm, Expressions &e,
        Method_Handle mh, Compile_Handle cmph, bool tp,
        unsigned num_bb,
        unsigned short traversal_num): Prop_Closure(m, pm, e, mh, cmph, tp, traversal_num) {
        defined_in_this_bb = (bool *) mem.alloc(num_vars * sizeof(bool));
        prop_values = (Operand **)mem.alloc(num_bb*num_vars*sizeof(Operand*));
        working_set = (Operand **)mem.alloc(       num_vars*sizeof(Operand*));
        kill_set = (Kill_Set_Entry **)mem.alloc(   num_vars*sizeof(Kill_Set_Entry*));
        if (type_prop)
        {
            type_prop_values = (Class_Handle *)mem.alloc(num_bb*num_vars*sizeof(Class_Handle));
            type_working_set = (Class_Handle *)mem.alloc(       num_vars*sizeof(Class_Handle));
        }
        else
        {
            type_prop_values = NULL;
            type_working_set = NULL;
        }
        memset(prop_values, 0, num_bb*num_vars * sizeof(prop_values[0]));
        if (type_prop)
        {
            memset(type_prop_values, 0, num_bb*num_vars * sizeof(type_prop_values[0]));
        }
    }
private:
    Operand **prop_values;
    Operand **working_set;
    Class_Handle *type_prop_values;
    Class_Handle *type_working_set;
    Kill_Set_Entry **kill_set;
    void init_working_set(Cfg_Node *node);
    void update_outgoing(Cfg_Node *node, Bit_Vector *node_bv);
    void update_this_ptr(Flow_Graph *fg, unsigned this_bvp) {
        unsigned epilog_label = fg->epilog()->label;
        Operand *this_prop_value = prop_values[epilog_label * num_vars + _hash(this_bvp)];
        if (this_prop_value != PROP_CONFLICT)
            fg->this_pointer_of_method = this_prop_value;
    }
    void init_types(Flow_Graph *fg);
    void process_bb(Cfg_Node *node);
    //Operand *replace_with_prop_value(Operand *opnd, bool update_grc, bool imm_ok);
    void set_type(Operand *opnd, Class_Handle ch) { type_working_set[opnd->bv_position()] = ch; }
    Class_Handle get_type(Operand *opnd) { return type_working_set[opnd->bv_position()]; }
    void combine(Operand *&dst, Operand *&src) {
        if (dst != src) dst = PROP_CONFLICT; }
    void init_kill_set();
    void add_to_kill_set(unsigned lhs_bvp, Operand *rhs);
    void kill_all_in_kill_set(Operand *opnd);
    void kill_all_in_kill_set_by_bvp(unsigned bvp);
    Operand *get_replace_opnd(unsigned bvp) { return working_set[bvp]; }
    bool is_valid_replacement(unsigned bvp, Operand *opnd, Operand *replace) {
        return (replace != PROP_CONFLICT);
    }
    unsigned _hash(unsigned bvp) { return bvp; }
};

class PC_Hash : public Prop_Closure
{
public:
    PC_Hash(Mem_Manager &m, Mem_Manager &pm, Expressions &e,
        Method_Handle mh, Compile_Handle cmph, bool tp,
        unsigned num_bb,
        unsigned short traversal_num): Prop_Closure(m, pm, e, mh, cmph, tp, traversal_num) {
        defined_in_this_bb = (bool *) mem.alloc(num_vars * sizeof(bool));
        prop_values = (Cp_Hash_Entry *)mem.alloc(num_bb*CP_HASH_SIZE*sizeof(Cp_Hash_Entry));
        working_set = (Cp_Hash_Entry *)mem.alloc(       CP_HASH_SIZE*sizeof(Cp_Hash_Entry));
#ifdef USE_KILL_SET
        kill_set =  (Kill_Set_Entry **)mem.alloc(       CP_HASH_SIZE*sizeof(Kill_Set_Entry*));
#endif // USE_KILL_SET
        if (type_prop)
        {
            type_prop_values = (Tp_Hash_Entry *)mem.alloc(num_bb*CP_HASH_SIZE*sizeof(Tp_Hash_Entry));
            type_working_set = (Tp_Hash_Entry *)mem.alloc(       CP_HASH_SIZE*sizeof(Tp_Hash_Entry));
        }
        else
        {
            type_prop_values = NULL;
            type_working_set = NULL;
        }
        memset(prop_values, 0, num_bb*CP_HASH_SIZE * sizeof(prop_values[0]));
        if (type_prop)
        {
            memset(type_prop_values, 0, num_bb*CP_HASH_SIZE * sizeof(type_prop_values[0]));
        }
    }
private:
    Cp_Hash_Entry *prop_values;
    Cp_Hash_Entry *working_set;
    Tp_Hash_Entry *type_prop_values;
    Tp_Hash_Entry *type_working_set;
#ifdef USE_KILL_SET
    Kill_Set_Entry **kill_set;
#endif // USE_KILL_SET
    void init_working_set(Cfg_Node *node);
    void update_outgoing(Cfg_Node *node, Bit_Vector *node_bv);
    void update_this_ptr(Flow_Graph *fg, unsigned this_bvp) {
        unsigned epilog_label = fg->epilog()->label;
        Operand *this_prop_value = prop_values[epilog_label * CP_HASH_SIZE + _hash(this_bvp)].opnd;
        if (this_prop_value != NULL)
            fg->this_pointer_of_method = this_prop_value;
    }
    void init_types(Flow_Graph *fg);
    void process_bb(Cfg_Node *node);
    //Operand *replace_with_prop_value(Operand *opnd, bool update_grc, bool imm_ok);
    void set_type(Operand *opnd, Class_Handle ch) {
        unsigned bvp = _hash(opnd->bv_position());
        type_working_set[bvp].opnd = opnd;
        type_working_set[bvp].replace = ch; }
    Class_Handle get_type(Operand *opnd) {
        unsigned bvp = _hash(opnd->bv_position());
        if (type_working_set[bvp].opnd == opnd)
            return type_working_set[bvp].replace;
        else
            return NULL; }
    void combine_hash(Cp_Hash_Entry &dst, Cp_Hash_Entry &src) {
        if (dst.opnd != src.opnd || dst.replace != src.replace) dst.opnd = NULL; }
    void combine_ch_hash(Tp_Hash_Entry &dst, Tp_Hash_Entry &src);
    Operand *get_replace_opnd(unsigned bvp) { return working_set[bvp].replace; }
    bool is_valid_replacement(unsigned bvp, Operand *opnd, Operand *replace) {
        return (working_set[bvp].opnd == opnd && replace != NULL);
    }
#ifdef USE_KILL_SET
    void init_kill_set();
    void add_to_kill_set(unsigned lhs_hash, Operand *rhs);
    void kill_all_in_kill_set(Operand *opnd);
#endif // USE_KILL_SET
    unsigned _hash(unsigned bvp) { return bvp % CP_HASH_SIZE; }
};


#endif // _COPY_PROP_H
